/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrUuidEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;

    public XrUuidEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrUuidEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t[XR_UUID_SIZE_EXT]")
    public ByteBuffer data() {
        return XrUuidEXT.ndata(this.address());
    }

    @NativeType(value="uint8_t")
    public byte data(int index) {
        return XrUuidEXT.ndata(this.address(), index);
    }

    public XrUuidEXT data(@NativeType(value="uint8_t[XR_UUID_SIZE_EXT]") ByteBuffer value) {
        XrUuidEXT.ndata(this.address(), value);
        return this;
    }

    public XrUuidEXT data(int index, @NativeType(value="uint8_t") byte value) {
        XrUuidEXT.ndata(this.address(), index, value);
        return this;
    }

    public XrUuidEXT set(XrUuidEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrUuidEXT malloc() {
        return (XrUuidEXT)XrUuidEXT.wrap(XrUuidEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrUuidEXT calloc() {
        return (XrUuidEXT)XrUuidEXT.wrap(XrUuidEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrUuidEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrUuidEXT)XrUuidEXT.wrap(XrUuidEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrUuidEXT create(long address) {
        return (XrUuidEXT)XrUuidEXT.wrap(XrUuidEXT.class, (long)address);
    }

    @Nullable
    public static XrUuidEXT createSafe(long address) {
        return address == 0L ? null : (XrUuidEXT)XrUuidEXT.wrap(XrUuidEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrUuidEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrUuidEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrUuidEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrUuidEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrUuidEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrUuidEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrUuidEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrUuidEXT malloc(MemoryStack stack) {
        return (XrUuidEXT)XrUuidEXT.wrap(XrUuidEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrUuidEXT calloc(MemoryStack stack) {
        return (XrUuidEXT)XrUuidEXT.wrap(XrUuidEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrUuidEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrUuidEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DATA), (int)16);
    }

    public static byte ndata(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DATA + Checks.check((int)index, (int)16) * 1L);
    }

    public static void ndata(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)16);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)DATA), (long)(value.remaining() * 1));
    }

    public static void ndata(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)DATA + Checks.check((int)index, (int)16) * 1L, value);
    }

    static {
        Struct.Layout layout = XrUuidEXT.__struct((Struct.Member[])new Struct.Member[]{XrUuidEXT.__array((int)1, (int)16)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XrUuidEXT, Buffer>
    implements NativeResource {
        private static final XrUuidEXT ELEMENT_FACTORY = XrUuidEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrUuidEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t[XR_UUID_SIZE_EXT]")
        public ByteBuffer data() {
            return XrUuidEXT.ndata(this.address());
        }

        @NativeType(value="uint8_t")
        public byte data(int index) {
            return XrUuidEXT.ndata(this.address(), index);
        }

        public Buffer data(@NativeType(value="uint8_t[XR_UUID_SIZE_EXT]") ByteBuffer value) {
            XrUuidEXT.ndata(this.address(), value);
            return this;
        }

        public Buffer data(int index, @NativeType(value="uint8_t") byte value) {
            XrUuidEXT.ndata(this.address(), index, value);
            return this;
        }
    }
}

