/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceProtectedMemoryFeatures
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PROTECTEDMEMORY;

    public VkPhysicalDeviceProtectedMemoryFeatures(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPhysicalDeviceProtectedMemoryFeatures.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceProtectedMemoryFeatures.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceProtectedMemoryFeatures.npNext(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean protectedMemory() {
        return VkPhysicalDeviceProtectedMemoryFeatures.nprotectedMemory(this.address()) != 0;
    }

    public VkPhysicalDeviceProtectedMemoryFeatures sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceProtectedMemoryFeatures.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceProtectedMemoryFeatures sType$Default() {
        return this.sType(1000145001);
    }

    public VkPhysicalDeviceProtectedMemoryFeatures pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceProtectedMemoryFeatures.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceProtectedMemoryFeatures protectedMemory(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceProtectedMemoryFeatures.nprotectedMemory(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceProtectedMemoryFeatures set(int sType, long pNext, boolean protectedMemory) {
        this.sType(sType);
        this.pNext(pNext);
        this.protectedMemory(protectedMemory);
        return this;
    }

    public VkPhysicalDeviceProtectedMemoryFeatures set(VkPhysicalDeviceProtectedMemoryFeatures src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures malloc() {
        return (VkPhysicalDeviceProtectedMemoryFeatures)VkPhysicalDeviceProtectedMemoryFeatures.wrap(VkPhysicalDeviceProtectedMemoryFeatures.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures calloc() {
        return (VkPhysicalDeviceProtectedMemoryFeatures)VkPhysicalDeviceProtectedMemoryFeatures.wrap(VkPhysicalDeviceProtectedMemoryFeatures.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkPhysicalDeviceProtectedMemoryFeatures)VkPhysicalDeviceProtectedMemoryFeatures.wrap(VkPhysicalDeviceProtectedMemoryFeatures.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures create(long address) {
        return (VkPhysicalDeviceProtectedMemoryFeatures)VkPhysicalDeviceProtectedMemoryFeatures.wrap(VkPhysicalDeviceProtectedMemoryFeatures.class, (long)address);
    }

    @Nullable
    public static VkPhysicalDeviceProtectedMemoryFeatures createSafe(long address) {
        return address == 0L ? null : (VkPhysicalDeviceProtectedMemoryFeatures)VkPhysicalDeviceProtectedMemoryFeatures.wrap(VkPhysicalDeviceProtectedMemoryFeatures.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkPhysicalDeviceProtectedMemoryFeatures.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkPhysicalDeviceProtectedMemoryFeatures.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkPhysicalDeviceProtectedMemoryFeatures.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceProtectedMemoryFeatures.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkPhysicalDeviceProtectedMemoryFeatures.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkPhysicalDeviceProtectedMemoryFeatures.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkPhysicalDeviceProtectedMemoryFeatures.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkPhysicalDeviceProtectedMemoryFeatures mallocStack() {
        return VkPhysicalDeviceProtectedMemoryFeatures.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceProtectedMemoryFeatures callocStack() {
        return VkPhysicalDeviceProtectedMemoryFeatures.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceProtectedMemoryFeatures mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryFeatures.malloc(stack);
    }

    @Deprecated
    public static VkPhysicalDeviceProtectedMemoryFeatures callocStack(MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryFeatures.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceProtectedMemoryFeatures.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceProtectedMemoryFeatures.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryFeatures.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryFeatures.calloc(capacity, stack);
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures malloc(MemoryStack stack) {
        return (VkPhysicalDeviceProtectedMemoryFeatures)VkPhysicalDeviceProtectedMemoryFeatures.wrap(VkPhysicalDeviceProtectedMemoryFeatures.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures calloc(MemoryStack stack) {
        return (VkPhysicalDeviceProtectedMemoryFeatures)VkPhysicalDeviceProtectedMemoryFeatures.wrap(VkPhysicalDeviceProtectedMemoryFeatures.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceProtectedMemoryFeatures.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceProtectedMemoryFeatures.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nprotectedMemory(long struct) {
        return UNSAFE.getInt(null, struct + (long)PROTECTEDMEMORY);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nprotectedMemory(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PROTECTEDMEMORY, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceProtectedMemoryFeatures.__struct((Struct.Member[])new Struct.Member[]{VkPhysicalDeviceProtectedMemoryFeatures.__member((int)4), VkPhysicalDeviceProtectedMemoryFeatures.__member((int)POINTER_SIZE), VkPhysicalDeviceProtectedMemoryFeatures.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PROTECTEDMEMORY = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceProtectedMemoryFeatures, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceProtectedMemoryFeatures ELEMENT_FACTORY = VkPhysicalDeviceProtectedMemoryFeatures.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPhysicalDeviceProtectedMemoryFeatures getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceProtectedMemoryFeatures.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceProtectedMemoryFeatures.npNext(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean protectedMemory() {
            return VkPhysicalDeviceProtectedMemoryFeatures.nprotectedMemory(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceProtectedMemoryFeatures.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000145001);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceProtectedMemoryFeatures.npNext(this.address(), value);
            return this;
        }

        public Buffer protectedMemory(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceProtectedMemoryFeatures.nprotectedMemory(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

