/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session.state;

import java.io.IOException;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.Outbind;
import org.jsmpp.extra.PendingResponse;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BaseResponseHandler;
import org.jsmpp.session.OutboundServerResponseHandler;
import org.jsmpp.session.ResponseHandler;
import org.jsmpp.session.state.SMPPOutboundServerSessionState;
import org.jsmpp.util.DefaultDecomposer;
import org.jsmpp.util.PDUDecomposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SMPPOutboundServerSessionOpen
implements SMPPOutboundServerSessionState {
    private static final Logger logger = LoggerFactory.getLogger(SMPPOutboundServerSessionOpen.class);
    private static final PDUDecomposer pduDecomposer = new DefaultDecomposer();
    private static final String INVALID_PROCESS_FOR_OPEN_SESSION = "Invalid process for open session state";

    SMPPOutboundServerSessionOpen() {
    }

    @Override
    public SessionState getSessionState() {
        return SessionState.OPEN;
    }

    @Override
    public void processOutbind(Command pduHeader, byte[] pdu, OutboundServerResponseHandler responseHandler) throws IOException {
        logger.info("processOutbind");
        try {
            Outbind outbind = pduDecomposer.outbind(pdu);
            responseHandler.processOutbind(outbind);
            logger.debug("Received outbind with {} and {}", (Object)outbind.getSystemId(), (Object)outbind.getPassword());
        }
        catch (PDUStringException e) {
            responseHandler.sendNegativeResponse(pduHeader.getCommandId(), e.getErrorCode(), pduHeader.getSequenceNumber());
        }
        catch (ProcessRequestException e) {
            responseHandler.sendNegativeResponse(pduHeader.getCommandId(), e.getErrorCode(), pduHeader.getSequenceNumber());
        }
    }

    @Override
    public void processBindResp(Command pduHeader, byte[] pdu, OutboundServerResponseHandler responseHandler) throws IOException {
        logger.info("processBindResp");
        throw new IOException(INVALID_PROCESS_FOR_OPEN_SESSION);
    }

    @Override
    public void processDeliverSm(Command pduHeader, byte[] pdu, OutboundServerResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unexpected deliver_sm"));
        }
    }

    @Override
    public void processEnquireLink(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unexpected enquire_link"));
        }
    }

    @Override
    public void processEnquireLinkResp(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unexpected enquire_link_resp"));
        }
    }

    @Override
    public void processGenericNack(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unexpected generic_nack"));
        }
    }

    @Override
    public void processUnbind(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unexpected unbind"));
        }
    }

    @Override
    public void processUnbindResp(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unexpected unbind_resp"));
        }
    }

    @Override
    public void processUnknownCid(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unknown command_id"));
        }
    }

    @Override
    public void processDataSm(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unexpected data_sm"));
        }
    }

    @Override
    public void processDataSmResp(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unexpected data_sm_resp"));
        }
    }

    public void processAlertNotification(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unexpected alert_notification"));
        }
    }
}

