/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.ui.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.config.core.dto.ConfigDescriptionDTO;
import org.openhab.core.ui.components.UIComponent;

@NonNullByDefault
public class RootUIComponent
extends UIComponent
implements Identifiable<String> {
    String uid;
    Set<String> tags = new HashSet<String>();
    ConfigDescriptionDTO props;
    @Nullable Date timestamp;

    public RootUIComponent() {
        this("");
    }

    public RootUIComponent(String name) {
        super(name);
        this.uid = UUID.randomUUID().toString();
        this.props = new ConfigDescriptionDTO(null, new ArrayList(), new ArrayList());
    }

    public RootUIComponent(String uid, String name) {
        super(name);
        this.uid = uid;
        this.props = new ConfigDescriptionDTO(null, new ArrayList(), new ArrayList());
    }

    public String getUID() {
        return this.uid;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public @Nullable Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    public void updateTimestamp() {
        this.timestamp = new Date();
    }

    public boolean hasTag(String tag) {
        return this.tags != null && this.tags.contains(tag);
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public void addTags(Collection<String> tags) {
        this.tags.addAll(tags);
    }

    public void addTags(String ... tags) {
        this.tags.addAll(Arrays.asList(tags));
    }

    public void removeTag(String tag) {
        this.tags.remove(tag);
    }

    public void removeAllTags() {
        this.tags.clear();
    }

    public ConfigDescriptionDTO getProps() {
        return this.props;
    }

    public void setProps(ConfigDescriptionDTO props) {
        this.props = props;
    }
}

