/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.unit;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Map;
import java.util.Objects;
import javax.measure.Dimension;
import javax.measure.Prefix;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.internal.library.unit.CurrencyConverter;
import org.openhab.core.internal.library.unit.CurrencyService;
import org.openhab.core.library.dimension.Currency;
import org.openhab.core.library.unit.CurrencyUnits;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.function.RationalNumber;
import tech.units.indriya.unit.UnitDimension;

@NonNullByDefault(value={DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE, DefaultLocation.FIELD, DefaultLocation.TYPE_BOUND})
public final class CurrencyUnit
extends AbstractUnit<Currency> {
    private static final long serialVersionUID = -1L;
    private static final Dimension DIMENSION = UnitDimension.parse((char)'$');
    private String name;
    private @Nullable String symbol;

    public CurrencyUnit(String name, @Nullable String symbol) throws IllegalArgumentException {
        if (name.length() != 3) {
            throw new IllegalArgumentException("Only three characters allowed for currency name");
        }
        this.symbol = symbol;
        this.name = name;
    }

    public UnitConverter getSystemConverter() {
        return this.internalGetConverterTo((Unit<Currency>)this.getSystemUnit());
    }

    protected Unit<Currency> toSystemUnit() {
        return CurrencyUnits.BASE_CURRENCY;
    }

    public String toString() {
        return this.getName();
    }

    @NonNullByDefault(value={})
    public Map<? extends Unit<?>, Integer> getBaseUnits() {
        return Map.of();
    }

    public Dimension getDimension() {
        return DIMENSION;
    }

    public void setName(@NonNullByDefault(value={}) String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public @Nullable String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(@Nullable String s) {
        this.symbol = s;
    }

    public Unit<Currency> shift(double offset) {
        return this.shift((Number)RationalNumber.of((double)offset));
    }

    public Unit<Currency> multiply(double multiplier) {
        return this.multiply((Number)RationalNumber.of((double)multiplier));
    }

    public Unit<Currency> divide(double divisor) {
        return this.divide((Number)RationalNumber.of((double)divisor));
    }

    private UnitConverter internalGetConverterTo(Unit<Currency> that) throws UnconvertibleException {
        if (this.equals(that)) {
            return AbstractConverter.IDENTITY;
        }
        if (CurrencyUnits.BASE_CURRENCY.equals((Object)this)) {
            BigDecimal factor = CurrencyService.FACTOR_FCN.apply(that);
            if (factor != null) {
                return new CurrencyConverter(factor);
            }
        } else if (CurrencyUnits.BASE_CURRENCY.equals(that)) {
            BigDecimal factor = CurrencyService.FACTOR_FCN.apply((Unit<Currency>)this);
            if (factor != null) {
                return new CurrencyConverter(factor).inverse();
            }
        } else {
            BigDecimal f1 = CurrencyService.FACTOR_FCN.apply((Unit<Currency>)this);
            BigDecimal f2 = CurrencyService.FACTOR_FCN.apply(that);
            if (f1 != null && f2 != null) {
                return new CurrencyConverter(f2.divide(f1, MathContext.DECIMAL128));
            }
        }
        throw new UnconvertibleException("Could not get factor for converting " + this.getName() + " to " + that.getName());
    }

    public Unit<?> pow(int n) {
        if (n > 0) {
            return this.multiply(this.pow(n - 1));
        }
        if (n == 0) {
            return ONE;
        }
        return ONE.divide(this.pow(-n));
    }

    public Unit<Currency> prefix(@NonNullByDefault(value={}) Prefix prefix) {
        return this.transform((UnitConverter)MultiplyConverter.ofPrefix((Prefix)prefix));
    }

    public int compareTo(Unit<Currency> that) {
        int nameCompare = this.getName().compareTo(that.getName());
        if (nameCompare != 0) {
            return nameCompare;
        }
        String thatSymbol = that.getSymbol();
        if (this.symbol != null && thatSymbol != null) {
            return this.symbol.compareTo(thatSymbol);
        }
        if (this.symbol != null) {
            return 1;
        }
        if (thatSymbol != null) {
            return -1;
        }
        return 0;
    }

    public boolean isEquivalentTo(@NonNullByDefault(value={}) Unit<Currency> that) {
        return this.getConverterTo(that).isIdentity();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        Object object = obj;
        if (object instanceof CurrencyUnit) {
            void that;
            CurrencyUnit currencyUnit = (CurrencyUnit)((Object)object);
            CurrencyUnit cfr_ignored_0 = (CurrencyUnit)((Object)object);
            return this.name.equals(that.name) && Objects.equals(this.symbol, that.symbol);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.symbol);
    }
}

