/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.inbox.events;

import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.discovery.DiscoveryResult;
import org.openhab.core.config.discovery.dto.DiscoveryResultDTO;
import org.openhab.core.config.discovery.dto.DiscoveryResultDTOMapper;
import org.openhab.core.config.discovery.inbox.events.InboxAddedEvent;
import org.openhab.core.config.discovery.inbox.events.InboxRemovedEvent;
import org.openhab.core.config.discovery.inbox.events.InboxUpdatedEvent;
import org.openhab.core.events.AbstractEventFactory;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventFactory;
import org.osgi.service.component.annotations.Component;

@NonNullByDefault
@Component(immediate=true, service={EventFactory.class})
public class InboxEventFactory
extends AbstractEventFactory {
    static final String INBOX_ADDED_EVENT_TOPIC = "openhab/inbox/{thingUID}/added";
    static final String INBOX_REMOVED_EVENT_TOPIC = "openhab/inbox/{thingUID}/removed";
    static final String INBOX_UPDATED_EVENT_TOPIC = "openhab/inbox/{thingUID}/updated";

    public InboxEventFactory() {
        super(Set.of(InboxAddedEvent.TYPE, InboxUpdatedEvent.TYPE, InboxRemovedEvent.TYPE));
    }

    protected Event createEventByType(String eventType, String topic, String payload, @Nullable String source) throws Exception {
        if (InboxAddedEvent.TYPE.equals(eventType)) {
            return this.createAddedEvent(topic, payload);
        }
        if (InboxRemovedEvent.TYPE.equals(eventType)) {
            return this.createRemovedEvent(topic, payload);
        }
        if (InboxUpdatedEvent.TYPE.equals(eventType)) {
            return this.createUpdatedEvent(topic, payload);
        }
        throw new IllegalArgumentException("The event type '" + eventType + "' is not supported by this factory.");
    }

    private Event createAddedEvent(String topic, String payload) {
        DiscoveryResultDTO resultDTO = (DiscoveryResultDTO)InboxEventFactory.deserializePayload((String)payload, DiscoveryResultDTO.class);
        return new InboxAddedEvent(topic, payload, resultDTO);
    }

    private Event createRemovedEvent(String topic, String payload) {
        DiscoveryResultDTO resultDTO = (DiscoveryResultDTO)InboxEventFactory.deserializePayload((String)payload, DiscoveryResultDTO.class);
        return new InboxRemovedEvent(topic, payload, resultDTO);
    }

    private Event createUpdatedEvent(String topic, String payload) {
        DiscoveryResultDTO resultDTO = (DiscoveryResultDTO)InboxEventFactory.deserializePayload((String)payload, DiscoveryResultDTO.class);
        return new InboxUpdatedEvent(topic, payload, resultDTO);
    }

    public static InboxAddedEvent createAddedEvent(DiscoveryResult discoveryResult) {
        InboxEventFactory.assertValidArgument(discoveryResult);
        String topic = InboxEventFactory.buildTopic(INBOX_ADDED_EVENT_TOPIC, discoveryResult.getThingUID().getAsString());
        DiscoveryResultDTO resultDTO = InboxEventFactory.map(discoveryResult);
        String payload = InboxEventFactory.serializePayload((Object)resultDTO);
        return new InboxAddedEvent(topic, payload, resultDTO);
    }

    public static InboxRemovedEvent createRemovedEvent(DiscoveryResult discoveryResult) {
        InboxEventFactory.assertValidArgument(discoveryResult);
        String topic = InboxEventFactory.buildTopic(INBOX_REMOVED_EVENT_TOPIC, discoveryResult.getThingUID().getAsString());
        DiscoveryResultDTO resultDTO = InboxEventFactory.map(discoveryResult);
        String payload = InboxEventFactory.serializePayload((Object)resultDTO);
        return new InboxRemovedEvent(topic, payload, resultDTO);
    }

    public static InboxUpdatedEvent createUpdatedEvent(DiscoveryResult discoveryResult) {
        InboxEventFactory.assertValidArgument(discoveryResult);
        String topic = InboxEventFactory.buildTopic(INBOX_UPDATED_EVENT_TOPIC, discoveryResult.getThingUID().getAsString());
        DiscoveryResultDTO resultDTO = InboxEventFactory.map(discoveryResult);
        String payload = InboxEventFactory.serializePayload((Object)resultDTO);
        return new InboxUpdatedEvent(topic, payload, resultDTO);
    }

    private static void assertValidArgument(DiscoveryResult discoveryResult) {
        InboxEventFactory.checkNotNull((Object)discoveryResult, (String)"discoveryResult");
    }

    private static String buildTopic(String topic, String thingUID) {
        return topic.replace("{thingUID}", thingUID);
    }

    private static DiscoveryResultDTO map(DiscoveryResult discoveryResult) {
        return DiscoveryResultDTOMapper.map(discoveryResult);
    }
}

