/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.util.Arrays;
import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.NoResponseOption;
import org.eclipse.californium.core.coap.option.EmptyOptionDefinition;
import org.eclipse.californium.core.coap.option.IntegerOptionDefinition;
import org.eclipse.californium.core.coap.option.OptionDefinition;
import org.eclipse.californium.core.coap.option.OptionNumber;
import org.eclipse.californium.core.coap.option.StandardOptionRegistry;
import org.eclipse.californium.core.coap.option.StringOptionDefinition;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.StringUtil;

public class Option
implements OptionNumber,
Comparable<OptionNumber> {
    private final OptionDefinition definition;
    private final byte[] value;

    Option(OptionDefinition definition, byte[] value, boolean unchecked) {
        if (definition == null) {
            throw new NullPointerException("Definition must not be null!");
        }
        this.definition = definition;
        this.value = value;
    }

    public Option(EmptyOptionDefinition definition) {
        this.definition = definition;
        this.value = Bytes.EMPTY;
    }

    public Option(OptionDefinition definition, byte[] value) {
        if (value == null) {
            throw new NullPointerException(definition.getName() + " option value must not be null!");
        }
        definition.assertValue(value);
        this.definition = definition;
        this.value = value;
    }

    public Option(StringOptionDefinition definition, String value) {
        this((OptionDefinition)definition, StringOptionDefinition.setStringValue(value));
    }

    public Option(IntegerOptionDefinition definition, int value) {
        this((OptionDefinition)definition, IntegerOptionDefinition.setIntegerValue(value));
    }

    public Option(IntegerOptionDefinition definition, long value) {
        this((OptionDefinition)definition, IntegerOptionDefinition.setLongValue(value));
    }

    public OptionDefinition getDefinition() {
        return this.definition;
    }

    public int getLength() {
        return this.getValue().length;
    }

    @Override
    public int getNumber() {
        return this.definition.getNumber();
    }

    public byte[] getValue() {
        if (this.value == null) {
            throw new IllegalStateException(this.definition.getName() + " option value must be set before!");
        }
        return this.value;
    }

    public String getStringValue() {
        return StringOptionDefinition.getStringValue(this.getValue());
    }

    public int getIntegerValue() {
        return IntegerOptionDefinition.getIntegerValue(this.getValue());
    }

    public long getLongValue() {
        return IntegerOptionDefinition.getLongValue(this.getValue());
    }

    public boolean isCritical() {
        return (this.getNumber() & 1) != 0;
    }

    public boolean isUnSafe() {
        return (this.getNumber() & 2) != 0;
    }

    public boolean isNoCacheKey() {
        return (this.getNumber() & 0x1E) == 28;
    }

    @Override
    public int compareTo(OptionNumber o) {
        return this.getNumber() - o.getNumber();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Option)) {
            return false;
        }
        Option op = (Option)o;
        return this.definition.equals(op.definition) && Arrays.equals(this.value, op.value);
    }

    public int hashCode() {
        return this.definition.hashCode() * 31 + Arrays.hashCode(this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.definition.getName());
        sb.append(": ");
        sb.append(this.toValueString());
        return sb.toString();
    }

    public String toValueString() {
        if (this.value == null) {
            return "not available";
        }
        switch (this.definition.getFormat()) {
            case INTEGER: {
                if (StandardOptionRegistry.BLOCK1.equals(this.definition) || StandardOptionRegistry.BLOCK2.equals(this.definition)) {
                    return "\"" + new BlockOption(this.value) + "\"";
                }
                int iValue = this.getIntegerValue();
                if (StandardOptionRegistry.ACCEPT.equals(this.definition) || StandardOptionRegistry.CONTENT_FORMAT.equals(this.definition)) {
                    return "\"" + MediaTypeRegistry.toString(iValue) + "\"";
                }
                if (StandardOptionRegistry.NO_RESPONSE.equals(this.definition)) {
                    return "\"" + new NoResponseOption(iValue) + "\"";
                }
                return Long.toString(this.getLongValue());
            }
            case STRING: {
                return "\"" + this.getStringValue() + "\"";
            }
            case EMPTY: {
                return "";
            }
        }
        return "0x" + StringUtil.byteArray2Hex((byte[])this.value);
    }
}

