/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.auth;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.handler.auth.AbstractMqttAuthHandler;
import com.hivemq.client.internal.mqtt.handler.auth.MqttReAuthHandler;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectEvent;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectUtil;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import com.hivemq.client.internal.mqtt.message.auth.MqttAuth;
import com.hivemq.client.internal.mqtt.message.auth.MqttEnhancedAuthBuilder;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.MqttStatefulConnect;
import com.hivemq.client.internal.mqtt.message.connect.connack.MqttConnAck;
import com.hivemq.client.internal.netty.DefaultChannelOutboundHandler;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.exceptions.ConnectionFailedException;
import com.hivemq.client.mqtt.lifecycle.MqttDisconnectSource;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5AuthException;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5ConnAckException;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5EnhancedAuth;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAckReasonCode;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

@ConnectionScope
public class MqttConnectAuthHandler
extends AbstractMqttAuthHandler
implements DefaultChannelOutboundHandler {
    @Inject
    MqttConnectAuthHandler(@NotNull MqttClientConfig clientConfig, @NotNull MqttConnect connect) {
        super(clientConfig, Checks.stateNotNull(connect.getRawEnhancedAuthMechanism(), "Auth mechanism"));
    }

    @Override
    public void write(@NotNull ChannelHandlerContext ctx, @NotNull Object msg, @NotNull ChannelPromise promise) {
        if (msg instanceof MqttConnect) {
            this.writeConnect((MqttConnect)msg, promise);
        } else {
            ctx.write(msg, promise);
        }
    }

    private void writeConnect(@NotNull MqttConnect connect, @NotNull ChannelPromise promise) {
        MqttEnhancedAuthBuilder enhancedAuthBuilder = new MqttEnhancedAuthBuilder(this.getMethod());
        this.state = AbstractMqttAuthHandler.MqttAuthState.IN_PROGRESS_INIT;
        this.callMechanismFuture(() -> this.authMechanism.onAuth(this.clientConfig, connect, enhancedAuthBuilder), ctx -> {
            this.state = AbstractMqttAuthHandler.MqttAuthState.WAIT_FOR_SERVER;
            MqttStatefulConnect statefulConnect = connect.createStateful(this.clientConfig.getRawClientIdentifier(), enhancedAuthBuilder.build());
            ctx.writeAndFlush((Object)statefulConnect, promise).addListener((GenericFutureListener)this);
        }, (ctx, throwable) -> MqttDisconnectUtil.close(ctx.channel(), new ConnectionFailedException((Throwable)throwable)));
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        if (msg instanceof MqttConnAck) {
            this.readConnAck(ctx, (MqttConnAck)msg);
        } else if (msg instanceof MqttAuth) {
            this.readAuth(ctx, (MqttAuth)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void readConnAck(@NotNull ChannelHandlerContext ctx, @NotNull MqttConnAck connAck) {
        this.cancelTimeout();
        if (((Mqtt5ConnAckReasonCode)connAck.getReasonCode()).isError()) {
            this.readConnAckError(ctx, connAck);
        } else if (this.validateConnAck(ctx, connAck)) {
            this.readConnAckSuccess(ctx, connAck);
        }
    }

    private void readConnAckError(@NotNull ChannelHandlerContext ctx, @NotNull MqttConnAck connAck) {
        this.callMechanism(() -> this.authMechanism.onAuthRejected(this.clientConfig, connAck));
        this.state = AbstractMqttAuthHandler.MqttAuthState.NONE;
        MqttDisconnectUtil.fireDisconnectEvent(ctx.channel(), new Mqtt5ConnAckException(connAck, "CONNECT failed as CONNACK contained an Error Code: " + connAck.getReasonCode() + "."), MqttDisconnectSource.SERVER);
    }

    private void readConnAckSuccess(@NotNull ChannelHandlerContext ctx, @NotNull MqttConnAck connAck) {
        if (this.state != AbstractMqttAuthHandler.MqttAuthState.WAIT_FOR_SERVER) {
            MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, new Mqtt5ConnAckException(connAck, "Must not receive CONNACK with reason code SUCCESS if client side AUTH is pending."));
            return;
        }
        this.state = AbstractMqttAuthHandler.MqttAuthState.IN_PROGRESS_DONE;
        this.callMechanismFutureResult(() -> this.authMechanism.onAuthSuccess(this.clientConfig, connAck), ctx2 -> {
            this.state = AbstractMqttAuthHandler.MqttAuthState.NONE;
            ctx2.pipeline().replace((ChannelHandler)this, "auth", (ChannelHandler)new MqttReAuthHandler(this));
            ctx2.fireChannelRead((Object)connAck);
        }, (ctx2, throwable) -> MqttDisconnectUtil.disconnect(ctx2.channel(), Mqtt5DisconnectReasonCode.NOT_AUTHORIZED, new Mqtt5ConnAckException(connAck, "Server CONNACK with reason code SUCCESS not accepted.")));
    }

    private boolean validateConnAck(@NotNull ChannelHandlerContext ctx, @NotNull MqttConnAck connAck) {
        Mqtt5EnhancedAuth enhancedAuth = connAck.getRawEnhancedAuth();
        if (enhancedAuth == null) {
            MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, new Mqtt5ConnAckException(connAck, "Auth method in CONNACK must be present."));
            return false;
        }
        if (!enhancedAuth.getMethod().equals(this.getMethod())) {
            MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, new Mqtt5ConnAckException(connAck, "Auth method in CONNACK must be the same as in the CONNECT."));
            return false;
        }
        return true;
    }

    @Override
    void readAuthSuccess(@NotNull ChannelHandlerContext ctx, @NotNull MqttAuth auth) {
        MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, new Mqtt5AuthException(auth, "Must not receive AUTH with reason code SUCCESS during connect auth."));
    }

    @Override
    void readReAuth(@NotNull ChannelHandlerContext ctx, @NotNull MqttAuth auth) {
        MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, new Mqtt5AuthException(auth, "Must not receive AUTH with reason code REAUTHENTICATE during connect auth."));
    }

    @Override
    protected void onDisconnectEvent(@NotNull ChannelHandlerContext ctx, @NotNull MqttDisconnectEvent disconnectEvent) {
        super.onDisconnectEvent(ctx, disconnectEvent);
        if (this.state != AbstractMqttAuthHandler.MqttAuthState.NONE) {
            this.callMechanism(() -> this.authMechanism.onAuthError(this.clientConfig, disconnectEvent.getCause()));
            this.state = AbstractMqttAuthHandler.MqttAuthState.NONE;
        }
    }

    @Override
    @NotNull
    protected String getTimeoutReasonString() {
        return "Timeout while waiting for AUTH or CONNACK.";
    }
}

