/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.crossdc.manager.consumer;

import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.servlets.MetricsServlet;
import com.codahale.metrics.servlets.ThreadDumpServlet;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.crossdc.common.ConfUtil;
import org.apache.solr.crossdc.common.KafkaCrossDcConf;
import org.apache.solr.crossdc.common.SensitivePropRedactionUtils;
import org.apache.solr.crossdc.manager.consumer.KafkaCrossDcConsumer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Consumer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String METRICS_REGISTRY = "metrics";
    private Server server;
    private CrossDcConsumer crossDcConsumer;
    private CountDownLatch startLatch = new CountDownLatch(1);
    private ExecutorService consumerThreadExecutor;

    public void start() {
        this.start(new HashMap<String, Object>());
    }

    public void start(Map<String, Object> properties) {
        String zkConnectString;
        ConfUtil.fillProperties(null, properties);
        if (log.isInfoEnabled()) {
            log.info("Consumer startup config properties before adding additional properties from Zookeeper={}", (Object)SensitivePropRedactionUtils.flattenAndRedactForLogging(properties));
        }
        if ((zkConnectString = (String)properties.get("solr.crossdc.zkConnectString")) == null) {
            throw new IllegalArgumentException("solr.crossdc.zkConnectString not specified for producer");
        }
        try (SolrZkClient client = new SolrZkClient.Builder().withUrl(zkConnectString).withTimeout(15, TimeUnit.SECONDS).build();){
            ConfUtil.fillProperties((SolrZkClient)client, properties);
        }
        ConfUtil.verifyProperties(properties);
        String bootstrapServers = (String)properties.get("solr.crossdc.bootstrapServers");
        String topicName = (String)properties.get("solr.crossdc.topicName");
        KafkaCrossDcConf conf = new KafkaCrossDcConf(properties);
        this.crossDcConsumer = this.getCrossDcConsumer(conf, this.startLatch);
        int port = conf.getInt("solr.crossdc.manager.port");
        if (port > 0) {
            log.info("Starting API endpoints...");
            this.server = new Server(port);
            ServletContextHandler context = new ServletContextHandler(0);
            context.setContextPath("/");
            this.server.setHandler((Handler)context);
            context.addServlet(ThreadDumpServlet.class, "/threads/*");
            context.addServlet(MetricsServlet.class, "/metrics/*");
            context.setAttribute("com.codahale.metrics.servlets.MetricsServlet.registry", (Object)SharedMetricRegistries.getOrCreate((String)METRICS_REGISTRY));
            for (ServletMapping mapping : context.getServletHandler().getServletMappings()) {
                if (!log.isInfoEnabled()) continue;
                log.info(" - {}", (Object)mapping.getPathSpecs()[0]);
            }
        }
        log.info("Starting CrossDC Consumer {}", (Object)conf);
        this.consumerThreadExecutor = ExecutorUtil.newMDCAwareSingleThreadExecutor((ThreadFactory)new SolrNamedThreadFactory("CrossDCConsumer"));
        this.consumerThreadExecutor.submit(this.crossDcConsumer);
        Thread shutdownHook = new Thread("ConsumerShutdownHook"){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info("Shutting down consumers!");
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        if (this.server != null) {
            try {
                this.server.start();
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, (Throwable)e);
            }
        }
        try {
            this.startLatch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (this.server != null) {
                try {
                    this.server.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, (Throwable)e);
        }
    }

    protected CrossDcConsumer getCrossDcConsumer(KafkaCrossDcConf conf, CountDownLatch startLatch) {
        return new KafkaCrossDcConsumer(conf, startLatch);
    }

    public static void main(String[] args) {
        Consumer consumer = new Consumer();
        consumer.start();
    }

    public final void shutdown() {
        if (this.crossDcConsumer != null) {
            this.crossDcConsumer.shutdown();
        }
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.consumerThreadExecutor != null) {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.consumerThreadExecutor);
        }
    }

    public static abstract class CrossDcConsumer
    implements Runnable {
        abstract void shutdown();
    }
}

