/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.internal;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.semver4j.Semver;

public class Comparator {
    private static final String ALL_DIGITS = "^\\d+$";
    private static final String CONTAINS_DIGITS = ".*\\d.*";
    private static final String TRAILING_DIGITS_EXTRACT = "(?<=\\D)(?=\\d)";
    private static final String LEADING_DIGITS_EXTRACT = "(?<=\\d)(?=\\D)";
    @NotNull
    private static final String UNDEFINED_MARKER = "undef";

    private Comparator() {
    }

    public static int compareTo(@NotNull Semver version, @NotNull Semver other) {
        int result = Comparator.mainCompare(version, other);
        if (result == 0) {
            return Comparator.preReleaseCompare(version, other);
        }
        return result;
    }

    private static int mainCompare(@NotNull Semver version, @NotNull Semver other) {
        int majorCompare = Long.compare(version.getMajor(), other.getMajor());
        if (majorCompare == 0) {
            int minorCompare = Long.compare(version.getMinor(), other.getMinor());
            if (minorCompare == 0) {
                return Long.compare(version.getPatch(), other.getPatch());
            }
            return minorCompare;
        }
        return majorCompare;
    }

    private static int preReleaseCompare(@NotNull Semver version, @NotNull Semver other) {
        if (!version.getPreRelease().isEmpty() && other.getPreRelease().isEmpty()) {
            return -1;
        }
        if (version.getPreRelease().isEmpty() && !other.getPreRelease().isEmpty()) {
            return 1;
        }
        if (version.getPreRelease().isEmpty() && other.getPreRelease().isEmpty()) {
            return 0;
        }
        int maxElements = Math.max(version.getPreRelease().size(), other.getPreRelease().size());
        int i = 0;
        do {
            String a = Comparator.getString(i, version.getPreRelease());
            String b = Comparator.getString(i, other.getPreRelease());
            ++i;
            if (a.equals(UNDEFINED_MARKER) && b.equals(UNDEFINED_MARKER)) {
                return 0;
            }
            if (b.equals(UNDEFINED_MARKER)) {
                return 1;
            }
            if (a.equals(UNDEFINED_MARKER)) {
                return -1;
            }
            if (a.equals(b)) continue;
            return Comparator.compareIdentifiers(a, b);
        } while (maxElements > i);
        return 0;
    }

    private static int compareIdentifiers(@NotNull String a, @NotNull String b) {
        Integer alphaNumericComparison;
        if (a.matches(ALL_DIGITS) && b.matches(ALL_DIGITS)) {
            long aAsLong = Long.parseLong(a);
            long bAsLong = Long.parseLong(b);
            return Long.compare(aAsLong, bAsLong);
        }
        if (a.matches(CONTAINS_DIGITS) && b.matches(CONTAINS_DIGITS) && (alphaNumericComparison = Comparator.checkAlphanumericPrerelease(a, b)) != null) {
            return alphaNumericComparison;
        }
        int i = a.compareTo(b);
        if (i > 0) {
            return 1;
        }
        if (i < 0) {
            return -1;
        }
        return 0;
    }

    @Nullable
    private static Integer checkAlphanumericPrerelease(@NotNull String a, @NotNull String b) {
        String[] tokenArrB;
        String[] tokenArrA = a.split(TRAILING_DIGITS_EXTRACT);
        if (tokenArrA[0].equals((tokenArrB = b.split(TRAILING_DIGITS_EXTRACT))[0])) {
            long digitB;
            String[] leadingDigitsArrA = tokenArrA[1].split(LEADING_DIGITS_EXTRACT);
            String[] leadingDigitsArrB = tokenArrB[1].split(LEADING_DIGITS_EXTRACT);
            long digitA = Long.parseLong(leadingDigitsArrA[0]);
            int digitComparison = Long.compare(digitA, digitB = Long.parseLong(leadingDigitsArrB[0]));
            if (digitComparison != 0) {
                return digitComparison;
            }
            if (leadingDigitsArrA.length != leadingDigitsArrB.length) {
                return leadingDigitsArrA.length - leadingDigitsArrB.length;
            }
            return Comparator.compareIdentifiers(a.substring(a.indexOf(leadingDigitsArrA[0]) + 1), b.substring(b.indexOf(leadingDigitsArrB[0]) + 1));
        }
        return null;
    }

    @NotNull
    private static String getString(int i, @NotNull @NotNull List<@NotNull String> list) {
        if (list.size() > i) {
            return list.get(i);
        }
        return UNDEFINED_MARKER;
    }
}

