/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.util.LinkedHashMap;
import java.util.Map;
import org.noggit.CharArr;
import org.noggit.JSONWriter;

class ReplicaHealth
implements Comparable<ReplicaHealth> {
    String shard;
    String name;
    String url;
    String status;
    long numDocs;
    boolean isLeader;
    String uptime;
    String memory;

    ReplicaHealth(String shard, String name, String url, String status, long numDocs, boolean isLeader, String uptime, String memory) {
        this.shard = shard;
        this.name = name;
        this.url = url;
        this.numDocs = numDocs;
        this.status = status;
        this.isLeader = isLeader;
        this.uptime = uptime;
        this.memory = memory;
    }

    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", this.name);
        map.put("url", this.url);
        map.put("numDocs", this.numDocs);
        map.put("status", this.status);
        if (this.uptime != null) {
            map.put("uptime", this.uptime);
        }
        if (this.memory != null) {
            map.put("memory", this.memory);
        }
        if (this.isLeader) {
            map.put("leader", true);
        }
        return map;
    }

    public String toString() {
        CharArr arr = new CharArr();
        new JSONWriter(arr, 2).write(this.asMap());
        return arr.toString();
    }

    public int hashCode() {
        return this.shard.hashCode() + (this.isLeader ? 1 : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaHealth)) {
            return true;
        }
        ReplicaHealth that = (ReplicaHealth)obj;
        return this.shard.equals(that.shard) && this.isLeader == that.isLeader;
    }

    @Override
    public int compareTo(ReplicaHealth other) {
        int otherShardIndex;
        if (this == other) {
            return 0;
        }
        if (other == null) {
            return 1;
        }
        int myShardIndex = Integer.parseInt(this.shard.substring("shard".length()));
        if (myShardIndex == (otherShardIndex = Integer.parseInt(other.shard.substring("shard".length())))) {
            return this.isLeader ? -1 : 1;
        }
        return myShardIndex - otherShardIndex;
    }
}

