/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class ValueSourceRangeFilter
extends Query {
    private final ValueSource valueSource;
    private final String lowerVal;
    private final String upperVal;
    private final boolean includeLower;
    private final boolean includeUpper;

    public ValueSourceRangeFilter(ValueSource valueSource, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        this.valueSource = valueSource;
        this.lowerVal = lowerVal;
        this.upperVal = upperVal;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    public ValueSource getValueSource() {
        return this.valueSource;
    }

    public String getLowerVal() {
        return this.lowerVal;
    }

    public String getUpperVal() {
        return this.upperVal;
    }

    public boolean isIncludeLower() {
        return this.includeLower;
    }

    public boolean isIncludeUpper() {
        return this.includeUpper;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new FunctionRangeWeight(searcher, scoreMode, boost);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("frange(");
        sb.append(this.valueSource);
        sb.append("):");
        sb.append(this.includeLower ? (char)'[' : '{');
        sb.append(this.lowerVal == null ? "*" : this.lowerVal);
        sb.append(" TO ");
        sb.append(this.upperVal == null ? "*" : this.upperVal);
        sb.append(this.includeUpper ? (char)']' : '}');
        return sb.toString();
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValueSourceRangeFilter)) {
            return false;
        }
        ValueSourceRangeFilter other = (ValueSourceRangeFilter)((Object)o);
        return Objects.equals(this.valueSource, other.valueSource) && this.includeLower == other.includeLower && this.includeUpper == other.includeUpper && Objects.equals(this.lowerVal, other.lowerVal) && Objects.equals(this.upperVal, other.upperVal);
    }

    public int hashCode() {
        int h = this.valueSource.hashCode();
        h += this.lowerVal != null ? this.lowerVal.hashCode() : 1461933019;
        h = h << 16 | h >>> 16;
        h += this.upperVal != null ? this.upperVal.hashCode() : -512759321;
        return h += (this.includeLower ? -626755208 : 0) + (this.includeUpper ? -1637659817 : 0);
    }

    private class FunctionRangeWeight
    extends ConstantScoreWeight {
        private final Map<Object, Object> vsContext;
        private final ScoreMode scoreMode;

        public FunctionRangeWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
            super((Query)ValueSourceRangeFilter.this, boost);
            this.scoreMode = scoreMode;
            this.vsContext = ValueSource.newContext((IndexSearcher)searcher);
            ValueSourceRangeFilter.this.valueSource.createWeight(this.vsContext, searcher);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            FunctionValues functionValues = ValueSourceRangeFilter.this.valueSource.getValues(this.vsContext, context);
            ValueSourceScorer scorer = functionValues.getRangeScorer((Weight)this, context, ValueSourceRangeFilter.this.lowerVal, ValueSourceRangeFilter.this.upperVal, ValueSourceRangeFilter.this.includeLower, ValueSourceRangeFilter.this.includeUpper);
            if (scorer.matches(doc)) {
                scorer.iterator().advance(doc);
                return Explanation.match((Number)Float.valueOf(scorer.score()), (String)ValueSourceRangeFilter.this.toString(), (Explanation[])new Explanation[]{functionValues.explain(doc)});
            }
            return Explanation.noMatch((String)ValueSourceRangeFilter.this.toString(), (Explanation[])new Explanation[]{functionValues.explain(doc)});
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            ValueSourceScorer scorer = ValueSourceRangeFilter.this.valueSource.getValues(this.vsContext, context).getRangeScorer((Weight)this, context, ValueSourceRangeFilter.this.lowerVal, ValueSourceRangeFilter.this.upperVal, ValueSourceRangeFilter.this.includeLower, ValueSourceRangeFilter.this.includeUpper);
            return new ConstantScoreScorer((Weight)this, this.score(), this.scoreMode, scorer.iterator());
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }
}

