/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.HTTP2ClientConnectionFactory;
import org.eclipse.jetty.http2.client.http.HTTPSessionListenerPromise;
import org.eclipse.jetty.http2.client.http.HttpConnectionOverHTTP2;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslClientConnectionFactory;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public class ClientConnectionFactoryOverHTTP2
extends ContainerLifeCycle
implements ClientConnectionFactory {
    private final ClientConnectionFactory factory = new HTTP2ClientConnectionFactory();
    private final HTTP2Client client;

    public ClientConnectionFactoryOverHTTP2(HTTP2Client client) {
        this.client = client;
        this.addBean(client);
    }

    public org.eclipse.jetty.io.Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HTTPSessionListenerPromise listenerPromise = new HTTPSessionListenerPromise(context);
        context.put("org.eclipse.jetty.client.http2", this.client);
        context.put("org.eclipse.jetty.client.http2.sessionListener", (Object)listenerPromise);
        context.put("org.eclipse.jetty.client.http2.sessionPromise", (Object)listenerPromise);
        return this.factory.newConnection(endPoint, context);
    }

    public static class HTTP2
    extends ClientConnectionFactory.Info {
        private static final List<String> protocols = List.of("h2", "h2c");
        private static final List<String> h2c = List.of("h2c");

        public HTTP2(HTTP2Client client) {
            super((ClientConnectionFactory)new ClientConnectionFactoryOverHTTP2(client));
        }

        public List<String> getProtocols(boolean secure) {
            return secure ? protocols : h2c;
        }

        public void upgrade(EndPoint endPoint, final Map<String, Object> context) {
            final HttpDestination destination = (HttpDestination)context.get("org.eclipse.jetty.client.destination");
            final Promise promise = (Promise)context.get("org.eclipse.jetty.client.connection.promise");
            context.put("org.eclipse.jetty.client.connection.promise", new Promise<HttpConnectionOverHTTP2>(){

                public void succeeded(HttpConnectionOverHTTP2 connection) {
                    promise.succeeded((Object)connection);
                    connection.upgrade(context);
                    destination.accept((Connection)connection);
                }

                public void failed(Throwable x) {
                    promise.failed(x);
                }
            });
            this.upgrade(destination.getClientConnectionFactory(), endPoint, context);
        }

        private void upgrade(ClientConnectionFactory factory, EndPoint endPoint, Map<String, Object> context) {
            try {
                if (factory instanceof SslClientConnectionFactory && endPoint instanceof SslConnection.DecryptedEndPoint) {
                    factory = ((SslClientConnectionFactory)factory).getClientConnectionFactory();
                }
                org.eclipse.jetty.io.Connection newConnection = factory.newConnection(endPoint, context);
                endPoint.upgrade(newConnection);
            }
            catch (IOException x) {
                throw new UncheckedIOException(x);
            }
        }

        public String toString() {
            return String.format("%s@%x%s", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), protocols);
        }
    }
}

