/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jetty.start.StartLog;

public class Classpath
implements Iterable<File> {
    private final List<File> elements = new ArrayList<File>();

    public Classpath() {
    }

    public Classpath(String initial) {
        this.addClasspath(initial);
    }

    public boolean addClasspath(String s) {
        boolean added = false;
        if (s != null) {
            StringTokenizer t = new StringTokenizer(s, File.pathSeparator);
            while (t.hasMoreTokens()) {
                added |= this.addComponent(t.nextToken());
            }
        }
        return added;
    }

    public boolean addComponent(File path) {
        StartLog.debug("Adding classpath component: %s", path);
        if (path == null || !path.exists()) {
            return false;
        }
        try {
            File key = path.getCanonicalFile();
            if (!this.elements.contains(key)) {
                this.elements.add(key);
                return true;
            }
        }
        catch (IOException e) {
            StartLog.debug(e);
        }
        return false;
    }

    public boolean addComponent(String component) {
        if (component == null || component.length() <= 0) {
            return false;
        }
        return this.addComponent(new File(component));
    }

    public int count() {
        return this.elements.size();
    }

    public void dump(PrintStream out) {
        int i = 0;
        for (File element : this.elements) {
            out.printf("%2d: %s%n", i++, element.getAbsolutePath());
        }
    }

    public ClassLoader getClassLoader() {
        int cnt = this.elements.size();
        URL[] urls = new URL[cnt];
        for (int i = 0; i < cnt; ++i) {
            try {
                urls[i] = this.elements.get(i).toURI().toURL();
                StartLog.debug("URLClassLoader.url[%d] = %s", i, urls[i]);
                continue;
            }
            catch (MalformedURLException e) {
                StartLog.warn(e);
            }
        }
        StartLog.debug("Loaded %d URLs into URLClassLoader", urls.length);
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = Classpath.class.getClassLoader();
        }
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        return new Loader(urls, parent);
    }

    public List<File> getElements() {
        return this.elements;
    }

    public boolean isEmpty() {
        return this.elements == null || this.elements.isEmpty();
    }

    @Override
    public Iterator<File> iterator() {
        return this.elements.iterator();
    }

    public void overlay(Classpath other) {
        for (File otherElement : other.elements) {
            if (this.elements.contains(otherElement)) continue;
            this.elements.add(otherElement);
        }
    }

    public String toString() {
        StringBuffer cp = new StringBuffer(1024);
        boolean needDelim = false;
        for (File element : this.elements) {
            if (needDelim) {
                cp.append(File.pathSeparatorChar);
            }
            cp.append(element.getAbsolutePath());
            needDelim = true;
        }
        return cp.toString();
    }

    private static class Loader
    extends URLClassLoader {
        Loader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public String toString() {
            return "startJarLoader@" + Long.toHexString(this.hashCode());
        }

        static {
            Loader.registerAsParallelCapable();
        }
    }
}

