/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eq;

import java.io.IOException;
import java.util.UUID;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.MultipleFieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eq.StreamEqualitor;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MultipleFieldEqualitor
implements StreamEqualitor {
    private static final long serialVersionUID = 1L;
    private UUID equalitorNodeId = UUID.randomUUID();
    private StreamEqualitor[] eqs;

    public MultipleFieldEqualitor(StreamEqualitor ... eqs) {
        this.eqs = eqs;
    }

    public StreamEqualitor[] getEqs() {
        return this.eqs;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (StreamEqualitor eq : this.eqs) {
            if (eq instanceof Expressible) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
            } else {
                throw new IOException("This MultiEqualitor contains a non-expressible equalitor - it cannot be converted to an expression");
            }
            sb.append(((Expressible)eq).toExpression(factory));
        }
        return new StreamExpressionValue(sb.toString());
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.equalitorNodeId.toString()).withExpressionType("equalitor").withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }

    @Override
    public boolean isDerivedFrom(StreamEqualitor base) {
        if (null == base) {
            return false;
        }
        if (base instanceof MultipleFieldEqualitor) {
            MultipleFieldEqualitor baseEq = (MultipleFieldEqualitor)base;
            if (baseEq.eqs.length >= this.eqs.length) {
                for (int idx = 0; idx < this.eqs.length; ++idx) {
                    if (this.eqs[idx].isDerivedFrom(baseEq.eqs[idx])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDerivedFrom(StreamComparator base) {
        if (null == base) {
            return false;
        }
        MultipleFieldComparator baseComps = (MultipleFieldComparator)base;
        if (baseComps.getComps().length >= this.eqs.length) {
            for (int idx = 0; idx < this.eqs.length; ++idx) {
                if (this.eqs[idx].isDerivedFrom(baseComps.getComps()[idx])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean test(Tuple t1, Tuple t2) {
        for (StreamEqualitor eq : this.eqs) {
            if (eq.test(t1, t2)) continue;
            return false;
        }
        return true;
    }
}

