/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.search.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.search.provider.SearchFilter;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.provider.impl.CompoundSearchInfo;
import org.netbeans.api.search.provider.impl.DelegatingSearchFilter;
import org.netbeans.api.search.provider.impl.DelegatingSearchInfo;
import org.netbeans.api.search.provider.impl.EmptySearchInfo;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.netbeans.spi.search.SearchInfoDefinitionFactory;
import org.netbeans.spi.search.impl.SearchInfoDefinitionUtils;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Parameters;

public final class SearchInfoUtils {
    public static final SearchFilter VISIBILITY_FILTER = SearchInfoUtils.createVisibilityFilter();
    public static final SearchFilter SHARABILITY_FILTER = SearchInfoUtils.createSharabilityFilter();
    public static final List<SearchFilter> DEFAULT_FILTERS = SearchInfoUtils.createDefaultFilterList();

    @CheckForNull
    public static SearchInfo getSearchInfoForNode(@NonNull Node node) {
        Parameters.notNull((CharSequence)"node", (Object)node);
        SearchInfoDefinition searchInfoDefinition = SearchInfoDefinitionUtils.getSearchInfoDefinition(node);
        if (searchInfoDefinition == null) {
            return null;
        }
        return new DelegatingSearchInfo(searchInfoDefinition);
    }

    @CheckForNull
    public static SearchInfo findDefinedSearchInfo(@NonNull Node node) {
        Parameters.notNull((CharSequence)"node", (Object)node);
        SearchInfoDefinition searchInfoDefinition = SearchInfoDefinitionUtils.findSearchInfoDefinition(node);
        if (searchInfoDefinition != null) {
            return new DelegatingSearchInfo(searchInfoDefinition);
        }
        return null;
    }

    @NonNull
    public static SearchInfo createForDefinition(@NonNull SearchInfoDefinition searchInfoDefinition) {
        Parameters.notNull((CharSequence)"definition", (Object)searchInfoDefinition);
        return new DelegatingSearchInfo(searchInfoDefinition);
    }

    @NonNull
    public static SearchInfo createCompoundSearchInfo(SearchInfo ... searchInfoArray) {
        Parameters.notNull((CharSequence)"delegates", (Object)searchInfoArray);
        return new CompoundSearchInfo(searchInfoArray);
    }

    @NonNull
    public static SearchInfo createEmptySearchInfo() {
        return new EmptySearchInfo();
    }

    @NonNull
    public static SearchInfo createSearchInfoForRoot(@NonNull FileObject fileObject) {
        Parameters.notNull((CharSequence)"root", (Object)fileObject);
        return new DelegatingSearchInfo(SearchInfoDefinitionFactory.createSearchInfo(fileObject));
    }

    @NonNull
    public static SearchInfo createSearchInfoForRoots(@NonNull FileObject[] fileObjectArray) {
        Parameters.notNull((CharSequence)"roots", (Object)fileObjectArray);
        return new DelegatingSearchInfo(SearchInfoDefinitionFactory.createSearchInfo(fileObjectArray));
    }

    @NonNull
    public static SearchInfo createSearchInfoForRoots(@NonNull FileObject[] fileObjectArray, boolean bl, SearchFilterDefinition ... searchFilterDefinitionArray) {
        Parameters.notNull((CharSequence)"roots", (Object)fileObjectArray);
        int n = bl ? SearchInfoDefinitionFactory.DEFAULT_FILTER_DEFS.size() : 0;
        int n2 = searchFilterDefinitionArray.length;
        SearchFilterDefinition[] searchFilterDefinitionArray2 = new SearchFilterDefinition[n + n2];
        for (int i = 0; i < n; ++i) {
            searchFilterDefinitionArray2[i] = SearchInfoDefinitionFactory.DEFAULT_FILTER_DEFS.get(i);
        }
        System.arraycopy(searchFilterDefinitionArray, 0, searchFilterDefinitionArray2, n, n2);
        return new DelegatingSearchInfo(SearchInfoDefinitionFactory.createSearchInfo(fileObjectArray, searchFilterDefinitionArray2));
    }

    private static SearchFilter createVisibilityFilter() {
        return new DelegatingSearchFilter(SearchInfoDefinitionFactory.VISIBILITY_FILTER);
    }

    private static SearchFilter createSharabilityFilter() {
        return new DelegatingSearchFilter(SearchInfoDefinitionFactory.SHARABILITY_FILTER);
    }

    private static List<SearchFilter> createDefaultFilterList() {
        ArrayList<SearchFilter> arrayList = new ArrayList<SearchFilter>(2);
        arrayList.add(VISIBILITY_FILTER);
        arrayList.add(SHARABILITY_FILTER);
        return Collections.unmodifiableList(arrayList);
    }
}

