/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XSizeHints
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 72 : 80;
    }

    @Override
    public int getDataSize() {
        return XSizeHints.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XSizeHints(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XSizeHints() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XSizeHints.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public long get_flags() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_flags(long l) {
        log.finest("");
        Native.putLong(this.pData + 0L, l);
    }

    public int get_x() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8));
    }

    public void set_x(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8), n);
    }

    public int get_y() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 12));
    }

    public void set_y(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 12), n);
    }

    public int get_width() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 16));
    }

    public void set_width(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 16), n);
    }

    public int get_height() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 16 : 20));
    }

    public void set_height(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 16 : 20), n);
    }

    public int get_min_width() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 20 : 24));
    }

    public void set_min_width(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 20 : 24), n);
    }

    public int get_min_height() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 24 : 28));
    }

    public void set_min_height(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 24 : 28), n);
    }

    public int get_max_width() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 32));
    }

    public void set_max_width(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 32), n);
    }

    public int get_max_height() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 36));
    }

    public void set_max_height(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 36), n);
    }

    public int get_width_inc() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 36 : 40));
    }

    public void set_width_inc(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 36 : 40), n);
    }

    public int get_height_inc() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 40 : 44));
    }

    public void set_height_inc(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 40 : 44), n);
    }

    public int get_min_aspect_x() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 44 : 48));
    }

    public void set_min_aspect_x(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 44 : 48), n);
    }

    public int get_min_aspect_y() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 48 : 52));
    }

    public void set_min_aspect_y(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 48 : 52), n);
    }

    public int get_max_aspect_x() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 52 : 56));
    }

    public void set_max_aspect_x(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 52 : 56), n);
    }

    public int get_max_aspect_y() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 56 : 60));
    }

    public void set_max_aspect_y(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 56 : 60), n);
    }

    public int get_base_width() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 60 : 64));
    }

    public void set_base_width(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 60 : 64), n);
    }

    public int get_base_height() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 64 : 68));
    }

    public void set_base_height(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 64 : 68), n);
    }

    public int get_win_gravity() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 68 : 72));
    }

    public void set_win_gravity(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 68 : 72), n);
    }

    @Override
    String getName() {
        return "XSizeHints";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(720);
        stringBuilder.append("flags = ").append(this.get_flags()).append(", ");
        stringBuilder.append("x = ").append(this.get_x()).append(", ");
        stringBuilder.append("y = ").append(this.get_y()).append(", ");
        stringBuilder.append("width = ").append(this.get_width()).append(", ");
        stringBuilder.append("height = ").append(this.get_height()).append(", ");
        stringBuilder.append("min_width = ").append(this.get_min_width()).append(", ");
        stringBuilder.append("min_height = ").append(this.get_min_height()).append(", ");
        stringBuilder.append("max_width = ").append(this.get_max_width()).append(", ");
        stringBuilder.append("max_height = ").append(this.get_max_height()).append(", ");
        stringBuilder.append("width_inc = ").append(this.get_width_inc()).append(", ");
        stringBuilder.append("height_inc = ").append(this.get_height_inc()).append(", ");
        stringBuilder.append("min_aspect_x = ").append(this.get_min_aspect_x()).append(", ");
        stringBuilder.append("min_aspect_y = ").append(this.get_min_aspect_y()).append(", ");
        stringBuilder.append("max_aspect_x = ").append(this.get_max_aspect_x()).append(", ");
        stringBuilder.append("max_aspect_y = ").append(this.get_max_aspect_y()).append(", ");
        stringBuilder.append("base_width = ").append(this.get_base_width()).append(", ");
        stringBuilder.append("base_height = ").append(this.get_base_height()).append(", ");
        stringBuilder.append("win_gravity = ").append(this.get_win_gravity()).append(", ");
        return stringBuilder.toString();
    }
}

