/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.BinaryOperatorNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;

public class OrNode
extends Node
implements BinaryOperatorNode {
    private final Node firstNode;
    private final Node secondNode;

    public OrNode(int line, Node firstNode, Node secondNode) {
        super(line, firstNode.containsVariableAssignment() || secondNode.containsVariableAssignment());
        assert (secondNode != null) : "secondNode is not null";
        this.firstNode = firstNode;
        this.secondNode = secondNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ORNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitOrNode(this);
    }

    @Override
    public Node getFirstNode() {
        return this.firstNode;
    }

    @Override
    public Node getSecondNode() {
        return this.secondNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.firstNode, this.secondNode);
    }
}

