/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.monospace;

import org.pentaho.reporting.libraries.fonts.monospace.MonospaceFontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontType;

public class MonospaceFontRecord
implements FontRecord,
FontIdentifier {
    private MonospaceFontFamily fontFamily;
    private boolean bold;
    private boolean italics;

    public MonospaceFontRecord(MonospaceFontFamily fontFamily, boolean bold, boolean italics) {
        if (fontFamily == null) {
            throw new NullPointerException();
        }
        this.fontFamily = fontFamily;
        this.bold = bold;
        this.italics = italics;
    }

    @Override
    public FontFamily getFamily() {
        return this.fontFamily;
    }

    @Override
    public boolean isBold() {
        return this.bold;
    }

    @Override
    public boolean isItalic() {
        return false;
    }

    @Override
    public boolean isOblique() {
        return this.italics;
    }

    @Override
    public boolean isScalable() {
        return false;
    }

    @Override
    public FontType getFontType() {
        return FontType.MONOSPACE;
    }

    @Override
    public FontIdentifier getIdentifier() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonospaceFontRecord that = (MonospaceFontRecord)o;
        if (this.bold != that.bold) {
            return false;
        }
        if (this.italics != that.italics) {
            return false;
        }
        return this.fontFamily.equals(that.fontFamily);
    }

    @Override
    public int hashCode() {
        int result = this.fontFamily.hashCode();
        result = 29 * result + (this.bold ? 1 : 0);
        result = 29 * result + (this.italics ? 1 : 0);
        return result;
    }
}

