/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.CompileTimeFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class Data
extends CompileTimeFunction
implements Callable {
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        if (this.argument.length == 0) {
            this.argument = new Expression[1];
            this.argument[0] = new ContextItemExpression();
        }
        Expression a = Atomizer.makeAtomizer(this.argument[0]);
        ExpressionTool.copyLocationInfo(this, a);
        return visitor.simplify(a);
    }

    public int getIntrinsicDependencies() {
        if (this.getNumberOfArguments() == 0) {
            return 2;
        }
        return super.getIntrinsicDependencies();
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Sequence arg = arguments.length == 0 ? context.getContextItem() : arguments[0];
        if (arg instanceof Item) {
            if (arg instanceof NodeInfo) {
                return ((NodeInfo)arg).atomize();
            }
            if (arg instanceof AtomicValue) {
                return arg;
            }
            throw new XPathException("Cannot atomize a function item or external value", "FOTY0017");
        }
        SequenceIterator a = Atomizer.getAtomizingIterator(arg.iterate(), false);
        return SequenceTool.toLazySequence(a);
    }
}

