/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VRVulkanDevice_t")
public class VRVulkanDevice
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_PINSTANCE;
    public static final int M_PDEVICE;
    public static final int M_PPHYSICALDEVICE;
    public static final int M_PQUEUE;
    public static final int M_UQUEUEFAMILYINDEX;

    public VRVulkanDevice(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VRVulkanDevice.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkInstance_T *")
    public long m_pInstance() {
        return VRVulkanDevice.nm_pInstance(this.address());
    }

    @NativeType(value="VkDevice_T *")
    public long m_pDevice() {
        return VRVulkanDevice.nm_pDevice(this.address());
    }

    @NativeType(value="VkPhysicalDevice_T *")
    public long m_pPhysicalDevice() {
        return VRVulkanDevice.nm_pPhysicalDevice(this.address());
    }

    @NativeType(value="VkQueue_T *")
    public long m_pQueue() {
        return VRVulkanDevice.nm_pQueue(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_uQueueFamilyIndex() {
        return VRVulkanDevice.nm_uQueueFamilyIndex(this.address());
    }

    public VRVulkanDevice m_pInstance(@NativeType(value="VkInstance_T *") long value) {
        VRVulkanDevice.nm_pInstance(this.address(), value);
        return this;
    }

    public VRVulkanDevice m_pDevice(@NativeType(value="VkDevice_T *") long value) {
        VRVulkanDevice.nm_pDevice(this.address(), value);
        return this;
    }

    public VRVulkanDevice m_pPhysicalDevice(@NativeType(value="VkPhysicalDevice_T *") long value) {
        VRVulkanDevice.nm_pPhysicalDevice(this.address(), value);
        return this;
    }

    public VRVulkanDevice m_pQueue(@NativeType(value="VkQueue_T *") long value) {
        VRVulkanDevice.nm_pQueue(this.address(), value);
        return this;
    }

    public VRVulkanDevice m_uQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VRVulkanDevice.nm_uQueueFamilyIndex(this.address(), value);
        return this;
    }

    public VRVulkanDevice set(long m_pInstance, long m_pDevice, long m_pPhysicalDevice, long m_pQueue, int m_uQueueFamilyIndex) {
        this.m_pInstance(m_pInstance);
        this.m_pDevice(m_pDevice);
        this.m_pPhysicalDevice(m_pPhysicalDevice);
        this.m_pQueue(m_pQueue);
        this.m_uQueueFamilyIndex(m_uQueueFamilyIndex);
        return this;
    }

    public VRVulkanDevice set(VRVulkanDevice src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VRVulkanDevice malloc() {
        return (VRVulkanDevice)VRVulkanDevice.wrap(VRVulkanDevice.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VRVulkanDevice calloc() {
        return (VRVulkanDevice)VRVulkanDevice.wrap(VRVulkanDevice.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VRVulkanDevice create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VRVulkanDevice)VRVulkanDevice.wrap(VRVulkanDevice.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VRVulkanDevice create(long address) {
        return (VRVulkanDevice)VRVulkanDevice.wrap(VRVulkanDevice.class, (long)address);
    }

    @Nullable
    public static VRVulkanDevice createSafe(long address) {
        return address == 0L ? null : (VRVulkanDevice)VRVulkanDevice.wrap(VRVulkanDevice.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VRVulkanDevice.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VRVulkanDevice.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VRVulkanDevice.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VRVulkanDevice.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VRVulkanDevice.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VRVulkanDevice.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VRVulkanDevice.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VRVulkanDevice malloc(MemoryStack stack) {
        return (VRVulkanDevice)VRVulkanDevice.wrap(VRVulkanDevice.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VRVulkanDevice calloc(MemoryStack stack) {
        return (VRVulkanDevice)VRVulkanDevice.wrap(VRVulkanDevice.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VRVulkanDevice.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VRVulkanDevice.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nm_pInstance(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)M_PINSTANCE));
    }

    public static long nm_pDevice(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)M_PDEVICE));
    }

    public static long nm_pPhysicalDevice(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)M_PPHYSICALDEVICE));
    }

    public static long nm_pQueue(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)M_PQUEUE));
    }

    public static int nm_uQueueFamilyIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_UQUEUEFAMILYINDEX);
    }

    public static void nm_pInstance(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)M_PINSTANCE), (long)Checks.check((long)value));
    }

    public static void nm_pDevice(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)M_PDEVICE), (long)Checks.check((long)value));
    }

    public static void nm_pPhysicalDevice(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)M_PPHYSICALDEVICE), (long)Checks.check((long)value));
    }

    public static void nm_pQueue(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)M_PQUEUE), (long)Checks.check((long)value));
    }

    public static void nm_uQueueFamilyIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_UQUEUEFAMILYINDEX, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)M_PINSTANCE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)M_PDEVICE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)M_PPHYSICALDEVICE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)M_PQUEUE)));
    }

    static {
        Struct.Layout layout = VRVulkanDevice.__struct((Struct.Member[])new Struct.Member[]{VRVulkanDevice.__member((int)POINTER_SIZE), VRVulkanDevice.__member((int)POINTER_SIZE), VRVulkanDevice.__member((int)POINTER_SIZE), VRVulkanDevice.__member((int)POINTER_SIZE), VRVulkanDevice.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_PINSTANCE = layout.offsetof(0);
        M_PDEVICE = layout.offsetof(1);
        M_PPHYSICALDEVICE = layout.offsetof(2);
        M_PQUEUE = layout.offsetof(3);
        M_UQUEUEFAMILYINDEX = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VRVulkanDevice, Buffer>
    implements NativeResource {
        private static final VRVulkanDevice ELEMENT_FACTORY = VRVulkanDevice.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VRVulkanDevice getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkInstance_T *")
        public long m_pInstance() {
            return VRVulkanDevice.nm_pInstance(this.address());
        }

        @NativeType(value="VkDevice_T *")
        public long m_pDevice() {
            return VRVulkanDevice.nm_pDevice(this.address());
        }

        @NativeType(value="VkPhysicalDevice_T *")
        public long m_pPhysicalDevice() {
            return VRVulkanDevice.nm_pPhysicalDevice(this.address());
        }

        @NativeType(value="VkQueue_T *")
        public long m_pQueue() {
            return VRVulkanDevice.nm_pQueue(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_uQueueFamilyIndex() {
            return VRVulkanDevice.nm_uQueueFamilyIndex(this.address());
        }

        public Buffer m_pInstance(@NativeType(value="VkInstance_T *") long value) {
            VRVulkanDevice.nm_pInstance(this.address(), value);
            return this;
        }

        public Buffer m_pDevice(@NativeType(value="VkDevice_T *") long value) {
            VRVulkanDevice.nm_pDevice(this.address(), value);
            return this;
        }

        public Buffer m_pPhysicalDevice(@NativeType(value="VkPhysicalDevice_T *") long value) {
            VRVulkanDevice.nm_pPhysicalDevice(this.address(), value);
            return this;
        }

        public Buffer m_pQueue(@NativeType(value="VkQueue_T *") long value) {
            VRVulkanDevice.nm_pQueue(this.address(), value);
            return this;
        }

        public Buffer m_uQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VRVulkanDevice.nm_uQueueFamilyIndex(this.address(), value);
            return this;
        }
    }
}

