/*
 * Decompiled with CFR 0.152.
 */
package wrappers;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import com.mongodb.WriteConcernException;
import com.mongodb.WriteResult;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.bson.types.ObjectId;

public class Mongo2Interface {
    boolean DEBUG = false;
    String Errmsg = "No error";
    String ovalName = null;
    Set<String> Colnames = null;
    Cursor cursor = null;
    MongoClient client = null;
    DB db = null;
    DBCollection coll = null;
    BasicDBObject doc = null;
    BasicDBObject dbq = null;
    BasicDBObject dbf = null;
    List<DBObject> pip = null;
    AggregationOptions aop = null;

    public Mongo2Interface() {
        this(false);
    }

    public Mongo2Interface(boolean b) {
        this.DEBUG = b;
    }

    protected void SetErrmsg(String str) {
        if (this.DEBUG) {
            System.out.println(str);
        }
        this.Errmsg = str;
    }

    protected void SetErrmsg(Exception e) {
        if (this.DEBUG) {
            System.out.println(e.getMessage());
        }
        this.Errmsg = e.toString();
    }

    public String GetErrmsg() {
        String err = this.Errmsg;
        this.Errmsg = "No error";
        return err;
    }

    public int MongoConnect(String[] parms) {
        int rc = 0;
        if (this.DEBUG) {
            System.out.println("Mongo2: URI=" + parms[0] + " DB=" + parms[1]);
        }
        try {
            MongoClientURI uri = new MongoClientURI(parms[0]);
            this.client = new MongoClient(uri);
            if (this.DEBUG) {
                System.out.println("Connection " + this.client.toString() + " established");
            }
            this.db = this.client.getDB(parms[1]);
            if (parms[2] != null && !parms[2].isEmpty()) {
                if (this.DEBUG) {
                    System.out.println("user=" + parms[2] + " pwd=" + parms[3]);
                }
                boolean auth = this.db.authenticate(parms[2], parms[3].toCharArray());
                if (this.DEBUG) {
                    System.out.println("Authentication: " + auth);
                }
            }
        }
        catch (MongoException me) {
            this.SetErrmsg(me);
            rc = -1;
        }
        catch (Exception e) {
            this.SetErrmsg(e);
            rc = -3;
        }
        return rc;
    }

    public int MongoDisconnect() {
        int rc = 0;
        try {
            if (this.cursor != null) {
                if (this.DEBUG) {
                    System.out.println("Closing cursor");
                }
                this.cursor.close();
                this.cursor = null;
            }
            if (this.client != null) {
                if (this.DEBUG) {
                    System.out.println("Closing connection");
                }
                this.client.close();
                this.client = null;
            }
        }
        catch (MongoException se) {
            this.SetErrmsg(se);
            rc += 8;
        }
        return rc;
    }

    public boolean GetCollection(String name) {
        if (this.DEBUG) {
            System.out.println("GetCollection: name=" + name);
        }
        try {
            this.coll = this.db.getCollection(name);
        }
        catch (Exception e) {
            this.SetErrmsg(e);
            return true;
        }
        return false;
    }

    public long GetCollSize() {
        return this.coll != null ? this.coll.count() : 0L;
    }

    public boolean FindColl(String query, String fields) {
        if (this.DEBUG) {
            System.out.println("FindColl: query=" + query + " fields=" + fields);
        }
        try {
            if (query != null || fields != null) {
                this.dbq = (BasicDBObject)JSON.parse(query != null ? query : "{}");
                if (fields != null) {
                    this.dbf = (BasicDBObject)JSON.parse(fields);
                    this.cursor = this.coll.find(this.dbq, this.dbf);
                } else {
                    this.cursor = this.coll.find(this.dbq);
                }
            } else {
                this.cursor = this.coll.find();
            }
        }
        catch (Exception e) {
            this.SetErrmsg(e);
            return true;
        }
        return false;
    }

    public boolean AggregateColl(String pipeline) {
        if (this.DEBUG) {
            System.out.println("AggregateColl: pipeline=" + pipeline);
        }
        try {
            DBObject pipe = (DBObject)JSON.parse(pipeline);
            this.pip = (List)pipe.get("pipeline");
            this.aop = AggregationOptions.builder().batchSize(0).allowDiskUse(true).outputMode(AggregationOptions.OutputMode.CURSOR).build();
            this.cursor = this.coll.aggregate(this.pip, this.aop);
        }
        catch (MongoException me) {
            this.SetErrmsg(me);
            return true;
        }
        return false;
    }

    public boolean Rewind() {
        if (this.cursor != null) {
            this.cursor.close();
        }
        this.cursor = this.pip == null ? (this.dbf != null ? this.coll.find(this.dbq, this.dbf) : (this.dbq != null ? this.coll.find(this.dbq) : this.coll.find())) : this.coll.aggregate(this.pip, this.aop);
        return this.cursor == null;
    }

    public int ReadNext() {
        try {
            if (this.cursor.hasNext()) {
                this.doc = (BasicDBObject)this.cursor.next();
                if (this.DEBUG) {
                    System.out.println("Class doc = " + this.doc.getClass());
                }
                this.Colnames = this.doc.keySet();
                return this.Colnames.size();
            }
            return 0;
        }
        catch (MongoException me) {
            this.SetErrmsg(me);
            return -1;
        }
    }

    public boolean Fetch(int row) {
        if (this.cursor.hasNext()) {
            this.doc = (BasicDBObject)this.cursor.next();
            this.Colnames = this.doc.keySet();
            return true;
        }
        return false;
    }

    public String GetDoc() {
        return this.doc != null ? this.doc.toString() : null;
    }

    public Set<String> GetColumns() {
        if (this.doc != null) {
            return this.doc.keySet();
        }
        return null;
    }

    public Object ColumnDesc(Object obj, int n, int[] val, int lvl) {
        Object ret = null;
        Object oval = obj != null ? obj : this.doc;
        BasicDBObject dob = oval instanceof BasicDBObject ? (BasicDBObject)oval : null;
        BasicDBList ary = oval instanceof BasicDBList ? (BasicDBList)oval : null;
        try {
            if (ary != null) {
                oval = ary.get(n);
                this.ovalName = Integer.toString(n);
            } else if (dob != null) {
                Object[] k = dob.keySet().toArray();
                oval = dob.get(k[n]);
                this.ovalName = (String)k[n];
            } else {
                this.ovalName = "x" + Integer.toString(n);
            }
            if (this.DEBUG) {
                System.out.println("Class of " + this.ovalName + " = " + oval.getClass());
            }
            val[0] = 0;
            val[1] = 0;
            val[2] = 0;
            val[3] = 0;
            val[4] = 0;
            if (oval == null) {
                val[3] = 1;
            } else if (oval instanceof String) {
                val[0] = 1;
                val[1] = ((String)oval).length();
            } else if (oval instanceof ObjectId) {
                val[0] = 1;
                val[1] = ((ObjectId)oval).toString().length();
            } else if (oval instanceof Integer) {
                val[0] = 7;
                val[1] = Integer.toString((Integer)oval).length();
            } else if (oval instanceof Long) {
                val[0] = 5;
                val[1] = Long.toString((Long)oval).length();
            } else if (oval instanceof Date) {
                Long TS = ((Date)oval).getTime() / 1000L;
                val[0] = 8;
                val[1] = TS.toString().length();
            } else if (oval instanceof Double) {
                String d = Double.toString((Double)oval);
                int i = d.indexOf(46) + 1;
                val[0] = 2;
                val[1] = d.length();
                val[2] = i > 0 ? val[1] - i : 0;
            } else if (oval instanceof Boolean) {
                val[0] = 4;
                val[1] = 1;
            } else if (oval instanceof BasicDBObject) {
                if (lvl > 0) {
                    ret = oval;
                    val[0] = 1;
                    val[4] = ((BasicDBObject)oval).size();
                } else if (lvl == 0) {
                    val[0] = 1;
                    val[1] = oval.toString().length();
                }
            } else if (oval instanceof BasicDBList) {
                if (lvl > 0) {
                    ret = oval;
                    val[0] = 2;
                    val[4] = ((BasicDBList)oval).size();
                } else if (lvl == 0) {
                    val[0] = 1;
                    val[1] = oval.toString().length();
                }
            } else {
                this.SetErrmsg("Type  of " + this.ovalName + " not supported");
                val[0] = -1;
            }
            return ret;
        }
        catch (Exception ex) {
            this.SetErrmsg(ex);
            val[0] = -1;
            return null;
        }
    }

    public String ColDescName() {
        return this.ovalName;
    }

    protected Object GetFieldObject(String path) {
        Object o = null;
        BasicDBObject dob = null;
        ArrayList lst = null;
        String[] names = null;
        if (path == null || path.equals("") || path.equals("*")) {
            return this.doc;
        }
        if (!(this.doc instanceof BasicDBObject)) {
            return this.doc;
        }
        dob = this.doc;
        try {
            String[] stringArray = names = path.split("\\.");
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                o = lst != null ? lst.get(Integer.parseInt(name)) : dob.get(name);
                if (o == null) break;
                if (this.DEBUG) {
                    System.out.println("Class o = " + o.getClass());
                }
                if (o instanceof BasicDBObject) {
                    dob = (BasicDBObject)o;
                    lst = null;
                } else {
                    if (!(o instanceof BasicDBList)) break;
                    lst = (BasicDBList)o;
                }
                ++n2;
            }
        }
        catch (IndexOutOfBoundsException x) {
            o = null;
        }
        catch (MongoException se) {
            this.SetErrmsg(se);
            o = null;
        }
        return o;
    }

    public String GetField(String path) {
        Object o = this.GetFieldObject(path);
        if (o != null) {
            if (o instanceof Date) {
                Long TS = ((Date)o).getTime() / 1000L;
                return TS.toString();
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? "1" : "0";
            }
            return o.toString();
        }
        return null;
    }

    public Object MakeBson(String s, int json) {
        if (json == 1 || json == 2) {
            return JSON.parse(s);
        }
        return null;
    }

    public Object MakeDocument() {
        return new BasicDBObject();
    }

    public boolean DocAdd(Object bdc, String key, Object val, int json) {
        try {
            if (json != 0 && val instanceof String) {
                ((BasicDBObject)bdc).append(key, JSON.parse((String)val));
            } else {
                ((BasicDBObject)bdc).append(key, val);
            }
        }
        catch (MongoException me) {
            this.SetErrmsg(me);
            return true;
        }
        return false;
    }

    public Object MakeArray() {
        return new BasicDBList();
    }

    public boolean ArrayAdd(Object bar, int n, Object val, int json) {
        try {
            if (json != 0 && val instanceof String) {
                ((BasicDBList)bar).put(n, JSON.parse((String)val));
            } else {
                ((BasicDBList)bar).put(n, val);
            }
        }
        catch (MongoException me) {
            this.SetErrmsg(me);
            return true;
        }
        catch (Exception ex) {
            this.SetErrmsg(ex);
            return true;
        }
        return false;
    }

    public boolean CollInsert(Object dob) {
        try {
            this.coll.insert((BasicDBObject)dob);
        }
        catch (MongoException me) {
            this.SetErrmsg(me);
            return true;
        }
        catch (Exception ex) {
            this.SetErrmsg(ex);
            return true;
        }
        return false;
    }

    public long CollUpdate(Object upd) {
        long n = -1L;
        if (this.DEBUG) {
            System.out.println("upd: " + upd.toString());
        }
        try {
            BasicDBObject qry = new BasicDBObject("_id", this.doc.get("_id"));
            WriteResult res = this.coll.update(qry, (DBObject)upd);
            if (this.DEBUG) {
                System.out.println("CollUpdate: " + res.toString());
            }
            n = res.getN();
        }
        catch (MongoException me) {
            this.SetErrmsg(me);
        }
        catch (Exception ex) {
            this.SetErrmsg(ex);
        }
        return n;
    }

    public long CollDelete(boolean all) {
        long n = -1L;
        try {
            BasicDBObject qry = new BasicDBObject();
            if (!all) {
                qry.append("_id", this.doc.get("_id"));
            }
            WriteResult res = this.coll.remove(qry);
            if (this.DEBUG) {
                System.out.println("CollDelete: " + res.toString());
            }
            n = res.getN();
        }
        catch (WriteConcernException wx) {
            this.SetErrmsg(wx);
        }
        catch (MongoException me) {
            this.SetErrmsg(me);
        }
        catch (UnsupportedOperationException ux) {
            this.SetErrmsg(ux);
            n = 0L;
        }
        return n;
    }
}

