/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ListOrderedShorthandBuilder;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class AnimationShorthandBuilder
extends ListOrderedShorthandBuilder {
    private static final List<String> RESET_PROPERTIES;

    AnimationShorthandBuilder(BaseCSSStyleDeclaration parentStyle) {
        super("animation", parentStyle, "none", "animation-name");
    }

    @Override
    boolean isResetProperty(String property) {
        return RESET_PROPERTIES.contains(property);
    }

    @Override
    boolean appendValueText(BufferSimpleWriter wri, DeclarationFormattingContext context, String property, boolean appended) {
        if (!RESET_PROPERTIES.contains(property)) {
            return super.appendValueText(wri, context, property, appended);
        }
        return appended;
    }

    @Override
    void endShorthandSerialization(BufferSimpleWriter wri, DeclarationFormattingContext context, boolean importantShorthand) {
        for (String property : RESET_PROPERTIES) {
            StyleValue shorthandSample;
            boolean important;
            StyleValue cssVal = this.getCSSValue(property);
            if (!this.isNotInitialValue(cssVal, property) || importantShorthand != (important = this.isPropertyInImportantSet(property)) || (shorthandSample = this.getCSSValue("animation-name")).getCssValueType() == CSSValue.CssType.KEYWORD && shorthandSample.getPrimitiveType() == cssVal.getPrimitiveType()) continue;
            wri.write((CharSequence)property);
            try {
                wri.write(':');
                context.writeMinifiedValue((SimpleWriter)wri, property, cssVal);
                if (important) {
                    wri.write((CharSequence)"!important;");
                    continue;
                }
                wri.write(';');
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    boolean valueClash(int index, String property) {
        StyleValue delay;
        String chkProperty = property;
        if ("animation-timing-function".equals(property)) {
            chkProperty = "transition-timing-function";
        }
        StyleValue freePropertyValue = this.getCSSListItemValue(this.freeProperty, index);
        CSSValue.CssType freeType = freePropertyValue.getCssValueType();
        boolean retval = false;
        if (freeType == CSSValue.CssType.TYPED) {
            retval = this.isConflictingIdentifier(chkProperty, (CSSTypedValue)((Object)freePropertyValue));
        } else if (freeType == CSSValue.CssType.LIST) {
            retval = this.listHasConflictingIdentifiers(chkProperty, (ValueList)freePropertyValue);
        }
        if (!retval && property.equals("animation-duration") && this.isNotInitialValue(delay = this.getCSSListItemValue("animation-delay", index), "animation-delay")) {
            retval = true;
        }
        return retval;
    }

    @Override
    boolean validValueClash(String property) {
        StyleValue delay;
        boolean retval;
        String chkProperty = property;
        if ("animation-timing-function".equals(property)) {
            chkProperty = "transition-timing-function";
        }
        if (!(retval = super.validValueClash(chkProperty)) && property.equals("animation-duration") && this.isNotInitialValue(delay = this.getCSSValue("animation-delay"), "animation-delay")) {
            retval = true;
        }
        return retval;
    }

    static {
        String[] resetProperties = new String[]{"animation-timeline", "animation-range-start", "animation-range-end"};
        RESET_PROPERTIES = new ArrayList<String>(3);
        Collections.addAll(RESET_PROPERTIES, resetProperties);
    }
}

