/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.types.basic;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.NotInHeapException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.debugger.UnalignedAddressException;
import sun.jvm.hotspot.debugger.UnmappedAddressException;
import sun.jvm.hotspot.types.CIntegerType;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.types.basic.BasicTypeDataBase;

public class BasicField
implements Field {
    protected BasicTypeDataBase db;
    protected Type type;
    private Type containingType;
    private String name;
    private long size;
    private boolean isStatic;
    private long offset;
    private Address staticFieldAddress;

    public BasicField(Field fld) {
        BasicField field = (BasicField)fld;
        this.db = field.db;
        this.containingType = field.containingType;
        this.name = field.name;
        this.type = field.type;
        this.size = field.size;
        this.isStatic = field.isStatic;
        this.offset = field.offset;
        this.staticFieldAddress = field.staticFieldAddress;
    }

    public BasicField(BasicTypeDataBase db, Type containingType, String name, Type type, boolean isStatic, long offsetInBytes, Address staticFieldAddress) {
        this.db = db;
        this.containingType = containingType;
        this.name = name;
        this.type = type;
        this.size = type.getSize();
        this.isStatic = isStatic;
        this.offset = offsetInBytes;
        this.staticFieldAddress = staticFieldAddress;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public long getOffset() throws WrongTypeException {
        if (this.isStatic) {
            throw new WrongTypeException("field \"" + this.name + "\" in class " + this.containingType.getName() + " is static");
        }
        return this.offset;
    }

    @Override
    public Address getStaticFieldAddress() throws WrongTypeException {
        if (!this.isStatic) {
            throw new WrongTypeException("field \"" + this.name + "\" in class " + this.containingType.getName() + " is not static");
        }
        return this.staticFieldAddress;
    }

    @Override
    public boolean getJBoolean(Address addr) throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (this.isStatic) {
            throw new WrongTypeException();
        }
        return addr.getJBooleanAt(this.offset);
    }

    @Override
    public byte getJByte(Address addr) throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (this.isStatic) {
            throw new WrongTypeException();
        }
        return addr.getJByteAt(this.offset);
    }

    @Override
    public char getJChar(Address addr) throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (this.isStatic) {
            throw new WrongTypeException();
        }
        return addr.getJCharAt(this.offset);
    }

    @Override
    public double getJDouble(Address addr) throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (this.isStatic) {
            throw new WrongTypeException();
        }
        return addr.getJDoubleAt(this.offset);
    }

    @Override
    public float getJFloat(Address addr) throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (this.isStatic) {
            throw new WrongTypeException();
        }
        return addr.getJFloatAt(this.offset);
    }

    @Override
    public int getJInt(Address addr) throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (this.isStatic) {
            throw new WrongTypeException();
        }
        return addr.getJIntAt(this.offset);
    }

    @Override
    public long getJLong(Address addr) throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (this.isStatic) {
            throw new WrongTypeException();
        }
        return addr.getJLongAt(this.offset);
    }

    @Override
    public short getJShort(Address addr) throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (this.isStatic) {
            throw new WrongTypeException();
        }
        return addr.getJShortAt(this.offset);
    }

    @Override
    public long getCInteger(Address addr, CIntegerType type) throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (this.isStatic) {
            throw new WrongTypeException();
        }
        return addr.getCIntegerAt(this.offset, type.getSize(), type.isUnsigned());
    }

    @Override
    public Address getAddress(Address addr) throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (this.isStatic) {
            throw new WrongTypeException();
        }
        return addr.getAddressAt(this.offset);
    }

    @Override
    public OopHandle getOopHandle(Address addr) throws UnmappedAddressException, UnalignedAddressException, WrongTypeException, NotInHeapException {
        if (this.isStatic) {
            throw new WrongTypeException();
        }
        return addr.getOopHandleAt(this.offset);
    }

    @Override
    public OopHandle getNarrowOopHandle(Address addr) throws UnmappedAddressException, UnalignedAddressException, WrongTypeException, NotInHeapException {
        if (this.isStatic) {
            throw new WrongTypeException();
        }
        return addr.getCompOopHandleAt(this.offset);
    }

    @Override
    public boolean getJBoolean() throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (!this.isStatic) {
            throw new WrongTypeException();
        }
        return this.staticFieldAddress.getJBooleanAt(0L);
    }

    @Override
    public byte getJByte() throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (!this.isStatic) {
            throw new WrongTypeException();
        }
        return this.staticFieldAddress.getJByteAt(0L);
    }

    @Override
    public char getJChar() throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (!this.isStatic) {
            throw new WrongTypeException();
        }
        return this.staticFieldAddress.getJCharAt(0L);
    }

    @Override
    public double getJDouble() throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (!this.isStatic) {
            throw new WrongTypeException();
        }
        return this.staticFieldAddress.getJDoubleAt(0L);
    }

    @Override
    public float getJFloat() throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (!this.isStatic) {
            throw new WrongTypeException();
        }
        return this.staticFieldAddress.getJFloatAt(0L);
    }

    @Override
    public int getJInt() throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (!this.isStatic) {
            throw new WrongTypeException();
        }
        return this.staticFieldAddress.getJIntAt(0L);
    }

    @Override
    public long getJLong() throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (!this.isStatic) {
            throw new WrongTypeException();
        }
        return this.staticFieldAddress.getJLongAt(0L);
    }

    @Override
    public short getJShort() throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (!this.isStatic) {
            throw new WrongTypeException();
        }
        return this.staticFieldAddress.getJShortAt(0L);
    }

    @Override
    public long getCInteger(CIntegerType type) throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (!this.isStatic) {
            throw new WrongTypeException();
        }
        return this.staticFieldAddress.getCIntegerAt(0L, type.getSize(), type.isUnsigned());
    }

    @Override
    public Address getAddress() throws UnmappedAddressException, UnalignedAddressException, WrongTypeException {
        if (!this.isStatic) {
            throw new WrongTypeException();
        }
        return this.staticFieldAddress.getAddressAt(0L);
    }

    @Override
    public OopHandle getOopHandle() throws UnmappedAddressException, UnalignedAddressException, WrongTypeException, NotInHeapException {
        if (!this.isStatic) {
            throw new WrongTypeException();
        }
        return this.staticFieldAddress.getOopHandleAt(0L);
    }

    @Override
    public OopHandle getNarrowOopHandle() throws UnmappedAddressException, UnalignedAddressException, WrongTypeException, NotInHeapException {
        if (!this.isStatic) {
            throw new WrongTypeException();
        }
        return this.staticFieldAddress.getCompOopHandleAt(0L);
    }
}

