/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.layer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.actions.MergeLayerAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.IEnabledStateUpdating;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public final class MergeAction
extends AbstractAction
implements IEnabledStateUpdating,
Layer.LayerAction,
Layer.MultiLayerAction {
    private final transient Layer layer;
    private final transient List<Layer> layers;
    private final LayerListDialog.LayerListModel model;

    public MergeAction(Layer layer, LayerListDialog.LayerListModel model) {
        this(layer, null, model);
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
    }

    public MergeAction(List<Layer> layers, LayerListDialog.LayerListModel model) {
        this(null, layers, model);
        CheckParameterUtil.ensureParameterNotNull(layers, "layers");
    }

    private MergeAction(Layer layer, List<Layer> layers, LayerListDialog.LayerListModel model) {
        this.layer = layer;
        this.layers = layers;
        this.model = model;
        this.putValue("Name", I18n.tr("Merge", new Object[0]));
        new ImageProvider("dialogs", "mergedown").getResource().attachImageIcon(this, true);
        this.putValue("ShortDescription", I18n.tr("Merge this layer into another layer", new Object[0]));
        this.putValue("help", HelpUtil.ht("/Dialog/LayerList#MergeLayer"));
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MergeLayerAction mergeLayerAction = MainApplication.getMenu().merge;
        if (this.layer != null) {
            mergeLayerAction.merge(this.layer);
        } else if (this.layers != null) {
            mergeLayerAction.merge(this.layers);
        } else if (this.model.getSelectedLayers().size() == 1) {
            Layer selectedLayer = this.model.getSelectedLayers().get(0);
            mergeLayerAction.merge(selectedLayer);
        } else {
            mergeLayerAction.merge(this.model.getSelectedLayers());
        }
    }

    @Override
    public void updateEnabledState() {
        if (this.layer == null && this.layers == null) {
            if (this.model.getSelectedLayers().isEmpty()) {
                this.setEnabled(false);
            } else if (this.model.getSelectedLayers().size() > 1) {
                this.setEnabled(this.supportLayers(this.model.getSelectedLayers()));
            } else {
                Layer selectedLayer = this.model.getSelectedLayers().get(0);
                List<Layer> targets = this.model.getPossibleMergeTargets(selectedLayer);
                this.setEnabled(!targets.isEmpty());
            }
        } else if (this.layer != null) {
            List<Layer> targets = this.model.getPossibleMergeTargets(this.layer);
            this.setEnabled(!targets.isEmpty());
        } else {
            this.setEnabled(this.supportLayers(this.layers));
        }
    }

    @Override
    public boolean supportLayers(List<Layer> layers) {
        if (layers.isEmpty()) {
            return false;
        }
        Layer firstLayer = layers.get(0);
        List<Layer> remainingLayers = layers.subList(1, layers.size());
        return this.model.getPossibleMergeTargets(firstLayer).containsAll(remainingLayers);
    }

    @Override
    public Component createMenuComponent() {
        return new JMenuItem(this);
    }

    @Override
    public MergeAction getMultiLayerAction(List<Layer> layers) {
        return new MergeAction(layers, this.model);
    }
}

