/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.asn1;

import com.ca.commons.cbutil.CBParse;
import com.ca.commons.security.asn1.ASN1Exception;
import com.ca.commons.security.asn1.ASN1Type;
import com.ca.commons.security.asn1.ASN1Util;
import com.ca.commons.security.asn1.Context;
import com.ca.commons.security.asn1.Primitive;
import com.ca.commons.security.asn1.Sequence;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class ASN1Object
implements Serializable {
    protected ASN1Type asn1Type;
    protected byte[] byteArray;
    private static Hashtable asn1ToJava = new Hashtable(27);
    private Object o = null;
    Vector comps = new Vector();

    protected void init(ASN1Type type) {
        this.asn1Type = type;
        this.byteArray = null;
    }

    public ASN1Type getASN1Type() {
        return this.asn1Type;
    }

    public byte[] getByteArray() {
        return this.byteArray;
    }

    void setByteArray(byte[] b) {
        this.byteArray = b;
    }

    public boolean isASN1Type(ASN1Type type) {
        return this.asn1Type.equals(type);
    }

    public boolean compByteArray(byte[] x, int xoff, byte[] y, int yoff, int len) {
        if (len <= 0 || x == null || xoff < 0 || x.length < xoff + len || y == null || yoff < 0 || y.length < yoff + len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (x[xoff + i] == y[yoff + i]) continue;
            return false;
        }
        return true;
    }

    public boolean compByteArray(byte[] x, byte[] y) {
        if (x == null || y == null || x.length != y.length) {
            return false;
        }
        return this.compByteArray(x, 0, y, 0, x.length);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ASN1Object)) {
            return false;
        }
        try {
            byte[] der = ASN1Util.toByteArrayDER(this);
            byte[] der1 = ASN1Util.toByteArrayDER((ASN1Object)o);
            return this.compByteArray(der, der1);
        }
        catch (ASN1Exception asn1e) {
            asn1e.printStackTrace(System.out);
            return false;
        }
    }

    public String toString() {
        return this.asn1Type.toString();
    }

    public Object getValue() {
        return this.o;
    }

    public void setValue(Object o) {
        this.o = o;
    }

    public void addComponent(ASN1Object o) {
        this.comps.addElement(o);
    }

    public void addComponent(ASN1Object o, int index) {
        throw new IllegalArgumentException("method not supported");
    }

    public ASN1Object getComponent() {
        throw new IllegalArgumentException("method not supported");
    }

    public ASN1Object getComponent(int index) {
        return (ASN1Object)this.comps.elementAt(index);
    }

    public int size() {
        return this.comps.size();
    }

    public boolean implicit() {
        throw new IllegalArgumentException("method not supported");
    }

    public int getTag() {
        if (this.asn1Type != null) {
            return this.asn1Type.getTag();
        }
        throw new IllegalArgumentException("Object not initialised, does not have a type");
    }

    private static void register(ASN1Type type, Class c) {
        asn1ToJava.put(type, c);
    }

    public static ASN1Object create(ASN1Type type) throws ASN1Exception {
        Class impl = null;
        try {
            impl = (Class)asn1ToJava.get(type);
            if (impl == null) {
                throw new ASN1Exception(type.toString() + " : no implementation class available");
            }
            ASN1Object o = (ASN1Object)impl.newInstance();
            o.init(type);
            return o;
        }
        catch (InstantiationException e) {
            throw new ASN1Exception("Cannot create instance for " + type.toString() + "\n" + e.toString());
        }
        catch (IllegalAccessException e) {
            throw new ASN1Exception("Cannot create instance for " + type.toString() + "\n" + e.toString());
        }
    }

    public static ASN1Object create(ASN1Type type, Object v) throws ASN1Exception {
        ASN1Object o = ASN1Object.create(type);
        o.setValue(v);
        return o;
    }

    public void initByteArray() {
        try {
            byte[] buf = ASN1Util.toByteArrayDER(this);
            this.setByteArray(buf);
        }
        catch (ASN1Exception asn1e) {
            asn1e.printStackTrace(System.out);
            this.setByteArray(null);
        }
    }

    public byte[] toDERBytes() {
        try {
            return ASN1Util.toByteArrayDER(this);
        }
        catch (ASN1Exception asn1e) {
            asn1e.printStackTrace(System.out);
            return null;
        }
    }

    public boolean toDERFile(File file) throws IOException {
        try {
            ASN1Util.saveDER(this, file);
            return true;
        }
        catch (ASN1Exception asn1e) {
            asn1e.printStackTrace(System.out);
            return false;
        }
    }

    public byte[] toBase64() {
        try {
            return ASN1Util.toByteArrayPEM(this);
        }
        catch (ASN1Exception asn1e) {
            asn1e.printStackTrace(System.out);
            return null;
        }
    }

    public boolean toPEMFile(File file, String name) throws IOException {
        try {
            ASN1Util.savePEM(this, file, name);
            return true;
        }
        catch (ASN1Exception asn1e) {
            asn1e.printStackTrace(System.out);
            return false;
        }
    }

    public static ASN1Object fromBytes(byte[] data) {
        try {
            return ASN1Util.fromByteArray(data);
        }
        catch (ASN1Exception asn1e) {
            System.out.println(CBParse.bytes2Hex(data));
            asn1e.printStackTrace(System.out);
            return null;
        }
    }

    public static ASN1Object fromFile(File file) throws IOException {
        try {
            return ASN1Util.fromFile(file);
        }
        catch (ASN1Exception asn1e) {
            asn1e.printStackTrace(System.out);
            return null;
        }
    }

    static {
        Class<?> p = new Primitive().getClass();
        ASN1Object.register(ASN1Type.BOOLEAN, p);
        ASN1Object.register(ASN1Type.INTEGER, p);
        ASN1Object.register(ASN1Type.OCTET_STRING, p);
        ASN1Object.register(ASN1Type.NULL, p);
        ASN1Object.register(ASN1Type.OBJECT_ID, p);
        ASN1Object.register(ASN1Type.BIT_STRING, p);
        ASN1Object.register(ASN1Type.IA5String, p);
        ASN1Object.register(ASN1Type.T61String, p);
        ASN1Object.register(ASN1Type.PrintableString, p);
        ASN1Object.register(ASN1Type.UTCTime, p);
        ASN1Object.register(ASN1Type.GENERALIZEDTIME, p);
        ASN1Object.register(ASN1Type.ENUMERATED, p);
        ASN1Object.register(ASN1Type.UniversalString, p);
        ASN1Object.register(ASN1Type.BMPString, p);
        Class<?> s = new Sequence().getClass();
        ASN1Object.register(ASN1Type.SEQUENCE, s);
        ASN1Object.register(ASN1Type.SET, s);
        Class<?> c = new Context().getClass();
        ASN1Object.register(ASN1Type.ContextSpecific, c);
    }
}

