/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.ClassTransfromerMethodCreatorImpl;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldCreatorImpl;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FieldTransformer;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.MethodTransformer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassTransformer {
    private final String className;
    private int addedModifiers = 0;
    private int removedModifiers = 0;
    private final Set<String> addedInterfaces = new HashSet<String>();
    private final Map<MethodDescriptor, ClassTransfromerMethodCreatorImpl> addedMethods = new HashMap<MethodDescriptor, ClassTransfromerMethodCreatorImpl>();
    private final Map<FieldDescriptor, FieldCreatorImpl> addedFields = new HashMap<FieldDescriptor, FieldCreatorImpl>();
    private final Map<NamedDescriptor, MethodTransformer> modifiedMethods = new HashMap<NamedDescriptor, MethodTransformer>();
    private final Map<NamedDescriptor, FieldTransformer> modifiedFields = new HashMap<NamedDescriptor, FieldTransformer>();
    private final Set<NamedDescriptor> removedMethods = new HashSet<NamedDescriptor>();
    private final Set<NamedDescriptor> removedFields = new HashSet<NamedDescriptor>();

    public ClassTransformer(String className) {
        this.className = DescriptorUtils.objectToInternalClassName(className);
    }

    String getClassName() {
        return this.className;
    }

    boolean hasAddedMethod(MethodDescriptor methodDescriptor) {
        return this.addedMethods.containsKey(methodDescriptor);
    }

    public void addModifiers(int modifiers) {
        this.addedModifiers |= modifiers;
    }

    public void removeModifiers(int modifiers) {
        this.removedModifiers |= modifiers;
    }

    public void addInterface(Object interfaceName) {
        this.addedInterfaces.add(DescriptorUtils.objectToInternalClassName(interfaceName));
    }

    public MethodCreator addMethod(MethodDescriptor methodDescriptor) {
        if (this.addedMethods.containsKey(methodDescriptor)) {
            throw new IllegalStateException("Method already added: " + methodDescriptor);
        }
        ClassTransfromerMethodCreatorImpl creator = new ClassTransfromerMethodCreatorImpl(methodDescriptor, this);
        this.addedMethods.put(methodDescriptor, creator);
        return creator;
    }

    public MethodCreator addMethod(String name, Object returnType, Object ... parameters) {
        return this.addMethod(MethodDescriptor.ofMethod((Object)this.className, name, returnType, parameters));
    }

    public void removeMethod(String name, Object returnType, Object ... parameters) {
        this.removeMethod(MethodDescriptor.ofMethod((Object)this.className, name, returnType, parameters));
    }

    public void removeMethod(MethodDescriptor method) {
        Objects.requireNonNull(method);
        NamedDescriptor namedDescriptor = new NamedDescriptor(method.getName(), method.getDescriptor());
        if (this.removedMethods.contains(namedDescriptor)) {
            throw new IllegalStateException("Method already removed: " + method);
        }
        if (this.modifiedMethods.containsKey(namedDescriptor)) {
            throw new IllegalStateException("Modified method cannot be removed: " + method);
        }
        this.removedMethods.add(namedDescriptor);
    }

    public FieldCreator addField(FieldDescriptor fieldDescriptor) {
        if (this.addedFields.containsKey(fieldDescriptor)) {
            throw new IllegalStateException("Field already added: " + fieldDescriptor);
        }
        FieldCreatorImpl fieldCreator = new FieldCreatorImpl(fieldDescriptor, false);
        this.addedFields.put(fieldDescriptor, fieldCreator);
        return fieldCreator;
    }

    public FieldCreator addField(String name, Object type) {
        return this.addField(FieldDescriptor.of(this.className, name, DescriptorUtils.objectToDescriptor(type)));
    }

    public void removeField(String name, Object type) {
        this.removeField(FieldDescriptor.of(this.className, name, DescriptorUtils.objectToDescriptor(type)));
    }

    public void removeField(FieldDescriptor field) {
        Objects.requireNonNull(field);
        NamedDescriptor namedDescriptor = new NamedDescriptor(field.getName(), field.getType());
        if (this.removedFields.contains(namedDescriptor)) {
            throw new IllegalStateException("Field already removed: " + field);
        }
        if (this.modifiedFields.containsKey(namedDescriptor)) {
            throw new IllegalStateException("Modified field cannot be removed: " + field);
        }
        this.removedFields.add(namedDescriptor);
    }

    public MethodTransformer modifyMethod(MethodDescriptor method) {
        NamedDescriptor namedDescriptor = new NamedDescriptor(method.getName(), method.getDescriptor());
        if (this.removedMethods.contains(namedDescriptor)) {
            throw new IllegalStateException("Removed method cannot be modified: " + method);
        }
        return this.modifiedMethods.computeIfAbsent(namedDescriptor, ignored -> new MethodTransformer());
    }

    public MethodTransformer modifyMethod(String name, Object returnType, Object ... parameters) {
        return this.modifyMethod(MethodDescriptor.ofMethod((Object)this.className, name, returnType, parameters));
    }

    public FieldTransformer modifyField(FieldDescriptor field) {
        NamedDescriptor namedDescriptor = new NamedDescriptor(field.getName(), field.getType());
        if (this.removedFields.contains(namedDescriptor)) {
            throw new IllegalStateException("Removed field cannot be modified: " + field);
        }
        return this.modifiedFields.computeIfAbsent(namedDescriptor, ignored -> new FieldTransformer());
    }

    public FieldTransformer modifyField(String name, Object type) {
        return this.modifyField(FieldDescriptor.of(this.className, name, DescriptorUtils.objectToDescriptor(type)));
    }

    public ClassVisitor applyTo(final ClassVisitor visitor) {
        return new ClassVisitor(589824, visitor){
            private boolean seenInitialVisit;
            {
                super(arg0, arg1);
                this.seenInitialVisit = false;
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                access |= ClassTransformer.this.addedModifiers;
                access &= ~ClassTransformer.this.removedModifiers;
                String[] newInterfaces = interfaces;
                if (!ClassTransformer.this.addedInterfaces.isEmpty()) {
                    LinkedHashSet<String> names = new LinkedHashSet<String>(Arrays.asList(interfaces));
                    names.addAll(ClassTransformer.this.addedInterfaces);
                    newInterfaces = (String[])names.toArray(String[]::new);
                }
                super.visit(version, access, name, signature, superName, newInterfaces);
                this.seenInitialVisit = true;
            }

            public void visitInnerClass(String name, String outerName, String innerName, int access) {
                if (ClassTransformer.this.className.equals(name)) {
                    access |= ClassTransformer.this.addedModifiers;
                    access &= ~ClassTransformer.this.removedModifiers;
                }
                super.visitInnerClass(name, outerName, innerName, access);
            }

            public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
                NamedDescriptor namedDescriptor = new NamedDescriptor(name, descriptor);
                if (ClassTransformer.this.removedFields.contains(namedDescriptor)) {
                    return null;
                }
                FieldTransformer fieldTransformer = ClassTransformer.this.modifiedFields.get(namedDescriptor);
                if (fieldTransformer != null) {
                    access |= fieldTransformer.addedModifiers;
                    access &= ~fieldTransformer.removedModifiers;
                    name = fieldTransformer.newName != null ? fieldTransformer.newName : name;
                }
                return super.visitField(access, name, descriptor, signature, value);
            }

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                NamedDescriptor namedDescriptor = new NamedDescriptor(name, descriptor);
                if (ClassTransformer.this.removedMethods.contains(namedDescriptor)) {
                    return null;
                }
                MethodTransformer methodTransformer = ClassTransformer.this.modifiedMethods.get(namedDescriptor);
                if (methodTransformer != null) {
                    access |= methodTransformer.addedModifiers;
                    access &= ~methodTransformer.removedModifiers;
                    name = methodTransformer.newName != null ? methodTransformer.newName : name;
                }
                return super.visitMethod(access, name, descriptor, signature, exceptions);
            }

            public void visitEnd() {
                if (!this.seenInitialVisit) {
                    throw new IllegalStateException("The ClassTransformer was applied to a ClassVisitor that was already visited");
                }
                for (FieldCreator fieldCreator : ClassTransformer.this.addedFields.values()) {
                    fieldCreator.write(visitor);
                }
                for (MethodCreator methodCreator : ClassTransformer.this.addedMethods.values()) {
                    methodCreator.write(visitor);
                }
                super.visitEnd();
            }
        };
    }

    private static class NamedDescriptor {
        final String name;
        final String descriptor;

        NamedDescriptor(String name, String descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NamedDescriptor)) {
                return false;
            }
            NamedDescriptor that = (NamedDescriptor)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.descriptor, that.descriptor);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.descriptor);
        }
    }
}

