/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.Assert;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.callback.ServerCredentialCallback;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;

public final class KeyManagerCredentialSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    private final SecurityFactory<X509KeyManager> keyManagerFactory;

    public KeyManagerCredentialSaslServerFactory(SaslServerFactory delegate, X509KeyManager keyManager) {
        super(delegate);
        Assert.checkNotNullParam((String)"keyManager", (Object)keyManager);
        this.keyManagerFactory = new FixedSecurityFactory((Object)keyManager);
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        return this.delegate.createSaslServer(mechanism, protocol, serverName, props, callbacks -> {
            ArrayList<Callback> list = new ArrayList<Callback>(Arrays.asList(callbacks));
            Iterator<Callback> iterator = list.iterator();
            while (iterator.hasNext()) {
                String alias;
                Callback callback = iterator.next();
                if (!(callback instanceof ServerCredentialCallback)) continue;
                X509KeyManager keyManager = null;
                try {
                    keyManager = (X509KeyManager)this.keyManagerFactory.create();
                }
                catch (GeneralSecurityException e) {
                    throw new SaslException(e.getMessage(), e);
                }
                ServerCredentialCallback credentialCallback = (ServerCredentialCallback)callback;
                String algorithmName = credentialCallback.getAlgorithm();
                if (algorithmName == null || !credentialCallback.isCredentialTypeSupported(X509CertificateChainPrivateCredential.class, algorithmName) || (alias = keyManager.chooseServerAlias(algorithmName, null, null)) == null) continue;
                X509Certificate[] certificateChain = keyManager.getCertificateChain(alias);
                PrivateKey privateKey = keyManager.getPrivateKey(alias);
                if (certificateChain == null || certificateChain.length == 0) continue;
                credentialCallback.setCredential((Credential)new X509CertificateChainPrivateCredential(privateKey, certificateChain));
                iterator.remove();
            }
            if (!list.isEmpty()) {
                cbh.handle(list.toArray(new Callback[list.size()]));
            }
        });
    }
}

