/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import jakarta.ws.rs.BadRequestException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelValidationException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.workflow.AdhocWorkflowEvent;
import org.keycloak.models.workflow.ResourceOperationType;
import org.keycloak.models.workflow.ResourceType;
import org.keycloak.models.workflow.Workflow;
import org.keycloak.models.workflow.WorkflowConditionProvider;
import org.keycloak.models.workflow.WorkflowConditionProviderFactory;
import org.keycloak.models.workflow.WorkflowEvent;
import org.keycloak.models.workflow.WorkflowExecutionContext;
import org.keycloak.models.workflow.WorkflowExecutionException;
import org.keycloak.models.workflow.WorkflowInvalidStateException;
import org.keycloak.models.workflow.WorkflowProvider;
import org.keycloak.models.workflow.WorkflowStateProvider;
import org.keycloak.models.workflow.WorkflowStep;
import org.keycloak.models.workflow.WorkflowStepProvider;
import org.keycloak.representations.workflows.WorkflowConditionRepresentation;
import org.keycloak.representations.workflows.WorkflowRepresentation;
import org.keycloak.representations.workflows.WorkflowStepRepresentation;

public class WorkflowsManager {
    private static final Logger log = Logger.getLogger(WorkflowsManager.class);
    private final KeycloakSession session;
    private final WorkflowStateProvider workflowStateProvider;

    public static boolean isFeatureEnabled() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.WORKFLOWS);
    }

    public WorkflowsManager(KeycloakSession session) {
        this.session = session;
        this.workflowStateProvider = (WorkflowStateProvider)session.getKeycloakSessionFactory().getProviderFactory(WorkflowStateProvider.class).create(session);
    }

    public Workflow addWorkflow(String providerId, Map<String, List<String>> config) {
        return this.addWorkflow(new Workflow(providerId, config));
    }

    private Workflow addWorkflow(Workflow workflow) {
        RealmModel realm = this.getRealm();
        ComponentModel model = new ComponentModel();
        model.setParentId(realm.getId());
        model.setProviderId(Optional.ofNullable(workflow.getProviderId()).orElse("event-based-workflow"));
        model.setProviderType(WorkflowProvider.class.getName());
        MultivaluedHashMap config = workflow.getConfig();
        if (config != null) {
            model.setConfig(config);
        }
        return new Workflow(realm.addComponentModel(model));
    }

    private void addSteps(Workflow workflow, List<WorkflowStep> steps) {
        for (int i = 0; i < steps.size(); ++i) {
            WorkflowStep step = steps.get(i);
            step.setPriority(i + 1);
            this.addStep(workflow, step);
        }
    }

    private WorkflowStep addStep(Workflow workflow, WorkflowStep step) {
        RealmModel realm = this.getRealm();
        ComponentModel workflowModel = realm.getComponent(workflow.getId());
        if (workflowModel == null) {
            throw new ModelValidationException("Workflow with id '%s' not found.".formatted(workflow.getId()));
        }
        ComponentModel stepModel = new ComponentModel();
        stepModel.setId(step.getId());
        stepModel.setParentId(workflowModel.getId());
        stepModel.setProviderId(step.getProviderId());
        stepModel.setProviderType(WorkflowStepProvider.class.getName());
        stepModel.setConfig(step.getConfig());
        return new WorkflowStep(realm.addComponentModel(stepModel));
    }

    public List<Workflow> getWorkflows() {
        RealmModel realm = this.getRealm();
        return realm.getComponentsStream(realm.getId(), WorkflowProvider.class.getName()).map(Workflow::new).toList();
    }

    public List<WorkflowStep> getSteps(String workflowId) {
        return this.getStepsStream(workflowId).toList();
    }

    public Stream<WorkflowStep> getStepsStream(String parentId) {
        RealmModel realm = this.session.getContext().getRealm();
        return realm.getComponentsStream(parentId, WorkflowStepProvider.class.getName()).map(this::toStep).sorted();
    }

    private WorkflowStep toStep(ComponentModel model) {
        return new WorkflowStep(model);
    }

    public WorkflowStep getStepById(String id) {
        RealmModel realm = this.session.getContext().getRealm();
        ComponentModel component = realm.getComponent(id);
        if (component == null) {
            return null;
        }
        return this.toStep(component);
    }

    private WorkflowProvider getWorkflowProvider(Workflow workflow) {
        ComponentFactory factory = (ComponentFactory)this.session.getKeycloakSessionFactory().getProviderFactory(WorkflowProvider.class, workflow.getProviderId());
        return (WorkflowProvider)factory.create(this.session, this.getRealm().getComponent(workflow.getId()));
    }

    public WorkflowStepProvider getStepProvider(WorkflowStep step) {
        return (WorkflowStepProvider)this.getStepProviderFactory(step).create(this.session, this.getRealm().getComponent(step.getId()));
    }

    private ComponentFactory<?, ?> getStepProviderFactory(WorkflowStep step) {
        ComponentFactory stepFactory = (ComponentFactory)this.session.getKeycloakSessionFactory().getProviderFactory(WorkflowStepProvider.class, step.getProviderId());
        if (stepFactory == null) {
            throw new WorkflowInvalidStateException("Step not found: " + step.getProviderId());
        }
        return stepFactory;
    }

    private RealmModel getRealm() {
        return this.session.getContext().getRealm();
    }

    public void removeWorkflows() {
        RealmModel realm = this.getRealm();
        realm.getComponentsStream(realm.getId(), WorkflowProvider.class.getName()).forEach(workflow -> {
            realm.getComponentsStream(workflow.getId(), WorkflowStepProvider.class.getName()).forEach(arg_0 -> ((RealmModel)realm).removeComponent(arg_0));
            realm.removeComponent(workflow);
        });
    }

    public void scheduleAllEligibleResources(Workflow workflow) {
        if (workflow.isEnabled()) {
            WorkflowProvider provider = this.getWorkflowProvider(workflow);
            provider.getEligibleResourcesForInitialStep().forEach(resourceId -> this.processEvent(List.of(workflow), new AdhocWorkflowEvent(ResourceType.USERS, (String)resourceId)));
        }
    }

    public void processEvent(WorkflowEvent event) {
        this.processEvent(this.getWorkflows(), event);
    }

    public void processEvent(List<Workflow> workflows, WorkflowEvent event) {
        Map scheduledSteps = this.workflowStateProvider.getScheduledStepsByResource(event.getResourceId()).stream().collect(HashMap::new, (m, v) -> m.put(v.workflowId(), v), HashMap::putAll);
        workflows.stream().filter(workflow -> workflow.isEnabled() && !this.getSteps(workflow.getId()).isEmpty()).forEach(workflow -> {
            block10: {
                WorkflowProvider provider = this.getWorkflowProvider((Workflow)workflow);
                try {
                    if (!scheduledSteps.containsKey(workflow.getId())) {
                        if (!provider.activateOnEvent(event)) break block10;
                        WorkflowExecutionContext context = this.buildAndInitContext((Workflow)workflow, event.getResourceId());
                        if (context.hasNextStep() && workflow.getNotBefore() != null && workflow.getNotBefore() > 0L) {
                            WorkflowStep step = context.getNextStep();
                            log.debugf("Scheduling first step '%s' of workflow '%s' for resource %s based on on event %s with notBefore %d", new Object[]{step.getProviderId(), workflow.getName(), event.getResourceId(), event.getOperation(), workflow.getNotBefore()});
                            Long originalAfter = step.getAfter();
                            try {
                                step.setAfter(workflow.getNotBefore());
                                this.workflowStateProvider.scheduleStep(workflow, step, event.getResourceId(), context.getExecutionId());
                                break block10;
                            }
                            finally {
                                step.setAfter(originalAfter);
                            }
                        }
                        this.processWorkflow((Workflow)workflow, context, event.getResourceId());
                        break block10;
                    }
                    WorkflowExecutionContext context = this.buildFromScheduledStep((WorkflowStateProvider.ScheduledStep)scheduledSteps.get(workflow.getId()));
                    if (provider.resetOnEvent(event)) {
                        context.restart();
                        this.processWorkflow((Workflow)workflow, context, event.getResourceId());
                    } else if (provider.deactivateOnEvent(event)) {
                        context.cancel();
                        this.workflowStateProvider.remove(context.getExecutionId());
                    }
                }
                catch (WorkflowInvalidStateException e) {
                    workflow.setEnabled(false);
                    workflow.setError(e.getMessage());
                    this.updateWorkflowConfig((Workflow)workflow, (MultivaluedHashMap<String, String>)workflow.getConfig());
                    log.warnf("Workflow %s was disabled due to: %s", (Object)workflow.getId(), (Object)e.getMessage());
                }
            }
        });
    }

    public void runScheduledSteps() {
        this.getWorkflows().stream().filter(Workflow::isEnabled).forEach(workflow -> {
            for (WorkflowStateProvider.ScheduledStep scheduled : this.workflowStateProvider.getDueScheduledSteps(workflow)) {
                WorkflowExecutionContext context = this.buildFromScheduledStep(scheduled);
                if (!context.hasNextStep()) {
                    log.warnf("Could not find step %s in workflow %s for resource %s. Removing the workflow state.", (Object)scheduled.stepId(), (Object)scheduled.workflowId(), (Object)scheduled.resourceId());
                    this.workflowStateProvider.remove(scheduled.executionId());
                    continue;
                }
                this.runWorkflowStep(context, context.getNextStep(), scheduled.resourceId());
                this.processWorkflow((Workflow)workflow, context, scheduled.resourceId());
            }
        });
    }

    public void removeWorkflow(String id) {
        RealmModel realm = this.getRealm();
        realm.getComponentsStream(realm.getId(), WorkflowProvider.class.getName()).filter(workflow -> workflow.getId().equals(id)).forEach(workflow -> {
            realm.getComponentsStream(workflow.getId(), WorkflowStepProvider.class.getName()).forEach(arg_0 -> ((RealmModel)realm).removeComponent(arg_0));
            realm.removeComponent(workflow);
        });
        this.workflowStateProvider.removeByWorkflow(id);
    }

    public Workflow getWorkflow(String id) {
        return new Workflow(this.getWorkflowComponent(id));
    }

    public void updateWorkflow(Workflow workflow, WorkflowRepresentation representation) {
        WorkflowRepresentation currentRep = this.toRepresentation(workflow);
        String currentName = currentRep.getName();
        currentRep.getConfig().remove((Object)"name");
        String newName = representation.getName();
        representation.getConfig().remove((Object)"name");
        Boolean currentEnabled = currentRep.getEnabled();
        currentRep.getConfig().remove((Object)"enabled");
        Boolean newEnabled = representation.getEnabled();
        representation.getConfig().remove((Object)"enabled");
        if (!currentRep.equals((Object)representation)) {
            throw new ModelValidationException("Workflow update can only change 'name' and 'enabled' config entries.");
        }
        if (!Objects.equals(currentName, newName) || !Objects.equals(currentEnabled, newEnabled)) {
            representation.setName(newName);
            representation.setEnabled(newEnabled);
            this.updateWorkflowConfig(workflow, (MultivaluedHashMap<String, String>)representation.getConfig());
        }
    }

    private void updateWorkflowConfig(Workflow workflow, MultivaluedHashMap<String, String> config) {
        ComponentModel component = this.getWorkflowComponent(workflow.getId());
        component.setConfig(config);
        this.getRealm().updateComponent(component);
    }

    private ComponentModel getWorkflowComponent(String id) {
        ComponentModel component = this.getRealm().getComponent(id);
        if (component == null || !WorkflowProvider.class.getName().equals(component.getProviderType())) {
            throw new BadRequestException("Not a valid resource workflow: " + id);
        }
        return component;
    }

    public WorkflowRepresentation toRepresentation(Workflow workflow) {
        List<WorkflowConditionRepresentation> conditions = this.toConditionRepresentation(workflow);
        List<WorkflowStepRepresentation> steps = this.toRepresentation(this.getSteps(workflow.getId()));
        return new WorkflowRepresentation(workflow.getId(), workflow.getProviderId(), workflow.getConfig(), conditions, steps);
    }

    private List<WorkflowConditionRepresentation> toConditionRepresentation(Workflow workflow) {
        MultivaluedHashMap workflowConfig = Optional.ofNullable(workflow.getConfig()).orElse(new MultivaluedHashMap());
        List ids = (List)workflowConfig.getOrDefault((Object)"conditions", List.of());
        if (ids.isEmpty()) {
            return null;
        }
        ArrayList<WorkflowConditionRepresentation> conditions = new ArrayList<WorkflowConditionRepresentation>();
        for (String id : ids) {
            MultivaluedHashMap config = new MultivaluedHashMap();
            for (Map.Entry configEntry : workflowConfig.entrySet()) {
                String key = (String)configEntry.getKey();
                if (!key.startsWith(id + ".")) continue;
                config.put((Object)key.substring(id.length() + 1), (Object)((List)configEntry.getValue()));
            }
            conditions.add(new WorkflowConditionRepresentation(id, config));
        }
        return conditions;
    }

    private List<WorkflowStepRepresentation> toRepresentation(List<WorkflowStep> existingSteps) {
        if (existingSteps == null || existingSteps.isEmpty()) {
            return null;
        }
        ArrayList<WorkflowStepRepresentation> steps = new ArrayList<WorkflowStepRepresentation>();
        for (WorkflowStep step : existingSteps) {
            steps.add(this.toRepresentation(step));
        }
        return steps;
    }

    public WorkflowStepRepresentation toRepresentation(WorkflowStep step) {
        return new WorkflowStepRepresentation(step.getId(), step.getProviderId(), step.getConfig());
    }

    public Workflow toModel(WorkflowRepresentation rep) {
        this.validateWorkflow(rep);
        MultivaluedHashMap config = Optional.ofNullable(rep.getConfig()).orElse(new MultivaluedHashMap());
        List conditions = Optional.ofNullable(rep.getConditions()).orElse(List.of());
        for (WorkflowConditionRepresentation condition : conditions) {
            String conditionProviderId = condition.getUses();
            this.getConditionProviderFactory(conditionProviderId);
            ((List)config.computeIfAbsent((Object)"conditions", key -> new ArrayList())).add(conditionProviderId);
            for (Map.Entry configEntry : condition.getConfig().entrySet()) {
                config.put((Object)(conditionProviderId + "." + (String)configEntry.getKey()), (Object)((List)configEntry.getValue()));
            }
        }
        Workflow workflow = this.addWorkflow(rep.getUses(), (Map<String, List<String>>)config);
        List<WorkflowStep> steps = rep.getSteps().stream().map(this::toModel).toList();
        this.addSteps(workflow, steps);
        return workflow;
    }

    private void validateWorkflow(WorkflowRepresentation rep) {
        boolean hasScheduledStep;
        WorkflowsManager.validateEvents(rep.getOnValues());
        WorkflowsManager.validateEvents(rep.getOnEventsReset());
        if (rep.getConfig() != null && Boolean.parseBoolean((String)rep.getConfig().getFirstOrDefault((Object)"recurring", (Object)"false")) && !(hasScheduledStep = Optional.ofNullable(rep.getSteps()).orElse(List.of()).stream().anyMatch(step -> Integer.parseInt(Optional.ofNullable(step.getAfter()).orElse("0")) > 0))) {
            throw new WorkflowInvalidStateException("A recurring workflow must have at least one step with a time delay.");
        }
    }

    private static void validateEvents(List<String> events) {
        for (String event : Optional.ofNullable(events).orElse(List.of())) {
            try {
                ResourceOperationType.valueOf((String)event.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new WorkflowInvalidStateException("Invalid event type: " + event);
            }
        }
    }

    public void bind(Workflow workflow, ResourceType type, String resourceId) {
        this.processEvent(List.of(workflow), new AdhocWorkflowEvent(type, resourceId));
    }

    public Object resolveResource(ResourceType type, String resourceId) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(type, "resourceId");
        return type.resolveResource(this.session, resourceId);
    }

    private void validateStep(WorkflowStep step) throws ModelValidationException {
        if (step.getAfter() < 0L) {
            throw new ModelValidationException("Step 'after' time condition cannot be negative.");
        }
        this.getStepProviderFactory(step);
    }

    public WorkflowStep addStepToWorkflow(Workflow workflow, WorkflowStep step, Integer position) {
        int targetPosition;
        Objects.requireNonNull(workflow, "workflow cannot be null");
        Objects.requireNonNull(step, "step cannot be null");
        List<WorkflowStep> existingSteps = this.getSteps(workflow.getId());
        int n = targetPosition = position != null ? position.intValue() : existingSteps.size();
        if (targetPosition < 0 || targetPosition > existingSteps.size()) {
            throw new BadRequestException("Invalid position: " + targetPosition + ". Must be between 0 and " + existingSteps.size());
        }
        this.shiftStepsForInsertion(targetPosition, existingSteps);
        step.setPriority(targetPosition + 1);
        WorkflowStep addedStep = this.addStep(workflow, step);
        log.debugf("Added step %s to workflow %s at position %d", (Object)addedStep.getId(), (Object)workflow.getId(), (Object)targetPosition);
        return addedStep;
    }

    public void removeStepFromWorkflow(Workflow workflow, String stepId) {
        Objects.requireNonNull(workflow, "workflow cannot be null");
        Objects.requireNonNull(stepId, "stepId cannot be null");
        RealmModel realm = this.getRealm();
        ComponentModel stepComponent = realm.getComponent(stepId);
        if (stepComponent == null || !stepComponent.getParentId().equals(workflow.getId())) {
            throw new BadRequestException("Step not found or not part of workflow: " + stepId);
        }
        realm.removeComponent(stepComponent);
        this.reorderAllSteps(workflow.getId());
        this.updateScheduledStepsAfterStepChange(workflow, stepId);
        log.debugf("Removed step %s from workflow %s", (Object)stepId, (Object)workflow.getId());
    }

    private void shiftStepsForInsertion(int insertPosition, List<WorkflowStep> existingSteps) {
        RealmModel realm = this.getRealm();
        for (int i = insertPosition; i < existingSteps.size(); ++i) {
            WorkflowStep step = existingSteps.get(i);
            step.setPriority(step.getPriority() + 1);
            this.updateStepComponent(realm, step);
        }
    }

    private void reorderAllSteps(String workflowId) {
        List<WorkflowStep> steps = this.getSteps(workflowId);
        RealmModel realm = this.getRealm();
        for (int i = 0; i < steps.size(); ++i) {
            WorkflowStep step = steps.get(i);
            step.setPriority(i + 1);
            this.updateStepComponent(realm, step);
        }
    }

    private void updateStepComponent(RealmModel realm, WorkflowStep step) {
        ComponentModel component = realm.getComponent(step.getId());
        component.setConfig(step.getConfig());
        realm.updateComponent(component);
    }

    private void updateScheduledStepsAfterStepChange(Workflow workflow, String stepId) {
        for (WorkflowStateProvider.ScheduledStep scheduled : this.workflowStateProvider.getScheduledStepsByStep(stepId)) {
            WorkflowExecutionContext context = this.buildFromScheduledStep(scheduled);
            context.restart();
            this.workflowStateProvider.scheduleStep(workflow, context.getNextStep(), scheduled.resourceId(), context.getExecutionId());
        }
    }

    public WorkflowStep toModel(WorkflowStepRepresentation rep) {
        WorkflowStep step = new WorkflowStep(rep.getUses(), rep.getConfig());
        this.validateStep(step);
        return step;
    }

    public WorkflowConditionProvider getConditionProvider(String providerId, MultivaluedHashMap<String, String> modelConfig) {
        WorkflowConditionProviderFactory<WorkflowConditionProvider> providerFactory = this.getConditionProviderFactory(providerId);
        HashMap<String, List> config = new HashMap<String, List>();
        for (Map.Entry configEntry : modelConfig.entrySet()) {
            if (!((String)configEntry.getKey()).startsWith(providerId)) continue;
            config.put(((String)configEntry.getKey()).substring(providerId.length() + 1), (List)configEntry.getValue());
        }
        WorkflowConditionProvider condition = providerFactory.create(this.session, config);
        if (condition == null) {
            throw new IllegalStateException("Factory " + String.valueOf(providerFactory.getClass()) + " returned a null provider");
        }
        return condition;
    }

    public WorkflowConditionProviderFactory<WorkflowConditionProvider> getConditionProviderFactory(String providerId) {
        KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
        WorkflowConditionProviderFactory providerFactory = (WorkflowConditionProviderFactory)sessionFactory.getProviderFactory(WorkflowConditionProvider.class, providerId);
        if (providerFactory == null) {
            throw new WorkflowInvalidStateException("Could not find condition provider: " + providerId);
        }
        return providerFactory;
    }

    private WorkflowExecutionContext buildAndInitContext(Workflow workflow, String resourceId) {
        WorkflowExecutionContext context = new WorkflowExecutionContext(workflow, this.getSteps(workflow.getId()), resourceId);
        context.init();
        return context;
    }

    private WorkflowExecutionContext buildFromScheduledStep(WorkflowStateProvider.ScheduledStep scheduledStep) {
        return new WorkflowExecutionContext(this.getWorkflow(scheduledStep.workflowId()), this.getSteps(scheduledStep.workflowId()), scheduledStep.resourceId(), scheduledStep.stepId(), scheduledStep.executionId());
    }

    private void processWorkflow(Workflow workflow, WorkflowExecutionContext context, String resourceId) {
        while (context.hasNextStep()) {
            WorkflowStep step = context.getNextStep();
            if (step.getAfter() > 0L) {
                log.debugf("Scheduling step %s to run in %d ms for resource %s (execution id: %s)", new Object[]{step.getProviderId(), step.getAfter(), resourceId, context.getExecutionId()});
                this.workflowStateProvider.scheduleStep(workflow, step, resourceId, context.getExecutionId());
                return;
            }
            this.runWorkflowStep(context, step, resourceId);
        }
        if (workflow.isRecurring()) {
            context.restart();
            this.processWorkflow(workflow, context, resourceId);
        } else {
            context.complete();
            this.workflowStateProvider.remove(context.getExecutionId());
        }
    }

    private void runWorkflowStep(WorkflowExecutionContext context, WorkflowStep step, String resourceId) {
        log.debugf("Running step %s on resource %s (execution id: %s)", (Object)step.getProviderId(), (Object)resourceId, (Object)context.getExecutionId());
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), (KeycloakContext)this.session.getContext(), s -> {
            try {
                this.getStepProvider(step).run(List.of(resourceId));
                context.success(step);
            }
            catch (WorkflowExecutionException e) {
                context.fail(step, e.getMessage());
                throw e;
            }
        });
    }
}

