/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.Base32;
import org.keycloak.utils.StringUtil;

public class OTPPolicy
implements Serializable {
    protected static final Logger logger = Logger.getLogger(OTPPolicy.class);
    protected String type;
    protected String algorithm;
    protected int initialCounter;
    protected int digits;
    protected int lookAheadWindow;
    protected int period;
    protected boolean isCodeReusable;
    private static final Map<String, String> algToKeyUriAlg = new HashMap<String, String>();
    public static OTPPolicy DEFAULT_POLICY;
    public static final boolean DEFAULT_IS_REUSABLE = false;
    public static final String REALM_REUSABLE_CODE_ATTRIBUTE = "realmReusableOtpCode";

    public OTPPolicy() {
    }

    public OTPPolicy(String type, String algorithm, int initialCounter, int digits, int lookAheadWindow, int period) {
        this(type, algorithm, initialCounter, digits, lookAheadWindow, period, false);
    }

    public OTPPolicy(String type, String algorithm, int initialCounter, int digits, int lookAheadWindow, int period, boolean isCodeReusable) {
        this.type = type;
        this.algorithm = algorithm;
        this.initialCounter = initialCounter;
        this.digits = digits;
        this.lookAheadWindow = lookAheadWindow;
        this.period = period;
        this.isCodeReusable = isCodeReusable;
    }

    public String getAlgorithmKey() {
        return algToKeyUriAlg.containsKey(this.algorithm) ? algToKeyUriAlg.get(this.algorithm) : this.algorithm;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public int getInitialCounter() {
        return this.initialCounter;
    }

    public void setInitialCounter(int initialCounter) {
        this.initialCounter = initialCounter;
    }

    public int getDigits() {
        return this.digits;
    }

    public void setDigits(int digits) {
        this.digits = digits;
    }

    public int getLookAheadWindow() {
        return this.lookAheadWindow;
    }

    public void setLookAheadWindow(int lookAheadWindow) {
        this.lookAheadWindow = lookAheadWindow;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public boolean isCodeReusable() {
        return this.isCodeReusable;
    }

    public void setCodeReusable(boolean isReusable) {
        this.isCodeReusable = isReusable;
    }

    public String getKeyURI(RealmModel realm, UserModel user, String secret) {
        String issuerName = !StringUtil.isNullOrEmpty(realm.getDisplayName()) ? realm.getDisplayName() : realm.getName();
        String accountName = user.getUsername();
        return this.getKeyURI(issuerName, accountName, secret);
    }

    public String getKeyURI(String rawIssuerName, String rawAccountName, String secret) {
        String accountName = URLEncoder.encode(rawAccountName, StandardCharsets.UTF_8);
        String issuerName = rawIssuerName.replaceAll("[:]", " ");
        issuerName = URLEncoder.encode(issuerName, StandardCharsets.UTF_8).replaceAll("\\+", "%20");
        String label = issuerName + ":" + accountName;
        String parameters = "secret=" + Base32.encode(secret.getBytes()) + "&digits=" + this.digits + "&algorithm=" + algToKeyUriAlg.get(this.algorithm) + "&issuer=" + issuerName;
        if (this.type.equals("hotp")) {
            parameters = parameters + "&counter=" + this.initialCounter;
        } else if (this.type.equals("totp")) {
            parameters = parameters + "&period=" + this.period;
        }
        return "otpauth://" + this.type + "/" + label + "?" + parameters;
    }

    static {
        algToKeyUriAlg.put("HmacSHA1", "SHA1");
        algToKeyUriAlg.put("HmacSHA256", "SHA256");
        algToKeyUriAlg.put("HmacSHA512", "SHA512");
        DEFAULT_POLICY = new OTPPolicy("totp", "HmacSHA1", 0, 6, 1, 30);
    }
}

