/*
 * Copyright (C) 2004, 2005 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _TRANSLATE_PAIR_H
#define _TRANSLATE_PAIR_H

#include <glib-object.h>

G_BEGIN_DECLS

#define TRANSLATE_TYPE_PAIR		(translate_pair_get_type())
#define TRANSLATE_PAIR(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), TRANSLATE_TYPE_PAIR, TranslatePair))
#define TRANSLATE_PAIR_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), TRANSLATE_TYPE_PAIR, TranslatePairClass))
#define TRANSLATE_IS_PAIR(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), TRANSLATE_TYPE_PAIR))
#define TRANSLATE_IS_PAIR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), TRANSLATE_TYPE_PAIR))
#define TRANSLATE_PAIR_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), TRANSLATE_TYPE_PAIR, TranslatePairClass))

#define TRANSLATE_TYPE_PAIR_FLAGS	(translate_pair_flags_get_type())

typedef struct _TranslatePair		TranslatePair;
typedef struct _TranslatePairClass	TranslatePairClass;
typedef struct _TranslatePairPrivate	TranslatePairPrivate;

struct _TranslatePair
{
  GObject			parent;

  TranslatePairPrivate		*priv;
};

struct _TranslatePairClass
{
  GObjectClass			parent;

  void (*reserved1) (void);
  void (*reserved2) (void);
  void (*reserved3) (void);
  void (*reserved4) (void);
  void (*reserved5) (void);
  void (*reserved6) (void);
  void (*reserved7) (void);
  void (*reserved8) (void);
};

typedef enum
{
  TRANSLATE_PAIR_TEXT		= 1 << 0,
  TRANSLATE_PAIR_WEB_PAGE	= 1 << 1
} TranslatePairFlags;

GType		    translate_pair_get_type	   (void);
GType		    translate_pair_flags_get_type  (void);

TranslatePair	   *translate_pair_new		   (TranslatePairFlags	 flags,
						    const char		*from,
						    const char		*to);

TranslatePairFlags  translate_pair_get_flags	   (TranslatePair	*pair);
const char	   *translate_pair_get_from	   (TranslatePair	*pair);
const char	   *translate_pair_get_to	   (TranslatePair	*pair);

GSList		   *translate_pairs_sort_by_tag    (GSList		*pairs);
GSList		   *translate_pairs_sort_by_name   (GSList		*pairs);

TranslatePair	   *translate_pairs_find	   (const GSList	*pairs,
						    const char		*from,
						    const char		*to);

G_END_DECLS

#endif /* _TRANSLATE_PAIR_H */
