/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.sse;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.sse.SseEventSource;
import org.apache.geronimo.osgi.locator.ProviderLocator;

final class SseFinder {
    private static final Logger LOGGER = Logger.getLogger(SseFinder.class.getName());
    private static final String FACTORY_ID = SseEventSource.Builder.class.getName().replace('$', '.');
    private static final String SERVICE_ID = "META-INF/services/" + FACTORY_ID;

    static Object find(String defaultClazz) throws ClassNotFoundException {
        ClassLoader classLoader = SseFinder.getContextClassLoader();
        try {
            Object delegate = ProviderLocator.getService((String)FACTORY_ID, ClientBuilder.class, (ClassLoader)classLoader);
            if (delegate != null) {
                return delegate;
            }
            InputStream is = classLoader == null ? ClassLoader.getSystemResourceAsStream(SERVICE_ID) : classLoader.getResourceAsStream(SERVICE_ID);
            if (is != null) {
                BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String factoryClassName = rd.readLine();
                rd.close();
                if (factoryClassName != null && !"".equals(factoryClassName)) {
                    return SseFinder.newInstance(factoryClassName, classLoader);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.finest(ex.getMessage());
        }
        try {
            File f = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "jaxrs.properties");
            if (f.exists()) {
                Properties props = new Properties();
                props.load(new FileInputStream(f));
                String factoryClassName = props.getProperty(FACTORY_ID);
                return SseFinder.newInstance(factoryClassName, classLoader);
            }
        }
        catch (Exception ex) {
            LOGGER.finest(ex.getMessage());
        }
        try {
            String systemProp = System.getProperty(FACTORY_ID);
            if (systemProp != null) {
                return SseFinder.newInstance(systemProp, classLoader);
            }
        }
        catch (SecurityException se) {
            LOGGER.finest(se.getMessage());
        }
        if (defaultClazz == null) {
            throw new ClassNotFoundException(FACTORY_ID + " not found", null);
        }
        return SseFinder.newInstance(defaultClazz, classLoader);
    }

    static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Class<?> spiClass;
            if (classLoader == null) {
                spiClass = Class.forName(className);
            } else {
                try {
                    spiClass = Class.forName(className, false, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    LOGGER.finest(ex.getMessage());
                    spiClass = Class.forName(className);
                }
            }
            return spiClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException x) {
            throw x;
        }
        catch (Exception x) {
            throw new ClassNotFoundException(x.getMessage(), x);
        }
    }

    private SseFinder() {
    }
}

