/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus.exception;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.modbus.exception.ModbusTransportException;

@NonNullByDefault
public class ModbusUnexpectedTransactionIdException
extends ModbusTransportException {
    private static final long serialVersionUID = -2453232634024813933L;
    private int requestId;
    private int responseId;

    public ModbusUnexpectedTransactionIdException(int requestId, int responseId) {
        this.requestId = requestId;
        this.responseId = responseId;
    }

    @Override
    public @Nullable String getMessage() {
        return String.format("Transaction id of request (%d) does not equal response (%d). Slave response is invalid.", this.requestId, this.responseId);
    }

    @Override
    public String toString() {
        return String.format("ModbusUnexpectedTransactionIdException(requestTransactionId=%d, responseTransactionId=%d)", this.requestId, this.responseId);
    }

    public int getRequestId() {
        return this.requestId;
    }

    public int getResponseId() {
        return this.responseId;
    }
}

