/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.Blob;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.GeoPoint;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.UserDataConverter;
import com.google.cloud.firestore.encoding.CustomClassMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.Value;
import com.google.firestore.v1.Write;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalExtensionOnly
@BetaApi
public final class PipelineResult {
    private final FirestoreRpcContext<?> rpcContext;
    @Nullable
    private final DocumentReference docRef;
    @Nullable
    private final Map<String, Value> fields;
    @Nonnull
    private final Timestamp executionTime;
    @Nullable
    private final Timestamp updateTime;
    @Nullable
    private final Timestamp createTime;

    PipelineResult(FirestoreRpcContext<?> rpcContext, @Nullable DocumentReference docRef, @Nullable Map<String, Value> fields, @Nonnull Timestamp executionTime, @Nullable Timestamp updateTime, @Nullable Timestamp createTime) {
        this.rpcContext = rpcContext;
        this.docRef = docRef;
        this.fields = fields;
        this.executionTime = executionTime;
        if (updateTime != null && updateTime.equals((Object)Timestamp.ofTimeMicroseconds((long)0L))) {
            updateTime = null;
        }
        this.updateTime = updateTime;
        if (createTime != null && createTime.equals((Object)Timestamp.ofTimeMicroseconds((long)0L))) {
            createTime = null;
        }
        this.createTime = createTime;
    }

    @Nullable
    @BetaApi
    public String getId() {
        return this.docRef.getId();
    }

    static PipelineResult fromDocument(FirestoreRpcContext<?> rpcContext, Timestamp executionTime, Document document) {
        return new PipelineResult(rpcContext, document.getName().isEmpty() ? null : new DocumentReference(rpcContext, ResourcePath.create(document.getName())), document.getFieldsMap(), executionTime, Timestamp.fromProto((com.google.protobuf.Timestamp)document.getUpdateTime()), Timestamp.fromProto((com.google.protobuf.Timestamp)document.getCreateTime()));
    }

    @Nullable
    @BetaApi
    public Timestamp getExecutionTime() {
        return this.executionTime;
    }

    @Nullable
    @BetaApi
    public Timestamp getUpdateTime() {
        return this.updateTime;
    }

    @Nullable
    @BetaApi
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @BetaApi
    public boolean exists() {
        return this.fields != null;
    }

    @Nonnull
    @BetaApi
    public Map<String, Object> getData() {
        if (this.fields == null) {
            return null;
        }
        HashMap<String, Object> decodedFields = new HashMap<String, Object>();
        for (Map.Entry<String, Value> entry : this.fields.entrySet()) {
            Object decodedValue = UserDataConverter.decodeValue(this.rpcContext, entry.getValue());
            decodedFields.put(entry.getKey(), decodedValue);
        }
        return decodedFields;
    }

    @Nullable
    @BetaApi
    <T> T toObject(@Nonnull Class<T> valueType) {
        Map<String, Object> data = this.getData();
        return data == null ? null : (T)CustomClassMapper.convertToCustomClass(data, valueType, this.docRef);
    }

    @BetaApi
    public boolean contains(@Nonnull String field) {
        return this.contains(FieldPath.fromDotSeparatedString(field));
    }

    @BetaApi
    public boolean contains(@Nonnull FieldPath fieldPath) {
        return this.extractField(fieldPath) != null;
    }

    @Nullable
    @BetaApi
    public Object get(@Nonnull String field) {
        return this.get(FieldPath.fromDotSeparatedString(field));
    }

    @Nullable
    @BetaApi
    public <T> T get(@Nonnull String field, @Nonnull Class<T> valueType) {
        return this.get(FieldPath.fromDotSeparatedString(field), valueType);
    }

    @Nullable
    @BetaApi
    public Object get(@Nonnull FieldPath fieldPath) {
        Value value = this.extractField(fieldPath);
        if (value == null) {
            return null;
        }
        return UserDataConverter.decodeValue(this.rpcContext, value);
    }

    @Nullable
    @BetaApi
    public <T> T get(@Nonnull FieldPath fieldPath, Class<T> valueType) {
        Object data = this.get(fieldPath);
        return data == null ? null : (T)CustomClassMapper.convertToCustomClass(data, valueType, this.docRef);
    }

    @Nullable
    Value extractField(@Nonnull FieldPath fieldPath) {
        Value value = null;
        if (this.fields != null) {
            UnmodifiableIterator components = fieldPath.getSegments().iterator();
            value = this.fields.get(components.next());
            while (value != null && components.hasNext()) {
                if (value.getValueTypeCase() != Value.ValueTypeCase.MAP_VALUE) {
                    return null;
                }
                value = value.getMapValue().getFieldsOrDefault((String)components.next(), null);
            }
        }
        return value;
    }

    @Nullable
    @BetaApi
    public Boolean getBoolean(@Nonnull String field) {
        return (Boolean)this.get(field);
    }

    @Nullable
    @BetaApi
    public Double getDouble(@Nonnull String field) {
        Number number = (Number)this.get(field);
        return number == null ? null : Double.valueOf(number.doubleValue());
    }

    @Nullable
    @BetaApi
    public String getString(@Nonnull String field) {
        return (String)this.get(field);
    }

    @Nullable
    @BetaApi
    public Long getLong(@Nonnull String field) {
        Number number = (Number)this.get(field);
        return number == null ? null : Long.valueOf(number.longValue());
    }

    @Nullable
    @BetaApi
    public Date getDate(@Nonnull String field) {
        Timestamp timestamp = this.getTimestamp(field);
        return timestamp == null ? null : timestamp.toDate();
    }

    @Nullable
    @BetaApi
    public Timestamp getTimestamp(@Nonnull String field) {
        return (Timestamp)this.get(field);
    }

    @Nullable
    @BetaApi
    public Blob getBlob(@Nonnull String field) {
        return (Blob)this.get(field);
    }

    @Nullable
    @BetaApi
    public GeoPoint getGeoPoint(@Nonnull String field) {
        return (GeoPoint)this.get(field);
    }

    @BetaApi
    public DocumentReference getReference() {
        return this.docRef;
    }

    boolean isEmpty() {
        return this.fields == null || this.fields.isEmpty();
    }

    Map<String, Value> getProtoFields() {
        return this.fields;
    }

    Write.Builder toPb() {
        Preconditions.checkState((boolean)this.exists(), (Object)"Can't call toDocument() on a document that doesn't exist");
        Write.Builder write = Write.newBuilder();
        Document.Builder document = write.getUpdateBuilder();
        document.setName(this.docRef.getName());
        document.putAllFields(this.fields);
        return write;
    }

    Document.Builder toDocumentPb() {
        Preconditions.checkState((boolean)this.exists(), (Object)"Can't call toDocument() on a document that doesn't exist");
        Document.Builder document = Document.newBuilder();
        return document.setName(this.docRef.getName()).putAllFields(this.fields).setCreateTime(this.createTime.toProto()).setUpdateTime(this.updateTime.toProto());
    }

    @BetaApi
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PipelineResult)) {
            return false;
        }
        PipelineResult that = (PipelineResult)obj;
        return Objects.equals(this.rpcContext, that.rpcContext) && Objects.equals(this.docRef, that.docRef) && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.rpcContext, this.docRef, this.fields);
    }

    public String toString() {
        return String.format("%s{doc=%s, fields=%s, executionTime=%s, updateTime=%s, createTime=%s}", this.getClass().getSimpleName(), this.docRef, this.fields, this.executionTime, this.updateTime, this.createTime);
    }
}

