/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.type;

import java.awt.Image;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.application.type.ApplicationType;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class DefaultApplicationType
extends ApplicationType {
    String name;
    Application application;

    protected DefaultApplicationType(Application app) {
        this.application = app;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            Jvm jvm;
            String mainClassName = null;
            if (1 == this.application.getState() && (jvm = JvmFactory.getJVMFor(this.application)).isBasicInfoSupported()) {
                mainClassName = jvm.getMainClass();
            }
            this.name = mainClassName != null && !mainClassName.isEmpty() ? mainClassName : this.application.getStorage().getCustomProperty("prop_suggested_name");
            if (this.name == null) {
                this.name = this.application.isLocalApplication() ? NbBundle.getMessage(DefaultApplicationType.class, (String)"LBL_Local_Application") : NbBundle.getMessage(DefaultApplicationType.class, (String)"LBL_Remote_Application");
            }
        }
        return this.name;
    }

    @Override
    public String getVersion() {
        return NbBundle.getMessage(DefaultApplicationType.class, (String)"LBL_Unknown_Version");
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public Image getIcon() {
        String iconPath = "org/graalvm/visualvm/application/resources/application.png";
        return ImageUtilities.loadImage((String)iconPath, (boolean)true);
    }
}

