/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.graalvm.visualvm.lib.jfluid.ProfilerClient;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.results.memory.AllocMemoryResultsDiff;
import org.graalvm.visualvm.lib.jfluid.results.memory.MemoryCCTProvider;
import org.graalvm.visualvm.lib.jfluid.results.memory.MemoryResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.memory.PresoObjAllocCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.memory.RuntimeMemoryCCTNode;

public class AllocMemoryResultsSnapshot
extends MemoryResultsSnapshot {
    private static final String MEMORY_ALLOC_MSG = ResourceBundle.getBundle("org.graalvm.visualvm.lib.jfluid.results.memory.Bundle").getString("AllocMemoryResultsSnapshot_MemoryAllocMsg");
    private int[] objectsCounts;

    public AllocMemoryResultsSnapshot() {
    }

    public AllocMemoryResultsSnapshot(long beginTime, long timeTaken, MemoryCCTProvider provider, ProfilerClient client) throws ClientUtils.TargetAppOrVMTerminated {
        super(beginTime, timeTaken, provider, client);
    }

    public int[] getObjectsCounts() {
        return this.objectsCounts;
    }

    @Override
    public void performInit(ProfilerClient client, MemoryCCTProvider provider) throws ClientUtils.TargetAppOrVMTerminated {
        super.performInit(client, provider);
        int[] cnts = client.getAllocatedObjectsCountResults();
        this.objectsCounts = new int[cnts.length];
        System.arraycopy(cnts, 0, this.objectsCounts, 0, cnts.length);
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    @Override
    public AllocMemoryResultsSnapshot createDiff(MemoryResultsSnapshot snapshot) {
        if (!(snapshot instanceof AllocMemoryResultsSnapshot)) {
            return null;
        }
        return new AllocMemoryResultsDiff(this, (AllocMemoryResultsSnapshot)snapshot);
    }

    @Override
    public void readFromStream(DataInputStream in) throws IOException {
        super.readFromStream(in);
        int len = in.readInt();
        this.objectsCounts = new int[len];
        for (int i = 0; i < len; ++i) {
            this.objectsCounts[i] = in.readInt();
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    @Override
    public String toString() {
        return MessageFormat.format(MEMORY_ALLOC_MSG, super.toString());
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        super.writeToStream(out);
        out.writeInt(this.objectsCounts.length);
        for (int i = 0; i < this.objectsCounts.length; ++i) {
            out.writeInt(this.objectsCounts[i]);
        }
    }

    @Override
    protected PresoObjAllocCCTNode createPresentationCCT(RuntimeMemoryCCTNode rootNode, int classId, boolean dontShowZeroLiveObjAllocPaths) {
        return PresoObjAllocCCTNode.createPresentationCCTFromSnapshot(this.getJMethodIdTable(), rootNode, this.getClassName(classId));
    }

    @Override
    void debugValues() {
        super.debugValues();
        LOGGER.finest("objectsCounts.length: " + this.debugLength(this.objectsCounts));
    }
}

