/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.samples.signature;

import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.samples.SampleUtils;
import org.apache.xml.security.samples.utils.resolver.OfflineResolver;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VerifyMerlinsExamplesSixteen {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$samples$signature$VerifyMerlinsExamplesSixteen == null ? (class$org$apache$xml$security$samples$signature$VerifyMerlinsExamplesSixteen = VerifyMerlinsExamplesSixteen.class$("org.apache.xml.security.samples.signature.VerifyMerlinsExamplesSixteen")) : class$org$apache$xml$security$samples$signature$VerifyMerlinsExamplesSixteen).getName());
    static final boolean schemaValidate = false;
    static final String signatureSchemaFile = "data/xmldsig-core-schema.xsd";
    static /* synthetic */ Class class$org$apache$xml$security$samples$signature$VerifyMerlinsExamplesSixteen;

    public static void main(String[] stringArray) {
        System.out.println("We do not schema-validation");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
        String[] stringArray2 = new String[]{"data/ie/baltimore/merlin-examples/merlin-xmldsig-sixteen/signature.xml"};
        int n = 0;
        int n2 = stringArray2.length;
        for (int i = n; i < n2; ++i) {
            String string = stringArray2[i];
            try {
                VerifyMerlinsExamplesSixteen.verify(documentBuilderFactory, string);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void verify(DocumentBuilderFactory documentBuilderFactory, String string) throws Exception {
        File file = new File(string);
        System.out.println("Try to verify " + file.toURL().toString());
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new FileInputStream(file));
        Element element = SampleUtils.createDSctx(document, "ds", "http://www.w3.org/2000/09/xmldsig#");
        Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)"//ds:Signature[1]", (Node)element);
        XMLSignature xMLSignature = new XMLSignature(element2, file.toURL().toString());
        xMLSignature.getSignedInfo().addResourceResolver((ResourceResolverSpi)new OfflineResolver());
        xMLSignature.setFollowNestedManifests(false);
        KeyInfo keyInfo = xMLSignature.getKeyInfo();
        if (keyInfo != null) {
            X509Certificate x509Certificate = xMLSignature.getKeyInfo().getX509Certificate();
            if (x509Certificate != null) {
                System.out.println("The XML signature in file " + file.toURL().toString() + " is " + (xMLSignature.checkSignatureValue(x509Certificate) ? "valid (good)" : "invalid !!!!! (bad)"));
            } else {
                PublicKey publicKey = xMLSignature.getKeyInfo().getPublicKey();
                if (publicKey != null) {
                    System.out.println("The XML signature in file " + file.toURL().toString() + " is " + (xMLSignature.checkSignatureValue((Key)publicKey) ? "valid (good)" : "invalid !!!!! (bad)"));
                } else {
                    System.out.println("Did not find a public key, so I can't check the signature");
                }
            }
        } else {
            System.out.println("Did not find a KeyInfo");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Init.init();
    }
}

