/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.format.RtxPayloadType;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.ObserverNode;
import org.jitsi.nlj.transform.node.incoming.IncomingSsrcStats;
import org.jitsi.nlj.transform.node.incoming.IncomingStatisticsSnapshot;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.util.RtpUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0014J\u0016\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/IncomingStatisticsTracker;", "Lorg/jitsi/nlj/transform/node/ObserverNode;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "<init>", "(Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;)V", "ssrcStats", "", "", "Lorg/jitsi/nlj/transform/node/incoming/IncomingSsrcStats;", "observe", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "getNodeStatsToAggregate", "trace", "f", "Lkotlin/Function0;", "getSnapshotOfActiveSsrcs", "Lorg/jitsi/nlj/transform/node/incoming/IncomingStatisticsSnapshot;", "getSnapshot", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nIncomingStatisticsTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncomingStatisticsTracker.kt\norg/jitsi/nlj/transform/node/incoming/IncomingStatisticsTracker\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,342:1\n216#2,2:343\n136#2,9:345\n216#2:354\n217#2:357\n145#2:358\n126#2:359\n153#2,3:360\n1#3:355\n1#3:356\n*S KotlinDebug\n*F\n+ 1 IncomingStatisticsTracker.kt\norg/jitsi/nlj/transform/node/incoming/IncomingStatisticsTracker\n*L\n66#1:343,2\n85#1:345,9\n85#1:354\n85#1:357\n85#1:358\n91#1:359\n91#1:360,3\n85#1:356\n*E\n"})
public final class IncomingStatisticsTracker
extends ObserverNode {
    @NotNull
    private final ReadOnlyStreamInformationStore streamInformationStore;
    @NotNull
    private final Map<Long, IncomingSsrcStats> ssrcStats;

    public IncomingStatisticsTracker(@NotNull ReadOnlyStreamInformationStore streamInformationStore) {
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        super("Incoming statistics tracker");
        this.streamInformationStore = streamInformationStore;
        this.ssrcStats = new ConcurrentHashMap();
    }

    @Override
    protected void observe(@NotNull PacketInfo packetInfo) {
        block2: {
            Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
            RtpPacket rtpPacket = (RtpPacket)packetInfo.packetAs();
            PayloadType payloadType = this.streamInformationStore.getRtpPayloadTypes().get((byte)rtpPacket.getPayloadType());
            if (payloadType == null) break block2;
            PayloadType payloadType2 = payloadType;
            boolean bl = false;
            if (!(payloadType2 instanceof RtxPayloadType)) {
                IncomingSsrcStats incomingSsrcStats = this.ssrcStats.computeIfAbsent(rtpPacket.getSsrc(), arg_0 -> IncomingStatisticsTracker.observe$lambda$3$lambda$1(arg_0 -> IncomingStatisticsTracker.observe$lambda$3$lambda$0(rtpPacket, payloadType2, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue(incomingSsrcStats, "computeIfAbsent(...)");
                IncomingSsrcStats stats = incomingSsrcStats;
                Instant packetSentTimestamp = RtpUtils.Companion.convertRtpTimestampToInstant((int)rtpPacket.getTimestamp(), payloadType2.getClockRate());
                Instant instant = packetInfo.getReceivedTime();
                if (instant != null) {
                    Instant it = instant;
                    boolean bl2 = false;
                    stats.packetReceived(rtpPacket, packetSentTimestamp, it);
                }
            }
        }
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u245 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        IncomingStatisticsSnapshot stats = this.getSnapshot();
        Map<Long, IncomingSsrcStats.Snapshot> $this$forEach$iv = stats.getSsrcStats();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, IncomingSsrcStats.Snapshot>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Long, IncomingSsrcStats.Snapshot> element$iv;
            Map.Entry<Long, IncomingSsrcStats.Snapshot> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            long ssrc = ((Number)entry.getKey()).longValue();
            IncomingSsrcStats.Snapshot streamStats = entry.getValue();
            $this$getNodeStats_u24lambda_u245.addJson(String.valueOf(ssrc), streamStats.toJson());
        }
        return nodeStatsBlock;
    }

    @Override
    @NotNull
    protected NodeStatsBlock getNodeStatsToAggregate() {
        return super.getNodeStats();
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IncomingStatisticsSnapshot getSnapshotOfActiveSsrcs() {
        void $this$mapNotNullTo$iv$iv;
        Map<Long, IncomingSsrcStats> $this$mapNotNull$iv = this.ssrcStats;
        boolean $i$f$mapNotNull = false;
        Map<Long, IncomingSsrcStats> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Pair<Long, IncomingSsrcStats.Snapshot> pair;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            long ssrc = ((Number)entry.getKey()).longValue();
            IncomingSsrcStats stats = (IncomingSsrcStats)entry.getValue();
            if (stats.getSnapshotIfActive() != null) {
                IncomingSsrcStats.Snapshot it;
                boolean bl3 = false;
                pair = new Pair<Long, IncomingSsrcStats.Snapshot>(ssrc, it);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair<Long, IncomingSsrcStats.Snapshot> it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map<Long, IncomingSsrcStats.Snapshot> map2 = MapsKt.toMap((List)destination$iv$iv);
        return new IncomingStatisticsSnapshot(map2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IncomingStatisticsSnapshot getSnapshot() {
        void $this$mapTo$iv$iv;
        Map<Long, IncomingSsrcStats> $this$map$iv = this.ssrcStats;
        boolean $i$f$map = false;
        Map<Long, IncomingSsrcStats> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            long ssrc = ((Number)entry.getKey()).longValue();
            IncomingSsrcStats stats = (IncomingSsrcStats)entry.getValue();
            collection.add(new Pair<Long, IncomingSsrcStats.Snapshot>(ssrc, stats.getSnapshot()));
        }
        Map<Long, IncomingSsrcStats.Snapshot> map2 = MapsKt.toMap((List)destination$iv$iv);
        return new IncomingStatisticsSnapshot(map2);
    }

    private static final IncomingSsrcStats observe$lambda$3$lambda$0(RtpPacket $rtpPacket, PayloadType $payloadType, Long it) {
        Intrinsics.checkNotNullParameter($rtpPacket, "$rtpPacket");
        Intrinsics.checkNotNullParameter($payloadType, "$payloadType");
        Intrinsics.checkNotNullParameter(it, "it");
        return new IncomingSsrcStats($rtpPacket.getSsrc(), $rtpPacket.getSequenceNumber(), $payloadType.getMediaType());
    }

    private static final IncomingSsrcStats observe$lambda$3$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (IncomingSsrcStats)$tmp0.invoke(p0);
    }
}

