/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jitsi.nlj.rtp.SsrcAssociationType;

public class EncodingsManager {
    private Map<String, List<SsrcAssociation>> ssrcAssociations = new ConcurrentHashMap<String, List<SsrcAssociation>>();
    private Set<EncodingsUpdateListener> listeners = ConcurrentHashMap.newKeySet();

    public void addSsrcAssociation(String endpointId, long primarySsrc, long secondarySsrc, SsrcAssociationType type) {
        List epSsrcAssociations = this.ssrcAssociations.computeIfAbsent(endpointId, k -> new ArrayList());
        epSsrcAssociations.add(new SsrcAssociation(primarySsrc, secondarySsrc, type));
        this.listeners.forEach(listener -> listener.onNewSsrcAssociation(endpointId, primarySsrc, secondarySsrc, type));
    }

    public void subscribe(EncodingsUpdateListener listener) {
        this.listeners.add(listener);
        this.ssrcAssociations.forEach((endpointId, ssrcAssociations) -> ssrcAssociations.forEach(ssrcAssociation -> listener.onNewSsrcAssociation((String)endpointId, ssrcAssociation.primarySsrc, ssrcAssociation.secondarySsrc, ssrcAssociation.type)));
    }

    public void unsubscribe(EncodingsUpdateListener listener) {
        this.listeners.remove(listener);
    }

    private static class SsrcAssociation {
        private long primarySsrc;
        private long secondarySsrc;
        private SsrcAssociationType type;

        private SsrcAssociation(long primarySsrc, long secondarySsrc, SsrcAssociationType type) {
            this.primarySsrc = primarySsrc;
            this.secondarySsrc = secondarySsrc;
            this.type = type;
        }
    }

    public static interface EncodingsUpdateListener {
        public void onNewSsrcAssociation(String var1, long var2, long var4, SsrcAssociationType var6);
    }
}

