/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.mucclient;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.mucclient.ConnectionStateListener;
import org.jitsi.xmpp.mucclient.IQListener;
import org.jitsi.xmpp.mucclient.MucClient;
import org.jitsi.xmpp.mucclient.MucClientConfiguration;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jxmpp.util.XmppStringUtils;

public class MucClientManager
implements ConnectionStateListener {
    private static final Logger logger = new LoggerImpl(MucClientManager.class.getName());
    private final Map<String, MucClient> mucClients = new ConcurrentHashMap<String, MucClient>();
    private final Set<String> features = new HashSet<String>();
    private IQListener iqListener;
    private Map<IQ, Boolean> registeredIqs = new HashMap<IQ, Boolean>();
    private final Map<String, ExtensionElement> presenceExtensions = new ConcurrentHashMap<String, ExtensionElement>();
    private final Object syncRoot = new Object();
    List<ConnectionStateListener> connectionStateListeners = new CopyOnWriteArrayList<ConnectionStateListener>();

    public MucClientManager() {
        this(new String[0]);
    }

    public MucClientManager(String[] features) {
        SmackConfiguration.setUnknownIqRequestReplyMode(SmackConfiguration.UnknownIqRequestReplyMode.replyFeatureNotImplemented);
        if (features != null) {
            this.features.addAll(Arrays.asList(features));
        }
    }

    public void addConnectionStateListener(ConnectionStateListener listener) {
        this.connectionStateListeners.add(listener);
    }

    public void removeConnectionStateListener(ConnectionStateListener listener) {
        this.connectionStateListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMucClient(MucClientConfiguration config) {
        MucClient mucClient;
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.mucClients.get(config.getId()) != null) {
                logger.error("Not adding a new MUC client, ID already exists.");
                return false;
            }
            mucClient = new MucClient(config, this);
            this.mucClients.put(config.getId(), mucClient);
        }
        mucClient.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPresenceExtension(ExtensionElement extension) {
        Object object = this.syncRoot;
        synchronized (object) {
            logger.debug("Setting a presence extension: " + extension);
            this.saveExtension(extension);
            this.mucClients.values().forEach(mucClient -> mucClient.setPresenceExtension(extension));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveExtension(ExtensionElement extension) {
        Object object = this.syncRoot;
        synchronized (object) {
            ExtensionElement previousExtension = this.presenceExtensions.put(XmppStringUtils.generateKey(extension.getElementName(), extension.getNamespace()), extension);
            if (previousExtension != null && logger.isDebugEnabled()) {
                logger.debug("Replacing presence extension: " + previousExtension);
            }
        }
    }

    private void removeExtension(String elementName, String namespace) {
        this.presenceExtensions.remove(XmppStringUtils.generateKey(elementName, namespace));
    }

    Collection<ExtensionElement> getPresenceExtensions() {
        return this.presenceExtensions.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePresenceExtension(String elementName, String namespace) {
        Object object = this.syncRoot;
        synchronized (object) {
            this.removeExtension(elementName, namespace);
            this.mucClients.values().forEach(mucClient -> mucClient.removePresenceExtension(elementName, namespace));
        }
    }

    Set<String> getFeatures() {
        return this.features;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIQListener(IQListener iqListener) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.iqListener != null) {
                logger.info("Replacing an existing IQ listener.");
            }
            this.iqListener = iqListener;
            this.mucClients.values().forEach(m4 -> m4.setIQListener(iqListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIQ(IQ iq, boolean requireResponse) {
        Object object = this.syncRoot;
        synchronized (object) {
            this.registeredIqs.put(iq, requireResponse);
            this.mucClients.values().forEach(mucClient -> mucClient.registerIQ(iq, requireResponse));
        }
    }

    public void registerIQ(IQ iq) {
        this.registerIQ(iq, true);
    }

    public void registerIQ(String elementName, String namespace) {
        this.registerIQ(elementName, namespace, true);
    }

    public void registerIQ(String elementName, String namespace, boolean requireResponse) {
        this.registerIQ(new IQ(elementName, namespace){

            @Override
            protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
                return null;
            }
        }, requireResponse);
    }

    Map<IQ, Boolean> getRegisteredIqs() {
        return new HashMap<IQ, Boolean>(this.registeredIqs);
    }

    IQListener getIqListener() {
        return this.iqListener;
    }

    public boolean removeMucClient(String id) {
        MucClient mucClient = this.mucClients.remove(id);
        if (mucClient == null) {
            logger.info("Can not find MucClient to remove.");
            return false;
        }
        mucClient.stop();
        return true;
    }

    @Nullable
    public MucClient getMucClient(@NotNull String id) {
        return this.mucClients.get(id);
    }

    public void stop() {
        this.mucClients.keySet().forEach(this::removeMucClient);
    }

    public long getClientCount() {
        return this.mucClients.size();
    }

    public long getClientConnectedCount() {
        return this.mucClients.values().stream().filter(MucClient::isConnected).count();
    }

    public List<String> getMucClientIds() {
        return new ArrayList<String>(this.mucClients.keySet());
    }

    public long getMucCount() {
        return this.mucClients.values().stream().map(MucClient::getMucsCount).mapToInt(Integer::intValue).sum();
    }

    public long getMucJoinedCount() {
        return this.mucClients.values().stream().map(MucClient::getMucsJoinedCount).mapToInt(Integer::intValue).sum();
    }

    @Override
    public void connected(@NotNull MucClient mucClient) {
        for (ConnectionStateListener listener : this.connectionStateListeners) {
            listener.connected(mucClient);
        }
    }

    @Override
    public void closed(@NotNull MucClient mucClient) {
        for (ConnectionStateListener listener : this.connectionStateListeners) {
            listener.closed(mucClient);
        }
    }

    @Override
    public void closedOnError(@NotNull MucClient mucClient) {
        for (ConnectionStateListener listener : this.connectionStateListeners) {
            listener.closedOnError(mucClient);
        }
    }

    @Override
    public void reconnecting(@NotNull MucClient mucClient) {
        for (ConnectionStateListener listener : this.connectionStateListeners) {
            listener.reconnecting(mucClient);
        }
    }

    @Override
    public void reconnectionFailed(@NotNull MucClient mucClient) {
        for (ConnectionStateListener listener : this.connectionStateListeners) {
            listener.reconnectionFailed(mucClient);
        }
    }

    @Override
    public void pingFailed(@NotNull MucClient mucClient) {
        for (ConnectionStateListener listener : this.connectionStateListeners) {
            listener.pingFailed(mucClient);
        }
    }
}

