/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet6Address;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public class IcmpV6HomeAgentAddressDiscoveryReplyPacket
extends AbstractPacket {
    private static final long serialVersionUID = 8080366373921919970L;
    private final IcmpV6HomeAgentAddressDiscoveryReplyHeader header;

    public static IcmpV6HomeAgentAddressDiscoveryReplyPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IcmpV6HomeAgentAddressDiscoveryReplyPacket(rawData, offset, length);
    }

    private IcmpV6HomeAgentAddressDiscoveryReplyPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new IcmpV6HomeAgentAddressDiscoveryReplyHeader(rawData, offset, length);
    }

    private IcmpV6HomeAgentAddressDiscoveryReplyPacket(Builder builder2) {
        this.header = new IcmpV6HomeAgentAddressDiscoveryReplyHeader(builder2);
    }

    @Override
    public IcmpV6HomeAgentAddressDiscoveryReplyHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV6HomeAgentAddressDiscoveryReplyHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 7184228144196703852L;
        private static final int IDENTIFIER_OFFSET = 0;
        private static final int IDENTIFIER_SIZE = 2;
        private static final int RESERVED_OFFSET = 2;
        private static final int RESERVED_SIZE = 2;
        private static final int HOME_AGENT_ADDRESSES_OFFSET = 4;
        private static final int HOME_AGENT_ADDRESSES_SIZE = 16;
        private static final int ICMPV6_HOME_AGENT_ADDRESS_DISCOVERY_REPLY_HEADER_MIN_SIZE = 20;
        private final short identifier;
        private final short reserved;
        private final List<Inet6Address> homeAgentAddresses;

        private IcmpV6HomeAgentAddressDiscoveryReplyHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 20) {
                StringBuilder sb = new StringBuilder();
                sb.append("The data is too short to build an ICMPv6 Home Agent Address Discovery Reply Header(").append(20).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.identifier = ByteArrays.getShort(rawData, 0 + offset);
            this.reserved = ByteArrays.getShort(rawData, 2 + offset);
            this.homeAgentAddresses = new ArrayList<Inet6Address>();
            for (int i = 4; i < length; i += 16) {
                this.homeAgentAddresses.add(ByteArrays.getInet6Address(rawData, i + offset));
            }
        }

        private IcmpV6HomeAgentAddressDiscoveryReplyHeader(Builder builder2) {
            this.identifier = builder2.identifier;
            this.reserved = builder2.reserved;
            this.homeAgentAddresses = builder2.homeAgentAddresses != null ? new ArrayList<Inet6Address>(builder2.homeAgentAddresses) : new ArrayList<Inet6Address>(0);
        }

        public short getIdentifier() {
            return this.identifier;
        }

        public int getIdentifierAsInt() {
            return this.identifier & 0xFFFF;
        }

        public short getReserved() {
            return this.reserved;
        }

        public List<Inet6Address> getHomeAgentAddresses() {
            return new ArrayList<Inet6Address>(this.homeAgentAddresses);
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.identifier));
            rawFields.add(ByteArrays.toByteArray(this.reserved));
            for (Inet6Address addr : this.homeAgentAddresses) {
                rawFields.add(ByteArrays.toByteArray(addr));
            }
            return rawFields;
        }

        @Override
        protected int calcLength() {
            return this.homeAgentAddresses.size() * 16 + 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[ICMPv6 Home Agent Address Discovery Reply Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Identifier: ").append(this.getIdentifierAsInt()).append(ls);
            sb.append("  Reserved: ").append(this.reserved).append(ls);
            for (Inet6Address addr : this.homeAgentAddresses) {
                sb.append("  HomeAgentAddress: ").append(addr);
                sb.append(ls);
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            IcmpV6HomeAgentAddressDiscoveryReplyHeader other = (IcmpV6HomeAgentAddressDiscoveryReplyHeader)obj;
            return this.identifier == other.identifier && this.reserved == other.reserved && this.homeAgentAddresses.equals(other.homeAgentAddresses);
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.identifier;
            result = 31 * result + this.reserved;
            result = 31 * result + this.homeAgentAddresses.hashCode();
            return result;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private short identifier;
        private short reserved;
        private List<Inet6Address> homeAgentAddresses;

        public Builder() {
        }

        private Builder(IcmpV6HomeAgentAddressDiscoveryReplyPacket packet) {
            this.identifier = packet.header.identifier;
            this.reserved = packet.header.reserved;
            this.homeAgentAddresses = packet.header.homeAgentAddresses;
        }

        public Builder identifier(short identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder reserved(short reserved) {
            this.reserved = reserved;
            return this;
        }

        public Builder homeAgentAddresses(List<Inet6Address> homeAgentAddresses) {
            this.homeAgentAddresses = homeAgentAddresses;
            return this;
        }

        @Override
        public IcmpV6HomeAgentAddressDiscoveryReplyPacket build() {
            return new IcmpV6HomeAgentAddressDiscoveryReplyPacket(this);
        }
    }
}

