/*
 * Decompiled with CFR 0.152.
 */
package smjni.jnigen;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import smjni.jnigen.ClassContent;
import smjni.jnigen.Context;
import smjni.jnigen.Generator;
import smjni.jnigen.JavaEntity;
import smjni.jnigen.JavaEntityType;
import smjni.jnigen.NameTable;
import smjni.jnigen.NativeMethod;
import smjni.jnigen.TypeMap;
import smjni.jnigen.UniqueName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ&\u0010\u000e\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00062\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\b0\u001dH\u0002J\u001e\u0010\u001e\u001a\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010!\u001a\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\"\u001a\u00020\b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010%\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010&\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010'\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006H\u0002\u00a8\u0006*"}, d2={"Lsmjni/jnigen/Generator;", "", "()V", "digestFile", "", "path", "", "generate", "", "typeMap", "Lsmjni/jnigen/TypeMap;", "context", "Lsmjni/jnigen/Context;", "generate$processor", "generateAllClassesHeader", "headers", "", "generateClassDef", "classHeader", "Ljava/io/FileWriter;", "content", "Lsmjni/jnigen/ClassContent;", "generateClassHeader", "", "header", "generateConstructorImplementation", "generateFile", "name", "generator", "Lkotlin/Function1;", "generateJavaEntityAccessors", "javaEntities", "Lsmjni/jnigen/JavaEntity;", "generateJavaEntityFields", "generateNativeMethodDeclarations", "nativeMethods", "Lsmjni/jnigen/NativeMethod;", "generateOutputsList", "generateRegistrationMethodImplementation", "generateTypeHeader", "makeGuardName", "fileName", "processor"})
@SourceDebugExtension(value={"SMAP\nGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Generator.kt\nsmjni/jnigen/Generator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,430:1\n1#2:431\n1620#3,3:432\n*S KotlinDebug\n*F\n+ 1 Generator.kt\nsmjni/jnigen/Generator\n*L\n147#1:432,3\n*E\n"})
public final class Generator {
    public final void generate$processor(@NotNull TypeMap typeMap, @NotNull Context context) {
        Intrinsics.checkNotNullParameter(typeMap, "typeMap");
        Intrinsics.checkNotNullParameter(context, "context");
        this.generateTypeHeader(typeMap, context);
        ArrayList<String> allHeaders = new ArrayList<String>();
        for (String header : CollectionsKt.sorted((Iterable)typeMap.getClassHeaders$processor())) {
            if (!this.generateClassHeader(header, typeMap, context)) continue;
            allHeaders.add(header);
        }
        this.generateAllClassesHeader((List<String>)allHeaders, typeMap, context);
        this.generateOutputsList((List<String>)allHeaders, context);
    }

    private final void generateTypeHeader(TypeMap typeMap, Context context) {
        boolean generated2 = this.generateFile(context.getDestPath() + '/' + context.getHeaderName(), (Function1<? super FileWriter, Unit>)new Function1<FileWriter, Unit>(this, context, typeMap){
            final /* synthetic */ Generator this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ TypeMap $typeMap;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                this.$typeMap = $typeMap;
                super(1);
            }

            public final void invoke(@NotNull FileWriter typeHeader) {
                Intrinsics.checkNotNullParameter(typeHeader, "typeHeader");
                String guardName = "HEADER_" + Generator.access$makeGuardName(this.this$0, this.$context.getHeaderName()) + "_INCLUDED";
                typeHeader.write("#ifndef " + guardName + '\n');
                typeHeader.write("#define " + guardName + "\n\n\n");
                typeHeader.write("//THIS FILE IS AUTO-GENERATED. DO NOT EDIT\n\n");
                typeHeader.write("#include <smjni/smjni.h>\n\n");
                Iterable $this$sortedBy$iv = new ArrayList<ClassContent>(this.$typeMap.getExposedClasses$processor().values());
                boolean $i$f$sortedBy = false;
                List<ClassContent> exposedClasses = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        ClassContent it = (ClassContent)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getCppName$processor());
                        it = (ClassContent)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getCppName$processor()));
                    }
                });
                for (ClassContent classContent : exposedClasses) {
                    typeHeader.write("DEFINE_JAVA_TYPE(" + classContent.getCppName$processor() + ",  \"" + classContent.getBinaryName() + "\")\n");
                }
                typeHeader.write("\n");
                Collection $this$toTypedArray$iv = this.$typeMap.getExposedArrays$processor();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                for (String arrayType : ArraysKt.sorted((Comparable[])((Comparable[])thisCollection$iv.toArray(new String[0])))) {
                    typeHeader.write("DEFINE_ARRAY_JAVA_TYPE(" + arrayType + ")\n");
                }
                typeHeader.write("\n");
                for (ClassContent classContent : exposedClasses) {
                    for (String item : CollectionsKt.sorted((Iterable)classContent.getConvertsTo())) {
                        typeHeader.write("DEFINE_JAVA_CONVERSION(" + this.$typeMap.nativeNameOf$processor(item) + ", " + classContent.getCppName$processor() + ")\n");
                    }
                }
                typeHeader.write("\n#endif\n");
            }
        });
        context.print("JNIGen: Generating " + context.getHeaderName() + ':' + (generated2 ? "  written" : "  up-to-date"));
    }

    private final boolean generateClassHeader(String header, TypeMap typeMap, Context context) {
        ClassContent classContent;
        block2: {
            Sequence<ClassContent> sequence = typeMap.classesInHeader$processor(header);
            Iterator<ClassContent> iterator2 = sequence.iterator();
            while (iterator2.hasNext()) {
                ClassContent classContent2;
                ClassContent it = classContent2 = iterator2.next();
                boolean bl = false;
                boolean bl2 = !((Collection)it.getJavaEntities$processor()).isEmpty() || !((Collection)it.getNativeMethods$processor()).isEmpty();
                if (!bl2) continue;
                classContent = classContent2;
                break block2;
            }
            classContent = null;
        }
        if (classContent == null) {
            return false;
        }
        boolean generated2 = this.generateFile(context.getDestPath() + '/' + header, (Function1<? super FileWriter, Unit>)new Function1<FileWriter, Unit>(this, header, context, typeMap){
            final /* synthetic */ Generator this$0;
            final /* synthetic */ String $header;
            final /* synthetic */ Context $context;
            final /* synthetic */ TypeMap $typeMap;
            {
                this.this$0 = $receiver;
                this.$header = $header;
                this.$context = $context;
                this.$typeMap = $typeMap;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull FileWriter classHeader) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(classHeader, "classHeader");
                String guardName = "HEADER_" + Generator.access$makeGuardName(this.this$0, this.$header) + "_INCLUDED";
                classHeader.write("#ifndef " + guardName + '\n');
                classHeader.write("#define " + guardName + "\n\n\n");
                classHeader.write("//THIS FILE IS AUTO-GENERATED. DO NOT EDIT\n\n");
                classHeader.write("#include \"" + this.$context.getHeaderName() + "\"\n\n");
                Sequence<ClassContent> $this$sortedBy$iv = this.$typeMap.classesInHeader$processor(this.$header);
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        ClassContent it = (ClassContent)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getCppName$processor());
                        it = (ClassContent)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getCppName$processor()));
                    }
                });
                Generator generator = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ClassContent classContent = (ClassContent)element$iv;
                    boolean bl = false;
                    if (!(!((Collection)classContent.getJavaEntities$processor()).isEmpty()) && !(!((Collection)classContent.getNativeMethods$processor()).isEmpty())) continue;
                    Generator.access$generateClassDef(generator, classHeader, classContent);
                }
                classHeader.write("#endif\n");
            }
        });
        context.print("JNIGen: Generating " + header + ':' + (generated2 ? "  written" : "  up-to-date"));
        return true;
    }

    private final void generateClassDef(FileWriter classHeader, ClassContent content) {
        classHeader.write("class " + content.getCppClassName() + " : public smjni::java_runtime::simple_java_class<" + content.getCppName$processor() + ">\n{\npublic:\n    " + content.getCppClassName() + "(JNIEnv * env);\n\n");
        if (!((Collection)content.getNativeMethods$processor()).isEmpty()) {
            classHeader.write("    void register_methods(JNIEnv * env) const;\n\n");
        }
        this.generateJavaEntityAccessors(content.getJavaEntities$processor(), classHeader);
        classHeader.write("private:\n");
        this.generateNativeMethodDeclarations(content.getNativeMethods$processor(), classHeader);
        this.generateJavaEntityFields(content.getJavaEntities$processor(), classHeader);
        classHeader.write("};\n\n\n");
        this.generateConstructorImplementation(content, classHeader);
        this.generateRegistrationMethodImplementation(content, classHeader);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateJavaEntityAccessors(List<JavaEntity> javaEntities, FileWriter classHeader) {
        for (JavaEntity javaEntity : javaEntities) {
            NameTable argNameTable = new NameTable();
            ArrayList<UniqueName> argNames = new ArrayList<UniqueName>();
            argNames.add(argNameTable.allocateName$processor("env"));
            if (javaEntity.getAllowNonVirt()) {
                argNameTable.allocateName$processor("classForNonVirtualCall");
            }
            Iterable $this$mapTo$iv = javaEntity.getArgNames();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                String string = (String)item$iv;
                Collection collection = argNames;
                boolean bl = false;
                collection.add(argNameTable.allocateName$processor((String)it));
            }
            switch (WhenMappings.$EnumSwitchMapping$0[javaEntity.getType().ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    int i;
                    classHeader.write("    " + javaEntity.getReturnType() + ' ' + javaEntity.getName() + "(JNIEnv * env");
                    int item$iv = javaEntity.getArgTypes().size();
                    for (int i2 = 0; i2 < item$iv; ++i2) {
                        classHeader.write(", " + javaEntity.getArgTypes().get(i2) + ' ' + argNames.get(i2 + 1));
                    }
                    String memberName = "m_" + javaEntity.getName();
                    classHeader.write(") const\n        { ");
                    if (!Intrinsics.areEqual(javaEntity.getReturnType(), "void")) {
                        classHeader.write("return ");
                    }
                    classHeader.write(memberName + "(env");
                    if (javaEntity.getType() == JavaEntityType.StaticMethod || javaEntity.getType() == JavaEntityType.Constructor) {
                        classHeader.write(", *this");
                    }
                    int it = javaEntity.getArgTypes().size();
                    for (i = 0; i < it; ++i) {
                        classHeader.write(", " + argNames.get(i + 1));
                    }
                    classHeader.write("); }\n");
                    if (!javaEntity.getAllowNonVirt()) break;
                    classHeader.write("    template<typename ClassType> " + javaEntity.getReturnType() + ' ' + javaEntity.getName() + "(JNIEnv * env");
                    classHeader.write(", " + javaEntity.getArgTypes().get(0) + ' ' + argNames.get(1));
                    classHeader.write(", const java_class<ClassType> & classForNonVirtualCall");
                    it = javaEntity.getArgTypes().size();
                    for (i = 1; i < it; ++i) {
                        classHeader.write(", " + javaEntity.getArgTypes().get(i) + ' ' + argNames.get(i + 1));
                    }
                    classHeader.write(") const\n        { ");
                    if (!Intrinsics.areEqual(javaEntity.getReturnType(), "void")) {
                        classHeader.write("return ");
                    }
                    classHeader.write(memberName + ".call_non_virtual(env");
                    classHeader.write(", " + argNames.get(1) + ", classForNonVirtualCall");
                    it = javaEntity.getArgTypes().size();
                    for (i = 1; i < it; ++i) {
                        classHeader.write(", " + argNames.get(i + 1));
                    }
                    classHeader.write("); }\n");
                    break;
                }
                case 4: 
                case 5: {
                    String memberName = "m_" + javaEntity.getName();
                    String getter = "get_" + javaEntity.getName();
                    classHeader.write("    " + javaEntity.getReturnType() + ' ' + getter + "(JNIEnv * env");
                    if (javaEntity.getArgTypes().size() == 2) {
                        classHeader.write(", " + javaEntity.getArgTypes().get(0) + ' ' + argNames.get(1));
                    }
                    classHeader.write(") const\n        { return " + memberName + ".get(env");
                    if (javaEntity.getType() == JavaEntityType.StaticField) {
                        classHeader.write(", *this");
                    }
                    if (javaEntity.getArgTypes().size() == 2) {
                        classHeader.write(", " + argNames.get(1));
                    }
                    classHeader.write("); }\n");
                    if (javaEntity.isFinal()) break;
                    String setter = "set_" + javaEntity.getName();
                    classHeader.write("    void " + setter + "(JNIEnv * env");
                    if (javaEntity.getArgTypes().size() == 2) {
                        classHeader.write(", " + javaEntity.getArgTypes().get(0) + ' ' + argNames.get(1));
                        classHeader.write(", " + javaEntity.getArgTypes().get(1) + " value");
                    } else {
                        classHeader.write(", " + javaEntity.getArgTypes().get(0) + " value");
                    }
                    classHeader.write(") const\n        { " + memberName + ".set(env");
                    if (javaEntity.getType() == JavaEntityType.StaticField) {
                        classHeader.write(", *this");
                    }
                    if (javaEntity.getArgTypes().size() == 2) {
                        classHeader.write(", " + argNames.get(1));
                    }
                    classHeader.write(", value); }\n");
                }
            }
        }
    }

    private final void generateJavaEntityFields(List<JavaEntity> javaEntities, FileWriter classHeader) {
        if (!((Collection)javaEntities).isEmpty()) {
            for (JavaEntity javaEntity : javaEntities) {
                switch (WhenMappings.$EnumSwitchMapping$0[javaEntity.getType().ordinal()]) {
                    case 1: {
                        classHeader.write("    const smjni::java_method<");
                        break;
                    }
                    case 2: {
                        classHeader.write("    const smjni::java_static_method<");
                        break;
                    }
                    case 4: {
                        classHeader.write("    const smjni::java_field<");
                        break;
                    }
                    case 5: {
                        classHeader.write("    const smjni::java_static_field<");
                        break;
                    }
                    case 3: {
                        classHeader.write("    const smjni::java_constructor<");
                    }
                }
                classHeader.write(CollectionsKt.joinToString$default(javaEntity.getTemplateArguments(), ", ", null, null, 0, null, null, 62, null));
                String memberName = "m_" + javaEntity.getName();
                classHeader.write("> " + memberName + ";\n");
            }
            classHeader.write("\n");
        }
    }

    private final void generateNativeMethodDeclarations(List<NativeMethod> nativeMethods, FileWriter classHeader) {
        if (!((Collection)nativeMethods).isEmpty()) {
            for (NativeMethod nativeMethod : nativeMethods) {
                classHeader.write("    static " + nativeMethod.getReturnType() + " JNICALL ");
                classHeader.write("" + nativeMethod.getName() + '(');
                NameTable argNameTable = new NameTable();
                String args2 = CollectionsKt.joinToString$default(nativeMethod.getArguments(), ", ", null, null, 0, null, new Function1<Pair<? extends String, ? extends String>, CharSequence>(argNameTable){
                    final /* synthetic */ NameTable $argNameTable;
                    {
                        this.$argNameTable = $argNameTable;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull Pair<String, String> arg) {
                        Intrinsics.checkNotNullParameter(arg, "arg");
                        String argName = arg.getSecond();
                        return argName == null ? (CharSequence)arg.getFirst() : (CharSequence)(arg.getFirst() + ' ' + this.$argNameTable.allocateName$processor(argName));
                    }
                }, 30, null);
                classHeader.write(args2 + ");\n");
            }
            classHeader.write("\n");
        }
    }

    private final void generateRegistrationMethodImplementation(ClassContent content, FileWriter classHeader) {
        if (!((Collection)content.getNativeMethods$processor()).isEmpty()) {
            classHeader.write("inline void " + content.getCppClassName() + "::register_methods(JNIEnv * env) const\n");
            classHeader.write("{\n");
            classHeader.write("    register_natives(env, {\n");
            for (NativeMethod nativeMethod : content.getNativeMethods$processor()) {
                StringBuilder cppName = new StringBuilder();
                if (nativeMethod.isNameNonUnique()) {
                    cppName.append('(' + nativeMethod.getReturnType() + " (JNICALL *)(");
                    CollectionsKt.joinTo$default(nativeMethod.getArguments(), cppName, ", ", null, null, 0, null, generateRegistrationMethodImplementation.1.INSTANCE, 60, null);
                    cppName.append("))");
                }
                cppName.append(nativeMethod.getName());
                if (nativeMethod.isStatic()) {
                    classHeader.write("        bind_native(\"" + nativeMethod.getName() + "\", " + cppName + "),\n");
                    continue;
                }
                classHeader.write("        bind_native(\"" + nativeMethod.getName() + "\", " + cppName + "),\n");
            }
            classHeader.write("    });\n");
            classHeader.write("}\n\n");
        }
    }

    private final void generateConstructorImplementation(ClassContent content, FileWriter classHeader) {
        classHeader.write("inline " + content.getCppClassName() + "::" + content.getCppClassName() + "(JNIEnv * env):\n");
        classHeader.write("    simple_java_class(env)");
        for (JavaEntity javaEntity : content.getJavaEntities$processor()) {
            String memberName = "m_" + javaEntity.getName();
            if (WhenMappings.$EnumSwitchMapping$0[javaEntity.getType().ordinal()] == 3) {
                classHeader.write(",\n    " + memberName + "(env, *this)");
                continue;
            }
            classHeader.write(",\n    " + memberName + "(env, *this, \"" + javaEntity.getName().getOriginal() + "\")");
        }
        classHeader.write("\n{}\n\n");
    }

    private final void generateAllClassesHeader(List<String> headers, TypeMap typeMap, Context context) {
        boolean generated2 = this.generateFile(context.getDestPath() + '/' + context.getAllHeaderName(), (Function1<? super FileWriter, Unit>)new Function1<FileWriter, Unit>(this, context, headers, typeMap){
            final /* synthetic */ Generator this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ List<String> $headers;
            final /* synthetic */ TypeMap $typeMap;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                this.$headers = $headers;
                this.$typeMap = $typeMap;
                super(1);
            }

            public final void invoke(@NotNull FileWriter allHeader) {
                Intrinsics.checkNotNullParameter(allHeader, "allHeader");
                String guardName = "HEADER_" + Generator.access$makeGuardName(this.this$0, this.$context.getAllHeaderName()) + "_INCLUDED";
                allHeader.write("#ifndef " + guardName + '\n');
                allHeader.write("#define " + guardName + "\n\n\n");
                allHeader.write("//THIS FILE IS AUTO-GENERATED. DO NOT EDIT\n\n");
                for (String header : this.$headers) {
                    allHeader.write("#include \"" + header + "\"\n");
                }
                allHeader.write("\n#define JNIGEN_ALL_GENERATED_CLASSES \\\n    ");
                allHeader.write(CollectionsKt.joinToString$default(this.$headers, ", \\\n    ", null, null, 0, null, new Function1<String, CharSequence>(this.$typeMap){
                    final /* synthetic */ TypeMap $typeMap;
                    {
                        this.$typeMap = $typeMap;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull String header) {
                        Intrinsics.checkNotNullParameter(header, "header");
                        return SequencesKt.joinToString$default(SequencesKt.sorted(SequencesKt.map(SequencesKt.filter(this.$typeMap.classesInHeader$processor(header), generateAllClassesHeader.generated.1.INSTANCE), generateAllClassesHeader.generated.2.INSTANCE)), ", \\\n    ", null, null, 0, null, null, 62, null);
                    }
                }, 30, null));
                allHeader.write("\n\n#endif\n");
            }
        });
        context.print("JNIGen: Generating " + context.getAllHeaderName() + ':' + (generated2 ? "  written" : "  up-to-date"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateOutputsList(List<String> headers, Context context) {
        boolean generated2 = this.generateFile(context.getDestPath() + '/' + context.getOutputListName(), (Function1<? super FileWriter, Unit>)new Function1<FileWriter, Unit>(context, headers){
            final /* synthetic */ Context $context;
            final /* synthetic */ List<String> $headers;
            {
                this.$context = $context;
                this.$headers = $headers;
                super(1);
            }

            public final void invoke(@NotNull FileWriter outList) {
                Intrinsics.checkNotNullParameter(outList, "outList");
                outList.write(this.$context.getHeaderName() + '\n');
                outList.write(this.$context.getAllHeaderName() + '\n');
                Iterable $this$forEach$iv = this.$headers;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    outList.write(it + '\n');
                }
            }
        });
        if (context.getOwnDestPath()) {
            Object object = new String[]{context.getOutputListName(), context.getHeaderName(), context.getAllHeaderName()};
            Set<String> written = SetsKt.plus(SetsKt.setOf(object), CollectionsKt.toSet((Iterable)headers));
            Path path = Paths.get(context.getDestPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue(path, "get(...)");
            object = Files.list(path);
            Throwable throwable = null;
            try {
                Stream stream = (Stream)object;
                boolean bl = false;
                stream.filter(arg_0 -> Generator.generateOutputsList$lambda$4$lambda$2(new Function1<Path, Boolean>(written){
                    final /* synthetic */ Set<String> $written;
                    {
                        this.$written = $written;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(Path it) {
                        Intrinsics.checkNotNull(it);
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        return !Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && !this.$written.contains(((Object)it.getFileName()).toString());
                    }
                }, arg_0)).forEach(arg_0 -> Generator.generateOutputsList$lambda$4$lambda$3(generateOutputsList.1.2.INSTANCE, arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, throwable);
            }
        }
        context.print("JNIGen: Generating " + context.getOutputListName() + ':' + (generated2 ? "  written" : "  up-to-date"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean generateFile(String name, Function1<? super FileWriter, Unit> generator) {
        File existing = new File(name);
        File dir = existing.getParentFile();
        Files.createDirectories(Paths.get(dir.getAbsolutePath(), new String[0]), new FileAttribute[0]);
        File temp = File.createTempFile("jnigen", null, dir);
        temp.deleteOnExit();
        try {
            Closeable closeable = new FileWriter(temp);
            CopyOption[] copyOptionArray = null;
            try {
                FileWriter it = (FileWriter)closeable;
                boolean bl = false;
                generator.invoke(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable object) {
                copyOptionArray = object;
                throw object;
            }
            finally {
                CloseableKt.closeFinally(closeable, (Throwable)copyOptionArray);
            }
            byte[] existingDigest = this.digestFile(name);
            if (existingDigest != null) {
                String string = temp.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
                byte[] newDigest = this.digestFile(string);
                Intrinsics.checkNotNull(newDigest);
                if (Arrays.equals(newDigest, existingDigest)) {
                    boolean bl = false;
                    return bl;
                }
                Files.delete(Paths.get(existing.getAbsolutePath(), new String[0]));
            }
            copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE};
            Files.move(Paths.get(temp.getAbsolutePath(), new String[0]), Paths.get(existing.getAbsolutePath(), new String[0]), copyOptionArray);
            boolean bl = true;
            return bl;
        }
        finally {
            temp.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] digestFile(String path) {
        MessageDigest md = MessageDigest.getInstance("MD5");
        try {
            Closeable closeable = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
            Throwable throwable = null;
            try {
                InputStream str = (InputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new DigestInputStream(str, md);
                Throwable throwable2 = null;
                try {
                    DigestInputStream dstr = (DigestInputStream)closeable2;
                    boolean bl2 = false;
                    byte[] buffer = new byte[1024];
                    while (dstr.read(buffer) != -1) {
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (NoSuchFileException ex) {
            return null;
        }
        return md.digest();
    }

    private final String makeGuardName(String fileName) {
        CharSequence charSequence = fileName;
        Regex regex = new Regex("[-.!@#$%^&*()+\\\\{}\\[\\];\"?<>,~`]");
        String string = "_";
        charSequence = regex.replace(charSequence, string);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string2 = ((String)charSequence).toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        return string2;
    }

    private static final boolean generateOutputsList$lambda$4$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void generateOutputsList$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$makeGuardName(Generator $this, String fileName) {
        return $this.makeGuardName(fileName);
    }

    public static final /* synthetic */ void access$generateClassDef(Generator $this, FileWriter classHeader, ClassContent content) {
        $this.generateClassDef(classHeader, content);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JavaEntityType.values().length];
            try {
                nArray[JavaEntityType.Method.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JavaEntityType.StaticMethod.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JavaEntityType.Constructor.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JavaEntityType.Field.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JavaEntityType.StaticField.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

