# dl-distro

Bash script for downloading and verifying OS images.

## Description

dl-distro aims to make downloading and verifying OS images quick and easy.

It uses `jq` for data retrieval, `wget` for downloading, `gpg` for signature
verification, and validates checksums with the relevant algorithm.

Supports **~700** images from **~40** [distributions](#supported-distributions).

## Dependencies

- `bash`
- `coreutils`
- `gnupg` (optional)
- `jq`
- `minisign` (optional: Void Linux verification)
- `signify`/`signify-openbsd (deb)` (optional: OpenBSD verification)
- `wget`

## Installation

### AUR

Use your preferred AUR helper to install `dl-distro` or `dl-distro-git`.

[![dl-distro](https://img.shields.io/aur/version/dl-distro?color=1793d1&label=dl-distro&logo=arch-linux&style=for-the-badge)](https://aur.archlinux.org/packages/dl-distro)
[![dl-distro-git](https://img.shields.io/aur/version/dl-distro-git?color=1793d1&label=dl-distro-git&logo=arch-linux&style=for-the-badge)](https://aur.archlinux.org/packages/dl-distro-git)

Or clone and build:

```
git clone https://aur.archlinux.org/dl-distro.git
cd dl-distro
makepkg -si
```

### Non-AUR

#### Install

`git clone` the repository and use the installer script inside the cloned
repository:

```
git clone https://codeberg.org/bashuser30/dl-distro.git
cd dl-distro
sudo ./scripts/installer.sh install
```

#### Update

```
git pull
sudo ./scripts/installer.sh install
```

#### Uninstall

```
sudo ./scripts/installer.sh uninstall
```

## Usage

It is recommended to generate a default config file using the `-c` option. This
config file has several values you can change, including a default download
directory:

```
dl-distro -c
```

See `man dl-distro` for more information about usage.

### Examples

Main menu with all distributions. Pick one and choose an image to download:

```
dl-distro
```

Provide a distribution name to skip the main menu. This will prompt you with
additional choice menus, if necessary:

```
dl-distro -d debian
```

You can skip the menus and start a download directly if you provide a JSON
query. The names used in the JSON query correspond directly to those in the
menus:

```
dl-distro -d debian.netinst.amd64
```

Download and verify the latest Debian network installer amd64 image, saving to
the ~/Downloads directory:

```
dl-distro -d debian.netinst.amd64 -p ~/Downloads
```

### Updating the JSON file

dl-distro relies on there being a locally stored JSON file. By default, this
file will be automatically updated upon runtime.

Use the `-a` option to toggle automatic updating of the file.

The `-u` option will force update the file.

## Supported Distributions

dl-distro aims to consistently support the latest versions officially
maintained, updating with new releases on their release day.

- [AlmaLinux OS](https://almalinux.org)
- [Alpine Linux](https://alpinelinux.org)
- [Arch Linux](https://archlinux.org)
- [CachyOS](https://cachyos.org)
- [Debian](https://debian.org)
- [deepin](https://deepin.org)
- [Dragora GNU/Linux-Libre](https://dragora.org)
- [EndeavourOS](https://endeavouros.com)
- [Fedora Linux](https://fedoraproject.org)
- [GhostBSD](https://ghostbsd.org)
- [GParted Live](https://gparted.org)
- [Guix System](https://guix.gnu.org)
- [Hyperbola GNU/Linux-libre](https://hyperbola.info)
- [Kali Linux](https://kali.org)
- [Linux Mint](https://linuxmint.com)
- [MX Linux](https://mxlinux.org)
- [NixOS](https://nixos.org)
- [Nobara](https://nobaraproject.org)
- [OpenBSD](https://openbsd.org)
- [openSUSE](https://opensuse.org)
- [Parabola GNU/Linux-libre](https://parabola.nu)
- [Parch GNU/Linux](https://parchlinux.com/en)
- [Parrot OS](https://parrotsec.org)
- [Pop!\_OS](https://pop.system76.com)
- [Proxmox](https://proxmox.com)
- [PureOS](https://pureos.net)
- [Qubes OS](https://qubes-os.org)
- [Rocky Linux](https://rockylinux.org)
- [Slackware Linux](http://slackware.com)
- [Solus](https://getsol.us)
- [Tails](https://tails.net)
- [Tiny Core](http://tinycorelinux.net)
- [Trisquel GNU/Linux](https://trisquel.info)
- [Ubuntu](https://ubuntu.com)
- [Void Linux](https://voidlinux.org)
- [Whonix](https://whonix.org)
- [Zorin OS](https://zorin.com/os)

## Repository Links

- [Codeberg](https://codeberg.org/bashuser30/dl-distro)
- [GitLab (read-only)](https://gitlab.com/bashuser30/dl-distro)
- [GitHub (read-only)](https://github.com/bashuser30/dl-distro)

## License

All files in this repository are licensed under the GNU General Public License version 3 or later - see the [LICENSE](LICENSE) file for details.
