import numpy
from numpy import array, nan, inf

version = '1.6.0'
cuda    = '7.0'
device  = 'Kepler K40c'
cpu     = '2x8 core Sandy Bridge E5-2670'

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/cgeev.txt
# numactl --interleave=all ./testing_cgeev -RN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgeev_RN = array([
	[    10,  nan,    0.0004 ],
	[    20,  nan,    0.0006 ],
	[    30,  nan,    0.0009 ],
	[    40,  nan,    0.0029 ],
	[    50,  nan,    0.0036 ],
	[    60,  nan,    0.0037 ],
	[    70,  nan,    0.0057 ],
	[    80,  nan,    0.0078 ],
	[    90,  nan,    0.0087 ],
	[   100,  nan,    0.0113 ],
	[   200,  nan,    0.0726 ],
	[   300,  nan,    0.0941 ],
	[   400,  nan,    0.1416 ],
	[   500,  nan,    0.1990 ],
	[   600,  nan,    0.3623 ],
	[   700,  nan,    0.4699 ],
	[   800,  nan,    0.5551 ],
	[   900,  nan,    0.7022 ],
	[  1000,  nan,    0.7844 ],
	[  2000,  nan,    2.4553 ],
	[  3000,  nan,    7.3229 ],
	[  4000,  nan,   11.6109 ],
	[  5000,  nan,   17.5744 ],
	[  6000,  nan,   31.7312 ],
	[  7000,  nan,   43.0479 ],
	[  8000,  nan,   56.3757 ],
	[  9000,  nan,   70.3988 ],
	[ 10000,  nan,   83.0759 ],
	[ 12000,  nan,  124.8967 ],
	[ 14000,  nan,  169.4146 ],
	[ 16000,  nan,  230.7517 ],
	[ 18000,  nan,  292.7448 ],
	[ 20000,  nan,  376.6332 ],
])

# numactl --interleave=all ./testing_cgeev -RV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgeev_RV = array([
	[    10,  nan,    0.0012 ],
	[    20,  nan,    0.0022 ],
	[    30,  nan,    0.0026 ],
	[    40,  nan,    0.0046 ],
	[    50,  nan,    0.0054 ],
	[    60,  nan,    0.0057 ],
	[    70,  nan,    0.0086 ],
	[    80,  nan,    0.0112 ],
	[    90,  nan,    0.0131 ],
	[   100,  nan,    0.0165 ],
	[   200,  nan,    0.0654 ],
	[   300,  nan,    0.1203 ],
	[   400,  nan,    0.1975 ],
	[   500,  nan,    0.2633 ],
	[   600,  nan,    0.4727 ],
	[   700,  nan,    0.5677 ],
	[   800,  nan,    0.7201 ],
	[   900,  nan,    0.9013 ],
	[  1000,  nan,    1.0094 ],
	[  2000,  nan,    3.6737 ],
	[  3000,  nan,   10.3041 ],
	[  4000,  nan,   18.0482 ],
	[  5000,  nan,   29.0504 ],
	[  6000,  nan,   46.3775 ],
	[  7000,  nan,   65.3780 ],
	[  8000,  nan,   94.4202 ],
	[  9000,  nan,  112.5593 ],
	[ 10000,  nan,  147.0741 ],
	[ 12000,  nan,  219.7016 ],
	[ 14000,  nan,  328.8260 ],
	[ 16000,  nan,  456.3178 ],
	[ 18000,  nan,  594.9366 ],
	[ 20000,  nan,  785.5734 ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/cgeqrf.txt
# numactl --interleave=all ./testing_cgeqrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgeqrf = array([
	[    10,     10,  nan,  nan,     0.11,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.60,   0.00,  nan ],
	[    30,     30,  nan,  nan,     1.48,   0.00,  nan ],
	[    40,     40,  nan,  nan,     2.56,   0.00,  nan ],
	[    50,     50,  nan,  nan,     3.45,   0.00,  nan ],
	[    60,     60,  nan,  nan,     4.57,   0.00,  nan ],
	[    70,     70,  nan,  nan,     1.65,   0.00,  nan ],
	[    80,     80,  nan,  nan,     2.46,   0.00,  nan ],
	[    90,     90,  nan,  nan,     3.21,   0.00,  nan ],
	[   100,    100,  nan,  nan,     4.29,   0.00,  nan ],
	[   200,    200,  nan,  nan,    15.56,   0.00,  nan ],
	[   300,    300,  nan,  nan,    33.84,   0.00,  nan ],
	[   400,    400,  nan,  nan,    54.11,   0.01,  nan ],
	[   500,    500,  nan,  nan,    78.57,   0.01,  nan ],
	[   600,    600,  nan,  nan,   122.03,   0.01,  nan ],
	[   700,    700,  nan,  nan,   146.82,   0.01,  nan ],
	[   800,    800,  nan,  nan,   184.33,   0.01,  nan ],
	[   900,    900,  nan,  nan,   211.19,   0.02,  nan ],
	[  1000,   1000,  nan,  nan,   245.28,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   636.57,   0.07,  nan ],
	[  3000,   3000,  nan,  nan,  1023.85,   0.14,  nan ],
	[  4000,   4000,  nan,  nan,  1380.78,   0.25,  nan ],
	[  5000,   5000,  nan,  nan,  1525.60,   0.44,  nan ],
	[  6000,   6000,  nan,  nan,  1796.98,   0.64,  nan ],
	[  7000,   7000,  nan,  nan,  1953.79,   0.94,  nan ],
	[  8000,   8000,  nan,  nan,  2092.46,   1.31,  nan ],
	[  9000,   9000,  nan,  nan,  2176.85,   1.79,  nan ],
	[ 10000,  10000,  nan,  nan,  2225.92,   2.40,  nan ],
	[ 12000,  12000,  nan,  nan,  2276.70,   4.05,  nan ],
	[ 14000,  14000,  nan,  nan,  2386.88,   6.13,  nan ],
	[ 16000,  16000,  nan,  nan,  2410.47,   9.06,  nan ],
	[ 18000,  18000,  nan,  nan,  2423.50,  12.84,  nan ],
	[ 20000,  20000,  nan,  nan,  2463.29,  17.32,  nan ],
])

# numactl --interleave=all ./testing_cgeqrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgeqrf_gpu = array([
	[    10,     10,  nan,  nan,     0.01,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.05,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.17,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.34,   0.00,  nan ],
	[    50,     50,  nan,  nan,     0.63,   0.00,  nan ],
	[    60,     60,  nan,  nan,     1.03,   0.00,  nan ],
	[    70,     70,  nan,  nan,     1.18,   0.00,  nan ],
	[    80,     80,  nan,  nan,     1.74,   0.00,  nan ],
	[    90,     90,  nan,  nan,     2.58,   0.00,  nan ],
	[   100,    100,  nan,  nan,     6.99,   0.00,  nan ],
	[   200,    200,  nan,  nan,    14.59,   0.00,  nan ],
	[   300,    300,  nan,  nan,    33.09,   0.00,  nan ],
	[   400,    400,  nan,  nan,    53.73,   0.01,  nan ],
	[   500,    500,  nan,  nan,    81.98,   0.01,  nan ],
	[   600,    600,  nan,  nan,   109.58,   0.01,  nan ],
	[   700,    700,  nan,  nan,   141.41,   0.01,  nan ],
	[   800,    800,  nan,  nan,   172.23,   0.02,  nan ],
	[   900,    900,  nan,  nan,   202.47,   0.02,  nan ],
	[  1000,   1000,  nan,  nan,   237.28,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   426.74,   0.10,  nan ],
	[  3000,   3000,  nan,  nan,   848.40,   0.17,  nan ],
	[  4000,   4000,  nan,  nan,  1218.24,   0.28,  nan ],
	[  5000,   5000,  nan,  nan,  1410.25,   0.47,  nan ],
	[  6000,   6000,  nan,  nan,  1683.70,   0.68,  nan ],
	[  7000,   7000,  nan,  nan,  1878.09,   0.97,  nan ],
	[  8000,   8000,  nan,  nan,  2008.94,   1.36,  nan ],
	[  9000,   9000,  nan,  nan,  2109.85,   1.84,  nan ],
	[ 10000,  10000,  nan,  nan,  2179.43,   2.45,  nan ],
	[ 12000,  12000,  nan,  nan,  2288.47,   4.03,  nan ],
	[ 14000,  14000,  nan,  nan,  2330.71,   6.28,  nan ],
	[ 16000,  16000,  nan,  nan,  2389.16,   9.14,  nan ],
	[ 18000,  18000,  nan,  nan,  2418.19,  12.86,  nan ],
	[ 20000,  20000,  nan,  nan,  2455.86,  17.38,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/cgetrf.txt
# numactl --interleave=all ./testing_cgetrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgetrf = array([
	[    10,     10,  nan,  nan,     0.24,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.60,  0.00,  nan ],
	[    30,     30,  nan,  nan,     1.49,  0.00,  nan ],
	[    40,     40,  nan,  nan,     2.56,  0.00,  nan ],
	[    50,     50,  nan,  nan,     3.41,  0.00,  nan ],
	[    60,     60,  nan,  nan,     4.30,  0.00,  nan ],
	[    70,     70,  nan,  nan,     1.03,  0.00,  nan ],
	[    80,     80,  nan,  nan,     1.51,  0.00,  nan ],
	[    90,     90,  nan,  nan,     2.02,  0.00,  nan ],
	[   100,    100,  nan,  nan,     2.62,  0.00,  nan ],
	[   200,    200,  nan,  nan,    11.24,  0.00,  nan ],
	[   300,    300,  nan,  nan,    25.38,  0.00,  nan ],
	[   400,    400,  nan,  nan,    41.74,  0.00,  nan ],
	[   500,    500,  nan,  nan,    61.73,  0.01,  nan ],
	[   600,    600,  nan,  nan,    82.20,  0.01,  nan ],
	[   700,    700,  nan,  nan,   104.94,  0.01,  nan ],
	[   800,    800,  nan,  nan,   128.90,  0.01,  nan ],
	[   900,    900,  nan,  nan,   152.75,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,   177.02,  0.02,  nan ],
	[  2000,   2000,  nan,  nan,   427.84,  0.05,  nan ],
	[  3000,   3000,  nan,  nan,   729.92,  0.10,  nan ],
	[  4000,   4000,  nan,  nan,  1058.53,  0.16,  nan ],
	[  5000,   5000,  nan,  nan,  1299.23,  0.26,  nan ],
	[  6000,   6000,  nan,  nan,  1544.91,  0.37,  nan ],
	[  7000,   7000,  nan,  nan,  1709.75,  0.53,  nan ],
	[  8000,   8000,  nan,  nan,  1862.17,  0.73,  nan ],
	[  9000,   9000,  nan,  nan,  1928.51,  1.01,  nan ],
	[ 10000,  10000,  nan,  nan,  2064.76,  1.29,  nan ],
	[ 12000,  12000,  nan,  nan,  2217.11,  2.08,  nan ],
	[ 14000,  14000,  nan,  nan,  2337.89,  3.13,  nan ],
	[ 16000,  16000,  nan,  nan,  2414.77,  4.52,  nan ],
	[ 18000,  18000,  nan,  nan,  2462.71,  6.31,  nan ],
	[ 20000,  20000,  nan,  nan,  2512.73,  8.49,  nan ],
])

# numactl --interleave=all ./testing_cgetrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.08,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.39,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.99,  0.00,  nan ],
	[    40,     40,  nan,  nan,     2.09,  0.00,  nan ],
	[    50,     50,  nan,  nan,     3.01,  0.00,  nan ],
	[    60,     60,  nan,  nan,     3.64,  0.00,  nan ],
	[    70,     70,  nan,  nan,     0.73,  0.00,  nan ],
	[    80,     80,  nan,  nan,     1.10,  0.00,  nan ],
	[    90,     90,  nan,  nan,     1.50,  0.00,  nan ],
	[   100,    100,  nan,  nan,     1.99,  0.00,  nan ],
	[   200,    200,  nan,  nan,     9.12,  0.00,  nan ],
	[   300,    300,  nan,  nan,    23.31,  0.00,  nan ],
	[   400,    400,  nan,  nan,    41.47,  0.00,  nan ],
	[   500,    500,  nan,  nan,    66.90,  0.00,  nan ],
	[   600,    600,  nan,  nan,    89.96,  0.01,  nan ],
	[   700,    700,  nan,  nan,   118.11,  0.01,  nan ],
	[   800,    800,  nan,  nan,   147.53,  0.01,  nan ],
	[   900,    900,  nan,  nan,   178.23,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,   226.13,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   589.04,  0.04,  nan ],
	[  3000,   3000,  nan,  nan,  1019.34,  0.07,  nan ],
	[  4000,   4000,  nan,  nan,  1322.84,  0.13,  nan ],
	[  5000,   5000,  nan,  nan,  1391.20,  0.24,  nan ],
	[  6000,   6000,  nan,  nan,  1751.29,  0.33,  nan ],
	[  7000,   7000,  nan,  nan,  1952.69,  0.47,  nan ],
	[  8000,   8000,  nan,  nan,  2114.16,  0.65,  nan ],
	[  9000,   9000,  nan,  nan,  2104.80,  0.92,  nan ],
	[ 10000,  10000,  nan,  nan,  2213.45,  1.20,  nan ],
	[ 12000,  12000,  nan,  nan,  2425.02,  1.90,  nan ],
	[ 14000,  14000,  nan,  nan,  2541.82,  2.88,  nan ],
	[ 16000,  16000,  nan,  nan,  2623.63,  4.16,  nan ],
	[ 18000,  18000,  nan,  nan,  2661.63,  5.84,  nan ],
	[ 20000,  20000,  nan,  nan,  2694.68,  7.92,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/cheevd.txt
# numactl --interleave=all ./testing_cheevd -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevd_JN = array([
	[    10,  nan,    0.0000 ],
	[    20,  nan,    0.0001 ],
	[    30,  nan,    0.0001 ],
	[    40,  nan,    0.0001 ],
	[    50,  nan,    0.0002 ],
	[    60,  nan,    0.0003 ],
	[    70,  nan,    0.0005 ],
	[    80,  nan,    0.0007 ],
	[    90,  nan,    0.0009 ],
	[   100,  nan,    0.0011 ],
	[   200,  nan,    0.0044 ],
	[   300,  nan,    0.0087 ],
	[   400,  nan,    0.0147 ],
	[   500,  nan,    0.0229 ],
	[   600,  nan,    0.0316 ],
	[   700,  nan,    0.0442 ],
	[   800,  nan,    0.0566 ],
	[   900,  nan,    0.0722 ],
	[  1000,  nan,    0.0904 ],
	[  2000,  nan,    0.4288 ],
	[  3000,  nan,    2.2439 ],
	[  4000,  nan,    4.7367 ],
	[  5000,  nan,    8.6498 ],
	[  6000,  nan,   14.5677 ],
	[  7000,  nan,   21.8536 ],
	[  8000,  nan,   31.6483 ],
	[  9000,  nan,   45.0053 ],
	[ 10000,  nan,   59.7391 ],
	[ 12000,  nan,  101.0408 ],
	[ 14000,  nan,  157.3369 ],
	[ 16000,  nan,  232.2880 ],
	[ 18000,  nan,  326.8029 ],
	[ 20000,  nan,  447.7241 ],
])

# numactl --interleave=all ./testing_cheevd -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevd_JV = array([
	[    10,  nan,    0.0001 ],
	[    20,  nan,    0.0002 ],
	[    30,  nan,    0.0002 ],
	[    40,  nan,    0.0004 ],
	[    50,  nan,    0.0005 ],
	[    60,  nan,    0.0007 ],
	[    70,  nan,    0.0009 ],
	[    80,  nan,    0.0012 ],
	[    90,  nan,    0.0015 ],
	[   100,  nan,    0.0018 ],
	[   200,  nan,    0.0087 ],
	[   300,  nan,    0.0139 ],
	[   400,  nan,    0.0226 ],
	[   500,  nan,    0.0333 ],
	[   600,  nan,    0.0425 ],
	[   700,  nan,    0.0571 ],
	[   800,  nan,    0.0728 ],
	[   900,  nan,    0.0933 ],
	[  1000,  nan,    0.1148 ],
	[  2000,  nan,    0.5110 ],
	[  3000,  nan,    2.3942 ],
	[  4000,  nan,    5.0314 ],
	[  5000,  nan,    9.1276 ],
	[  6000,  nan,   15.5466 ],
	[  7000,  nan,   23.2524 ],
	[  8000,  nan,   33.6680 ],
	[  9000,  nan,   47.5679 ],
	[ 10000,  nan,   62.8846 ],
	[ 12000,  nan,  106.4060 ],
	[ 14000,  nan,  165.7773 ],
	[ 16000,  nan,  244.5624 ],
	[ 18000,  nan,  345.0942 ],
	[ 20000,  nan,  472.0977 ],
])

# numactl --interleave=all ./testing_cheevd_gpu -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevd_gpu_JN = array([
	[    10,  nan,    0.0001 ],
	[    20,  nan,    0.0001 ],
	[    30,  nan,    0.0001 ],
	[    40,  nan,    0.0002 ],
	[    50,  nan,    0.0002 ],
	[    60,  nan,    0.0003 ],
	[    70,  nan,    0.0006 ],
	[    80,  nan,    0.0008 ],
	[    90,  nan,    0.0010 ],
	[   100,  nan,    0.0012 ],
	[   200,  nan,    0.0048 ],
	[   300,  nan,    0.0096 ],
	[   400,  nan,    0.0159 ],
	[   500,  nan,    0.0244 ],
	[   600,  nan,    0.0334 ],
	[   700,  nan,    0.0462 ],
	[   800,  nan,    0.0592 ],
	[   900,  nan,    0.0750 ],
	[  1000,  nan,    0.0992 ],
	[  2000,  nan,    0.4394 ],
	[  3000,  nan,    2.2151 ],
	[  4000,  nan,    4.7230 ],
	[  5000,  nan,    8.6151 ],
	[  6000,  nan,   14.1466 ],
	[  7000,  nan,   21.8019 ],
	[  8000,  nan,   31.5555 ],
	[  9000,  nan,   44.0570 ],
	[ 10000,  nan,   59.6667 ],
	[ 12000,  nan,  100.8712 ],
	[ 14000,  nan,  157.5311 ],
	[ 16000,  nan,  232.0096 ],
	[ 18000,  nan,  328.4225 ],
	[ 20000,  nan,  447.2557 ],
])

# numactl --interleave=all ./testing_cheevd_gpu -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevd_gpu_JV = array([
	[    10,  nan,    0.0002 ],
	[    20,  nan,    0.0002 ],
	[    30,  nan,    0.0003 ],
	[    40,  nan,    0.0005 ],
	[    50,  nan,    0.0006 ],
	[    60,  nan,    0.0007 ],
	[    70,  nan,    0.0011 ],
	[    80,  nan,    0.0013 ],
	[    90,  nan,    0.0016 ],
	[   100,  nan,    0.0019 ],
	[   200,  nan,    0.0085 ],
	[   300,  nan,    0.0155 ],
	[   400,  nan,    0.0235 ],
	[   500,  nan,    0.0340 ],
	[   600,  nan,    0.0441 ],
	[   700,  nan,    0.0582 ],
	[   800,  nan,    0.0750 ],
	[   900,  nan,    0.0991 ],
	[  1000,  nan,    0.1159 ],
	[  2000,  nan,    0.5046 ],
	[  3000,  nan,    2.3384 ],
	[  4000,  nan,    5.0226 ],
	[  5000,  nan,    9.0943 ],
	[  6000,  nan,   14.9902 ],
	[  7000,  nan,   22.9990 ],
	[  8000,  nan,   33.5338 ],
	[  9000,  nan,   46.7255 ],
	[ 10000,  nan,   63.2776 ],
	[ 12000,  nan,  106.8226 ],
	[ 14000,  nan,  166.9566 ],
	[ 16000,  nan,  246.0812 ],
	[ 18000,  nan,  348.8499 ],
	[ 20000,  nan,  476.2520 ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/cheevd_2stage.txt
# numactl --interleave=all ./testing_cheevdx_2stage -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevdx_2stage_JN = array([
	[    10,      0,   0.0001 ],
	[    20,      0,   0.0000 ],
	[    30,      0,   0.0000 ],
	[    40,      0,   0.0000 ],
	[    50,      0,   0.0000 ],
	[    60,      0,   0.0000 ],
	[    70,      0,   0.0000 ],
	[    80,      0,   0.0000 ],
	[    90,      0,   0.0000 ],
	[   100,      0,   0.0000 ],
	[   200,    200,   0.0052 ],
	[   300,    300,   0.0259 ],
	[   400,    400,   0.0487 ],
	[   500,    500,   0.0823 ],
	[   600,    600,   0.1104 ],
	[   700,    700,   0.1962 ],
	[   800,    800,   0.1615 ],
	[   900,    900,   0.1952 ],
	[  1000,   1000,   0.2281 ],
	[  2000,   2000,   0.7722 ],
	[  3000,   3000,   1.1484 ],
	[  4000,   4000,   1.6794 ],
	[  5000,   5000,   2.2711 ],
	[  6000,   6000,   2.9625 ],
	[  7000,   7000,   3.8104 ],
	[  8000,   8000,   4.7135 ],
	[  9000,   9000,   6.0213 ],
	[ 10000,  10000,   7.4816 ],
	[ 12000,  12000,  10.4194 ],
	[ 14000,  14000,  14.8428 ],
	[ 16000,  16000,  19.6603 ],
	[ 18000,  18000,  25.6901 ],
	[ 20000,  20000,  33.2309 ],
])

# numactl --interleave=all ./testing_cheevdx_2stage -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevdx_2stage_JV = array([
	[    10,     10,    0.0002 ],
	[    20,     20,    0.0002 ],
	[    30,     30,    0.0003 ],
	[    40,     40,    0.0004 ],
	[    50,     50,    0.0006 ],
	[    60,     60,    0.0008 ],
	[    70,     70,    0.0011 ],
	[    80,     80,    0.0013 ],
	[    90,     90,    0.0017 ],
	[   100,    100,    0.0020 ],
	[   200,    200,    0.0092 ],
	[   300,    300,    0.0370 ],
	[   400,    400,    0.0653 ],
	[   500,    500,    0.0973 ],
	[   600,    600,    0.1293 ],
	[   700,    700,    0.1689 ],
	[   800,    800,    0.2032 ],
	[   900,    900,    0.2553 ],
	[  1000,   1000,    0.2971 ],
	[  2000,   2000,    0.7651 ],
	[  3000,   3000,    1.6033 ],
	[  4000,   4000,    2.4661 ],
	[  5000,   5000,    3.9819 ],
	[  6000,   6000,    5.2710 ],
	[  7000,   7000,    7.1507 ],
	[  8000,   8000,   10.9312 ],
	[  9000,   9000,   13.3433 ],
	[ 10000,  10000,   18.6679 ],
	[ 12000,  12000,   31.9737 ],
	[ 14000,  14000,   39.5782 ],
	[ 16000,  16000,   66.8599 ],
	[ 18000,  18000,   83.8218 ],
	[ 20000,  20000,  129.1439 ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/chemv.txt
# numactl --interleave=all ./testing_chemv -N 100 -N 1000 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
chemv_L = array([
	[    10,    0.0297,   0.0310,    0.0354,   0.0260,   0.0398,   0.0231,   0.4288,    0.0021,  1.43e-07,  1.92e-07,  1.43e-07,  nan ],
	[    11,    0.0355,   0.0310,    0.0439,   0.0250,   0.0496,   0.0222,   0.5767,    0.0019,  2.45e-07,  3.13e-07,  2.45e-07,  nan ],
	[    12,    0.0431,   0.0300,    0.0518,   0.0250,   0.0618,   0.0210,   0.6795,    0.0019,  2.87e-07,  1.59e-07,  2.51e-07,  nan ],
	[    13,    0.0487,   0.0310,    0.0580,   0.0260,   0.0680,   0.0222,   0.7906,    0.0019,  1.73e-07,  1.64e-07,  1.47e-07,  nan ],
	[    14,    0.0583,   0.0298,    0.0700,   0.0248,   0.0827,   0.0210,   0.8090,    0.0021,  1.52e-07,  1.52e-07,  2.04e-07,  nan ],
	[    15,    0.0639,   0.0310,    0.0735,   0.0269,   0.0865,   0.0229,   1.0381,    0.0019,  2.17e-07,  1.91e-07,  2.29e-07,  nan ],
	[    16,    0.0723,   0.0310,    0.0862,   0.0260,   0.0969,   0.0231,   1.1744,    0.0019,  1.69e-07,  2.46e-07,  1.69e-07,  nan ],
	[    17,    0.0812,   0.0310,    0.0968,   0.0260,   0.1005,   0.0250,   0.8794,    0.0029,  1.16e-07,  1.68e-07,  1.25e-07,  nan ],
	[    18,    0.0906,   0.0310,    0.1042,   0.0269,   0.1178,   0.0238,   0.9060,    0.0031,  2.18e-07,  3.35e-07,  2.12e-07,  nan ],
	[    19,    0.0975,   0.0319,    0.1157,   0.0269,   0.1245,   0.0250,   1.4522,    0.0021,  2.07e-07,  2.07e-07,  2.01e-07,  nan ],
	[    20,    0.1110,   0.0310,    0.1038,   0.0331,   0.1374,   0.0250,   1.8036,    0.0019,  1.91e-07,  1.91e-07,  2.13e-07,  nan ],
	[    21,    0.1220,   0.0310,    0.1355,   0.0279,   0.1524,   0.0248,   1.3212,    0.0029,  3.27e-07,  2.72e-07,  2.03e-07,  nan ],
	[    22,    0.1334,   0.0310,    0.1483,   0.0279,   0.1652,   0.0250,   1.9275,    0.0021,  2.74e-07,  2.60e-07,  1.94e-07,  nan ],
	[    23,    0.1454,   0.0310,    0.1602,   0.0281,   0.1801,   0.0250,   2.3635,    0.0019,  1.96e-07,  2.07e-07,  2.23e-07,  nan ],
	[    24,    0.1580,   0.0310,    0.1740,   0.0281,   0.1956,   0.0250,   2.5669,    0.0019,  2.51e-07,  2.51e-07,  2.51e-07,  nan ],
	[    25,    0.1710,   0.0310,    0.1950,   0.0272,   0.2117,   0.0250,   1.8525,    0.0029,  2.41e-07,  2.56e-07,  1.71e-07,  nan ],
	[    26,    0.1845,   0.0310,    0.2051,   0.0279,   0.2201,   0.0260,   1.8455,    0.0031,  2.20e-07,  1.64e-07,  2.20e-07,  nan ],
	[    27,    0.1927,   0.0319,    0.2207,   0.0279,   0.2459,   0.0250,   2.1517,    0.0029,  1.58e-07,  1.58e-07,  1.58e-07,  nan ],
	[    28,    0.2116,   0.0312,    0.2369,   0.0279,   0.2640,   0.0250,   2.1320,    0.0031,  3.41e-07,  2.81e-07,  3.41e-07,  nan ],
	[    29,    0.2215,   0.0319,    0.2537,   0.0279,   0.2723,   0.0260,   2.2830,    0.0031,  2.10e-07,  1.47e-07,  2.25e-07,  nan ],
	[    30,    0.2421,   0.0312,    0.2599,   0.0291,   0.3020,   0.0250,   2.4391,    0.0031,  3.18e-07,  2.01e-07,  1.59e-07,  nan ],
	[    31,    0.2600,   0.0310,    0.2889,   0.0279,   0.3220,   0.0250,   1.9886,    0.0041,  1.74e-07,  2.48e-07,  2.63e-07,  nan ],
	[    32,    0.2767,   0.0310,    0.3074,   0.0279,   0.3426,   0.0250,   2.7670,    0.0031,  1.88e-07,  1.69e-07,  2.67e-07,  nan ],
	[    33,    0.2851,   0.0319,    0.2530,   0.0360,   0.3381,   0.0269,   2.2472,    0.0041,  2.38e-07,  1.73e-07,  2.31e-07,  nan ],
	[    34,    0.3214,   0.0300,    0.3000,   0.0322,   0.3894,   0.0248,   2.3824,    0.0041,  2.65e-07,  1.91e-07,  2.80e-07,  nan ],
	[    35,    0.3019,   0.0339,    0.3199,   0.0319,   0.3933,   0.0260,   3.5721,    0.0029,  1.96e-07,  2.18e-07,  1.74e-07,  nan ],
	[    36,    0.3484,   0.0310,    0.3380,   0.0319,   0.4156,   0.0260,   5.0332,    0.0021,  2.28e-07,  1.91e-07,  3.22e-07,  nan ],
	[    37,    0.3824,   0.0298,    0.3567,   0.0319,   0.4385,   0.0260,   3.9832,    0.0029,  2.58e-07,  3.10e-07,  2.43e-07,  nan ],
	[    38,    0.3874,   0.0310,    0.3759,   0.0319,   0.4797,   0.0250,   3.8742,    0.0031,  3.05e-07,  3.02e-07,  1.81e-07,  nan ],
	[    39,    0.4240,   0.0298,    0.3841,   0.0329,   0.4862,   0.0260,   2.5238,    0.0050,  2.19e-07,  2.94e-07,  3.28e-07,  nan ],
	[    40,    0.4285,   0.0310,    0.4157,   0.0319,   0.5110,   0.0260,   3.2765,    0.0041,  2.90e-07,  2.86e-07,  3.02e-07,  nan ],
	[    41,    0.4640,   0.0300,    0.4331,   0.0322,   0.5568,   0.0250,   3.4393,    0.0041,  2.08e-07,  1.95e-07,  2.08e-07,  nan ],
	[    42,    0.4865,   0.0300,    0.4541,   0.0322,   0.5624,   0.0260,   3.6061,    0.0041,  2.95e-07,  2.76e-07,  3.05e-07,  nan ],
	[    43,    0.4939,   0.0310,    0.4619,   0.0331,   0.5890,   0.0260,   3.0574,    0.0050,  3.20e-07,  3.76e-07,  3.20e-07,  nan ],
	[    44,    0.5331,   0.0300,    0.5013,   0.0319,   0.6459,   0.0248,   3.9515,    0.0041,  2.91e-07,  3.13e-07,  2.74e-07,  nan ],
	[    45,    0.5240,   0.0319,    0.5088,   0.0329,   0.6383,   0.0262,   3.3435,    0.0050,  2.68e-07,  2.40e-07,  2.68e-07,  nan ],
	[    46,    0.5640,   0.0310,    0.5275,   0.0331,   0.6726,   0.0260,   3.4913,    0.0050,  2.78e-07,  3.42e-07,  2.99e-07,  nan ],
	[    47,    0.5708,   0.0319,    0.5349,   0.0341,   0.7017,   0.0260,   3.6423,    0.0050,  2.03e-07,  2.47e-07,  1.81e-07,  nan ],
	[    48,    0.5950,   0.0319,    0.5736,   0.0331,   0.6756,   0.0281,   3.7964,    0.0050,  2.46e-07,  3.28e-07,  2.42e-07,  nan ],
	[    49,    0.6196,   0.0319,    0.5806,   0.0341,   0.6806,   0.0291,   3.3212,    0.0060,  3.11e-07,  3.97e-07,  3.21e-07,  nan ],
	[    50,    0.6448,   0.0319,    0.6042,   0.0341,   0.7082,   0.0291,   4.1144,    0.0050,  3.15e-07,  3.41e-07,  3.41e-07,  nan ],
	[    51,    0.6705,   0.0319,    0.6112,   0.0350,   0.7614,   0.0281,   3.5937,    0.0060,  2.70e-07,  3.35e-07,  2.70e-07,  nan ],
	[    52,    0.6915,   0.0322,    0.6350,   0.0350,   0.7652,   0.0291,   4.4452,    0.0050,  3.67e-07,  3.02e-07,  3.02e-07,  nan ],
	[    53,    0.7179,   0.0322,    0.6778,   0.0341,   0.8284,   0.0279,   4.6153,    0.0050,  2.52e-07,  2.88e-07,  2.16e-07,  nan ],
	[    54,    0.7449,   0.0322,    0.7032,   0.0341,   0.8243,   0.0291,   4.0225,    0.0060,  3.00e-07,  2.23e-07,  2.23e-07,  nan ],
	[    55,    0.7781,   0.0319,    0.7142,   0.0348,   0.8836,   0.0281,   4.1708,    0.0060,  3.10e-07,  2.22e-07,  2.19e-07,  nan ],
	[    56,    0.7829,   0.0329,    0.7609,   0.0339,   0.8575,   0.0300,   4.3218,    0.0060,  2.46e-07,  2.72e-07,  2.15e-07,  nan ],
	[    57,    0.8108,   0.0329,    0.7611,   0.0350,   0.9563,   0.0279,   4.4755,    0.0060,  3.35e-07,  2.99e-07,  2.99e-07,  nan ],
	[    58,    0.8642,   0.0319,    0.7931,   0.0348,   0.9492,   0.0291,   3.9930,    0.0069,  2.79e-07,  4.00e-07,  3.54e-07,  nan ],
	[    59,    0.8679,   0.0329,    0.8204,   0.0348,   1.0237,   0.0279,   4.1301,    0.0069,  3.23e-07,  2.74e-07,  2.74e-07,  nan ],
	[    60,    0.9172,   0.0322,    0.8200,   0.0360,   1.0149,   0.0291,   4.7621,    0.0062,  2.62e-07,  2.62e-07,  2.01e-07,  nan ],
	[    61,    0.9547,   0.0319,    0.8472,   0.0360,   1.0486,   0.0291,   5.1171,    0.0060,  3.54e-07,  3.13e-07,  3.96e-07,  nan ],
	[    62,    0.9858,   0.0319,    0.8987,   0.0350,   1.0828,   0.0291,   3.8854,    0.0081,  3.08e-07,  2.54e-07,  2.54e-07,  nan ],
	[    63,    0.9880,   0.0329,    0.9030,   0.0360,   1.1176,   0.0291,   4.7017,    0.0069,  2.57e-07,  2.18e-07,  2.44e-07,  nan ],
	[    64,    1.0820,   0.0310,    0.9569,   0.0350,   1.1530,   0.0291,   5.6264,    0.0060,  3.63e-07,  3.63e-07,  3.58e-07,  nan ],
	[    65,    0.9065,   0.0381,    0.9122,   0.0379,   1.1157,   0.0310,   4.8346,    0.0072,  3.63e-07,  3.71e-07,  2.62e-07,  nan ],
	[    66,    0.9402,   0.0379,    0.9900,   0.0360,   1.1499,   0.0310,   4.5298,    0.0079,  2.89e-07,  3.57e-07,  3.52e-07,  nan ],
	[    67,    0.9685,   0.0379,    1.0199,   0.0360,   1.1846,   0.0310,   5.9230,    0.0062,  2.85e-07,  3.46e-07,  3.60e-07,  nan ],
	[    68,    0.9911,   0.0381,    1.0502,   0.0360,   1.1834,   0.0319,   4.6641,    0.0081,  4.05e-07,  2.80e-07,  3.37e-07,  nan ],
	[    69,    0.9068,   0.0429,    1.0810,   0.0360,   1.2556,   0.0310,   4.8008,    0.0081,  3.50e-07,  2.47e-07,  3.36e-07,  nan ],
	[    70,    1.1122,   0.0360,    1.1503,   0.0348,   1.2918,   0.0310,   5.0891,    0.0079,  3.93e-07,  2.72e-07,  2.72e-07,  nan ],
	[    71,    1.1143,   0.0370,    1.1830,   0.0348,   1.3708,   0.0300,   6.9089,    0.0060,  5.40e-07,  5.37e-07,  4.33e-07,  nan ],
	[    72,    1.1456,   0.0370,    1.2080,   0.0350,   1.3251,   0.0319,   7.1028,    0.0060,  2.69e-07,  3.33e-07,  2.65e-07,  nan ],
	[    73,    1.1698,   0.0372,    1.2085,   0.0360,   1.4037,   0.0310,   5.5299,    0.0079,  3.51e-07,  4.31e-07,  3.30e-07,  nan ],
	[    74,    1.2095,   0.0370,    1.2415,   0.0360,   1.4997,   0.0298,   5.5138,    0.0081,  2.58e-07,  3.26e-07,  3.14e-07,  nan ],
	[    75,    1.2421,   0.0370,    1.3097,   0.0350,   1.4809,   0.0310,   5.0663,    0.0091,  4.44e-07,  3.31e-07,  3.22e-07,  nan ],
	[    76,    1.2352,   0.0381,    1.3088,   0.0360,   1.4749,   0.0319,   5.2009,    0.0091,  3.62e-07,  3.17e-07,  3.05e-07,  nan ],
	[    77,    1.2443,   0.0389,    1.3432,   0.0360,   1.5136,   0.0319,   3.6876,    0.0131,  2.22e-07,  2.48e-07,  3.13e-07,  nan ],
	[    78,    1.3086,   0.0379,    1.3780,   0.0360,   1.6005,   0.0310,   7.1749,    0.0069,  3.28e-07,  3.94e-07,  3.28e-07,  nan ],
	[    79,    1.3012,   0.0391,    1.3767,   0.0370,   1.6415,   0.0310,   5.6155,    0.0091,  3.98e-07,  4.85e-07,  3.89e-07,  nan ],
	[    80,    1.3422,   0.0389,    1.4488,   0.0360,   1.6829,   0.0310,   5.9128,    0.0088,  2.95e-07,  2.95e-07,  2.86e-07,  nan ],
	[    81,    1.3672,   0.0391,    1.2740,   0.0420,   1.5680,   0.0341,   5.3387,    0.0100,  4.21e-07,  2.98e-07,  4.02e-07,  nan ],
	[    82,    1.4009,   0.0391,    1.4822,   0.0370,   1.6648,   0.0329,   6.0460,    0.0091,  3.75e-07,  3.63e-07,  2.98e-07,  nan ],
	[    83,    1.4350,   0.0391,    1.5183,   0.0370,   1.6573,   0.0339,   6.9216,    0.0081,  4.34e-07,  3.79e-07,  3.79e-07,  nan ],
	[    84,    1.5156,   0.0379,    1.5548,   0.0370,   1.6971,   0.0339,   8.3099,    0.0069,  4.06e-07,  3.27e-07,  3.27e-07,  nan ],
	[    85,    1.5516,   0.0379,    1.5917,   0.0370,   1.7252,   0.0341,   5.3632,    0.0110,  3.83e-07,  3.70e-07,  4.51e-07,  nan ],
	[    86,    1.5396,   0.0391,    1.5781,   0.0381,   1.7781,   0.0339,   8.4166,    0.0072,  4.78e-07,  2.81e-07,  3.58e-07,  nan ],
	[    87,    1.6147,   0.0381,    1.6668,   0.0370,   1.8067,   0.0341,   5.6164,    0.0110,  2.67e-07,  2.77e-07,  2.36e-07,  nan ],
	[    88,    1.6114,   0.0391,    1.6941,   0.0372,   1.8481,   0.0341,   7.7728,    0.0081,  3.70e-07,  3.13e-07,  3.47e-07,  nan ],
	[    89,    1.7436,   0.0370,    1.7898,   0.0360,   2.0169,   0.0319,   8.1898,    0.0079,  3.66e-07,  4.37e-07,  3.53e-07,  nan ],
	[    90,    1.7713,   0.0372,    1.6952,   0.0389,   2.0621,   0.0319,   7.2716,    0.0091,  2.71e-07,  3.40e-07,  2.71e-07,  nan ],
	[   100,    2.0272,   0.0401,    2.1973,   0.0370,   2.3327,   0.0348,  10.3205,    0.0079,  4.83e-07,  3.15e-07,  3.81e-07,  nan ],
	[   110,    2.3927,   0.0410,    2.5883,   0.0379,   2.7996,   0.0350,   5.7964,    0.0169,  4.65e-07,  4.86e-07,  4.39e-07,  nan ],
	[   120,    2.9120,   0.0401,    2.9831,   0.0391,   3.0014,   0.0389,  10.6353,    0.0110,  4.02e-07,  5.13e-07,  2.84e-07,  nan ],
	[   130,    3.0350,   0.0451,    3.5191,   0.0389,   3.4144,   0.0401,  10.6225,    0.0129,  3.76e-07,  3.71e-07,  3.52e-07,  nan ],
	[   140,    3.4441,   0.0460,    3.9566,   0.0401,   3.9803,   0.0398,   9.9211,    0.0160,  3.97e-07,  4.49e-07,  3.31e-07,  nan ],
	[   150,    3.9509,   0.0460,    4.4333,   0.0410,   4.3325,   0.0420,  12.9241,    0.0141,  5.48e-07,  4.55e-07,  4.55e-07,  nan ],
	[   160,    4.4925,   0.0460,    5.1610,   0.0401,   4.8986,   0.0422,  10.9753,    0.0188,  6.11e-07,  5.16e-07,  5.56e-07,  nan ],
	[   170,    4.9408,   0.0472,    5.5584,   0.0420,   5.2880,   0.0441,  11.6462,    0.0200,  4.12e-07,  3.70e-07,  4.69e-07,  nan ],
	[   180,    5.5365,   0.0472,    6.2285,   0.0420,   5.8001,   0.0451,  12.4571,    0.0210,  5.24e-07,  6.90e-07,  5.16e-07,  nan ],
	[   190,    6.3258,   0.0460,    6.7827,   0.0429,   6.3258,   0.0460,  15.2610,    0.0191,  5.62e-07,  6.47e-07,  4.89e-07,  nan ],
	[   200,    6.0912,   0.0529,    7.3492,   0.0439,   6.6943,   0.0482,  13.5224,    0.0238,  6.56e-07,  5.50e-07,  4.72e-07,  nan ],
	[   210,    6.7132,   0.0529,    8.0996,   0.0439,   7.0968,   0.0501,  16.1991,    0.0219,  5.82e-07,  5.40e-07,  5.14e-07,  nan ],
	[   220,    7.2350,   0.0539,    8.8384,   0.0441,   7.8235,   0.0498,  16.1892,    0.0241,  4.86e-07,  4.87e-07,  4.97e-07,  nan ],
	[   230,    7.9053,   0.0539,    9.4529,   0.0451,   8.1954,   0.0520,  17.0153,    0.0250,  6.63e-07,  6.63e-07,  5.97e-07,  nan ],
	[   240,    8.7604,   0.0529,   10.5696,   0.0439,   8.9212,   0.0520,  14.5135,    0.0319,  6.39e-07,  7.63e-07,  7.66e-07,  nan ],
	[   250,    9.5033,   0.0529,   10.7093,   0.0470,   9.2940,   0.0541,  17.2929,    0.0291,  8.54e-07,  7.43e-07,  7.35e-07,  nan ],
	[   260,    9.0891,   0.0598,   11.5805,   0.0470,   9.5057,   0.0572,  15.9536,    0.0341,  7.42e-07,  7.26e-07,  7.87e-07,  nan ],
	[   270,    9.7607,   0.0601,   12.4228,   0.0472,  10.1223,   0.0579,  17.3219,    0.0339,  9.11e-07,  7.93e-07,  7.93e-07,  nan ],
	[   280,   10.4951,   0.0601,   13.4252,   0.0470,  10.7075,   0.0589,  17.0630,    0.0370,  5.87e-07,  7.63e-07,  6.54e-07,  nan ],
	[   290,   11.3009,   0.0598,   13.7695,   0.0491,  11.0802,   0.0610,  17.7283,    0.0381,  7.66e-07,  9.53e-07,  9.56e-07,  nan ],
	[   300,   11.8555,   0.0610,   14.7330,   0.0491,  11.6731,   0.0620,  17.6453,    0.0410,  1.12e-06,  1.22e-06,  1.22e-06,  nan ],
	[   310,   12.7066,   0.0608,   15.4294,   0.0501,  12.0453,   0.0641,  18.8383,    0.0410,  7.45e-07,  7.94e-07,  7.94e-07,  nan ],
	[   320,   13.9760,   0.0589,   17.1745,   0.0479,  13.2772,   0.0620,  18.2650,    0.0451,  6.74e-07,  6.88e-07,  7.69e-07,  nan ],
	[   330,   13.2996,   0.0658,   17.2333,   0.0508,  13.2996,   0.0658,  17.4795,    0.0501,  6.87e-07,  7.63e-07,  8.34e-07,  nan ],
	[   340,   14.1160,   0.0658,   17.7900,   0.0522,  13.8648,   0.0670,  18.5524,    0.0501,  7.18e-07,  8.38e-07,  8.38e-07,  nan ],
	[   350,   14.9026,   0.0660,   19.2899,   0.0510,  14.9026,   0.0660,  17.8703,    0.0551,  6.99e-07,  6.06e-07,  6.10e-07,  nan ],
	[   360,   15.5401,   0.0670,   19.6702,   0.0529,  15.0578,   0.0691,  18.5820,    0.0560,  8.23e-07,  9.56e-07,  8.04e-07,  nan ],
	[   370,   16.4136,   0.0670,   20.6826,   0.0532,  15.4773,   0.0710,  18.0872,    0.0608,  7.78e-07,  7.47e-07,  7.00e-07,  nan ],
	[   380,   17.0083,   0.0682,   21.1495,   0.0548,  16.3234,   0.0710,  19.6145,    0.0591,  8.03e-07,  7.40e-07,  7.27e-07,  nan ],
	[   390,   16.5266,   0.0739,   22.1786,   0.0551,  16.4735,   0.0741,  18.7665,    0.0651,  8.64e-07,  7.83e-07,  7.83e-07,  nan ],
	[   400,   17.6106,   0.0730,   24.2741,   0.0529,  17.6106,   0.0730,  19.8119,    0.0648,  7.97e-07,  8.53e-07,  7.24e-07,  nan ],
	[   410,   17.9719,   0.0751,   24.0899,   0.0560,  17.5812,   0.0768,  18.2617,    0.0739,  1.04e-06,  1.13e-06,  9.70e-07,  nan ],
	[   420,   18.9176,   0.0749,   23.9522,   0.0591,  18.1656,   0.0780,  19.9334,    0.0710,  9.47e-07,  1.02e-06,  9.47e-07,  nan ],
	[   430,   19.7646,   0.0751,   25.2059,   0.0589,  18.8092,   0.0789,  19.8276,    0.0749,  7.11e-07,  9.40e-07,  8.01e-07,  nan ],
	[   440,   20.7589,   0.0749,   26.7143,   0.0582,  19.1714,   0.0811,  20.1804,    0.0770,  1.18e-06,  1.25e-06,  1.04e-06,  nan ],
	[   450,   20.1104,   0.0808,   26.6306,   0.0610,  19.5903,   0.0830,  19.8181,    0.0820,  9.71e-07,  9.59e-07,  9.71e-07,  nan ],
	[   460,   21.0126,   0.0808,   28.2669,   0.0601,  20.7072,   0.0820,  20.9508,    0.0811,  1.08e-06,  1.07e-06,  1.08e-06,  nan ],
	[   470,   21.6158,   0.0820,   29.0462,   0.0610,  20.5979,   0.0861,  20.0968,    0.0882,  7.82e-07,  7.66e-07,  7.93e-07,  nan ],
	[   480,   22.5439,   0.0820,   29.8273,   0.0620,  21.0165,   0.0880,  20.3013,    0.0911,  9.45e-07,  1.03e-06,  9.26e-07,  nan ],
	[   490,   22.8926,   0.0842,   27.9622,   0.0689,  21.6651,   0.0889,  21.2102,    0.0908,  8.72e-07,  7.80e-07,  9.07e-07,  nan ],
	[   500,   24.1775,   0.0830,   31.2780,   0.0641,  22.0256,   0.0911,  20.8779,    0.0961,  1.01e-06,  9.94e-07,  8.89e-07,  nan ],
	[   510,   25.4453,   0.0820,   33.1560,   0.0629,  23.4042,   0.0892,  20.8906,    0.0999,  9.95e-07,  7.78e-07,  1.02e-06,  nan ],
	[   520,   24.3949,   0.0889,   33.4533,   0.0648,  23.3315,   0.0930,  21.4606,    0.1011,  9.68e-07,  1.06e-06,  9.75e-07,  nan ],
	[   530,   25.3408,   0.0889,   34.1232,   0.0660,  23.6895,   0.0951,  20.4591,    0.1101,  1.16e-06,  1.16e-06,  1.05e-06,  nan ],
	[   540,   26.5898,   0.0880,   35.9401,   0.0651,  24.6524,   0.0949,  21.2834,    0.1099,  1.14e-06,  1.06e-06,  1.15e-06,  nan ],
	[   550,   26.0304,   0.0932,   34.6187,   0.0701,  23.7801,   0.1020,  21.0723,    0.1152,  7.85e-07,  8.08e-07,  8.25e-07,  nan ],
	[   560,   26.2459,   0.0958,   36.0097,   0.0699,  22.8373,   0.1101,  21.3149,    0.1180,  1.10e-06,  1.10e-06,  1.16e-06,  nan ],
	[   570,   27.6722,   0.0942,   25.7795,   0.1011,  24.8421,   0.1049,  20.9799,    0.1242,  1.62e-06,  1.73e-06,  1.73e-06,  nan ],
	[   580,   26.7539,   0.1009,   37.9762,   0.0710,  24.9821,   0.1080,  21.3930,    0.1261,  9.66e-07,  1.15e-06,  9.41e-07,  nan ],
	[   590,   27.1065,   0.1030,   38.7748,   0.0720,  26.0802,   0.1070,  21.1754,    0.1318,  1.14e-06,  1.26e-06,  1.16e-06,  nan ],
	[   600,   28.5608,   0.1011,   40.0987,   0.0720,  26.4985,   0.1090,  21.5477,    0.1340,  9.50e-07,  1.16e-06,  9.65e-07,  nan ],
	[   610,   28.7071,   0.1040,   40.2454,   0.0741,  26.4057,   0.1130,  21.0358,    0.1419,  1.39e-06,  1.30e-06,  1.44e-06,  nan ],
	[   620,   29.6549,   0.1040,   41.5740,   0.0741,  27.9860,   0.1101,  21.6938,    0.1421,  1.15e-06,  1.15e-06,  1.15e-06,  nan ],
	[   630,   29.9988,   0.1061,   42.5142,   0.0749,  27.4116,   0.1161,  21.0559,    0.1512,  1.46e-06,  1.17e-06,  1.16e-06,  nan ],
	[   640,   31.3093,   0.1049,   44.2962,   0.0741,  28.5811,   0.1149,  21.4581,    0.1531,  1.25e-06,  1.34e-06,  1.24e-06,  nan ],
	[   650,   29.9778,   0.1130,   43.4540,   0.0780,  27.3259,   0.1240,  21.1765,    0.1600,  1.22e-06,  1.05e-06,  9.58e-07,  nan ],
	[   660,   30.9062,   0.1130,   44.7998,   0.0780,  27.4850,   0.1271,  21.7030,    0.1609,  1.58e-06,  1.55e-06,  1.46e-06,  nan ],
	[   670,   31.3201,   0.1149,   44.4009,   0.0811,  28.3233,   0.1271,  20.9380,    0.1719,  1.28e-06,  1.28e-06,  1.19e-06,  nan ],
	[   680,   32.4630,   0.1142,   46.8367,   0.0792,  30.6098,   0.1211,  21.6873,    0.1709,  1.35e-06,  1.17e-06,  1.35e-06,  nan ],
	[   690,   32.3434,   0.1180,   46.0057,   0.0830,  28.7433,   0.1328,  21.3182,    0.1791,  1.29e-06,  1.27e-06,  1.19e-06,  nan ],
	[   700,   33.0198,   0.1190,   47.3474,   0.0830,  29.5285,   0.1330,  21.1242,    0.1860,  1.57e-06,  1.13e-06,  1.19e-06,  nan ],
	[   710,   33.1065,   0.1221,   48.7084,   0.0830,  29.9479,   0.1349,  21.4836,    0.1881,  1.23e-06,  1.32e-06,  1.16e-06,  nan ],
	[   720,   33.5209,   0.1240,   49.5195,   0.0839,  30.1051,   0.1380,  21.0010,    0.1979,  1.50e-06,  1.45e-06,  1.38e-06,  nan ],
	[   730,   33.9354,   0.1259,   50.1902,   0.0851,  30.1141,   0.1419,  20.8348,    0.2050,  1.06e-06,  1.34e-06,  1.09e-06,  nan ],
	[   740,   35.4070,   0.1240,   50.5815,   0.0868,  31.1534,   0.1409,  22.1560,    0.1981,  1.16e-06,  1.33e-06,  1.32e-06,  nan ],
	[   750,   35.4824,   0.1271,   52.3881,   0.0861,  32.2183,   0.1400,  21.8890,    0.2060,  1.35e-06,  1.17e-06,  1.17e-06,  nan ],
	[   760,   36.1626,   0.1280,   53.7931,   0.0861,  32.6375,   0.1419,  21.9427,    0.2110,  1.39e-06,  1.37e-06,  1.36e-06,  nan ],
	[   770,   36.3082,   0.1309,   54.0195,   0.0880,  32.0985,   0.1481,  20.9382,    0.2270,  1.42e-06,  1.22e-06,  1.33e-06,  nan ],
	[   780,   37.2564,   0.1309,   54.8359,   0.0889,  33.1504,   0.1471,  21.2838,    0.2291,  1.66e-06,  1.61e-06,  1.61e-06,  nan ],
	[   790,   38.4974,   0.1299,   56.8593,   0.0880,  35.5010,   0.1409,  21.9238,    0.2282,  1.35e-06,  1.26e-06,  1.56e-06,  nan ],
	[   800,   39.4049,   0.1302,   59.1074,   0.0868,  35.3286,   0.1452,  21.5582,    0.2379,  1.18e-06,  1.22e-06,  1.15e-06,  nan ],
	[   810,   39.1755,   0.1342,   58.5035,   0.0899,  33.4686,   0.1571,  21.0256,    0.2501,  1.58e-06,  1.43e-06,  1.30e-06,  nan ],
	[   820,   39.8647,   0.1352,   56.7921,   0.0949,  34.5088,   0.1562,  21.1443,    0.2549,  1.42e-06,  1.34e-06,  1.27e-06,  nan ],
	[   830,   40.5559,   0.1361,   59.3780,   0.0930,  35.3548,   0.1562,  21.6425,    0.2551,  1.18e-06,  1.11e-06,  1.09e-06,  nan ],
	[   840,   39.5305,   0.1431,   60.1987,   0.0939,  35.6130,   0.1588,  21.8400,    0.2589,  1.37e-06,  1.31e-06,  1.24e-06,  nan ],
	[   850,   40.7481,   0.1421,   61.0197,   0.0949,  35.7671,   0.1619,  21.1365,    0.2739,  1.59e-06,  1.52e-06,  1.59e-06,  nan ],
	[   860,   41.1592,   0.1440,   61.8412,   0.0958,  36.7754,   0.1612,  20.2279,    0.2930,  1.14e-06,  1.14e-06,  1.07e-06,  nan ],
	[   870,   42.4019,   0.1431,   63.1294,   0.0961,  37.1946,   0.1631,  21.6520,    0.2801,  1.39e-06,  1.38e-06,  1.39e-06,  nan ],
	[   880,   43.4538,   0.1428,   65.3991,   0.0949,  39.2592,   0.1581,  21.5471,    0.2880,  1.39e-06,  1.33e-06,  1.27e-06,  nan ],
	[   890,   43.7883,   0.1450,   64.7768,   0.0980,  38.6966,   0.1640,  21.2307,    0.2990,  1.26e-06,  1.24e-06,  1.18e-06,  nan ],
	[   900,   43.2133,   0.1502,   64.8200,   0.1001,  38.3983,   0.1690,  21.2691,    0.3052,  1.26e-06,  1.34e-06,  1.34e-06,  nan ],
	[  1000,   48.5618,   0.1650,   74.1827,   0.1080,  42.8632,   0.1869,  20.7565,    0.3860,  1.49e-06,  1.60e-06,  1.64e-06,  nan ],
	[  1100,   53.2847,   0.1819,   84.3490,   0.1149,  29.5467,   0.3281,  21.7413,    0.4458,  1.83e-06,  1.80e-06,  1.62e-06,  nan ],
	[  1200,   59.7269,   0.1931,   94.6747,   0.1218,  32.4908,   0.3550,  22.1819,    0.5200,  1.83e-06,  1.83e-06,  2.04e-06,  nan ],
	[  1300,   63.5038,   0.2131,  103.4106,   0.1309,  34.0158,   0.3979,  17.5549,    0.7710,  1.80e-06,  1.44e-06,  1.54e-06,  nan ],
	[  1400,   70.7166,   0.2220,  111.9679,   0.1402,  37.1961,   0.4220,  19.0061,    0.8259,  1.42e-06,  1.49e-06,  1.51e-06,  nan ],
	[  1500,   74.8247,   0.2408,  120.1478,   0.1500,  40.2198,   0.4480,  17.0786,    1.0550,  1.96e-06,  2.04e-06,  2.03e-06,  nan ],
	[  1600,   80.6565,   0.2542,  129.8790,   0.1578,  42.6065,   0.4811,  17.1685,    1.1940,  1.81e-06,  2.06e-06,  1.93e-06,  nan ],
	[  1700,   86.3504,   0.2680,  133.6885,   0.1731,  44.9342,   0.5150,  17.0277,    1.3590,  1.98e-06,  2.25e-06,  1.99e-06,  nan ],
	[  1800,   91.3576,   0.2840,  143.3557,   0.1810,  47.3485,   0.5479,  16.3349,    1.5881,  2.09e-06,  2.04e-06,  1.90e-06,  nan ],
	[  1900,   96.0595,   0.3009,  151.3447,   0.1910,  49.9288,   0.5789,  16.9715,    1.7030,  2.22e-06,  1.96e-06,  1.98e-06,  nan ],
	[  2000,  100.6884,   0.3181,  157.0975,   0.2038,  52.5914,   0.6089,  17.1237,    1.8702,  1.91e-06,  1.95e-06,  1.93e-06,  nan ],
	[  2100,  104.1355,   0.3390,  161.3080,   0.2189,  39.0921,   0.9031,  16.7949,    2.1021,  2.56e-06,  2.68e-06,  2.67e-06,  nan ],
	[  2200,  110.7045,   0.3500,  165.4931,   0.2341,  41.0493,   0.9439,  16.6442,    2.3279,  2.13e-06,  2.19e-06,  2.24e-06,  nan ],
	[  2300,  117.0084,   0.3619,  173.6253,   0.2439,  42.8203,   0.9890,  17.3473,    2.4412,  2.87e-06,  2.99e-06,  2.98e-06,  nan ],
	[  2400,  121.6317,   0.3791,  182.2755,   0.2530,  44.3769,   1.0390,  17.2751,    2.6691,  2.99e-06,  3.08e-06,  3.17e-06,  nan ],
	[  2500,  125.9550,   0.3972,  185.2083,   0.2701,  45.9774,   1.0881,  17.2879,    2.8939,  2.64e-06,  2.58e-06,  2.77e-06,  nan ],
	[  2600,  129.1741,   0.4189,  192.5011,   0.2811,  48.1049,   1.1249,  17.2265,    3.1412,  2.55e-06,  2.38e-06,  2.34e-06,  nan ],
	[  2700,  136.3497,   0.4280,  200.4486,   0.2911,  49.6546,   1.1752,  17.3975,    3.3541,  2.39e-06,  2.38e-06,  2.47e-06,  nan ],
	[  2800,  139.1161,   0.4511,  205.1502,   0.3059,  51.1878,   1.2259,  17.5730,    3.5710,  2.93e-06,  3.13e-06,  2.86e-06,  nan ],
	[  2900,  143.5377,   0.4690,  212.9251,   0.3161,  52.7145,   1.2770,  18.1779,    3.7031,  2.95e-06,  2.53e-06,  2.78e-06,  nan ],
	[  3000,  147.3139,   0.4890,  220.8632,   0.3262,  54.2833,   1.3270,  17.3994,    4.1401,  3.20e-06,  2.67e-06,  3.08e-06,  nan ],
	[  3100,  152.8977,   0.5031,  222.9538,   0.3450,  43.5318,   1.7669,  16.8458,    4.5660,  2.46e-06,  2.55e-06,  2.79e-06,  nan ],
	[  3200,  156.6812,   0.5231,  233.5316,   0.3510,  45.3089,   1.8089,  17.5953,    4.6580,  2.75e-06,  2.92e-06,  2.91e-06,  nan ],
	[  3300,  161.1167,   0.5410,  232.5533,   0.3748,  46.4103,   1.8780,  17.7119,    4.9210,  3.11e-06,  2.96e-06,  3.26e-06,  nan ],
	[  3400,  165.2024,   0.5600,  239.6914,   0.3860,  47.5681,   1.9450,  17.5927,    5.2590,  2.59e-06,  2.88e-06,  2.83e-06,  nan ],
	[  3500,  167.5705,   0.5851,  243.9015,   0.4020,  48.8731,   2.0061,  17.6876,    5.5430,  3.18e-06,  3.71e-06,  3.05e-06,  nan ],
	[  3600,  174.0187,   0.5960,  250.0268,   0.4148,  50.1784,   2.0671,  16.5770,    6.2571,  3.40e-06,  3.27e-06,  3.34e-06,  nan ],
	[  3700,  177.2941,   0.6180,  259.6307,   0.4220,  51.2715,   2.1369,  17.7171,    6.1841,  3.51e-06,  3.65e-06,  4.07e-06,  nan ],
	[  3800,  179.9916,   0.6421,  257.4176,   0.4489,  52.5496,   2.1992,  17.7059,    6.5269,  2.91e-06,  3.01e-06,  2.70e-06,  nan ],
	[  3900,  183.3247,   0.6640,  256.3048,   0.4749,  53.8849,   2.2590,  17.8742,    6.8102,  3.17e-06,  2.72e-06,  2.74e-06,  nan ],
	[  4000,  179.8634,   0.7119,  261.3490,   0.4900,  54.7195,   2.3401,  16.2498,    7.8800,  4.09e-06,  3.94e-06,  3.82e-06,  nan ],
	[  4100,  178.1675,   0.7551,  264.9091,   0.5078,  46.4523,   2.8961,  17.7573,    7.5760,  3.14e-06,  3.31e-06,  3.22e-06,  nan ],
	[  4200,  179.1563,   0.7880,  261.4179,   0.5400,  47.4829,   2.9731,  17.7152,    7.9689,  3.37e-06,  3.49e-06,  3.22e-06,  nan ],
	[  4300,  180.8912,   0.8180,  265.6840,   0.5569,  48.5442,   3.0482,  17.8601,    8.2850,  3.20e-06,  3.37e-06,  3.21e-06,  nan ],
	[  4400,  183.3104,   0.8452,  260.7686,   0.5941,  49.3908,   3.1369,  17.1900,    9.0129,  3.44e-06,  3.55e-06,  3.11e-06,  nan ],
	[  4500,  184.3514,   0.8790,  259.2310,   0.6251,  50.4531,   3.2120,  17.7612,    9.1240,  3.62e-06,  3.52e-06,  3.64e-06,  nan ],
	[  4600,  188.3435,   0.8991,  258.9294,   0.6540,  51.4520,   3.2911,  16.8161,   10.0698,  3.91e-06,  3.50e-06,  3.61e-06,  nan ],
	[  4700,  187.0469,   0.9451,  256.2039,   0.6900,  52.5518,   3.3638,  17.7292,    9.9709,  3.99e-06,  4.17e-06,  4.09e-06,  nan ],
	[  4800,  189.1259,   0.9749,  260.3824,   0.7081,  53.5959,   3.4401,  17.6641,   10.4380,  4.05e-06,  3.51e-06,  3.53e-06,  nan ],
	[  4900,  187.4595,   1.0250,  265.0077,   0.7250,  54.3088,   3.5379,  17.0717,   11.2548,  3.57e-06,  3.64e-06,  3.45e-06,  nan ],
	[  5000,  189.1171,   1.0579,  258.5066,   0.7739,  55.0526,   3.6340,  17.0150,   11.7579,  4.27e-06,  4.90e-06,  4.41e-06,  nan ],
	[  5100,  191.8698,   1.0848,  263.8282,   0.7889,  55.9369,   3.7210,  16.8440,   12.3570,  4.20e-06,  4.50e-06,  4.41e-06,  nan ],
	[  5200,  192.6908,   1.1230,  262.9124,   0.8230,  48.9998,   4.4160,  16.6999,   12.9571,  3.88e-06,  3.88e-06,  3.87e-06,  nan ],
	[  5300,  193.9541,   1.1590,  263.8709,   0.8519,  49.7762,   4.5159,  16.9903,   13.2301,  3.67e-06,  3.55e-06,  3.68e-06,  nan ],
	[  5400,  194.4604,   1.2000,  264.2330,   0.8831,  50.5067,   4.6201,  17.0660,   13.6731,  4.65e-06,  4.40e-06,  4.29e-06,  nan ],
	[  5500,  197.2986,   1.2269,  262.8264,   0.9210,  50.8132,   4.7638,  17.0144,   14.2272,  3.96e-06,  3.73e-06,  4.31e-06,  nan ],
	[  5600,  199.6489,   1.2569,  268.0970,   0.9360,  52.4230,   4.7870,  16.5970,   15.1200,  4.03e-06,  4.28e-06,  4.37e-06,  nan ],
	[  5700,  199.8663,   1.3008,  264.9989,   0.9811,  52.6594,   4.9372,  17.0407,   15.2569,  4.19e-06,  4.61e-06,  4.30e-06,  nan ],
	[  5800,  199.8342,   1.3471,  270.2401,   0.9961,  53.8701,   4.9970,  16.9677,   15.8648,  4.50e-06,  4.40e-06,  4.14e-06,  nan ],
	[  5900,  201.4009,   1.3831,  268.3341,   1.0381,  54.4979,   5.1112,  17.2564,   16.1419,  4.33e-06,  4.35e-06,  4.26e-06,  nan ],
	[  6000,  202.2872,   1.4241,  268.9808,   1.0710,  55.5804,   5.1830,  17.2829,   16.6681,  4.16e-06,  4.41e-06,  3.78e-06,  nan ],
	[  6100,  204.2302,   1.4579,  266.0561,   1.1191,  55.4166,   5.3730,  17.0867,   17.4260,  4.37e-06,  4.55e-06,  4.73e-06,  nan ],
	[  6200,  207.5522,   1.4820,  268.8921,   1.1439,  49.8626,   6.1688,  17.0327,   18.0590,  3.80e-06,  3.64e-06,  3.88e-06,  nan ],
	[  6300,  207.8472,   1.5280,  271.6893,   1.1690,  50.6538,   6.2699,  17.0466,   18.6310,  4.89e-06,  4.27e-06,  4.90e-06,  nan ],
	[  6400,  208.3528,   1.5731,  274.0107,   1.1961,  51.4218,   6.3739,  18.9299,   17.3142,  4.76e-06,  4.43e-06,  4.06e-06,  nan ],
	[  6500,  211.2952,   1.6000,  275.7686,   1.2259,  51.2617,   6.5951,  17.1351,   19.7301,  4.80e-06,  4.15e-06,  4.67e-06,  nan ],
	[  6600,  213.4565,   1.6329,  275.9463,   1.2631,  51.8151,   6.7270,  17.1046,   20.3781,  4.36e-06,  4.63e-06,  4.35e-06,  nan ],
	[  6700,  214.1876,   1.6770,  275.6808,   1.3030,  53.4994,   6.7141,  17.1194,   20.9820,  5.18e-06,  4.38e-06,  4.96e-06,  nan ],
	[  6800,  213.2608,   1.7350,  276.9271,   1.3361,  53.5138,   6.9141,  17.9630,   20.5979,  4.36e-06,  3.81e-06,  4.12e-06,  nan ],
	[  6900,  217.8424,   1.7488,  279.1046,   1.3649,  53.8476,   7.0748,  17.9268,   21.2510,  4.06e-06,  3.64e-06,  3.65e-06,  nan ],
	[  7000,  216.6122,   1.8101,  277.8374,   1.4112,  54.6679,   7.1721,  17.8912,   21.9150,  4.19e-06,  4.06e-06,  3.98e-06,  nan ],
	[  7100,  216.8465,   1.8601,  280.1517,   1.4398,  55.9766,   7.2060,  17.0989,   23.5901,  4.30e-06,  4.02e-06,  3.65e-06,  nan ],
	[  7200,  221.0142,   1.8768,  281.6161,   1.4729,  49.8317,   8.3241,  16.6703,   24.8830,  4.07e-06,  4.35e-06,  4.07e-06,  nan ],
	[  7300,  220.2565,   1.9360,  280.3265,   1.5211,  50.8164,   8.3911,  16.7009,   25.5320,  4.46e-06,  4.42e-06,  4.83e-06,  nan ],
	[  7400,  223.7688,   1.9581,  279.4303,   1.5681,  50.6731,   8.6470,  16.8884,   25.9449,  4.27e-06,  4.18e-06,  4.25e-06,  nan ],
	[  7500,  223.8073,   2.0111,  285.2114,   1.5781,  51.8645,   8.6782,  16.9858,   26.4981,  4.63e-06,  4.19e-06,  3.96e-06,  nan ],
	[  7600,  227.7892,   2.0289,  282.4958,   1.6360,  52.4539,   8.8110,  16.9642,   27.2439,  3.98e-06,  3.88e-06,  4.11e-06,  nan ],
	[  7700,  225.6811,   2.1021,  280.3762,   1.6921,  53.0423,   8.9440,  16.2793,   29.1421,  5.22e-06,  4.58e-06,  4.79e-06,  nan ],
	[  7800,  225.7928,   2.1560,  282.3737,   1.7240,  53.5791,   9.0859,  17.3999,   27.9779,  4.48e-06,  5.09e-06,  4.55e-06,  nan ],
	[  7900,  224.1337,   2.2280,  281.8259,   1.7719,  54.6775,   9.1331,  17.6807,   28.2440,  4.67e-06,  4.82e-06,  4.81e-06,  nan ],
	[  8000,  224.7919,   2.2781,  283.6992,   1.8051,  54.6647,   9.3679,  16.8975,   30.3061,  4.53e-06,  4.92e-06,  5.02e-06,  nan ],
	[  8100,  225.8837,   2.3241,  281.6467,   1.8640,  55.5366,   9.4528,  16.5045,   31.8081,  5.05e-06,  5.03e-06,  4.99e-06,  nan ],
	[  8200,  225.8646,   2.3820,  283.7793,   1.8959,  50.3293,  10.6900,  15.6825,   34.3070,  5.15e-06,  5.52e-06,  5.39e-06,  nan ],
	[  8300,  225.5373,   2.4440,  282.3968,   1.9519,  51.3820,  10.7279,  16.4813,   33.4451,  6.48e-06,  6.03e-06,  5.59e-06,  nan ],
	[  8400,  224.9262,   2.5101,  286.7204,   1.9691,  51.3626,  10.9921,  16.5936,   34.0240,  4.66e-06,  4.62e-06,  4.69e-06,  nan ],
	[  8500,  230.3130,   2.5101,  280.7707,   2.0590,  52.8864,  10.9310,  16.8912,   34.2250,  5.47e-06,  5.63e-06,  5.70e-06,  nan ],
	[  8600,  226.9054,   2.6081,  283.7031,   2.0859,  53.0515,  11.1549,  16.8464,   35.1281,  5.47e-06,  5.26e-06,  5.34e-06,  nan ],
	[  8700,  227.1662,   2.6660,  285.5089,   2.1212,  53.3639,  11.3490,  17.4045,   34.7970,  5.47e-06,  5.42e-06,  5.35e-06,  nan ],
	[  8800,  224.6627,   2.7580,  286.4747,   2.1629,  53.7307,  11.5321,  17.2728,   35.8729,  5.95e-06,  5.68e-06,  5.45e-06,  nan ],
	[  8900,  227.2435,   2.7890,  283.9452,   2.2321,  54.4264,  11.6448,  17.5132,   36.1891,  5.69e-06,  5.32e-06,  5.15e-06,  nan ],
	[  9000,  228.6836,   2.8341,  285.3624,   2.2712,  54.1355,  11.9720,  17.7070,   36.6018,  5.18e-06,  5.31e-06,  5.75e-06,  nan ],
	[ 10000,  234.0923,   3.4180,  287.3980,   2.7840,  55.0860,  14.5249,  17.5426,   45.6102,  5.70e-06,  5.45e-06,  4.63e-06,  nan ],
	[ 12000,  239.3364,   4.8139,  291.9905,   3.9458,  54.8667,  20.9990,  17.2520,   66.7832,  6.72e-06,  6.68e-06,  6.34e-06,  nan ],
	[ 14000,  248.3621,   6.3140,  294.7248,   5.3208,  55.2851,  28.3651,  17.0299,   92.0832,  7.49e-06,  8.12e-06,  7.84e-06,  nan ],
	[ 16000,  252.3645,   8.1160,  293.3896,   6.9811,  55.2936,  37.0421,  15.6852,  130.5811,  6.96e-06,  6.64e-06,  6.96e-06,  nan ],
	[ 18000,  252.9734,  10.2470,  294.1387,   8.8129,  54.7344,  47.3599,  16.5955,  156.1999,  7.60e-06,  7.60e-06,  8.15e-06,  nan ],
	[ 20000,  258.1453,  12.3971,  293.4711,  10.9048,  53.9516,  59.3169,  17.3051,  184.9301,  9.59e-06,  9.18e-06,  9.22e-06,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/cpotrf.txt
# numactl --interleave=all ./testing_cpotrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cpotrf = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.03,  0.00,  nan ],
	[    30,  nan,  nan,     0.11,  0.00,  nan ],
	[    40,  nan,  nan,     1.33,  0.00,  nan ],
	[    50,  nan,  nan,     1.76,  0.00,  nan ],
	[    60,  nan,  nan,     2.51,  0.00,  nan ],
	[    70,  nan,  nan,     3.14,  0.00,  nan ],
	[    80,  nan,  nan,     3.68,  0.00,  nan ],
	[    90,  nan,  nan,     1.82,  0.00,  nan ],
	[   100,  nan,  nan,     2.18,  0.00,  nan ],
	[   200,  nan,  nan,    15.63,  0.00,  nan ],
	[   300,  nan,  nan,    17.10,  0.00,  nan ],
	[   400,  nan,  nan,    32.64,  0.00,  nan ],
	[   500,  nan,  nan,    54.64,  0.00,  nan ],
	[   600,  nan,  nan,    65.61,  0.00,  nan ],
	[   700,  nan,  nan,    92.82,  0.00,  nan ],
	[   800,  nan,  nan,   105.05,  0.01,  nan ],
	[   900,  nan,  nan,   137.17,  0.01,  nan ],
	[  1000,  nan,  nan,   172.83,  0.01,  nan ],
	[  2000,  nan,  nan,   448.49,  0.02,  nan ],
	[  3000,  nan,  nan,  1034.13,  0.03,  nan ],
	[  4000,  nan,  nan,  1306.94,  0.07,  nan ],
	[  5000,  nan,  nan,  1532.60,  0.11,  nan ],
	[  6000,  nan,  nan,  1749.80,  0.16,  nan ],
	[  7000,  nan,  nan,  1888.45,  0.24,  nan ],
	[  8000,  nan,  nan,  2029.63,  0.34,  nan ],
	[  9000,  nan,  nan,  2140.42,  0.45,  nan ],
	[ 10000,  nan,  nan,  2224.90,  0.60,  nan ],
	[ 12000,  nan,  nan,  2391.62,  0.96,  nan ],
	[ 14000,  nan,  nan,  2513.78,  1.46,  nan ],
	[ 16000,  nan,  nan,  2604.63,  2.10,  nan ],
	[ 18000,  nan,  nan,  2654.90,  2.93,  nan ],
	[ 20000,  nan,  nan,  2717.04,  3.93,  nan ],
])

# numactl --interleave=all ./testing_cpotrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cpotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,  nan,  nan,     0.04,  0.00,  nan ],
	[    40,  nan,  nan,     0.10,  0.00,  nan ],
	[    50,  nan,  nan,     0.19,  0.00,  nan ],
	[    60,  nan,  nan,     0.33,  0.00,  nan ],
	[    70,  nan,  nan,     0.50,  0.00,  nan ],
	[    80,  nan,  nan,     0.72,  0.00,  nan ],
	[    90,  nan,  nan,     1.01,  0.00,  nan ],
	[   100,  nan,  nan,     1.31,  0.00,  nan ],
	[   200,  nan,  nan,    25.81,  0.00,  nan ],
	[   300,  nan,  nan,    14.85,  0.00,  nan ],
	[   400,  nan,  nan,    28.69,  0.00,  nan ],
	[   500,  nan,  nan,    51.90,  0.00,  nan ],
	[   600,  nan,  nan,    66.53,  0.00,  nan ],
	[   700,  nan,  nan,    96.74,  0.00,  nan ],
	[   800,  nan,  nan,   111.33,  0.01,  nan ],
	[   900,  nan,  nan,   144.85,  0.01,  nan ],
	[  1000,  nan,  nan,   189.02,  0.01,  nan ],
	[  2000,  nan,  nan,   645.94,  0.02,  nan ],
	[  3000,  nan,  nan,  1172.10,  0.03,  nan ],
	[  4000,  nan,  nan,  1520.32,  0.06,  nan ],
	[  5000,  nan,  nan,  1748.09,  0.10,  nan ],
	[  6000,  nan,  nan,  1975.51,  0.15,  nan ],
	[  7000,  nan,  nan,  2128.39,  0.21,  nan ],
	[  8000,  nan,  nan,  2292.40,  0.30,  nan ],
	[  9000,  nan,  nan,  2378.84,  0.41,  nan ],
	[ 10000,  nan,  nan,  2448.90,  0.54,  nan ],
	[ 12000,  nan,  nan,  2582.69,  0.89,  nan ],
	[ 14000,  nan,  nan,  2687.58,  1.36,  nan ],
	[ 16000,  nan,  nan,  2773.17,  1.97,  nan ],
	[ 18000,  nan,  nan,  2797.79,  2.78,  nan ],
	[ 20000,  nan,  nan,  2853.78,  3.74,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/dgeev.txt
# numactl --interleave=all ./testing_dgeev -RN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgeev_RN = array([
	[    10,  nan,    0.0003 ],
	[    20,  nan,    0.0005 ],
	[    30,  nan,    0.0010 ],
	[    40,  nan,    0.0036 ],
	[    50,  nan,    0.0038 ],
	[    60,  nan,    0.0029 ],
	[    70,  nan,    0.0049 ],
	[    80,  nan,    0.0070 ],
	[    90,  nan,    0.0077 ],
	[   100,  nan,    0.0104 ],
	[   200,  nan,    0.0504 ],
	[   300,  nan,    0.0928 ],
	[   400,  nan,    0.1492 ],
	[   500,  nan,    0.2035 ],
	[   600,  nan,    0.3972 ],
	[   700,  nan,    0.4888 ],
	[   800,  nan,    0.6213 ],
	[   900,  nan,    0.7286 ],
	[  1000,  nan,    0.8346 ],
	[  2000,  nan,    2.6839 ],
	[  3000,  nan,    8.3090 ],
	[  4000,  nan,   13.0648 ],
	[  5000,  nan,   19.1756 ],
	[  6000,  nan,   34.5229 ],
	[  7000,  nan,   45.5130 ],
	[  8000,  nan,   57.6382 ],
	[  9000,  nan,   71.9485 ],
	[ 10000,  nan,   86.3439 ],
	[ 12000,  nan,  127.5089 ],
	[ 14000,  nan,  172.5061 ],
	[ 16000,  nan,  234.0620 ],
	[ 18000,  nan,  297.6919 ],
	[ 20000,  nan,  376.7777 ],
])

# numactl --interleave=all ./testing_dgeev -RV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgeev_RV = array([
	[    10,  nan,    0.0019 ],
	[    20,  nan,    0.0022 ],
	[    30,  nan,    0.0027 ],
	[    40,  nan,    0.0057 ],
	[    50,  nan,    0.0061 ],
	[    60,  nan,    0.0053 ],
	[    70,  nan,    0.0082 ],
	[    80,  nan,    0.0108 ],
	[    90,  nan,    0.0124 ],
	[   100,  nan,    0.0160 ],
	[   200,  nan,    0.0715 ],
	[   300,  nan,    0.1328 ],
	[   400,  nan,    0.1919 ],
	[   500,  nan,    0.2605 ],
	[   600,  nan,    0.4616 ],
	[   700,  nan,    0.5876 ],
	[   800,  nan,    0.7825 ],
	[   900,  nan,    0.9140 ],
	[  1000,  nan,    1.0389 ],
	[  2000,  nan,    3.8141 ],
	[  3000,  nan,    9.8144 ],
	[  4000,  nan,   16.8121 ],
	[  5000,  nan,   26.1404 ],
	[  6000,  nan,   43.0581 ],
	[  7000,  nan,   58.4856 ],
	[  8000,  nan,   78.0931 ],
	[  9000,  nan,   96.9315 ],
	[ 10000,  nan,  120.1575 ],
	[ 12000,  nan,  182.2855 ],
	[ 14000,  nan,  264.6482 ],
	[ 16000,  nan,  352.2808 ],
	[ 18000,  nan,  468.5955 ],
	[ 20000,  nan,  637.4293 ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/dgeqrf.txt
# numactl --interleave=all ./testing_dgeqrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgeqrf = array([
	[    10,     10,  nan,  nan,     0.02,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.18,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.47,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.79,   0.00,  nan ],
	[    50,     50,  nan,  nan,     1.25,   0.00,  nan ],
	[    60,     60,  nan,  nan,     1.61,   0.00,  nan ],
	[    70,     70,  nan,  nan,     0.47,   0.00,  nan ],
	[    80,     80,  nan,  nan,     0.85,   0.00,  nan ],
	[    90,     90,  nan,  nan,     1.19,   0.00,  nan ],
	[   100,    100,  nan,  nan,     1.55,   0.00,  nan ],
	[   200,    200,  nan,  nan,     5.27,   0.00,  nan ],
	[   300,    300,  nan,  nan,    11.84,   0.00,  nan ],
	[   400,    400,  nan,  nan,    19.21,   0.00,  nan ],
	[   500,    500,  nan,  nan,    27.64,   0.01,  nan ],
	[   600,    600,  nan,  nan,    36.80,   0.01,  nan ],
	[   700,    700,  nan,  nan,    45.76,   0.01,  nan ],
	[   800,    800,  nan,  nan,    56.97,   0.01,  nan ],
	[   900,    900,  nan,  nan,    66.99,   0.01,  nan ],
	[  1000,   1000,  nan,  nan,    79.00,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   203.94,   0.05,  nan ],
	[  3000,   3000,  nan,  nan,   321.58,   0.11,  nan ],
	[  4000,   4000,  nan,  nan,   425.81,   0.20,  nan ],
	[  5000,   5000,  nan,  nan,   542.72,   0.31,  nan ],
	[  6000,   6000,  nan,  nan,   637.54,   0.45,  nan ],
	[  7000,   7000,  nan,  nan,   714.97,   0.64,  nan ],
	[  8000,   8000,  nan,  nan,   772.51,   0.88,  nan ],
	[  9000,   9000,  nan,  nan,   810.88,   1.20,  nan ],
	[ 10000,  10000,  nan,  nan,   843.87,   1.58,  nan ],
	[ 12000,  12000,  nan,  nan,   923.69,   2.49,  nan ],
	[ 14000,  14000,  nan,  nan,   962.33,   3.80,  nan ],
	[ 16000,  16000,  nan,  nan,   989.29,   5.52,  nan ],
	[ 18000,  18000,  nan,  nan,  1001.21,   7.77,  nan ],
	[ 20000,  20000,  nan,  nan,  1014.24,  10.52,  nan ],
])

# numactl --interleave=all ./testing_dgeqrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgeqrf_gpu = array([
	[    10,     10,  nan,  nan,     0.00,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.01,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.04,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.08,   0.00,  nan ],
	[    50,     50,  nan,  nan,     0.16,   0.00,  nan ],
	[    60,     60,  nan,  nan,     0.27,   0.00,  nan ],
	[    70,     70,  nan,  nan,     0.31,   0.00,  nan ],
	[    80,     80,  nan,  nan,     0.46,   0.00,  nan ],
	[    90,     90,  nan,  nan,     0.70,   0.00,  nan ],
	[   100,    100,  nan,  nan,     2.03,   0.00,  nan ],
	[   200,    200,  nan,  nan,     4.12,   0.00,  nan ],
	[   300,    300,  nan,  nan,     9.20,   0.00,  nan ],
	[   400,    400,  nan,  nan,    15.57,   0.01,  nan ],
	[   500,    500,  nan,  nan,    23.52,   0.01,  nan ],
	[   600,    600,  nan,  nan,    31.90,   0.01,  nan ],
	[   700,    700,  nan,  nan,    42.22,   0.01,  nan ],
	[   800,    800,  nan,  nan,    51.42,   0.01,  nan ],
	[   900,    900,  nan,  nan,    60.63,   0.02,  nan ],
	[  1000,   1000,  nan,  nan,    71.80,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   191.44,   0.06,  nan ],
	[  3000,   3000,  nan,  nan,   303.43,   0.12,  nan ],
	[  4000,   4000,  nan,  nan,   403.44,   0.21,  nan ],
	[  5000,   5000,  nan,  nan,   522.78,   0.32,  nan ],
	[  6000,   6000,  nan,  nan,   622.05,   0.46,  nan ],
	[  7000,   7000,  nan,  nan,   690.83,   0.66,  nan ],
	[  8000,   8000,  nan,  nan,   749.23,   0.91,  nan ],
	[  9000,   9000,  nan,  nan,   789.91,   1.23,  nan ],
	[ 10000,  10000,  nan,  nan,   824.35,   1.62,  nan ],
	[ 12000,  12000,  nan,  nan,   890.05,   2.59,  nan ],
	[ 14000,  14000,  nan,  nan,   938.13,   3.90,  nan ],
	[ 16000,  16000,  nan,  nan,   971.05,   5.62,  nan ],
	[ 18000,  18000,  nan,  nan,   990.70,   7.85,  nan ],
	[ 20000,  20000,  nan,  nan,  1004.45,  10.62,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/dgetrf.txt
# numactl --interleave=all ./testing_dgetrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgetrf = array([
	[    10,     10,  nan,  nan,    0.03,  0.00,  nan ],
	[    20,     20,  nan,  nan,    0.21,  0.00,  nan ],
	[    30,     30,  nan,  nan,    0.00,  0.02,  nan ],
	[    40,     40,  nan,  nan,    0.89,  0.00,  nan ],
	[    50,     50,  nan,  nan,    1.29,  0.00,  nan ],
	[    60,     60,  nan,  nan,    1.82,  0.00,  nan ],
	[    70,     70,  nan,  nan,    1.71,  0.00,  nan ],
	[    80,     80,  nan,  nan,    2.47,  0.00,  nan ],
	[    90,     90,  nan,  nan,    2.87,  0.00,  nan ],
	[   100,    100,  nan,  nan,    3.62,  0.00,  nan ],
	[   200,    200,  nan,  nan,    4.03,  0.00,  nan ],
	[   300,    300,  nan,  nan,    8.82,  0.00,  nan ],
	[   400,    400,  nan,  nan,   14.86,  0.00,  nan ],
	[   500,    500,  nan,  nan,   21.87,  0.00,  nan ],
	[   600,    600,  nan,  nan,   29.41,  0.00,  nan ],
	[   700,    700,  nan,  nan,   37.04,  0.01,  nan ],
	[   800,    800,  nan,  nan,   45.54,  0.01,  nan ],
	[   900,    900,  nan,  nan,   52.82,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,   62.48,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,  154.80,  0.03,  nan ],
	[  3000,   3000,  nan,  nan,  251.08,  0.07,  nan ],
	[  4000,   4000,  nan,  nan,  320.89,  0.13,  nan ],
	[  5000,   5000,  nan,  nan,  410.68,  0.20,  nan ],
	[  6000,   6000,  nan,  nan,  483.75,  0.30,  nan ],
	[  7000,   7000,  nan,  nan,  575.18,  0.40,  nan ],
	[  8000,   8000,  nan,  nan,  638.29,  0.53,  nan ],
	[  9000,   9000,  nan,  nan,  677.18,  0.72,  nan ],
	[ 10000,  10000,  nan,  nan,  724.13,  0.92,  nan ],
	[ 12000,  12000,  nan,  nan,  800.38,  1.44,  nan ],
	[ 14000,  14000,  nan,  nan,  848.85,  2.15,  nan ],
	[ 16000,  16000,  nan,  nan,  888.31,  3.07,  nan ],
	[ 18000,  18000,  nan,  nan,  912.50,  4.26,  nan ],
	[ 20000,  20000,  nan,  nan,  940.37,  5.67,  nan ],
])

# numactl --interleave=all ./testing_dgetrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.01,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.10,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.21,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.46,  0.00,  nan ],
	[    50,     50,  nan,  nan,     0.76,  0.00,  nan ],
	[    60,     60,  nan,  nan,     1.14,  0.00,  nan ],
	[    70,     70,  nan,  nan,     1.23,  0.00,  nan ],
	[    80,     80,  nan,  nan,     1.69,  0.00,  nan ],
	[    90,     90,  nan,  nan,     2.04,  0.00,  nan ],
	[   100,    100,  nan,  nan,     2.50,  0.00,  nan ],
	[   200,    200,  nan,  nan,     2.67,  0.00,  nan ],
	[   300,    300,  nan,  nan,     6.80,  0.00,  nan ],
	[   400,    400,  nan,  nan,    12.39,  0.00,  nan ],
	[   500,    500,  nan,  nan,    19.27,  0.00,  nan ],
	[   600,    600,  nan,  nan,    27.91,  0.01,  nan ],
	[   700,    700,  nan,  nan,    37.40,  0.01,  nan ],
	[   800,    800,  nan,  nan,    47.21,  0.01,  nan ],
	[   900,    900,  nan,  nan,    57.21,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,    67.08,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   184.44,  0.03,  nan ],
	[  3000,   3000,  nan,  nan,   315.04,  0.06,  nan ],
	[  4000,   4000,  nan,  nan,   397.68,  0.11,  nan ],
	[  5000,   5000,  nan,  nan,   515.53,  0.16,  nan ],
	[  6000,   6000,  nan,  nan,   632.60,  0.23,  nan ],
	[  7000,   7000,  nan,  nan,   708.18,  0.32,  nan ],
	[  8000,   8000,  nan,  nan,   783.29,  0.44,  nan ],
	[  9000,   9000,  nan,  nan,   801.62,  0.61,  nan ],
	[ 10000,  10000,  nan,  nan,   847.98,  0.79,  nan ],
	[ 12000,  12000,  nan,  nan,   910.15,  1.27,  nan ],
	[ 14000,  14000,  nan,  nan,   970.27,  1.89,  nan ],
	[ 16000,  16000,  nan,  nan,  1003.93,  2.72,  nan ],
	[ 18000,  18000,  nan,  nan,  1025.04,  3.79,  nan ],
	[ 20000,  20000,  nan,  nan,  1047.88,  5.09,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/dpotrf.txt
# numactl --interleave=all ./testing_dpotrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dpotrf = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,  nan,  nan,     0.03,  0.00,  nan ],
	[    40,  nan,  nan,     0.45,  0.00,  nan ],
	[    50,  nan,  nan,     0.69,  0.00,  nan ],
	[    60,  nan,  nan,     1.25,  0.00,  nan ],
	[    70,  nan,  nan,     1.46,  0.00,  nan ],
	[    80,  nan,  nan,     1.77,  0.00,  nan ],
	[    90,  nan,  nan,     0.60,  0.00,  nan ],
	[   100,  nan,  nan,     0.80,  0.00,  nan ],
	[   200,  nan,  nan,     5.16,  0.00,  nan ],
	[   300,  nan,  nan,     5.43,  0.00,  nan ],
	[   400,  nan,  nan,    10.29,  0.00,  nan ],
	[   500,  nan,  nan,    17.52,  0.00,  nan ],
	[   600,  nan,  nan,    21.12,  0.00,  nan ],
	[   700,  nan,  nan,    28.69,  0.00,  nan ],
	[   800,  nan,  nan,    33.87,  0.01,  nan ],
	[   900,  nan,  nan,    42.94,  0.01,  nan ],
	[  1000,  nan,  nan,    55.68,  0.01,  nan ],
	[  2000,  nan,  nan,   174.02,  0.02,  nan ],
	[  3000,  nan,  nan,   308.06,  0.03,  nan ],
	[  4000,  nan,  nan,   489.93,  0.04,  nan ],
	[  5000,  nan,  nan,   578.75,  0.07,  nan ],
	[  6000,  nan,  nan,   673.17,  0.11,  nan ],
	[  7000,  nan,  nan,   728.76,  0.16,  nan ],
	[  8000,  nan,  nan,   794.65,  0.21,  nan ],
	[  9000,  nan,  nan,   832.96,  0.29,  nan ],
	[ 10000,  nan,  nan,   870.23,  0.38,  nan ],
	[ 12000,  nan,  nan,   936.04,  0.62,  nan ],
	[ 14000,  nan,  nan,   986.12,  0.93,  nan ],
	[ 16000,  nan,  nan,  1027.05,  1.33,  nan ],
	[ 18000,  nan,  nan,  1048.62,  1.85,  nan ],
	[ 20000,  nan,  nan,  1075.40,  2.48,  nan ],
])

# numactl --interleave=all ./testing_dpotrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dpotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.00,  0.00,  nan ],
	[    30,  nan,  nan,     0.01,  0.00,  nan ],
	[    40,  nan,  nan,     0.03,  0.00,  nan ],
	[    50,  nan,  nan,     0.05,  0.00,  nan ],
	[    60,  nan,  nan,     0.08,  0.00,  nan ],
	[    70,  nan,  nan,     0.13,  0.00,  nan ],
	[    80,  nan,  nan,     0.19,  0.00,  nan ],
	[    90,  nan,  nan,     0.26,  0.00,  nan ],
	[   100,  nan,  nan,     0.33,  0.00,  nan ],
	[   200,  nan,  nan,     7.48,  0.00,  nan ],
	[   300,  nan,  nan,     4.24,  0.00,  nan ],
	[   400,  nan,  nan,     8.37,  0.00,  nan ],
	[   500,  nan,  nan,    15.60,  0.00,  nan ],
	[   600,  nan,  nan,    19.72,  0.00,  nan ],
	[   700,  nan,  nan,    28.35,  0.00,  nan ],
	[   800,  nan,  nan,    33.24,  0.01,  nan ],
	[   900,  nan,  nan,    43.14,  0.01,  nan ],
	[  1000,  nan,  nan,    53.49,  0.01,  nan ],
	[  2000,  nan,  nan,   203.87,  0.01,  nan ],
	[  3000,  nan,  nan,   363.39,  0.02,  nan ],
	[  4000,  nan,  nan,   594.67,  0.04,  nan ],
	[  5000,  nan,  nan,   699.20,  0.06,  nan ],
	[  6000,  nan,  nan,   812.44,  0.09,  nan ],
	[  7000,  nan,  nan,   871.36,  0.13,  nan ],
	[  8000,  nan,  nan,   932.76,  0.18,  nan ],
	[  9000,  nan,  nan,   970.43,  0.25,  nan ],
	[ 10000,  nan,  nan,   996.29,  0.33,  nan ],
	[ 12000,  nan,  nan,  1055.65,  0.55,  nan ],
	[ 14000,  nan,  nan,  1097.37,  0.83,  nan ],
	[ 16000,  nan,  nan,  1129.46,  1.21,  nan ],
	[ 18000,  nan,  nan,  1140.54,  1.70,  nan ],
	[ 20000,  nan,  nan,  1161.71,  2.30,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/dsyevd.txt
# numactl --interleave=all ./testing_dsyevd -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevd_JN = array([
	[    10,  nan,    0.0000 ],
	[    20,  nan,    0.0001 ],
	[    30,  nan,    0.0001 ],
	[    40,  nan,    0.0001 ],
	[    50,  nan,    0.0002 ],
	[    60,  nan,    0.0003 ],
	[    70,  nan,    0.0004 ],
	[    80,  nan,    0.0005 ],
	[    90,  nan,    0.0007 ],
	[   100,  nan,    0.0010 ],
	[   200,  nan,    0.0046 ],
	[   300,  nan,    0.0094 ],
	[   400,  nan,    0.0158 ],
	[   500,  nan,    0.0247 ],
	[   600,  nan,    0.0330 ],
	[   700,  nan,    0.0444 ],
	[   800,  nan,    0.0584 ],
	[   900,  nan,    0.0729 ],
	[  1000,  nan,    0.0905 ],
	[  2000,  nan,    0.3901 ],
	[  3000,  nan,    1.6846 ],
	[  4000,  nan,    3.4543 ],
	[  5000,  nan,    6.1636 ],
	[  6000,  nan,   10.0288 ],
	[  7000,  nan,   15.0627 ],
	[  8000,  nan,   21.6150 ],
	[  9000,  nan,   30.0964 ],
	[ 10000,  nan,   40.0830 ],
	[ 12000,  nan,   67.2872 ],
	[ 14000,  nan,  103.7819 ],
	[ 16000,  nan,  152.1573 ],
	[ 18000,  nan,  214.1986 ],
	[ 20000,  nan,  292.3491 ],
])

# numactl --interleave=all ./testing_dsyevd -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevd_JV = array([
	[    10,  nan,    0.0001 ],
	[    20,  nan,    0.0001 ],
	[    30,  nan,    0.0003 ],
	[    40,  nan,    0.0004 ],
	[    50,  nan,    0.0005 ],
	[    60,  nan,    0.0007 ],
	[    70,  nan,    0.0009 ],
	[    80,  nan,    0.0012 ],
	[    90,  nan,    0.0016 ],
	[   100,  nan,    0.0020 ],
	[   200,  nan,    0.0092 ],
	[   300,  nan,    0.0154 ],
	[   400,  nan,    0.0236 ],
	[   500,  nan,    0.0349 ],
	[   600,  nan,    0.0406 ],
	[   700,  nan,    0.0543 ],
	[   800,  nan,    0.0689 ],
	[   900,  nan,    0.0894 ],
	[  1000,  nan,    0.1088 ],
	[  2000,  nan,    0.4371 ],
	[  3000,  nan,    1.7745 ],
	[  4000,  nan,    3.5866 ],
	[  5000,  nan,    6.1729 ],
	[  6000,  nan,   10.2059 ],
	[  7000,  nan,   15.6413 ],
	[  8000,  nan,   22.1738 ],
	[  9000,  nan,   30.8648 ],
	[ 10000,  nan,   41.6346 ],
	[ 12000,  nan,   69.6852 ],
	[ 14000,  nan,  107.9567 ],
	[ 16000,  nan,  159.0155 ],
	[ 18000,  nan,  224.3631 ],
	[ 20000,  nan,  307.3239 ],
])

# numactl --interleave=all ./testing_dsyevd_gpu -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevd_gpu_JN = array([
	[    10,  nan,    0.0001 ],
	[    20,  nan,    0.0001 ],
	[    30,  nan,    0.0001 ],
	[    40,  nan,    0.0002 ],
	[    50,  nan,    0.0002 ],
	[    60,  nan,    0.0003 ],
	[    70,  nan,    0.0004 ],
	[    80,  nan,    0.0006 ],
	[    90,  nan,    0.0008 ],
	[   100,  nan,    0.0011 ],
	[   200,  nan,    0.0045 ],
	[   300,  nan,    0.0099 ],
	[   400,  nan,    0.0162 ],
	[   500,  nan,    0.0246 ],
	[   600,  nan,    0.0339 ],
	[   700,  nan,    0.0453 ],
	[   800,  nan,    0.0588 ],
	[   900,  nan,    0.0741 ],
	[  1000,  nan,    0.0921 ],
	[  2000,  nan,    0.3924 ],
	[  3000,  nan,    1.6663 ],
	[  4000,  nan,    3.4803 ],
	[  5000,  nan,    6.2043 ],
	[  6000,  nan,    9.9758 ],
	[  7000,  nan,   14.9753 ],
	[  8000,  nan,   21.5516 ],
	[  9000,  nan,   29.9531 ],
	[ 10000,  nan,   39.9814 ],
	[ 12000,  nan,   67.1131 ],
	[ 14000,  nan,  103.8750 ],
	[ 16000,  nan,  151.8922 ],
	[ 18000,  nan,  213.8282 ],
	[ 20000,  nan,  291.9441 ],
])

# numactl --interleave=all ./testing_dsyevd_gpu -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevd_gpu_JV = array([
	[    10,  nan,    0.0001 ],
	[    20,  nan,    0.0002 ],
	[    30,  nan,    0.0003 ],
	[    40,  nan,    0.0004 ],
	[    50,  nan,    0.0006 ],
	[    60,  nan,    0.0008 ],
	[    70,  nan,    0.0010 ],
	[    80,  nan,    0.0013 ],
	[    90,  nan,    0.0017 ],
	[   100,  nan,    0.0021 ],
	[   200,  nan,    0.0086 ],
	[   300,  nan,    0.0150 ],
	[   400,  nan,    0.0234 ],
	[   500,  nan,    0.0349 ],
	[   600,  nan,    0.0412 ],
	[   700,  nan,    0.0543 ],
	[   800,  nan,    0.0699 ],
	[   900,  nan,    0.0898 ],
	[  1000,  nan,    0.1107 ],
	[  2000,  nan,    0.4399 ],
	[  3000,  nan,    1.7617 ],
	[  4000,  nan,    3.6543 ],
	[  5000,  nan,    6.2934 ],
	[  6000,  nan,   10.2892 ],
	[  7000,  nan,   15.6360 ],
	[  8000,  nan,   22.7291 ],
	[  9000,  nan,   31.6410 ],
	[ 10000,  nan,   43.0747 ],
	[ 12000,  nan,   72.2865 ],
	[ 14000,  nan,  111.7001 ],
	[ 16000,  nan,  164.5137 ],
	[ 18000,  nan,  231.8863 ],
	[ 20000,  nan,  318.6287 ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/dsyevd_2stage.txt
# numactl --interleave=all ./testing_dsyevdx_2stage -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevdx_2stage_JN = array([
	[    10,      0,   0.0001 ],
	[    20,      0,   0.0000 ],
	[    30,      0,   0.0000 ],
	[    40,      0,   0.0000 ],
	[    50,      0,   0.0000 ],
	[    60,      0,   0.0000 ],
	[    70,     70,   0.0004 ],
	[    80,     80,   0.0005 ],
	[    90,     90,   0.0007 ],
	[   100,    100,   0.0010 ],
	[   200,    200,   0.0045 ],
	[   300,    300,   0.0201 ],
	[   400,    400,   0.0358 ],
	[   500,    500,   0.0587 ],
	[   600,    600,   0.0766 ],
	[   700,    700,   0.0980 ],
	[   800,    800,   0.1183 ],
	[   900,    900,   0.1424 ],
	[  1000,   1000,   0.1739 ],
	[  2000,   2000,   0.6036 ],
	[  3000,   3000,   1.0258 ],
	[  4000,   4000,   1.6122 ],
	[  5000,   5000,   2.2011 ],
	[  6000,   6000,   2.8054 ],
	[  7000,   7000,   3.7121 ],
	[  8000,   8000,   4.8386 ],
	[  9000,   9000,   6.4815 ],
	[ 10000,  10000,   7.7210 ],
	[ 12000,  12000,  11.1897 ],
	[ 14000,  14000,  14.2319 ],
	[ 16000,  16000,  19.9898 ],
	[ 18000,  18000,  26.2808 ],
	[ 20000,  20000,  31.9030 ],
])

# numactl --interleave=all ./testing_dsyevdx_2stage -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevdx_2stage_JV = array([
	[    10,     10,   0.0001 ],
	[    20,     20,   0.0002 ],
	[    30,     30,   0.0003 ],
	[    40,     40,   0.0005 ],
	[    50,     50,   0.0006 ],
	[    60,     60,   0.0008 ],
	[    70,     70,   0.0010 ],
	[    80,     80,   0.0013 ],
	[    90,     90,   0.0018 ],
	[   100,    100,   0.0023 ],
	[   200,    200,   0.0090 ],
	[   300,    300,   0.0321 ],
	[   400,    400,   0.0539 ],
	[   500,    500,   0.0812 ],
	[   600,    600,   0.1004 ],
	[   700,    700,   0.1316 ],
	[   800,    800,   0.1618 ],
	[   900,    900,   0.2007 ],
	[  1000,   1000,   0.2101 ],
	[  2000,   2000,   0.9127 ],
	[  3000,   3000,   1.1344 ],
	[  4000,   4000,   1.8945 ],
	[  5000,   5000,   2.8313 ],
	[  6000,   6000,   4.0173 ],
	[  7000,   7000,   6.4601 ],
	[  8000,   8000,   8.3011 ],
	[  9000,   9000,  11.4377 ],
	[ 10000,  10000,  15.2911 ],
	[ 12000,  12000,  24.1945 ],
	[ 14000,  14000,  34.8274 ],
	[ 16000,  16000,  52.9206 ],
	[ 18000,  18000,  72.3969 ],
	[ 20000,  20000,  90.1417 ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/dsymv.txt
# numactl --interleave=all ./testing_dsymv -N 100 -N 1000 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
dsymv_L = array([
	[    10,   0.0073,   0.0300,   0.0088,   0.0250,   0.0110,   0.0200,   0.0710,   0.0031,  8.88e-17,  8.88e-17,  8.88e-17,  nan ],
	[    11,   0.0089,   0.0298,   0.0110,   0.0241,   0.0132,   0.0200,   0.1384,   0.0019,  8.07e-17,  8.07e-17,  8.07e-17,  nan ],
	[    12,   0.0104,   0.0300,   0.0130,   0.0241,   0.0156,   0.0200,   0.1454,   0.0021,  7.40e-17,  7.40e-17,  7.40e-17,  nan ],
	[    13,   0.0125,   0.0291,   0.0153,   0.0238,   0.0182,   0.0200,   0.1696,   0.0021,  6.83e-17,  1.37e-16,  6.83e-17,  nan ],
	[    14,   0.0146,   0.0288,   0.0155,   0.0272,   0.0210,   0.0200,   0.2202,   0.0019,  1.27e-16,  1.27e-16,  1.27e-16,  nan ],
	[    15,   0.0160,   0.0300,   0.0192,   0.0250,   0.0240,   0.0200,   0.1549,   0.0031,  5.92e-17,  5.92e-17,  5.92e-17,  nan ],
	[    16,   0.0187,   0.0291,   0.0219,   0.0248,   0.0275,   0.0198,   0.2535,   0.0021,  1.11e-16,  1.11e-16,  5.55e-17,  nan ],
	[    17,   0.0197,   0.0310,   0.0235,   0.0260,   0.0292,   0.0210,   0.2852,   0.0021,  1.04e-16,  1.04e-16,  2.09e-16,  nan ],
	[    18,   0.0221,   0.0310,   0.0254,   0.0269,   0.0322,   0.0212,   0.2207,   0.0031,  9.87e-17,  9.87e-17,  9.87e-17,  nan ],
	[    19,   0.0255,   0.0298,   0.0292,   0.0260,   0.0384,   0.0198,   0.2452,   0.0031,  1.40e-16,  9.35e-17,  1.40e-16,  nan ],
	[    20,   0.0280,   0.0300,   0.0309,   0.0272,   0.0400,   0.0210,   0.2710,   0.0031,  8.88e-17,  8.88e-17,  8.88e-17,  nan ],
	[    21,   0.0308,   0.0300,   0.0356,   0.0260,   0.0440,   0.0210,   0.4844,   0.0019,  8.46e-17,  1.27e-16,  1.69e-16,  nan ],
	[    22,   0.0337,   0.0300,   0.0372,   0.0272,   0.0505,   0.0200,   0.3537,   0.0029,  8.07e-17,  8.07e-17,  8.07e-17,  nan ],
	[    23,   0.0356,   0.0310,   0.0406,   0.0272,   0.0526,   0.0210,   0.3562,   0.0031,  7.72e-17,  1.16e-16,  1.16e-16,  nan ],
	[    24,   0.0399,   0.0300,   0.0445,   0.0269,   0.0572,   0.0210,   0.5592,   0.0021,  1.11e-16,  7.40e-17,  1.11e-16,  nan ],
	[    25,   0.0419,   0.0310,   0.0483,   0.0269,   0.0483,   0.0269,   0.4194,   0.0031,  1.42e-16,  1.42e-16,  7.11e-17,  nan ],
	[    26,   0.0467,   0.0300,   0.0521,   0.0269,   0.0633,   0.0222,   0.4530,   0.0031,  1.37e-16,  1.37e-16,  1.37e-16,  nan ],
	[    27,   0.0488,   0.0310,   0.0561,   0.0269,   0.0682,   0.0222,   0.4878,   0.0031,  1.32e-16,  1.32e-16,  1.32e-16,  nan ],
	[    28,   0.0524,   0.0310,   0.0577,   0.0281,   0.0774,   0.0210,   0.8514,   0.0019,  1.90e-16,  1.27e-16,  1.27e-16,  nan ],
	[    29,   0.0561,   0.0310,   0.0624,   0.0279,   0.0793,   0.0219,   0.5614,   0.0031,  1.84e-16,  1.84e-16,  1.23e-16,  nan ],
	[    30,   0.0619,   0.0300,   0.0667,   0.0279,   0.0887,   0.0210,   0.6001,   0.0031,  5.92e-17,  1.18e-16,  1.18e-16,  nan ],
	[    31,   0.0640,   0.0310,   0.0705,   0.0281,   0.0905,   0.0219,   0.6401,   0.0031,  1.15e-16,  1.15e-16,  1.15e-16,  nan ],
	[    32,   0.0603,   0.0350,   0.0784,   0.0269,   0.1007,   0.0210,   0.9843,   0.0021,  1.67e-16,  1.11e-16,  1.67e-16,  nan ],
	[    33,   0.0702,   0.0319,   0.0645,   0.0348,   0.0980,   0.0229,   0.7843,   0.0029,  1.08e-16,  1.08e-16,  1.08e-16,  nan ],
	[    34,   0.0768,   0.0310,   0.0723,   0.0329,   0.1085,   0.0219,   0.7679,   0.0031,  2.09e-16,  1.57e-16,  1.04e-16,  nan ],
	[    35,   0.0789,   0.0319,   0.0648,   0.0389,   0.1101,   0.0229,   0.8130,   0.0031,  2.03e-16,  1.52e-16,  1.02e-16,  nan ],
	[    36,   0.0860,   0.0310,   0.0804,   0.0331,   0.1152,   0.0231,   1.2415,   0.0021,  9.87e-17,  9.87e-17,  1.48e-16,  nan ],
	[    37,   0.0907,   0.0310,   0.0855,   0.0329,   0.1229,   0.0229,   0.9073,   0.0031,  9.60e-17,  1.44e-16,  9.60e-17,  nan ],
	[    38,   0.0956,   0.0310,   0.0875,   0.0339,   0.1295,   0.0229,   1.3813,   0.0021,  1.87e-16,  1.40e-16,  1.40e-16,  nan ],
	[    39,   0.1007,   0.0310,   0.0941,   0.0331,   0.1349,   0.0231,   1.0905,   0.0029,  9.11e-17,  1.37e-16,  9.11e-17,  nan ],
	[    40,   0.1101,   0.0298,   0.1019,   0.0322,   0.1433,   0.0229,   1.7197,   0.0019,  1.78e-16,  1.33e-16,  1.33e-16,  nan ],
	[    41,   0.1146,   0.0300,   0.1078,   0.0319,   0.1570,   0.0219,   1.6050,   0.0021,  1.30e-16,  1.30e-16,  1.30e-16,  nan ],
	[    42,   0.1165,   0.0310,   0.1059,   0.0341,   0.1443,   0.0250,   1.8937,   0.0019,  1.69e-16,  1.27e-16,  1.27e-16,  nan ],
	[    43,   0.1221,   0.0310,   0.1150,   0.0329,   0.1636,   0.0231,   1.9839,   0.0019,  2.48e-16,  1.24e-16,  1.65e-16,  nan ],
	[    44,   0.1318,   0.0300,   0.1161,   0.0341,   0.1805,   0.0219,   1.3841,   0.0029,  1.61e-16,  1.61e-16,  1.61e-16,  nan ],
	[    45,   0.1120,   0.0370,   0.1258,   0.0329,   0.1887,   0.0219,   0.8269,   0.0050,  1.58e-16,  1.58e-16,  1.58e-16,  nan ],
	[    46,   0.1395,   0.0310,   0.1353,   0.0319,   0.1971,   0.0219,   1.3951,   0.0031,  1.54e-16,  1.54e-16,  1.54e-16,  nan ],
	[    47,   0.1502,   0.0300,   0.1371,   0.0329,   0.1951,   0.0231,   1.4557,   0.0031,  1.51e-16,  1.51e-16,  1.13e-16,  nan ],
	[    48,   0.1566,   0.0300,   0.1430,   0.0329,   0.2145,   0.0219,   2.1922,   0.0021,  1.48e-16,  1.48e-16,  1.48e-16,  nan ],
	[    49,   0.1631,   0.0300,   0.1534,   0.0319,   0.2119,   0.0231,   1.5809,   0.0031,  1.45e-16,  1.45e-16,  1.45e-16,  nan ],
	[    50,   0.1698,   0.0300,   0.1506,   0.0339,   0.2325,   0.0219,   1.6455,   0.0031,  1.42e-16,  1.42e-16,  1.42e-16,  nan ],
	[    51,   0.1766,   0.0300,   0.1612,   0.0329,   0.2418,   0.0219,   1.7113,   0.0031,  1.39e-16,  1.39e-16,  1.39e-16,  nan ],
	[    52,   0.1835,   0.0300,   0.1583,   0.0348,   0.2513,   0.0219,   1.9266,   0.0029,  2.05e-16,  1.37e-16,  1.37e-16,  nan ],
	[    53,   0.1847,   0.0310,   0.1740,   0.0329,   0.2475,   0.0231,   1.8468,   0.0031,  1.34e-16,  2.01e-16,  1.34e-16,  nan ],
	[    54,   0.1859,   0.0319,   0.1695,   0.0350,   0.2491,   0.0238,   1.4655,   0.0041,  1.32e-16,  1.32e-16,  1.32e-16,  nan ],
	[    55,   0.1928,   0.0319,   0.1711,   0.0360,   0.2558,   0.0241,   1.5198,   0.0041,  1.94e-16,  1.94e-16,  1.29e-16,  nan ],
	[    56,   0.1998,   0.0319,   0.1886,   0.0339,   0.2760,   0.0231,   1.5751,   0.0041,  1.90e-16,  1.27e-16,  1.27e-16,  nan ],
	[    57,   0.2070,   0.0319,   0.1953,   0.0339,   0.2773,   0.0238,   1.7333,   0.0038,  1.25e-16,  1.87e-16,  1.87e-16,  nan ],
	[    58,   0.2126,   0.0322,   0.1901,   0.0360,   0.2990,   0.0229,   1.6886,   0.0041,  1.23e-16,  1.23e-16,  1.23e-16,  nan ],
	[    59,   0.2200,   0.0322,   0.2020,   0.0350,   0.2940,   0.0241,   1.4141,   0.0050,  1.20e-16,  1.81e-16,  1.20e-16,  nan ],
	[    60,   0.2291,   0.0319,   0.2089,   0.0350,   0.3040,   0.0241,   1.8060,   0.0041,  1.18e-16,  1.18e-16,  1.78e-16,  nan ],
	[    61,   0.2440,   0.0310,   0.2101,   0.0360,   0.2808,   0.0269,   1.5107,   0.0050,  1.75e-16,  2.33e-16,  2.91e-16,  nan ],
	[    62,   0.2520,   0.0310,   0.2170,   0.0360,   0.3244,   0.0241,   1.5603,   0.0050,  1.72e-16,  1.15e-16,  1.72e-16,  nan ],
	[    63,   0.2524,   0.0319,   0.2301,   0.0350,   0.3382,   0.0238,   1.3529,   0.0060,  1.13e-16,  1.69e-16,  2.26e-16,  nan ],
	[    64,   0.2684,   0.0310,   0.2458,   0.0339,   0.3490,   0.0238,   2.1810,   0.0038,  2.22e-16,  1.67e-16,  1.11e-16,  nan ],
	[    65,   0.2322,   0.0370,   0.2322,   0.0370,   0.3427,   0.0250,   1.7137,   0.0050,  2.73e-16,  2.19e-16,  3.28e-16,  nan ],
	[    66,   0.2457,   0.0360,   0.2393,   0.0370,   0.3533,   0.0250,   1.7664,   0.0050,  1.61e-16,  2.15e-16,  2.15e-16,  nan ],
	[    67,   0.2466,   0.0370,   0.2531,   0.0360,   0.3506,   0.0260,   1.8199,   0.0050,  1.59e-16,  1.59e-16,  1.59e-16,  nan ],
	[    68,   0.2607,   0.0360,   0.2539,   0.0370,   0.3611,   0.0260,   2.3153,   0.0041,  1.57e-16,  2.09e-16,  2.09e-16,  nan ],
	[    69,   0.2614,   0.0370,   0.2614,   0.0370,   0.3717,   0.0260,   1.9294,   0.0050,  2.06e-16,  2.06e-16,  2.06e-16,  nan ],
	[    70,   0.2690,   0.0370,   0.2690,   0.0370,   0.3825,   0.0260,   1.6677,   0.0060,  1.52e-16,  2.03e-16,  2.03e-16,  nan ],
	[    71,   0.2767,   0.0370,   0.2767,   0.0370,   0.3934,   0.0260,   1.7153,   0.0060,  3.00e-16,  2.50e-16,  2.50e-16,  nan ],
	[    72,   0.2845,   0.0370,   0.2826,   0.0372,   0.3868,   0.0272,   1.7636,   0.0060,  1.48e-16,  1.48e-16,  9.87e-17,  nan ],
	[    73,   0.2924,   0.0370,   0.3001,   0.0360,   0.4157,   0.0260,   2.1579,   0.0050,  1.46e-16,  1.46e-16,  1.46e-16,  nan ],
	[    74,   0.3083,   0.0360,   0.3083,   0.0360,   0.4271,   0.0260,   1.7906,   0.0062,  2.40e-16,  2.88e-16,  2.40e-16,  nan ],
	[    75,   0.3065,   0.0372,   0.3085,   0.0370,   0.4231,   0.0269,   1.9126,   0.0060,  1.42e-16,  1.42e-16,  1.42e-16,  nan ],
	[    76,   0.3251,   0.0360,   0.3339,   0.0350,   0.4675,   0.0250,   1.9636,   0.0060,  1.40e-16,  1.87e-16,  1.40e-16,  nan ],
	[    77,   0.3337,   0.0360,   0.3337,   0.0360,   0.4798,   0.0250,   2.0153,   0.0060,  1.85e-16,  1.85e-16,  2.31e-16,  nan ],
	[    78,   0.3516,   0.0350,   0.3423,   0.0360,   0.4742,   0.0260,   1.7230,   0.0072,  2.28e-16,  1.37e-16,  1.37e-16,  nan ],
	[    79,   0.3511,   0.0360,   0.3607,   0.0350,   0.5049,   0.0250,   2.0391,   0.0062,  1.80e-16,  1.80e-16,  1.80e-16,  nan ],
	[    80,   0.3600,   0.0360,   0.3698,   0.0350,   0.5227,   0.0248,   2.1743,   0.0060,  1.78e-16,  1.33e-16,  1.78e-16,  nan ],
	[    81,   0.3690,   0.0360,   0.3816,   0.0348,   0.5112,   0.0260,   2.2287,   0.0060,  1.75e-16,  1.75e-16,  1.75e-16,  nan ],
	[    82,   0.3683,   0.0370,   0.3683,   0.0370,   0.5238,   0.0260,   1.9687,   0.0069,  2.60e-16,  2.60e-16,  2.60e-16,  nan ],
	[    83,   0.3773,   0.0370,   0.3773,   0.0370,   0.5366,   0.0260,   2.7850,   0.0050,  1.71e-16,  2.57e-16,  1.71e-16,  nan ],
	[    84,   0.3864,   0.0370,   0.3864,   0.0370,   0.5495,   0.0260,   1.9965,   0.0072,  1.69e-16,  1.69e-16,  1.69e-16,  nan ],
	[    85,   0.4061,   0.0360,   0.3931,   0.0372,   0.5626,   0.0260,   2.4528,   0.0060,  2.51e-16,  2.51e-16,  2.51e-16,  nan ],
	[    86,   0.4049,   0.0370,   0.3923,   0.0381,   0.5758,   0.0260,   2.1643,   0.0069,  2.07e-16,  2.07e-16,  1.65e-16,  nan ],
	[    87,   0.4143,   0.0370,   0.4039,   0.0379,   0.5892,   0.0260,   1.8889,   0.0081,  2.04e-16,  2.04e-16,  2.04e-16,  nan ],
	[    88,   0.4351,   0.0360,   0.4106,   0.0381,   0.6027,   0.0260,   2.2655,   0.0069,  2.02e-16,  1.61e-16,  1.21e-16,  nan ],
	[    89,   0.4335,   0.0370,   0.4200,   0.0381,   0.6164,   0.0260,   2.3170,   0.0069,  2.00e-16,  3.19e-16,  1.60e-16,  nan ],
	[    90,   0.4432,   0.0370,   0.4321,   0.0379,   0.6303,   0.0260,   2.3691,   0.0069,  1.58e-16,  2.37e-16,  2.37e-16,  nan ],
	[   100,   0.5198,   0.0389,   0.5166,   0.0391,   0.6945,   0.0291,   3.3890,   0.0060,  2.13e-16,  1.42e-16,  2.13e-16,  nan ],
	[   110,   0.6284,   0.0389,   0.6245,   0.0391,   0.8395,   0.0291,   2.7682,   0.0088,  3.23e-16,  3.23e-16,  3.23e-16,  nan ],
	[   120,   0.7661,   0.0379,   0.7294,   0.0398,   0.9984,   0.0291,   2.9001,   0.0100,  3.55e-16,  4.74e-16,  3.55e-16,  nan ],
	[   130,   0.8117,   0.0420,   0.8306,   0.0410,   1.1710,   0.0291,   2.8572,   0.0119,  3.28e-16,  2.19e-16,  2.73e-16,  nan ],
	[   140,   0.9149,   0.0432,   0.9627,   0.0410,   1.3142,   0.0300,   3.5998,   0.0110,  4.06e-16,  4.06e-16,  3.55e-16,  nan ],
	[   150,   1.0556,   0.0429,   1.0735,   0.0422,   1.5080,   0.0300,   0.8520,   0.0532,  1.42e-16,  1.42e-16,  1.42e-16,  nan ],
	[   160,   1.2278,   0.0420,   1.2563,   0.0410,   1.7150,   0.0300,   1.2005,   0.0429,  1.78e-16,  1.33e-16,  1.33e-16,  nan ],
	[   170,   1.2902,   0.0451,   1.3253,   0.0439,   1.7671,   0.0329,   2.3224,   0.0250,  1.67e-16,  1.67e-16,  1.67e-16,  nan ],
	[   180,   1.4460,   0.0451,   1.4460,   0.0451,   1.9112,   0.0341,   2.2402,   0.0291,  1.58e-16,  1.58e-16,  1.58e-16,  nan ],
	[   190,   1.6107,   0.0451,   1.6107,   0.0451,   2.1288,   0.0341,   2.6019,   0.0279,  2.24e-16,  1.50e-16,  1.50e-16,  nan ],
	[   200,   1.6058,   0.0501,   1.7031,   0.0472,   2.2333,   0.0360,   1.6777,   0.0479,  2.13e-16,  1.42e-16,  1.42e-16,  nan ],
	[   210,   1.7700,   0.0501,   1.9259,   0.0460,   2.4616,   0.0360,   2.5459,   0.0348,  2.03e-16,  2.03e-16,  1.35e-16,  nan ],
	[   220,   1.9515,   0.0498,   2.0703,   0.0470,   2.7010,   0.0360,   3.0437,   0.0319,  1.94e-16,  1.94e-16,  1.29e-16,  nan ],
	[   230,   2.1223,   0.0501,   2.2624,   0.0470,   2.8754,   0.0370,   2.1325,   0.0498,  1.85e-16,  1.85e-16,  1.85e-16,  nan ],
	[   240,   2.3105,   0.0501,   2.4139,   0.0479,   3.0325,   0.0381,   3.1102,   0.0372,  1.78e-16,  1.78e-16,  1.18e-16,  nan ],
	[   250,   2.4597,   0.0510,   2.5186,   0.0498,   3.2899,   0.0381,   3.3960,   0.0370,  1.71e-16,  1.71e-16,  2.27e-16,  nan ],
	[   260,   2.4223,   0.0560,   2.6601,   0.0510,   3.3884,   0.0401,   2.6601,   0.0510,  2.19e-16,  1.64e-16,  1.09e-16,  nan ],
	[   270,   2.4454,   0.0598,   2.5682,   0.0570,   3.0537,   0.0479,   3.7426,   0.0391,  1.58e-16,  2.11e-16,  1.58e-16,  nan ],
	[   280,   2.8086,   0.0560,   3.0842,   0.0510,   3.4198,   0.0460,   4.4899,   0.0350,  1.52e-16,  1.52e-16,  1.52e-16,  nan ],
	[   290,   2.7227,   0.0620,   2.9132,   0.0579,   3.4532,   0.0489,   2.6317,   0.0641,  2.45e-16,  1.96e-16,  1.96e-16,  nan ],
	[   300,   2.9134,   0.0620,   3.0668,   0.0589,   3.6951,   0.0489,   4.0079,   0.0451,  1.89e-16,  1.42e-16,  1.89e-16,  nan ],
	[   310,   3.0634,   0.0629,   3.2093,   0.0601,   3.9451,   0.0489,   4.1904,   0.0460,  2.29e-16,  2.29e-16,  2.29e-16,  nan ],
	[   320,   3.4194,   0.0601,   3.4886,   0.0589,   4.2870,   0.0479,   2.8532,   0.0720,  1.78e-16,  1.78e-16,  1.78e-16,  nan ],
	[   330,   3.2038,   0.0682,   3.5792,   0.0610,   4.2817,   0.0510,   4.3633,   0.0501,  2.15e-16,  1.72e-16,  2.15e-16,  nan ],
	[   340,   3.1373,   0.0739,   3.7407,   0.0620,   4.5447,   0.0510,   4.3810,   0.0529,  1.67e-16,  2.51e-16,  2.09e-16,  nan ],
	[   350,   3.7204,   0.0660,   3.9636,   0.0620,   4.8156,   0.0510,   4.3853,   0.0560,  1.62e-16,  1.62e-16,  1.62e-16,  nan ],
	[   360,   3.8252,   0.0679,   4.1295,   0.0629,   4.9107,   0.0529,   3.2159,   0.0808,  1.58e-16,  2.37e-16,  1.97e-16,  nan ],
	[   370,   3.9707,   0.0691,   4.2807,   0.0641,   5.1870,   0.0529,   4.5877,   0.0598,  1.54e-16,  2.30e-16,  2.30e-16,  nan ],
	[   380,   4.2614,   0.0679,   4.6712,   0.0620,   5.6752,   0.0510,   4.9170,   0.0589,  2.24e-16,  2.24e-16,  2.24e-16,  nan ],
	[   390,   4.1131,   0.0741,   4.6856,   0.0651,   5.7621,   0.0529,   3.4666,   0.0880,  2.19e-16,  2.19e-16,  2.19e-16,  nan ],
	[   400,   4.6398,   0.0691,   5.3394,   0.0601,   6.1722,   0.0520,   5.1751,   0.0620,  2.13e-16,  2.13e-16,  2.84e-16,  nan ],
	[   410,   4.6195,   0.0730,   5.1031,   0.0660,   5.9145,   0.0570,   5.0305,   0.0670,  2.77e-16,  2.08e-16,  2.08e-16,  nan ],
	[   420,   4.3626,   0.0811,   5.1324,   0.0689,   5.9809,   0.0591,   3.6444,   0.0970,  2.03e-16,  2.71e-16,  2.03e-16,  nan ],
	[   430,   4.9354,   0.0751,   5.3609,   0.0691,   6.0729,   0.0610,   5.3609,   0.0691,  1.98e-16,  2.64e-16,  1.98e-16,  nan ],
	[   440,   5.0394,   0.0770,   5.4622,   0.0710,   6.3583,   0.0610,   5.3898,   0.0720,  1.94e-16,  1.94e-16,  1.94e-16,  nan ],
	[   450,   4.7160,   0.0861,   5.4918,   0.0739,   6.5480,   0.0620,   3.8692,   0.1049,  1.89e-16,  1.89e-16,  1.89e-16,  nan ],
	[   460,   5.1117,   0.0830,   5.8134,   0.0730,   6.3306,   0.0670,   5.3743,   0.0789,  2.47e-16,  1.85e-16,  1.85e-16,  nan ],
	[   470,   5.3982,   0.0820,   5.9140,   0.0749,   6.6085,   0.0670,   5.5267,   0.0801,  2.42e-16,  1.81e-16,  2.42e-16,  nan ],
	[   480,   5.6301,   0.0820,   6.3293,   0.0730,   6.9919,   0.0660,   4.0518,   0.1140,  2.37e-16,  2.37e-16,  2.37e-16,  nan ],
	[   490,   5.3392,   0.0901,   6.1719,   0.0780,   6.5955,   0.0730,   5.6533,   0.0851,  2.32e-16,  2.32e-16,  1.74e-16,  nan ],
	[   500,   5.7571,   0.0870,   6.4261,   0.0780,   6.5057,   0.0770,   5.5009,   0.0911,  2.27e-16,  2.84e-16,  1.71e-16,  nan ],
	[   510,   6.0558,   0.0861,   6.5258,   0.0799,   7.2389,   0.0720,   6.0558,   0.0861,  2.23e-16,  2.23e-16,  2.23e-16,  nan ],
	[   520,   6.0123,   0.0901,   6.6065,   0.0820,   7.2147,   0.0751,   4.3705,   0.1240,  2.19e-16,  2.19e-16,  2.19e-16,  nan ],
	[   530,   6.1161,   0.0920,   6.8628,   0.0820,   7.3090,   0.0770,   5.8581,   0.0961,  2.15e-16,  2.68e-16,  2.15e-16,  nan ],
	[   540,   6.3488,   0.0920,   7.1240,   0.0820,   7.1240,   0.0820,   5.9626,   0.0980,  2.63e-16,  2.63e-16,  1.58e-16,  nan ],
	[   550,   6.2461,   0.0970,   7.0616,   0.0858,   7.2016,   0.0842,   5.8307,   0.1040,  2.58e-16,  2.58e-16,  2.07e-16,  nan ],
	[   560,   6.4910,   0.0968,   7.3820,   0.0851,   7.8668,   0.0799,   6.1004,   0.1030,  2.03e-16,  2.03e-16,  3.05e-16,  nan ],
	[   570,   6.7082,   0.0970,   4.9731,   0.1309,   7.7564,   0.0839,   6.2620,   0.1040,  2.99e-16,  1.99e-16,  1.99e-16,  nan ],
	[   580,   6.7465,   0.0999,   7.6607,   0.0880,   8.0079,   0.0842,   6.4835,   0.1040,  2.94e-16,  1.96e-16,  1.96e-16,  nan ],
	[   590,   6.8342,   0.1020,   7.8419,   0.0889,   8.2164,   0.0849,   6.1709,   0.1130,  2.89e-16,  2.89e-16,  2.89e-16,  nan ],
	[   600,   7.0676,   0.1020,   7.9187,   0.0911,   8.5936,   0.0839,   6.5617,   0.1099,  2.37e-16,  2.37e-16,  1.89e-16,  nan ],
	[   610,   7.0259,   0.1061,   7.8359,   0.0951,   8.5658,   0.0870,   6.5960,   0.1130,  2.80e-16,  1.86e-16,  2.33e-16,  nan ],
	[   620,   7.3404,   0.1049,   8.1150,   0.0949,   8.7528,   0.0880,   6.6869,   0.1152,  2.29e-16,  1.83e-16,  2.75e-16,  nan ],
	[   630,   7.4436,   0.1068,   8.3577,   0.0951,   8.8220,   0.0901,   6.6297,   0.1199,  2.71e-16,  2.26e-16,  2.71e-16,  nan ],
	[   640,   7.7334,   0.1061,   8.5606,   0.0958,   8.9154,   0.0920,   6.4687,   0.1268,  2.66e-16,  2.66e-16,  3.11e-16,  nan ],
	[   650,   7.6173,   0.1111,   8.6366,   0.0980,   9.1960,   0.0920,   6.7228,   0.1259,  2.62e-16,  2.62e-16,  2.62e-16,  nan ],
	[   660,   7.6561,   0.1140,   8.7971,   0.0992,   9.3836,   0.0930,   6.4204,   0.1359,  2.58e-16,  2.58e-16,  2.15e-16,  nan ],
	[   670,   7.7598,   0.1159,   8.9155,   0.1009,   9.2888,   0.0968,   6.6163,   0.1359,  2.55e-16,  2.55e-16,  2.55e-16,  nan ],
	[   680,   7.9277,   0.1168,   9.0762,   0.1020,   9.8594,   0.0939,   7.1146,   0.1302,  2.51e-16,  2.51e-16,  2.51e-16,  nan ],
	[   690,   8.1458,   0.1171,   9.3449,   0.1020,   9.9246,   0.0961,   6.7561,   0.1411,  3.30e-16,  3.30e-16,  2.47e-16,  nan ],
	[   700,   8.2491,   0.1190,   9.2709,   0.1059,   9.8007,   0.1001,   6.8150,   0.1440,  2.44e-16,  2.44e-16,  3.25e-16,  nan ],
	[   710,   8.3524,   0.1209,   9.5161,   0.1061,  10.0825,   0.1001,   7.0578,   0.1431,  2.40e-16,  2.40e-16,  2.40e-16,  nan ],
	[   720,   8.7268,   0.1190,  10.0803,   0.1030,  10.3683,   0.1001,   7.1623,   0.1450,  2.37e-16,  2.37e-16,  2.37e-16,  nan ],
	[   730,   8.6085,   0.1240,  10.0594,   0.1061,   9.9697,   0.1070,   7.1623,   0.1490,  2.34e-16,  3.11e-16,  2.34e-16,  nan ],
	[   740,   8.8458,   0.1240,  10.1541,   0.1080,  10.3367,   0.1061,   7.2211,   0.1519,  3.07e-16,  3.07e-16,  2.30e-16,  nan ],
	[   750,   8.9317,   0.1261,  10.4302,   0.1080,  10.4533,   0.1078,   7.3141,   0.1540,  3.03e-16,  3.79e-16,  3.79e-16,  nan ],
	[   760,   9.0516,   0.1278,  10.7100,   0.1080,  10.8054,   0.1070,   7.3733,   0.1569,  2.99e-16,  2.24e-16,  2.24e-16,  nan ],
	[   770,   9.2739,   0.1280,  10.8027,   0.1099,  10.7794,   0.1101,   7.4776,   0.1588,  2.95e-16,  2.95e-16,  2.95e-16,  nan ],
	[   780,   9.5161,   0.1280,  10.9896,   0.1109,  10.9896,   0.1109,   7.5706,   0.1609,  2.19e-16,  2.19e-16,  2.19e-16,  nan ],
	[   790,   9.6007,   0.1302,  11.2488,   0.1111,  11.1769,   0.1118,   7.5315,   0.1659,  2.88e-16,  2.16e-16,  2.88e-16,  nan ],
	[   800,   9.7735,   0.1311,  11.2456,   0.1140,  11.6603,   0.1099,   7.4452,   0.1721,  2.84e-16,  2.84e-16,  3.55e-16,  nan ],
	[   810,  10.0375,   0.1309,  11.6257,   0.1130,  11.3153,   0.1161,   7.5487,   0.1740,  2.81e-16,  2.81e-16,  2.11e-16,  nan ],
	[   820,  10.1208,   0.1330,  11.2274,   0.1199,  12.0157,   0.1121,   7.8327,   0.1719,  2.77e-16,  2.77e-16,  2.77e-16,  nan ],
	[   830,  10.2952,   0.1340,  12.1043,   0.1140,  11.8806,   0.1161,   7.5831,   0.1819,  2.74e-16,  2.74e-16,  2.74e-16,  nan ],
	[   840,  10.3062,   0.1371,  12.2693,   0.1152,  12.3976,   0.1140,   7.9331,   0.1781,  2.71e-16,  3.38e-16,  2.71e-16,  nan ],
	[   850,  10.4800,   0.1380,  12.3582,   0.1171,  11.8514,   0.1221,   8.2221,   0.1760,  2.67e-16,  2.67e-16,  2.67e-16,  nan ],
	[   860,  10.7279,   0.1380,  12.6506,   0.1171,  12.4478,   0.1190,   7.9634,   0.1860,  2.64e-16,  2.64e-16,  2.64e-16,  nan ],
	[   870,  10.6655,   0.1421,  12.7387,   0.1190,  12.6374,   0.1199,   7.9359,   0.1910,  3.27e-16,  3.27e-16,  3.92e-16,  nan ],
	[   880,  10.8392,   0.1431,  13.0331,   0.1190,  13.0331,   0.1190,   8.0689,   0.1922,  3.23e-16,  2.58e-16,  2.58e-16,  nan ],
	[   890,  11.2366,   0.1411,  13.2248,   0.1199,  12.8916,   0.1230,   8.2635,   0.1919,  3.19e-16,  2.55e-16,  2.55e-16,  nan ],
	[   900,  11.9339,   0.1359,  14.2308,   0.1140,  14.6286,   0.1109,   8.4817,   0.1912,  2.53e-16,  2.53e-16,  2.53e-16,  nan ],
	[  1000,  13.2445,   0.1512,  15.7542,   0.1271,  15.4073,   0.1299,   8.8951,   0.2251,  2.84e-16,  2.84e-16,  2.84e-16,  nan ],
	[  1100,  14.0130,   0.1729,  17.6994,   0.1369,  11.1154,   0.2179,   9.0387,   0.2680,  3.10e-16,  3.10e-16,  3.10e-16,  nan ],
	[  1200,  15.5795,   0.1850,  19.6261,   0.1469,  11.6247,   0.2480,  10.9112,   0.2642,  3.32e-16,  2.84e-16,  2.84e-16,  nan ],
	[  1300,  17.0116,   0.1988,  21.0187,   0.1609,  12.8163,   0.2639,  10.3409,   0.3271,  3.50e-16,  2.62e-16,  3.06e-16,  nan ],
	[  1400,  18.6758,   0.2100,  23.3713,   0.1678,  14.1110,   0.2780,  14.0627,   0.2789,  3.25e-16,  3.25e-16,  3.25e-16,  nan ],
	[  1500,  19.9229,   0.2260,  25.1491,   0.1791,  14.9659,   0.3009,  11.2623,   0.3998,  3.79e-16,  3.03e-16,  3.79e-16,  nan ],
	[  1600,  21.6180,   0.2370,  26.9614,   0.1900,  16.2667,   0.3150,  14.5980,   0.3510,  3.55e-16,  3.55e-16,  3.55e-16,  nan ],
	[  1700,  22.7768,   0.2539,  28.3380,   0.2041,  17.3143,   0.3340,  13.7358,   0.4210,  3.34e-16,  3.34e-16,  4.01e-16,  nan ],
	[  1800,  24.1941,   0.2680,  30.7279,   0.2110,  18.2145,   0.3560,  15.8937,   0.4079,  3.79e-16,  3.79e-16,  3.79e-16,  nan ],
	[  1900,  25.2490,   0.2861,  31.5284,   0.2291,  19.2129,   0.3760,  13.6851,   0.5279,  3.59e-16,  3.59e-16,  2.99e-16,  nan ],
	[  2000,  27.1392,   0.2949,  34.7888,   0.2301,  20.7358,   0.3860,  16.5702,   0.4830,  3.98e-16,  4.55e-16,  3.41e-16,  nan ],
	[  2100,  28.2962,   0.3119,  35.4176,   0.2491,  15.3447,   0.5751,  15.6232,   0.5648,  4.33e-16,  3.25e-16,  3.25e-16,  nan ],
	[  2200,  29.2646,   0.3309,  36.3972,   0.2661,  16.0614,   0.6030,  13.8161,   0.7010,  5.17e-16,  3.62e-16,  3.62e-16,  nan ],
	[  2300,  30.8513,   0.3431,  37.6868,   0.2809,  16.6461,   0.6359,  13.7616,   0.7691,  3.95e-16,  4.45e-16,  3.95e-16,  nan ],
	[  2400,  33.3139,   0.3459,  40.5865,   0.2840,  17.7585,   0.6490,  13.8545,   0.8318,  4.26e-16,  4.26e-16,  3.79e-16,  nan ],
	[  2500,  34.2585,   0.3650,  41.5608,   0.3009,  18.3905,   0.6800,  16.0544,   0.7789,  4.55e-16,  4.09e-16,  4.09e-16,  nan ],
	[  2600,  35.4112,   0.3819,  43.9077,   0.3080,  19.0749,   0.7091,  15.5806,   0.8681,  5.25e-16,  3.94e-16,  4.81e-16,  nan ],
	[  2700,  36.0918,   0.4041,  43.4177,   0.3359,  19.6264,   0.7432,  15.6499,   0.9320,  4.21e-16,  4.21e-16,  4.63e-16,  nan ],
	[  2800,  37.1696,   0.4220,  44.0363,   0.3562,  20.1132,   0.7799,  16.3049,   0.9620,  4.06e-16,  4.47e-16,  4.06e-16,  nan ],
	[  2900,  38.1679,   0.4408,  46.3378,   0.3631,  20.8794,   0.8059,  16.3970,   1.0262,  5.49e-16,  4.70e-16,  4.70e-16,  nan ],
	[  3000,  39.4786,   0.4561,  47.2607,   0.3810,  21.7456,   0.8280,  16.4430,   1.0951,  5.31e-16,  4.55e-16,  5.31e-16,  nan ],
	[  3100,  41.6962,   0.4611,  50.2120,   0.3829,  17.4622,   1.1010,   3.0891,   6.2239,  5.13e-16,  5.13e-16,  5.87e-16,  nan ],
	[  3200,  42.2449,   0.4849,  50.8439,   0.4029,  18.0973,   1.1320,  15.2082,   1.3471,  4.97e-16,  4.97e-16,  5.68e-16,  nan ],
	[  3300,  44.3806,   0.4909,  52.3665,   0.4160,  18.7330,   1.1630,  15.6526,   1.3919,  4.82e-16,  4.82e-16,  4.82e-16,  nan ],
	[  3400,  45.3487,   0.5100,  53.0349,   0.4361,  19.2424,   1.2019,  15.3143,   1.5101,  5.35e-16,  4.68e-16,  5.35e-16,  nan ],
	[  3500,  45.4621,   0.5391,  54.8212,   0.4470,  19.8283,   1.2360,  15.1652,   1.6160,  5.20e-16,  5.85e-16,  5.20e-16,  nan ],
	[  3600,  46.9748,   0.5519,  56.8758,   0.4559,  20.3189,   1.2760,  15.4689,   1.6761,  5.68e-16,  4.42e-16,  4.42e-16,  nan ],
	[  3700,  47.6248,   0.5751,  56.0074,   0.4890,  20.6863,   1.3239,  16.9052,   1.6201,  6.76e-16,  6.15e-16,  5.53e-16,  nan ],
	[  3800,  48.8956,   0.5908,  59.0753,   0.4890,  21.1491,   1.3659,  16.4134,   1.7600,  5.39e-16,  5.98e-16,  4.79e-16,  nan ],
	[  3900,  49.4856,   0.6149,  57.8529,   0.5260,  21.7973,   1.3959,   4.8615,   6.2590,  4.66e-16,  6.41e-16,  4.66e-16,  nan ],
	[  4000,  48.8720,   0.6549,  60.0408,   0.5331,  22.2270,   1.4400,  14.3861,   2.2249,  5.12e-16,  5.68e-16,  5.12e-16,  nan ],
	[  4100,  48.4531,   0.6940,  61.4851,   0.5469,  18.2869,   1.8389,  16.9162,   1.9879,  4.99e-16,  5.55e-16,  5.55e-16,  nan ],
	[  4200,  48.3536,   0.7298,  64.3803,   0.5481,  19.0538,   1.8520,   9.4836,   3.7210,  7.04e-16,  5.41e-16,  4.87e-16,  nan ],
	[  4300,  48.6184,   0.7608,  63.3489,   0.5839,  19.5392,   1.8930,  15.9365,   2.3210,  6.35e-16,  6.35e-16,  4.76e-16,  nan ],
	[  4400,  49.4040,   0.7839,  65.0803,   0.5951,  19.9338,   1.9429,  17.9294,   2.1601,  5.68e-16,  5.17e-16,  5.68e-16,  nan ],
	[  4500,  50.1349,   0.8080,  63.6118,   0.6368,  20.3970,   1.9860,  15.3512,   2.6388,  6.06e-16,  6.57e-16,  5.56e-16,  nan ],
	[  4600,  51.3571,   0.8242,  65.3207,   0.6480,  20.8529,   2.0299,   6.2590,   6.7630,  4.94e-16,  6.43e-16,  5.93e-16,  nan ],
	[  4700,  50.6819,   0.8719,  65.7714,   0.6719,  21.2965,   2.0750,   3.7332,  11.8370,  5.81e-16,  5.32e-16,  5.81e-16,  nan ],
	[  4800,  50.8186,   0.9069,  65.9549,   0.6988,  21.6574,   2.1281,  12.9393,   3.5620,  6.16e-16,  5.68e-16,  5.68e-16,  nan ],
	[  4900,  50.7179,   0.9470,  66.4199,   0.7231,  22.0310,   2.1801,   2.2890,  20.9830,  6.50e-16,  6.50e-16,  6.03e-16,  nan ],
	[  5000,  51.3985,   0.9730,  66.3369,   0.7539,  22.4772,   2.2249,  20.4641,   2.4438,  6.37e-16,  5.46e-16,  6.37e-16,  nan ],
	[  5100,  52.2332,   0.9961,  66.1906,   0.7861,  22.8394,   2.2781,  16.6068,   3.1331,  8.47e-16,  7.58e-16,  6.24e-16,  nan ],
	[  5200,  52.2625,   1.0350,  67.1019,   0.8061,  19.8714,   2.7220,  19.3378,   2.7971,  7.00e-16,  6.12e-16,  7.43e-16,  nan ],
	[  5300,  52.7131,   1.0660,  66.3515,   0.8469,  20.1833,   2.7840,  19.3561,   2.9030,  6.44e-16,  6.44e-16,  6.01e-16,  nan ],
	[  5400,  52.5015,   1.1110,  67.9226,   0.8588,  20.4820,   2.8479,  16.1001,   3.6230,  8.42e-16,  6.74e-16,  7.58e-16,  nan ],
	[  5500,  53.0411,   1.1408,  67.6083,   0.8950,  20.8513,   2.9020,  16.9359,   3.5729,  8.27e-16,  6.61e-16,  6.61e-16,  nan ],
	[  5600,  54.2726,   1.1559,  67.0183,   0.9360,  21.2858,   2.9471,  16.6972,   3.7570,  7.31e-16,  6.50e-16,  7.31e-16,  nan ],
	[  5700,  54.2044,   1.1990,  67.6915,   0.9601,  21.5047,   3.0222,  20.7044,   3.1390,  7.18e-16,  6.38e-16,  5.58e-16,  nan ],
	[  5800,  53.9246,   1.2479,  67.0248,   1.0040,  21.8132,   3.0849,  15.5018,   4.3409,  7.84e-16,  7.84e-16,  7.84e-16,  nan ],
	[  5900,  55.1363,   1.2629,  66.4370,   1.0481,  22.1759,   3.1400,  20.0906,   3.4659,  7.71e-16,  7.71e-16,  6.94e-16,  nan ],
	[  6000,  54.5889,   1.3192,  66.9267,   1.0760,  22.5605,   3.1919,  16.4036,   4.3900,  6.82e-16,  6.82e-16,  6.06e-16,  nan ],
	[  6100,  55.2258,   1.3478,  67.9120,   1.0960,  22.7495,   3.2718,   3.0494,  24.4091,  7.45e-16,  6.71e-16,  7.45e-16,  nan ],
	[  6200,  55.7590,   1.3790,  67.0918,   1.1461,  20.1922,   3.8080,  21.2948,   3.6108,  8.07e-16,  7.33e-16,  6.60e-16,  nan ],
	[  6300,  56.2304,   1.4119,  67.1094,   1.1830,  20.6638,   3.8421,  21.4975,   3.6931,  8.66e-16,  7.22e-16,  8.66e-16,  nan ],
	[  6400,  57.0186,   1.4369,  66.4445,   1.2331,  20.8223,   3.9349,  20.8741,   3.9251,  7.11e-16,  8.53e-16,  7.11e-16,  nan ],
	[  6500,  57.2192,   1.4770,  67.9849,   1.2431,  21.0445,   4.0159,  12.8890,   6.5570,  7.70e-16,  8.40e-16,  7.70e-16,  nan ],
	[  6600,  57.8173,   1.5070,  68.6703,   1.2689,  21.4034,   4.0710,  21.3409,   4.0829,  8.27e-16,  7.58e-16,  6.89e-16,  nan ],
	[  6700,  57.7817,   1.5540,  68.1913,   1.3168,  21.6523,   4.1471,  16.8187,   5.3389,  8.14e-16,  7.47e-16,  6.79e-16,  nan ],
	[  6800,  57.7043,   1.6029,  68.0130,   1.3599,  22.0274,   4.1990,  20.9508,   4.4148,  7.36e-16,  6.69e-16,  6.69e-16,  nan ],
	[  6900,  58.5688,   1.6260,  67.8281,   1.4040,  22.1370,   4.3020,  16.1985,   5.8792,  7.25e-16,  7.25e-16,  7.25e-16,  nan ],
	[  7000,  58.4116,   1.6780,  68.6426,   1.4279,  22.5532,   4.3459,  19.9981,   4.9012,  8.45e-16,  8.45e-16,  8.45e-16,  nan ],
	[  7100,  58.1186,   1.7350,  68.6351,   1.4691,  22.8339,   4.4160,  17.6008,   5.7290,  7.69e-16,  8.97e-16,  7.69e-16,  nan ],
	[  7200,  59.8412,   1.7328,  68.5787,   1.5121,  20.3369,   5.0988,  18.8606,   5.4979,  7.58e-16,  9.47e-16,  8.21e-16,  nan ],
	[  7300,  60.1898,   1.7710,  68.8573,   1.5481,  20.7794,   5.1298,  17.1155,   6.2280,  8.72e-16,  9.34e-16,  8.10e-16,  nan ],
	[  7400,  60.0552,   1.8239,  68.7655,   1.5929,  21.0272,   5.2092,  14.0754,   7.7820,  7.37e-16,  8.60e-16,  7.37e-16,  nan ],
	[  7500,  60.2018,   1.8690,  69.1157,   1.6279,  21.3221,   5.2769,   9.1557,  12.2890,  8.49e-16,  8.49e-16,  6.67e-16,  nan ],
	[  7600,  61.1624,   1.8890,  69.6050,   1.6599,  21.6238,   5.3430,  16.5853,   6.9661,  8.38e-16,  7.78e-16,  7.78e-16,  nan ],
	[  7700,  60.8174,   1.9500,  69.3953,   1.7090,  21.8773,   5.4209,  21.5793,   5.4958,  9.45e-16,  7.68e-16,  8.86e-16,  nan ],
	[  7800,  61.0633,   1.9929,  69.4649,   1.7519,  22.0421,   5.5211,  21.9115,   5.5540,  8.16e-16,  7.58e-16,  7.00e-16,  nan ],
	[  7900,  60.3921,   2.0671,  69.5536,   1.7948,  22.2922,   5.6000,  16.9088,   7.3829,  8.63e-16,  8.63e-16,  6.91e-16,  nan ],
	[  8000,  59.9864,   2.1341,  69.1574,   1.8511,  22.1793,   5.7719,  18.2906,   6.9990,  8.53e-16,  8.53e-16,  7.39e-16,  nan ],
	[  8100,  60.5350,   2.1679,  70.5156,   1.8611,  22.8799,   5.7359,  18.5911,   7.0591,  7.86e-16,  7.86e-16,  6.74e-16,  nan ],
	[  8200,  60.8280,   2.2111,  70.6385,   1.9040,  20.5022,   6.5601,  20.6093,   6.5260,  7.21e-16,  9.43e-16,  7.76e-16,  nan ],
	[  8300,  61.5441,   2.2390,  71.2828,   1.9331,  21.1282,   6.5219,  21.2814,   6.4750,  9.31e-16,  8.22e-16,  6.57e-16,  nan ],
	[  8400,  60.5225,   2.3320,  72.1212,   1.9569,  21.1948,   6.6590,  21.8512,   6.4590,  8.12e-16,  7.58e-16,  6.50e-16,  nan ],
	[  8500,  61.5254,   2.3489,  70.9443,   2.0370,  21.4194,   6.7470,  20.7905,   6.9511,  8.02e-16,  8.56e-16,  6.95e-16,  nan ],
	[  8600,  61.1324,   2.4199,  72.1253,   2.0511,  21.6441,   6.8350,  19.8089,   7.4682,  9.52e-16,  1.22e-15,  1.00e-15,  nan ],
	[  8700,  60.9704,   2.4831,  72.0943,   2.1000,  21.9354,   6.9020,  19.1764,   7.8950,  8.89e-16,  7.84e-16,  6.27e-16,  nan ],
	[  8800,  60.4811,   2.5611,  72.1795,   2.1460,  21.9771,   7.0481,  17.6843,   8.7590,  9.30e-16,  7.75e-16,  9.82e-16,  nan ],
	[  8900,  61.1012,   2.5930,  71.9195,   2.2030,  22.3029,   7.1039,  22.5565,   7.0240,  1.02e-15,  9.20e-16,  7.66e-16,  nan ],
	[  9000,  61.4869,   2.6350,  73.1410,   2.2151,  22.5525,   7.1840,  17.5572,   9.2280,  8.59e-16,  8.08e-16,  8.08e-16,  nan ],
	[ 10000,  62.8564,   3.1822,  73.0788,   2.7370,  22.4035,   8.9281,  21.2720,   9.4030,  1.14e-15,  9.09e-16,  8.64e-16,  nan ],
	[ 12000,  64.1323,   4.4911,  72.5126,   3.9721,  22.5124,  12.7940,  19.2103,  14.9932,  1.14e-15,  9.09e-16,  9.09e-16,  nan ],
	[ 14000,  66.8979,   5.8601,  74.2341,   5.2810,  22.5186,  17.4091,  12.2374,  32.0351,  1.30e-15,  1.10e-15,  1.17e-15,  nan ],
	[ 16000,  67.5309,   7.5822,  73.9385,   6.9251,  22.5514,  22.7051,  22.4320,  22.8260,  1.14e-15,  1.08e-15,  1.02e-15,  nan ],
	[ 18000,  67.5529,   9.5930,  74.4429,   8.7051,  21.5724,  30.0400,  23.1086,  28.0430,  1.26e-15,  1.52e-15,  1.16e-15,  nan ],
	[ 20000,  69.3451,  11.5371,  74.4979,  10.7391,  21.3060,  37.5500,  23.9261,  33.4380,  1.50e-15,  1.27e-15,  1.27e-15,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/setup.txt
# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/sgeev.txt
# numactl --interleave=all ./testing_sgeev -RN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgeev_RN = array([
	[    10,  nan,    0.0004 ],
	[    20,  nan,    0.0006 ],
	[    30,  nan,    0.0011 ],
	[    40,  nan,    0.0036 ],
	[    50,  nan,    0.0042 ],
	[    60,  nan,    0.0033 ],
	[    70,  nan,    0.0054 ],
	[    80,  nan,    0.0085 ],
	[    90,  nan,    0.0091 ],
	[   100,  nan,    0.0117 ],
	[   200,  nan,    0.0489 ],
	[   300,  nan,    0.0945 ],
	[   400,  nan,    0.1520 ],
	[   500,  nan,    0.1932 ],
	[   600,  nan,    0.4097 ],
	[   700,  nan,    0.3163 ],
	[   800,  nan,    0.3919 ],
	[   900,  nan,    0.4874 ],
	[  1000,  nan,    0.5590 ],
	[  2000,  nan,    1.5849 ],
	[  3000,  nan,    4.3722 ],
	[  4000,  nan,    6.7113 ],
	[  5000,  nan,   10.2678 ],
	[  6000,  nan,   19.3033 ],
	[  7000,  nan,   28.3088 ],
	[  8000,  nan,   33.5227 ],
	[  9000,  nan,   41.2253 ],
	[ 10000,  nan,   49.3605 ],
	[ 12000,  nan,   67.5125 ],
	[ 14000,  nan,   93.4652 ],
	[ 16000,  nan,  126.9086 ],
	[ 18000,  nan,  161.3364 ],
	[ 20000,  nan,  206.5495 ],
])

# numactl --interleave=all ./testing_sgeev -RV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgeev_RV = array([
	[    10,  nan,    0.0015 ],
	[    20,  nan,    0.0025 ],
	[    30,  nan,    0.0025 ],
	[    40,  nan,    0.0039 ],
	[    50,  nan,    0.0045 ],
	[    60,  nan,    0.0041 ],
	[    70,  nan,    0.0060 ],
	[    80,  nan,    0.0082 ],
	[    90,  nan,    0.0090 ],
	[   100,  nan,    0.0122 ],
	[   200,  nan,    0.0439 ],
	[   300,  nan,    0.1166 ],
	[   400,  nan,    0.1348 ],
	[   500,  nan,    0.1697 ],
	[   600,  nan,    0.2631 ],
	[   700,  nan,    0.3950 ],
	[   800,  nan,    0.5128 ],
	[   900,  nan,    0.6054 ],
	[  1000,  nan,    0.7472 ],
	[  2000,  nan,    2.1411 ],
	[  3000,  nan,    5.9891 ],
	[  4000,  nan,    9.7285 ],
	[  5000,  nan,   15.6502 ],
	[  6000,  nan,   24.9938 ],
	[  7000,  nan,   32.3044 ],
	[  8000,  nan,   43.2878 ],
	[  9000,  nan,   53.4072 ],
	[ 10000,  nan,   78.3079 ],
	[ 12000,  nan,   98.0557 ],
	[ 14000,  nan,  139.6687 ],
	[ 16000,  nan,  192.7468 ],
	[ 18000,  nan,  246.5340 ],
	[ 20000,  nan,  316.4681 ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/sgeqrf.txt
# numactl --interleave=all ./testing_sgeqrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgeqrf = array([
	[    10,     10,  nan,  nan,     0.01,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.04,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.12,  0.00,  nan ],
	[    40,     40,  nan,  nan,     1.07,  0.00,  nan ],
	[    50,     50,  nan,  nan,     1.48,  0.00,  nan ],
	[    60,     60,  nan,  nan,     2.22,  0.00,  nan ],
	[    70,     70,  nan,  nan,     2.53,  0.00,  nan ],
	[    80,     80,  nan,  nan,     1.46,  0.00,  nan ],
	[    90,     90,  nan,  nan,     1.76,  0.00,  nan ],
	[   100,    100,  nan,  nan,     1.53,  0.00,  nan ],
	[   200,    200,  nan,  nan,     6.48,  0.00,  nan ],
	[   300,    300,  nan,  nan,    14.22,  0.00,  nan ],
	[   400,    400,  nan,  nan,    25.30,  0.00,  nan ],
	[   500,    500,  nan,  nan,    36.48,  0.00,  nan ],
	[   600,    600,  nan,  nan,    52.68,  0.01,  nan ],
	[   700,    700,  nan,  nan,    64.74,  0.01,  nan ],
	[   800,    800,  nan,  nan,    80.14,  0.01,  nan ],
	[   900,    900,  nan,  nan,    97.49,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,   112.62,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   316.39,  0.03,  nan ],
	[  3000,   3000,  nan,  nan,   568.03,  0.06,  nan ],
	[  4000,   4000,  nan,  nan,   728.14,  0.12,  nan ],
	[  5000,   5000,  nan,  nan,   934.81,  0.18,  nan ],
	[  6000,   6000,  nan,  nan,  1048.53,  0.27,  nan ],
	[  7000,   7000,  nan,  nan,  1116.13,  0.41,  nan ],
	[  8000,   8000,  nan,  nan,  1386.17,  0.49,  nan ],
	[  9000,   9000,  nan,  nan,  1487.87,  0.65,  nan ],
	[ 10000,  10000,  nan,  nan,  1589.34,  0.84,  nan ],
	[ 12000,  12000,  nan,  nan,  1726.17,  1.33,  nan ],
	[ 14000,  14000,  nan,  nan,  1787.23,  2.05,  nan ],
	[ 16000,  16000,  nan,  nan,  1873.62,  2.92,  nan ],
	[ 18000,  18000,  nan,  nan,  1906.54,  4.08,  nan ],
	[ 20000,  20000,  nan,  nan,  1936.86,  5.51,  nan ],
])

# numactl --interleave=all ./testing_sgeqrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgeqrf_gpu = array([
	[    10,     10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.04,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.10,  0.00,  nan ],
	[    50,     50,  nan,  nan,     0.18,  0.00,  nan ],
	[    60,     60,  nan,  nan,     0.27,  0.00,  nan ],
	[    70,     70,  nan,  nan,     0.41,  0.00,  nan ],
	[    80,     80,  nan,  nan,     0.60,  0.00,  nan ],
	[    90,     90,  nan,  nan,     0.79,  0.00,  nan ],
	[   100,    100,  nan,  nan,     0.83,  0.00,  nan ],
	[   200,    200,  nan,  nan,     6.99,  0.00,  nan ],
	[   300,    300,  nan,  nan,    14.65,  0.00,  nan ],
	[   400,    400,  nan,  nan,    25.22,  0.00,  nan ],
	[   500,    500,  nan,  nan,    29.15,  0.01,  nan ],
	[   600,    600,  nan,  nan,    44.10,  0.01,  nan ],
	[   700,    700,  nan,  nan,    55.32,  0.01,  nan ],
	[   800,    800,  nan,  nan,    72.09,  0.01,  nan ],
	[   900,    900,  nan,  nan,    85.90,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,   104.39,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   304.72,  0.04,  nan ],
	[  3000,   3000,  nan,  nan,   494.96,  0.07,  nan ],
	[  4000,   4000,  nan,  nan,   670.82,  0.13,  nan ],
	[  5000,   5000,  nan,  nan,   870.41,  0.19,  nan ],
	[  6000,   6000,  nan,  nan,  1014.38,  0.28,  nan ],
	[  7000,   7000,  nan,  nan,  1086.34,  0.42,  nan ],
	[  8000,   8000,  nan,  nan,  1324.67,  0.52,  nan ],
	[  9000,   9000,  nan,  nan,  1421.01,  0.68,  nan ],
	[ 10000,  10000,  nan,  nan,  1531.29,  0.87,  nan ],
	[ 12000,  12000,  nan,  nan,  1674.26,  1.38,  nan ],
	[ 14000,  14000,  nan,  nan,  1755.17,  2.08,  nan ],
	[ 16000,  16000,  nan,  nan,  1855.08,  2.94,  nan ],
	[ 18000,  18000,  nan,  nan,  1891.68,  4.11,  nan ],
	[ 20000,  20000,  nan,  nan,  1985.87,  5.37,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/sgetrf.txt
# numactl --interleave=all ./testing_sgetrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgetrf = array([
	[    10,     10,  nan,  nan,     0.03,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.08,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.46,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.78,  0.00,  nan ],
	[    50,     50,  nan,  nan,     1.64,  0.00,  nan ],
	[    60,     60,  nan,  nan,     2.50,  0.00,  nan ],
	[    70,     70,  nan,  nan,     1.94,  0.00,  nan ],
	[    80,     80,  nan,  nan,     2.99,  0.00,  nan ],
	[    90,     90,  nan,  nan,     3.19,  0.00,  nan ],
	[   100,    100,  nan,  nan,     4.54,  0.00,  nan ],
	[   200,    200,  nan,  nan,    15.40,  0.00,  nan ],
	[   300,    300,  nan,  nan,    10.80,  0.00,  nan ],
	[   400,    400,  nan,  nan,    21.34,  0.00,  nan ],
	[   500,    500,  nan,  nan,    31.76,  0.00,  nan ],
	[   600,    600,  nan,  nan,    41.53,  0.00,  nan ],
	[   700,    700,  nan,  nan,    53.96,  0.00,  nan ],
	[   800,    800,  nan,  nan,    65.58,  0.01,  nan ],
	[   900,    900,  nan,  nan,    79.93,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,    94.29,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   250.63,  0.02,  nan ],
	[  3000,   3000,  nan,  nan,   420.57,  0.04,  nan ],
	[  4000,   4000,  nan,  nan,   584.61,  0.07,  nan ],
	[  5000,   5000,  nan,  nan,   717.45,  0.12,  nan ],
	[  6000,   6000,  nan,  nan,   870.77,  0.17,  nan ],
	[  7000,   7000,  nan,  nan,  1013.93,  0.23,  nan ],
	[  8000,   8000,  nan,  nan,  1153.37,  0.30,  nan ],
	[  9000,   9000,  nan,  nan,  1258.18,  0.39,  nan ],
	[ 10000,  10000,  nan,  nan,  1345.26,  0.50,  nan ],
	[ 12000,  12000,  nan,  nan,  1494.13,  0.77,  nan ],
	[ 14000,  14000,  nan,  nan,  1604.54,  1.14,  nan ],
	[ 16000,  16000,  nan,  nan,  1684.49,  1.62,  nan ],
	[ 18000,  18000,  nan,  nan,  1763.92,  2.20,  nan ],
	[ 20000,  20000,  nan,  nan,  1916.93,  2.78,  nan ],
])

# numactl --interleave=all ./testing_sgetrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.01,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.05,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.24,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.45,  0.00,  nan ],
	[    50,     50,  nan,  nan,     0.85,  0.00,  nan ],
	[    60,     60,  nan,  nan,     1.37,  0.00,  nan ],
	[    70,     70,  nan,  nan,     1.34,  0.00,  nan ],
	[    80,     80,  nan,  nan,     2.27,  0.00,  nan ],
	[    90,     90,  nan,  nan,     2.40,  0.00,  nan ],
	[   100,    100,  nan,  nan,     3.02,  0.00,  nan ],
	[   200,    200,  nan,  nan,     9.57,  0.00,  nan ],
	[   300,    300,  nan,  nan,     8.65,  0.00,  nan ],
	[   400,    400,  nan,  nan,    15.74,  0.00,  nan ],
	[   500,    500,  nan,  nan,    25.63,  0.00,  nan ],
	[   600,    600,  nan,  nan,    34.95,  0.00,  nan ],
	[   700,    700,  nan,  nan,    48.47,  0.00,  nan ],
	[   800,    800,  nan,  nan,    60.65,  0.01,  nan ],
	[   900,    900,  nan,  nan,    75.51,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,    90.27,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   260.33,  0.02,  nan ],
	[  3000,   3000,  nan,  nan,   456.62,  0.04,  nan ],
	[  4000,   4000,  nan,  nan,   648.71,  0.07,  nan ],
	[  5000,   5000,  nan,  nan,   735.27,  0.11,  nan ],
	[  6000,   6000,  nan,  nan,   919.21,  0.16,  nan ],
	[  7000,   7000,  nan,  nan,  1093.36,  0.21,  nan ],
	[  8000,   8000,  nan,  nan,  1255.72,  0.27,  nan ],
	[  9000,   9000,  nan,  nan,  1331.20,  0.37,  nan ],
	[ 10000,  10000,  nan,  nan,  1462.23,  0.46,  nan ],
	[ 12000,  12000,  nan,  nan,  1676.81,  0.69,  nan ],
	[ 14000,  14000,  nan,  nan,  1703.77,  1.07,  nan ],
	[ 16000,  16000,  nan,  nan,  1878.36,  1.45,  nan ],
	[ 18000,  18000,  nan,  nan,  1953.21,  1.99,  nan ],
	[ 20000,  20000,  nan,  nan,  2085.38,  2.56,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/spotrf.txt
# numactl --interleave=all ./testing_spotrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
spotrf = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,  nan,  nan,     0.03,  0.00,  nan ],
	[    40,  nan,  nan,     0.08,  0.00,  nan ],
	[    50,  nan,  nan,     0.14,  0.00,  nan ],
	[    60,  nan,  nan,     0.24,  0.00,  nan ],
	[    70,  nan,  nan,     1.74,  0.00,  nan ],
	[    80,  nan,  nan,     2.32,  0.00,  nan ],
	[    90,  nan,  nan,     2.84,  0.00,  nan ],
	[   100,  nan,  nan,     3.44,  0.00,  nan ],
	[   200,  nan,  nan,     5.67,  0.00,  nan ],
	[   300,  nan,  nan,     6.37,  0.00,  nan ],
	[   400,  nan,  nan,    14.48,  0.00,  nan ],
	[   500,  nan,  nan,    24.85,  0.00,  nan ],
	[   600,  nan,  nan,    24.63,  0.00,  nan ],
	[   700,  nan,  nan,    39.08,  0.00,  nan ],
	[   800,  nan,  nan,    42.74,  0.00,  nan ],
	[   900,  nan,  nan,    57.22,  0.00,  nan ],
	[  1000,  nan,  nan,    73.35,  0.00,  nan ],
	[  2000,  nan,  nan,   291.34,  0.01,  nan ],
	[  3000,  nan,  nan,   544.54,  0.02,  nan ],
	[  4000,  nan,  nan,   826.19,  0.03,  nan ],
	[  5000,  nan,  nan,  1027.28,  0.04,  nan ],
	[  6000,  nan,  nan,  1215.00,  0.06,  nan ],
	[  7000,  nan,  nan,  1356.11,  0.08,  nan ],
	[  8000,  nan,  nan,  1502.71,  0.11,  nan ],
	[  9000,  nan,  nan,  1600.75,  0.15,  nan ],
	[ 10000,  nan,  nan,  1689.10,  0.20,  nan ],
	[ 12000,  nan,  nan,  1856.77,  0.31,  nan ],
	[ 14000,  nan,  nan,  1994.98,  0.46,  nan ],
	[ 16000,  nan,  nan,  2095.11,  0.65,  nan ],
	[ 18000,  nan,  nan,  2181.16,  0.89,  nan ],
	[ 20000,  nan,  nan,  2261.68,  1.18,  nan ],
])

# numactl --interleave=all ./testing_spotrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
spotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.00,  0.00,  nan ],
	[    30,  nan,  nan,     0.01,  0.00,  nan ],
	[    40,  nan,  nan,     0.03,  0.00,  nan ],
	[    50,  nan,  nan,     0.05,  0.00,  nan ],
	[    60,  nan,  nan,     0.08,  0.00,  nan ],
	[    70,  nan,  nan,     0.13,  0.00,  nan ],
	[    80,  nan,  nan,     0.19,  0.00,  nan ],
	[    90,  nan,  nan,     0.27,  0.00,  nan ],
	[   100,  nan,  nan,     0.36,  0.00,  nan ],
	[   200,  nan,  nan,     8.81,  0.00,  nan ],
	[   300,  nan,  nan,     4.79,  0.00,  nan ],
	[   400,  nan,  nan,    10.68,  0.00,  nan ],
	[   500,  nan,  nan,    18.97,  0.00,  nan ],
	[   600,  nan,  nan,    22.60,  0.00,  nan ],
	[   700,  nan,  nan,    34.39,  0.00,  nan ],
	[   800,  nan,  nan,    40.10,  0.00,  nan ],
	[   900,  nan,  nan,    53.54,  0.00,  nan ],
	[  1000,  nan,  nan,    69.20,  0.00,  nan ],
	[  2000,  nan,  nan,   314.33,  0.01,  nan ],
	[  3000,  nan,  nan,   640.99,  0.01,  nan ],
	[  4000,  nan,  nan,   980.53,  0.02,  nan ],
	[  5000,  nan,  nan,  1195.28,  0.03,  nan ],
	[  6000,  nan,  nan,  1423.59,  0.05,  nan ],
	[  7000,  nan,  nan,  1577.57,  0.07,  nan ],
	[  8000,  nan,  nan,  1773.95,  0.10,  nan ],
	[  9000,  nan,  nan,  1867.30,  0.13,  nan ],
	[ 10000,  nan,  nan,  1970.38,  0.17,  nan ],
	[ 12000,  nan,  nan,  2124.71,  0.27,  nan ],
	[ 14000,  nan,  nan,  2262.73,  0.40,  nan ],
	[ 16000,  nan,  nan,  2354.46,  0.58,  nan ],
	[ 18000,  nan,  nan,  2410.71,  0.81,  nan ],
	[ 20000,  nan,  nan,  2481.65,  1.07,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/ssyevd.txt
# numactl --interleave=all ./testing_ssyevd -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevd_JN = array([
	[    10,  nan,    0.0000 ],
	[    20,  nan,    0.0000 ],
	[    30,  nan,    0.0001 ],
	[    40,  nan,    0.0001 ],
	[    50,  nan,    0.0002 ],
	[    60,  nan,    0.0002 ],
	[    70,  nan,    0.0003 ],
	[    80,  nan,    0.0004 ],
	[    90,  nan,    0.0005 ],
	[   100,  nan,    0.0006 ],
	[   200,  nan,    0.0036 ],
	[   300,  nan,    0.0071 ],
	[   400,  nan,    0.0115 ],
	[   500,  nan,    0.0171 ],
	[   600,  nan,    0.0235 ],
	[   700,  nan,    0.0310 ],
	[   800,  nan,    0.0400 ],
	[   900,  nan,    0.0501 ],
	[  1000,  nan,    0.0611 ],
	[  2000,  nan,    0.2263 ],
	[  3000,  nan,    1.0571 ],
	[  4000,  nan,    2.0159 ],
	[  5000,  nan,    3.6684 ],
	[  6000,  nan,    5.7982 ],
	[  7000,  nan,    8.7812 ],
	[  8000,  nan,   12.3024 ],
	[  9000,  nan,   17.1279 ],
	[ 10000,  nan,   22.5072 ],
	[ 12000,  nan,   37.5260 ],
	[ 14000,  nan,   57.2239 ],
	[ 16000,  nan,   83.5117 ],
	[ 18000,  nan,  117.2557 ],
	[ 20000,  nan,  157.4736 ],
])

# numactl --interleave=all ./testing_ssyevd -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevd_JV = array([
	[    10,  nan,    0.0001 ],
	[    20,  nan,    0.0001 ],
	[    30,  nan,    0.0002 ],
	[    40,  nan,    0.0003 ],
	[    50,  nan,    0.0003 ],
	[    60,  nan,    0.0005 ],
	[    70,  nan,    0.0006 ],
	[    80,  nan,    0.0007 ],
	[    90,  nan,    0.0008 ],
	[   100,  nan,    0.0011 ],
	[   200,  nan,    0.0071 ],
	[   300,  nan,    0.0108 ],
	[   400,  nan,    0.0170 ],
	[   500,  nan,    0.0245 ],
	[   600,  nan,    0.0288 ],
	[   700,  nan,    0.0368 ],
	[   800,  nan,    0.0450 ],
	[   900,  nan,    0.0569 ],
	[  1000,  nan,    0.0662 ],
	[  2000,  nan,    0.2429 ],
	[  3000,  nan,    1.0858 ],
	[  4000,  nan,    2.0679 ],
	[  5000,  nan,    3.6946 ],
	[  6000,  nan,    5.8756 ],
	[  7000,  nan,    8.8921 ],
	[  8000,  nan,   12.3839 ],
	[  9000,  nan,   17.2556 ],
	[ 10000,  nan,   22.7367 ],
	[ 12000,  nan,   38.1187 ],
	[ 14000,  nan,   58.3367 ],
	[ 16000,  nan,   85.4064 ],
	[ 18000,  nan,  120.0282 ],
	[ 20000,  nan,  161.1557 ],
])

# numactl --interleave=all ./testing_ssyevd_gpu -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevd_gpu_JN = array([
	[    10,  nan,    0.0001 ],
	[    20,  nan,    0.0001 ],
	[    30,  nan,    0.0001 ],
	[    40,  nan,    0.0002 ],
	[    50,  nan,    0.0002 ],
	[    60,  nan,    0.0003 ],
	[    70,  nan,    0.0004 ],
	[    80,  nan,    0.0005 ],
	[    90,  nan,    0.0006 ],
	[   100,  nan,    0.0007 ],
	[   200,  nan,    0.0034 ],
	[   300,  nan,    0.0069 ],
	[   400,  nan,    0.0119 ],
	[   500,  nan,    0.0175 ],
	[   600,  nan,    0.0242 ],
	[   700,  nan,    0.0322 ],
	[   800,  nan,    0.0411 ],
	[   900,  nan,    0.0512 ],
	[  1000,  nan,    0.0622 ],
	[  2000,  nan,    0.2277 ],
	[  3000,  nan,    1.0560 ],
	[  4000,  nan,    2.0458 ],
	[  5000,  nan,    3.6631 ],
	[  6000,  nan,    5.7676 ],
	[  7000,  nan,    8.7463 ],
	[  8000,  nan,   12.2980 ],
	[  9000,  nan,   16.9969 ],
	[ 10000,  nan,   22.5091 ],
	[ 12000,  nan,   37.5123 ],
	[ 14000,  nan,   57.2456 ],
	[ 16000,  nan,   83.4449 ],
	[ 18000,  nan,  117.4840 ],
	[ 20000,  nan,  157.2814 ],
])

# numactl --interleave=all ./testing_ssyevd_gpu -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevd_gpu_JV = array([
	[    10,  nan,    0.0001 ],
	[    20,  nan,    0.0001 ],
	[    30,  nan,    0.0003 ],
	[    40,  nan,    0.0003 ],
	[    50,  nan,    0.0004 ],
	[    60,  nan,    0.0006 ],
	[    70,  nan,    0.0007 ],
	[    80,  nan,    0.0008 ],
	[    90,  nan,    0.0010 ],
	[   100,  nan,    0.0011 ],
	[   200,  nan,    0.0063 ],
	[   300,  nan,    0.0105 ],
	[   400,  nan,    0.0166 ],
	[   500,  nan,    0.0236 ],
	[   600,  nan,    0.0283 ],
	[   700,  nan,    0.0365 ],
	[   800,  nan,    0.0454 ],
	[   900,  nan,    0.0581 ],
	[  1000,  nan,    0.0677 ],
	[  2000,  nan,    0.2467 ],
	[  3000,  nan,    1.0858 ],
	[  4000,  nan,    2.0658 ],
	[  5000,  nan,    3.7673 ],
	[  6000,  nan,    6.0034 ],
	[  7000,  nan,    9.0122 ],
	[  8000,  nan,   12.7578 ],
	[  9000,  nan,   17.7505 ],
	[ 10000,  nan,   23.5353 ],
	[ 12000,  nan,   39.5142 ],
	[ 14000,  nan,   60.6329 ],
	[ 16000,  nan,   88.8563 ],
	[ 18000,  nan,  125.6932 ],
	[ 20000,  nan,  168.7029 ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/ssyevd_2stage.txt
# numactl --interleave=all ./testing_ssyevdx_2stage -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevdx_2stage_JN = array([
	[    10,      0,   0.0000 ],
	[    20,      0,   0.0000 ],
	[    30,      0,   0.0000 ],
	[    40,      0,   0.0000 ],
	[    50,      0,   0.0000 ],
	[    60,      0,   0.0000 ],
	[    70,     70,   0.0003 ],
	[    80,     80,   0.0003 ],
	[    90,     90,   0.0004 ],
	[   100,    100,   0.0005 ],
	[   200,    200,   0.0032 ],
	[   300,    300,   0.0157 ],
	[   400,    400,   0.0278 ],
	[   500,    500,   0.0438 ],
	[   600,    600,   0.0565 ],
	[   700,    700,   0.0724 ],
	[   800,    800,   0.0891 ],
	[   900,    900,   0.1102 ],
	[  1000,   1000,   0.1308 ],
	[  2000,   2000,   0.4994 ],
	[  3000,   3000,   0.7160 ],
	[  4000,   4000,   1.0252 ],
	[  5000,   5000,   1.4076 ],
	[  6000,   6000,   1.8414 ],
	[  7000,   7000,   2.3676 ],
	[  8000,   8000,   2.9968 ],
	[  9000,   9000,   3.7616 ],
	[ 10000,  10000,   4.4908 ],
	[ 12000,  12000,   6.4617 ],
	[ 14000,  14000,   8.9896 ],
	[ 16000,  16000,  11.9006 ],
	[ 18000,  18000,  15.7092 ],
	[ 20000,  20000,  19.8704 ],
])

# numactl --interleave=all ./testing_ssyevdx_2stage -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevdx_2stage_JV = array([
	[    10,     10,   0.0001 ],
	[    20,     20,   0.0001 ],
	[    30,     30,   0.0003 ],
	[    40,     40,   0.0003 ],
	[    50,     50,   0.0004 ],
	[    60,     60,   0.0005 ],
	[    70,     70,   0.0006 ],
	[    80,     80,   0.0007 ],
	[    90,     90,   0.0009 ],
	[   100,    100,   0.0010 ],
	[   200,    200,   0.0048 ],
	[   300,    300,   0.0250 ],
	[   400,    400,   0.0415 ],
	[   500,    500,   0.0611 ],
	[   600,    600,   0.0776 ],
	[   700,    700,   0.1001 ],
	[   800,    800,   0.1205 ],
	[   900,    900,   0.1474 ],
	[  1000,   1000,   0.1789 ],
	[  2000,   2000,   0.5342 ],
	[  3000,   3000,   0.9981 ],
	[  4000,   4000,   1.5876 ],
	[  5000,   5000,   2.0208 ],
	[  6000,   6000,   2.7923 ],
	[  7000,   7000,   3.9590 ],
	[  8000,   8000,   6.2597 ],
	[  9000,   9000,   8.2678 ],
	[ 10000,  10000,   9.9975 ],
	[ 12000,  12000,  15.3769 ],
	[ 14000,  14000,  22.4067 ],
	[ 16000,  16000,  30.0392 ],
	[ 18000,  18000,  41.6473 ],
	[ 20000,  20000,  54.5105 ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/ssymv.txt
# numactl --interleave=all ./testing_ssymv -N 100 -N 1000 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
ssymv_L = array([
	[    10,    0.0071,  0.0310,    0.0073,  0.0300,   0.0091,   0.0241,   0.0710,   0.0031,  4.77e-08,  4.77e-08,  4.77e-08,  nan ],
	[    11,    0.0088,  0.0300,    0.0092,  0.0288,   0.0115,   0.0229,   0.1384,   0.0019,  4.33e-08,  4.33e-08,  4.33e-08,  nan ],
	[    12,    0.0104,  0.0300,    0.0104,  0.0300,   0.0135,   0.0231,   0.1454,   0.0021,  3.97e-08,  1.99e-08,  1.99e-08,  nan ],
	[    13,    0.0117,  0.0310,    0.0114,  0.0319,   0.0164,   0.0222,   0.1908,   0.0019,  7.34e-08,  7.34e-08,  7.34e-08,  nan ],
	[    14,    0.0131,  0.0319,    0.0144,  0.0291,   0.0191,   0.0219,   0.1957,   0.0021,  6.81e-08,  6.81e-08,  6.81e-08,  nan ],
	[    15,    0.0130,  0.0370,    0.0165,  0.0291,   0.0210,   0.0229,   0.2517,   0.0019,  3.18e-08,  4.77e-08,  6.36e-08,  nan ],
	[    16,    0.0151,  0.0360,    0.0183,  0.0298,   0.0235,   0.0231,   0.1755,   0.0031,  5.96e-08,  5.96e-08,  5.96e-08,  nan ],
	[    17,    0.0197,  0.0310,    0.0192,  0.0319,   0.0254,   0.0241,   0.1975,   0.0031,  5.61e-08,  2.80e-08,  5.61e-08,  nan ],
	[    18,    0.0228,  0.0300,    0.0221,  0.0310,   0.0287,   0.0238,   0.2207,   0.0031,  7.95e-08,  2.65e-08,  5.30e-08,  nan ],
	[    19,    0.0245,  0.0310,    0.0211,  0.0360,   0.0332,   0.0229,   0.3985,   0.0019,  5.02e-08,  5.02e-08,  5.02e-08,  nan ],
	[    20,    0.0282,  0.0298,    0.0280,  0.0300,   0.0349,   0.0241,   0.2936,   0.0029,  4.77e-08,  4.77e-08,  4.77e-08,  nan ],
	[    21,    0.0308,  0.0300,    0.0308,  0.0300,   0.0400,   0.0231,   0.4306,   0.0021,  9.08e-08,  6.81e-08,  4.54e-08,  nan ],
	[    22,    0.0340,  0.0298,    0.0297,  0.0341,   0.0420,   0.0241,   0.3265,   0.0031,  6.50e-08,  4.33e-08,  6.50e-08,  nan ],
	[    23,    0.0368,  0.0300,    0.0356,  0.0310,   0.0458,   0.0241,   0.3859,   0.0029,  4.15e-08,  8.29e-08,  4.15e-08,  nan ],
	[    24,    0.0365,  0.0329,    0.0376,  0.0319,   0.0547,   0.0219,   0.6291,   0.0019,  7.95e-08,  3.97e-08,  3.97e-08,  nan ],
	[    25,    0.0451,  0.0288,    0.0419,  0.0310,   0.0545,   0.0238,   0.1652,   0.0079,  7.63e-08,  7.63e-08,  5.72e-08,  nan ],
	[    26,    0.0487,  0.0288,    0.0453,  0.0310,   0.0589,   0.0238,   0.4530,   0.0031,  7.34e-08,  7.34e-08,  7.34e-08,  nan ],
	[    27,    0.0542,  0.0279,    0.0488,  0.0310,   0.0661,   0.0229,   0.4878,   0.0031,  7.06e-08,  7.06e-08,  7.06e-08,  nan ],
	[    28,    0.0541,  0.0300,    0.0508,  0.0319,   0.0674,   0.0241,   0.5240,   0.0031,  6.81e-08,  6.81e-08,  1.02e-07,  nan ],
	[    29,    0.0561,  0.0310,    0.0529,  0.0329,   0.0695,   0.0250,   0.6082,   0.0029,  6.58e-08,  6.58e-08,  9.87e-08,  nan ],
	[    30,    0.0600,  0.0310,    0.0582,  0.0319,   0.0780,   0.0238,   0.6001,   0.0031,  9.54e-08,  9.54e-08,  1.27e-07,  nan ],
	[    31,    0.0666,  0.0298,    0.0603,  0.0329,   0.0832,   0.0238,   0.6935,   0.0029,  9.23e-08,  6.15e-08,  9.23e-08,  nan ],
	[    32,    0.0661,  0.0319,    0.0624,  0.0339,   0.0813,   0.0260,   0.6814,   0.0031,  5.96e-08,  5.96e-08,  5.96e-08,  nan ],
	[    33,    0.0747,  0.0300,    0.0702,  0.0319,   0.0856,   0.0262,   0.7240,   0.0031,  8.67e-08,  1.16e-07,  5.78e-08,  nan ],
	[    34,    0.0745,  0.0319,    0.0718,  0.0331,   0.0846,   0.0281,   0.7679,   0.0031,  5.61e-08,  8.41e-08,  5.61e-08,  nan ],
	[    35,    0.0813,  0.0310,    0.0766,  0.0329,   0.0970,   0.0260,   0.6217,   0.0041,  5.45e-08,  5.45e-08,  5.45e-08,  nan ],
	[    36,    0.0860,  0.0310,    0.0787,  0.0339,   0.0989,   0.0269,   0.8595,   0.0031,  7.95e-08,  5.30e-08,  5.30e-08,  nan ],
	[    37,    0.0907,  0.0310,    0.0880,  0.0319,   0.1044,   0.0269,   0.6938,   0.0041,  1.03e-07,  1.03e-07,  1.03e-07,  nan ],
	[    38,    0.0956,  0.0310,    0.0901,  0.0329,   0.1141,   0.0260,   0.7770,   0.0038,  7.53e-08,  5.02e-08,  7.53e-08,  nan ],
	[    39,    0.0890,  0.0350,    0.0922,  0.0339,   0.0557,   0.0560,   0.6232,   0.0050,  4.89e-08,  4.89e-08,  4.89e-08,  nan ],
	[    40,    0.1092,  0.0300,    0.0997,  0.0329,   0.1262,   0.0260,   0.8598,   0.0038,  7.15e-08,  9.54e-08,  7.15e-08,  nan ],
	[    41,    0.1111,  0.0310,    0.1047,  0.0329,   0.1325,   0.0260,   1.2038,   0.0029,  6.98e-08,  6.98e-08,  6.98e-08,  nan ],
	[    42,    0.0565,  0.0639,    0.1067,  0.0339,   0.1341,   0.0269,   0.9469,   0.0038,  9.08e-08,  9.08e-08,  9.08e-08,  nan ],
	[    43,    0.1260,  0.0300,    0.1142,  0.0331,   0.1456,   0.0260,   0.9920,   0.0038,  8.87e-08,  8.87e-08,  8.87e-08,  nan ],
	[    44,    0.1329,  0.0298,    0.1161,  0.0341,   0.1457,   0.0272,   0.9770,   0.0041,  8.67e-08,  8.67e-08,  8.67e-08,  nan ],
	[    45,    0.1378,  0.0300,    0.1286,  0.0322,   0.1593,   0.0260,   1.0853,   0.0038,  8.48e-08,  8.48e-08,  8.48e-08,  nan ],
	[    46,    0.1451,  0.0298,    0.1343,  0.0322,   0.1664,   0.0260,   0.8636,   0.0050,  8.29e-08,  1.24e-07,  8.29e-08,  nan ],
	[    47,    0.1412,  0.0319,    0.1402,  0.0322,   0.1892,   0.0238,   1.1132,   0.0041,  8.12e-08,  8.12e-08,  8.12e-08,  nan ],
	[    48,    0.1566,  0.0300,    0.1518,  0.0310,   0.1810,   0.0260,   1.1606,   0.0041,  7.95e-08,  3.97e-08,  7.95e-08,  nan ],
	[    49,    0.1581,  0.0310,    0.1479,  0.0331,   0.1803,   0.0272,   1.2089,   0.0041,  7.79e-08,  7.79e-08,  7.79e-08,  nan ],
	[    50,    0.1596,  0.0319,    0.1496,  0.0341,   0.1813,   0.0281,   1.0186,   0.0050,  3.81e-08,  5.72e-08,  5.72e-08,  nan ],
	[    51,    0.1711,  0.0310,    0.1612,  0.0329,   0.1901,   0.0279,   1.0594,   0.0050,  7.48e-08,  5.61e-08,  7.48e-08,  nan ],
	[    52,    0.1778,  0.0310,    0.1617,  0.0341,   0.2046,   0.0269,   1.1009,   0.0050,  1.10e-07,  1.10e-07,  1.10e-07,  nan ],
	[    53,    0.1847,  0.0310,    0.1727,  0.0331,   0.2035,   0.0281,   1.1432,   0.0050,  9.00e-08,  1.08e-07,  7.20e-08,  nan ],
	[    54,    0.1916,  0.0310,    0.1792,  0.0331,   0.1792,   0.0331,   1.2457,   0.0048,  1.06e-07,  1.06e-07,  1.06e-07,  nan ],
	[    55,    0.1987,  0.0310,    0.1859,  0.0331,   0.2190,   0.0281,   1.2303,   0.0050,  6.94e-08,  6.94e-08,  6.94e-08,  nan ],
	[    56,    0.2060,  0.0310,    0.1940,  0.0329,   0.2269,   0.0281,   1.2751,   0.0050,  6.81e-08,  6.81e-08,  3.41e-08,  nan ],
	[    57,    0.2219,  0.0298,    0.2010,  0.0329,   0.2273,   0.0291,   1.3866,   0.0048,  6.69e-08,  6.69e-08,  6.69e-08,  nan ],
	[    58,    0.2142,  0.0319,    0.1953,  0.0350,   0.1953,   0.0350,   1.3669,   0.0050,  9.87e-08,  1.32e-07,  9.87e-08,  nan ],
	[    59,    0.2357,  0.0300,    0.2077,  0.0341,   0.2357,   0.0300,   1.1878,   0.0060,  9.70e-08,  6.47e-08,  6.47e-08,  nan ],
	[    60,    0.2362,  0.0310,    0.2147,  0.0341,   0.2624,   0.0279,   1.1809,   0.0062,  1.27e-07,  9.54e-08,  9.54e-08,  nan ],
	[    61,    0.2440,  0.0310,    0.2282,  0.0331,   0.2600,   0.0291,   1.5107,   0.0050,  1.25e-07,  1.25e-07,  9.38e-08,  nan ],
	[    62,    0.2520,  0.0310,    0.2307,  0.0339,   0.2520,   0.0310,   1.2602,   0.0062,  9.23e-08,  9.23e-08,  1.23e-07,  nan ],
	[    63,    0.2602,  0.0310,    0.2433,  0.0331,   0.2772,   0.0291,   1.3529,   0.0060,  9.08e-08,  9.08e-08,  1.51e-07,  nan ],
	[    64,    0.2860,  0.0291,    0.2604,  0.0319,   0.3061,   0.0272,   1.6617,   0.0050,  8.94e-08,  5.96e-08,  8.94e-08,  nan ],
	[    65,    0.2383,  0.0360,    0.2208,  0.0389,   0.2856,   0.0300,   1.4395,   0.0060,  5.87e-08,  5.87e-08,  8.80e-08,  nan ],
	[    66,    0.2594,  0.0341,    0.2276,  0.0389,   0.3066,   0.0288,   1.7664,   0.0050,  8.67e-08,  8.67e-08,  8.67e-08,  nan ],
	[    67,    0.2691,  0.0339,    0.2389,  0.0381,   0.2940,   0.0310,   1.4699,   0.0062,  1.14e-07,  1.14e-07,  1.14e-07,  nan ],
	[    68,    0.2752,  0.0341,    0.2475,  0.0379,   0.3226,   0.0291,   1.5744,   0.0060,  1.40e-07,  1.12e-07,  1.40e-07,  nan ],
	[    69,    0.2833,  0.0341,    0.2471,  0.0391,   0.3216,   0.0300,   1.6207,   0.0060,  8.29e-08,  8.29e-08,  1.11e-07,  nan ],
	[    70,    0.2915,  0.0341,    0.2622,  0.0379,   0.3563,   0.0279,   1.6677,   0.0060,  1.36e-07,  1.63e-07,  1.63e-07,  nan ],
	[    71,    0.3020,  0.0339,    0.2615,  0.0391,   0.3176,   0.0322,   1.7153,   0.0060,  8.06e-08,  1.61e-07,  1.07e-07,  nan ],
	[    72,    0.2920,  0.0360,    0.1208,  0.0870,   0.3392,   0.0310,   2.0995,   0.0050,  1.06e-07,  1.06e-07,  1.32e-07,  nan ],
	[    73,    0.3001,  0.0360,    0.2635,  0.0410,   0.3596,   0.0300,   2.1579,   0.0050,  1.05e-07,  7.84e-08,  1.05e-07,  nan ],
	[    74,    0.3167,  0.0350,    0.2856,  0.0389,   0.3695,   0.0300,   1.8623,   0.0060,  1.29e-07,  1.29e-07,  1.29e-07,  nan ],
	[    75,    0.3253,  0.0350,    0.2780,  0.0410,   0.3795,   0.0300,   1.9126,   0.0060,  1.27e-07,  7.63e-08,  7.63e-08,  nan ],
	[    76,    0.3339,  0.0350,    0.3012,  0.0389,   0.3896,   0.0300,   1.6363,   0.0072,  1.00e-07,  1.00e-07,  7.53e-08,  nan ],
	[    77,    0.3427,  0.0350,    0.2999,  0.0401,   0.3846,   0.0312,   2.0153,   0.0060,  9.91e-08,  9.91e-08,  9.91e-08,  nan ],
	[    78,    0.3540,  0.0348,    0.3095,  0.0398,   0.3976,   0.0310,   1.9881,   0.0062,  7.34e-08,  7.34e-08,  7.34e-08,  nan ],
	[    79,    0.3607,  0.0350,    0.3233,  0.0391,   0.4241,   0.0298,   1.5593,   0.0081,  9.66e-08,  1.45e-07,  1.21e-07,  nan ],
	[    80,    0.3801,  0.0341,    0.3315,  0.0391,   0.4057,   0.0319,   2.1743,   0.0060,  9.54e-08,  9.54e-08,  9.54e-08,  nan ],
	[    81,    0.3690,  0.0360,    0.2887,  0.0460,   0.4422,   0.0300,   2.2287,   0.0060,  9.42e-08,  1.18e-07,  1.18e-07,  nan ],
	[    82,    0.3884,  0.0350,    0.3398,  0.0401,   0.4531,   0.0300,   2.2837,   0.0060,  1.40e-07,  1.40e-07,  9.30e-08,  nan ],
	[    83,    0.3979,  0.0350,    0.3481,  0.0401,   0.4119,   0.0339,   1.9495,   0.0072,  1.15e-07,  9.19e-08,  9.19e-08,  nan ],
	[    84,    0.4074,  0.0350,    0.3652,  0.0391,   0.4607,   0.0310,   1.9965,   0.0072,  9.08e-08,  9.08e-08,  9.08e-08,  nan ],
	[    85,    0.4171,  0.0350,    0.3672,  0.0398,   0.4717,   0.0310,   2.1145,   0.0069,  8.98e-08,  8.98e-08,  1.35e-07,  nan ],
	[    86,    0.4270,  0.0350,    0.3736,  0.0401,   0.5021,   0.0298,   2.1643,   0.0069,  1.33e-07,  1.33e-07,  8.87e-08,  nan ],
	[    87,    0.4369,  0.0350,    0.3940,  0.0389,   0.4940,   0.0310,   2.2146,   0.0069,  8.77e-08,  6.58e-08,  8.77e-08,  nan ],
	[    88,    0.4469,  0.0350,    0.4006,  0.0391,   0.5054,   0.0310,   2.6280,   0.0060,  1.30e-07,  8.67e-08,  8.67e-08,  nan ],
	[    89,    0.4571,  0.0350,    0.4097,  0.0391,   0.5169,   0.0310,   2.2398,   0.0072,  1.29e-07,  1.29e-07,  1.29e-07,  nan ],
	[    90,    0.4674,  0.0350,    0.4089,  0.0401,   0.5285,   0.0310,   2.3691,   0.0069,  1.27e-07,  1.27e-07,  1.27e-07,  nan ],
	[   100,    0.5803,  0.0348,    0.5043,  0.0401,   0.6276,   0.0322,   2.8242,   0.0072,  1.14e-07,  1.14e-07,  1.14e-07,  nan ],
	[   110,    0.6968,  0.0350,    0.5955,  0.0410,   0.7422,   0.0329,   2.6954,   0.0091,  1.39e-07,  1.39e-07,  1.04e-07,  nan ],
	[   120,    0.8286,  0.0350,    0.7427,  0.0391,   0.9369,   0.0310,   3.5824,   0.0081,  9.54e-08,  1.27e-07,  1.27e-07,  nan ],
	[   130,    0.8764,  0.0389,    0.8503,  0.0401,   0.9990,   0.0341,   3.4014,   0.0100,  1.47e-07,  1.47e-07,  1.47e-07,  nan ],
	[   140,    0.9857,  0.0401,    0.9684,  0.0408,   1.0097,   0.0391,   3.9426,   0.0100,  2.18e-07,  1.63e-07,  1.63e-07,  nan ],
	[   150,    1.1310,  0.0401,    1.1047,  0.0410,   1.2258,   0.0370,   3.8000,   0.0119,  1.53e-07,  1.27e-07,  1.53e-07,  nan ],
	[   160,    1.2863,  0.0401,    1.2209,  0.0422,   1.4311,   0.0360,   4.6976,   0.0110,  1.43e-07,  1.43e-07,  1.43e-07,  nan ],
	[   170,    1.4178,  0.0410,    1.3856,  0.0420,   1.5733,   0.0370,   4.8771,   0.0119,  1.35e-07,  1.35e-07,  1.35e-07,  nan ],
	[   180,    1.5528,  0.0420,    1.5183,  0.0429,   1.7189,   0.0379,   4.6322,   0.0141,  1.70e-07,  1.27e-07,  1.27e-07,  nan ],
	[   190,    1.7699,  0.0410,    1.6455,  0.0441,   1.9026,   0.0381,   5.1597,   0.0141,  2.41e-07,  2.01e-07,  1.61e-07,  nan ],
	[   200,    1.7937,  0.0448,    1.8735,  0.0429,   1.9606,   0.0410,   6.2449,   0.0129,  1.53e-07,  1.53e-07,  1.53e-07,  nan ],
	[   210,    2.0201,  0.0439,    2.1119,  0.0420,   2.2125,   0.0401,   5.5477,   0.0160,  1.82e-07,  1.82e-07,  1.82e-07,  nan ],
	[   220,    2.2046,  0.0441,    2.2046,  0.0441,   2.4277,   0.0401,   5.6646,   0.0172,  1.73e-07,  2.08e-07,  1.73e-07,  nan ],
	[   230,    2.3093,  0.0460,    2.4091,  0.0441,   2.5323,   0.0420,   4.7923,   0.0222,  2.32e-07,  1.66e-07,  1.66e-07,  nan ],
	[   240,    2.4629,  0.0470,    2.5672,  0.0451,   2.7412,   0.0422,   7.2417,   0.0160,  2.23e-07,  2.54e-07,  2.23e-07,  nan ],
	[   250,    2.7274,  0.0460,    2.7851,  0.0451,   2.9244,   0.0429,   7.0185,   0.0179,  2.75e-07,  2.75e-07,  3.05e-07,  nan ],
	[   260,    2.6601,  0.0510,    2.9495,  0.0460,   3.1450,   0.0432,   3.3096,   0.0410,  1.17e-07,  8.80e-08,  8.80e-08,  nan ],
	[   270,    3.0386,  0.0482,    3.3178,  0.0441,   3.3178,   0.0441,   6.6717,   0.0219,  1.13e-07,  5.65e-08,  8.48e-08,  nan ],
	[   280,    3.2196,  0.0489,    3.3503,  0.0470,   3.5677,   0.0441,   7.1741,   0.0219,  8.17e-08,  5.45e-08,  8.17e-08,  nan ],
	[   290,    3.3710,  0.0501,    3.5935,  0.0470,   3.6680,   0.0460,   3.4365,   0.0491,  1.05e-07,  7.89e-08,  1.05e-07,  nan ],
	[   300,    3.5397,  0.0510,    3.9248,  0.0460,   3.9248,   0.0460,   6.2089,   0.0291,  1.02e-07,  7.63e-08,  1.02e-07,  nan ],
	[   310,    3.9259,  0.0491,    4.1904,  0.0460,   4.2791,   0.0451,   6.0354,   0.0319,  9.84e-08,  7.38e-08,  1.23e-07,  nan ],
	[   320,    4.2033,  0.0489,    4.4647,  0.0460,   4.3740,   0.0470,   5.2864,   0.0389,  9.54e-08,  9.54e-08,  1.43e-07,  nan ],
	[   330,    4.0544,  0.0539,    4.6512,  0.0470,   4.5586,   0.0479,   8.4063,   0.0260,  1.16e-07,  9.25e-08,  9.25e-08,  nan ],
	[   340,    4.3034,  0.0539,    4.8387,  0.0479,   4.8387,   0.0479,   7.7189,   0.0300,  1.12e-07,  8.98e-08,  1.12e-07,  nan ],
	[   350,    4.6213,  0.0532,    5.3396,  0.0460,   5.2047,   0.0472,   8.8080,   0.0279,  8.72e-08,  8.72e-08,  8.72e-08,  nan ],
	[   360,    4.8238,  0.0539,    5.2922,  0.0491,   5.3180,   0.0489,   6.8136,   0.0381,  1.48e-07,  1.06e-07,  8.48e-08,  nan ],
	[   370,    4.9000,  0.0560,    5.5898,  0.0491,   5.5898,   0.0491,   9.7585,   0.0281,  1.24e-07,  1.65e-07,  1.24e-07,  nan ],
	[   380,    5.3502,  0.0541,    5.6752,  0.0510,   5.5711,   0.0520,  10.3804,   0.0279,  1.20e-07,  1.20e-07,  1.20e-07,  nan ],
	[   390,    5.1789,  0.0589,    6.2096,  0.0491,   5.8410,   0.0522,   7.2681,   0.0420,  1.17e-07,  1.17e-07,  1.17e-07,  nan ],
	[   400,    5.5372,  0.0579,    6.5636,  0.0489,   6.1722,   0.0520,  10.3503,   0.0310,  1.14e-07,  1.14e-07,  1.14e-07,  nan ],
	[   410,    5.7229,  0.0589,    6.8620,  0.0491,   6.4842,   0.0520,  10.5490,   0.0319,  1.12e-07,  1.12e-07,  1.12e-07,  nan ],
	[   420,    5.9809,  0.0591,    7.0632,  0.0501,   6.6515,   0.0532,   8.4277,   0.0420,  1.09e-07,  1.45e-07,  1.09e-07,  nan ],
	[   430,    6.1939,  0.0598,    7.5837,  0.0489,   7.1315,   0.0520,  12.3386,   0.0300,  1.42e-07,  1.06e-07,  1.06e-07,  nan ],
	[   440,    6.4592,  0.0601,    7.6062,  0.0510,   7.2023,   0.0539,  13.3420,   0.0291,  1.04e-07,  1.04e-07,  1.04e-07,  nan ],
	[   450,    6.4244,  0.0632,    7.9555,  0.0510,   7.2445,   0.0560,   9.2525,   0.0439,  1.02e-07,  1.36e-07,  1.02e-07,  nan ],
	[   460,    6.8419,  0.0620,    8.3126,  0.0510,   7.5697,   0.0560,  13.2753,   0.0319,  9.95e-08,  1.33e-07,  9.95e-08,  nan ],
	[   470,    7.0075,  0.0632,    8.6775,  0.0510,   7.9358,   0.0558,  14.7380,   0.0300,  9.74e-08,  9.74e-08,  9.74e-08,  nan ],
	[   480,    7.3362,  0.0629,    9.0503,  0.0510,   8.3843,   0.0551,   8.5697,   0.0539,  9.54e-08,  9.54e-08,  9.54e-08,  nan ],
	[   490,    7.5027,  0.0641,    9.2579,  0.0520,   8.4444,   0.0570,  13.0207,   0.0370,  9.34e-08,  1.25e-07,  1.25e-07,  nan ],
	[   500,    7.8408,  0.0639,    9.6392,  0.0520,   8.4732,   0.0591,  13.5571,   0.0370,  9.16e-08,  1.22e-07,  1.53e-07,  nan ],
	[   510,    8.1270,  0.0641,    9.8475,  0.0529,   8.6752,   0.0601,  13.3302,   0.0391,  8.98e-08,  8.98e-08,  8.98e-08,  nan ],
	[   520,    7.9742,  0.0679,   10.0116,  0.0541,   8.9123,   0.0608,  10.4250,   0.0520,  1.47e-07,  8.80e-08,  1.17e-07,  nan ],
	[   530,    8.4014,  0.0670,   10.8294,  0.0520,   8.9424,   0.0629,  15.2310,   0.0370,  1.44e-07,  1.15e-07,  1.15e-07,  nan ],
	[   540,    8.7212,  0.0670,   10.9895,  0.0532,   9.0097,   0.0648,  15.8106,   0.0370,  1.13e-07,  1.13e-07,  1.13e-07,  nan ],
	[   550,    8.9199,  0.0679,   11.1990,  0.0541,   9.6294,   0.0629,  14.7800,   0.0410,  1.39e-07,  1.11e-07,  1.11e-07,  nan ],
	[   560,    9.1189,  0.0689,   11.8178,  0.0532,   9.5484,   0.0658,  16.0693,   0.0391,  1.36e-07,  1.09e-07,  1.09e-07,  nan ],
	[   570,    9.4146,  0.0691,   12.0275,  0.0541,   9.8565,   0.0660,  14.4457,   0.0451,  1.34e-07,  1.07e-07,  1.07e-07,  nan ],
	[   580,    9.4859,  0.0710,   12.7333,  0.0529,   9.9186,   0.0679,  16.4348,   0.0410,  1.05e-07,  1.05e-07,  1.05e-07,  nan ],
	[   590,    9.5589,  0.0730,   12.9426,  0.0539,  10.4093,   0.0670,  17.0060,   0.0410,  1.29e-07,  1.03e-07,  1.29e-07,  nan ],
	[   600,    9.8854,  0.0730,   13.0949,  0.0551,  10.6138,   0.0679,  15.6732,   0.0460,  1.27e-07,  1.53e-07,  1.27e-07,  nan ],
	[   610,   10.2174,  0.0730,   13.5936,  0.0548,  10.6344,   0.0701,  16.1996,   0.0460,  1.25e-07,  1.00e-07,  1.25e-07,  nan ],
	[   620,   10.4187,  0.0739,   13.7438,  0.0560,  10.5548,   0.0730,  16.3948,   0.0470,  1.23e-07,  9.84e-08,  1.23e-07,  nan ],
	[   630,   10.7572,  0.0739,   13.9528,  0.0570,  10.8978,   0.0730,  16.9275,   0.0470,  1.21e-07,  1.21e-07,  1.21e-07,  nan ],
	[   640,   11.1011,  0.0739,   14.8976,  0.0551,  11.3952,   0.0720,  18.3050,   0.0448,  9.54e-08,  1.19e-07,  1.19e-07,  nan ],
	[   650,   10.8221,  0.0782,   14.8520,  0.0570,  11.6001,   0.0730,  18.7812,   0.0451,  1.17e-07,  1.17e-07,  1.41e-07,  nan ],
	[   660,   11.1915,  0.0780,   14.7565,  0.0591,  11.6548,   0.0749,  18.5767,   0.0470,  1.39e-07,  1.16e-07,  1.16e-07,  nan ],
	[   670,   11.3592,  0.0792,   15.5196,  0.0579,  11.8222,   0.0761,  19.1435,   0.0470,  1.37e-07,  9.11e-08,  9.11e-08,  nan ],
	[   680,   11.7006,  0.0792,   15.4765,  0.0598,  11.8433,   0.0782,  18.9493,   0.0489,  1.12e-07,  1.35e-07,  1.35e-07,  nan ],
	[   690,   12.1939,  0.0782,   16.1927,  0.0589,  12.3827,   0.0770,  19.0457,   0.0501,  1.33e-07,  1.33e-07,  1.33e-07,  nan ],
	[   700,   12.4359,  0.0789,   16.5979,  0.0591,  12.4359,   0.0789,  18.8821,   0.0520,  1.31e-07,  1.31e-07,  1.31e-07,  nan ],
	[   710,   12.3100,  0.0820,   16.8711,  0.0598,  12.6408,   0.0799,  21.0679,   0.0479,  1.29e-07,  1.29e-07,  1.29e-07,  nan ],
	[   720,   12.5135,  0.0830,   17.3494,  0.0598,  12.9604,   0.0801,  20.7366,   0.0501,  1.27e-07,  1.27e-07,  1.27e-07,  nan ],
	[   730,   12.8633,  0.0830,   17.7635,  0.0601,  13.0128,   0.0820,  20.5340,   0.0520,  1.25e-07,  1.25e-07,  1.25e-07,  nan ],
	[   740,   13.0306,  0.0842,   17.6916,  0.0620,  13.2178,   0.0830,  21.1000,   0.0520,  1.24e-07,  1.24e-07,  1.24e-07,  nan ],
	[   750,   13.3849,  0.0842,   17.0573,  0.0660,  13.5383,   0.0832,  22.0789,   0.0510,  1.22e-07,  1.22e-07,  1.63e-07,  nan ],
	[   760,   13.2922,  0.0870,   18.6601,  0.0620,  13.9415,   0.0830,  21.0941,   0.0548,  1.20e-07,  1.20e-07,  1.20e-07,  nan ],
	[   770,   13.3514,  0.0889,   18.7927,  0.0632,  13.9498,   0.0851,  21.9386,   0.0541,  1.19e-07,  1.19e-07,  1.59e-07,  nan ],
	[   780,   13.8487,  0.0880,   19.3567,  0.0629,  14.3142,   0.0851,  23.0188,   0.0529,  1.57e-07,  1.17e-07,  1.57e-07,  nan ],
	[   790,   14.2058,  0.0880,   19.8559,  0.0629,  14.8919,   0.0839,  21.9329,   0.0570,  1.55e-07,  1.55e-07,  1.16e-07,  nan ],
	[   800,   14.4113,  0.0889,   20.3614,  0.0629,  15.0995,   0.0849,  24.2136,   0.0529,  1.53e-07,  1.14e-07,  1.53e-07,  nan ],
	[   810,   14.9338,  0.0880,   21.1945,  0.0620,  15.0974,   0.0870,  23.9590,   0.0548,  1.13e-07,  1.13e-07,  1.51e-07,  nan ],
	[   820,   14.7837,  0.0911,   20.6864,  0.0651,  15.4723,   0.0870,  23.1450,   0.0582,  1.49e-07,  1.12e-07,  1.49e-07,  nan ],
	[   830,   15.1463,  0.0911,   21.5891,  0.0639,  15.8517,   0.0870,  23.3301,   0.0591,  1.47e-07,  1.10e-07,  1.10e-07,  nan ],
	[   840,   14.7048,  0.0961,   22.0299,  0.0641,  15.8875,   0.0889,  25.2172,   0.0560,  1.45e-07,  1.45e-07,  1.09e-07,  nan ],
	[   850,   15.0943,  0.0958,   21.9851,  0.0658,  16.2678,   0.0889,  24.5664,   0.0589,  1.08e-07,  1.44e-07,  1.08e-07,  nan ],
	[   860,   15.4513,  0.0958,   22.7525,  0.0651,  16.4324,   0.0901,  25.5614,   0.0579,  1.42e-07,  1.42e-07,  1.06e-07,  nan ],
	[   870,   15.8125,  0.0958,   22.9481,  0.0660,  16.8611,   0.0899,  25.2247,   0.0601,  1.40e-07,  1.40e-07,  1.40e-07,  nan ],
	[   880,   15.8236,  0.0980,   23.1442,  0.0670,  17.0249,   0.0911,  25.9104,   0.0598,  1.39e-07,  1.39e-07,  1.39e-07,  nan ],
	[   890,   16.3442,  0.0970,   23.2590,  0.0682,  17.4138,   0.0911,  25.5849,   0.0620,  1.03e-07,  1.37e-07,  1.03e-07,  nan ],
	[   900,   15.4248,  0.1051,   23.1372,  0.0701,  17.2648,   0.0939,  25.7664,   0.0629,  1.36e-07,  1.36e-07,  1.36e-07,  nan ],
	[  1000,   17.8660,  0.1121,   27.4412,  0.0730,  18.7433,   0.1068,  28.2727,   0.0708,  1.22e-07,  1.22e-07,  1.53e-07,  nan ],
	[  1100,   19.0609,  0.1271,   30.6007,  0.0792,  20.5241,   0.1180,  28.1425,   0.0861,  1.66e-07,  1.39e-07,  1.39e-07,  nan ],
	[  1200,   21.3598,  0.1349,   34.7404,  0.0830,  23.0719,   0.1249,  30.3760,   0.0949,  1.78e-07,  1.27e-07,  1.27e-07,  nan ],
	[  1300,   22.9946,  0.1471,   38.8703,  0.0870,  25.6558,   0.1318,  29.4350,   0.1149,  1.64e-07,  1.17e-07,  1.64e-07,  nan ],
	[  1400,   25.6284,  0.1531,   43.6430,  0.0899,  27.6064,   0.1421,  30.8694,   0.1271,  1.74e-07,  1.74e-07,  1.31e-07,  nan ],
	[  1500,   27.2933,  0.1650,   46.9825,  0.0958,  28.6600,   0.1571,  33.3692,   0.1349,  2.03e-07,  1.63e-07,  1.63e-07,  nan ],
	[  1600,   29.7621,  0.1721,   50.3238,  0.1018,  31.0524,   0.1650,  32.8065,   0.1562,  1.91e-07,  1.53e-07,  1.53e-07,  nan ],
	[  1700,   31.2595,  0.1850,   55.0053,  0.1051,  33.0481,   0.1750,  34.6039,   0.1671,  1.80e-07,  2.15e-07,  1.80e-07,  nan ],
	[  1800,   33.2447,  0.1950,   57.3717,  0.1130,  35.4091,   0.1831,  34.6865,   0.1869,  1.70e-07,  1.70e-07,  1.70e-07,  nan ],
	[  1900,   35.6038,  0.2029,   62.2152,  0.1161,  37.4059,   0.1931,  32.8264,   0.2201,  2.25e-07,  1.61e-07,  1.28e-07,  nan ],
	[  2000,   36.8914,  0.2170,   60.5979,  0.1321,  37.2186,   0.2151,  35.4127,   0.2260,  2.14e-07,  1.53e-07,  1.53e-07,  nan ],
	[  2100,   39.2070,  0.2251,   62.5192,  0.1411,  24.4461,   0.3610,  34.8835,   0.2530,  2.03e-07,  1.74e-07,  1.74e-07,  nan ],
	[  2200,   40.3370,  0.2401,   66.8081,  0.1450,  25.2765,   0.3831,  33.8494,   0.2861,  2.50e-07,  1.66e-07,  1.39e-07,  nan ],
	[  2300,   42.4833,  0.2491,   72.0699,  0.1469,  26.1301,   0.4051,  36.2408,   0.2921,  2.92e-07,  1.86e-07,  1.86e-07,  nan ],
	[  2400,   44.1448,  0.2611,   73.7993,  0.1562,  27.3873,   0.4208,  37.6468,   0.3061,  2.29e-07,  1.78e-07,  1.78e-07,  nan ],
	[  2500,   45.6482,  0.2739,   75.7945,  0.1650,  28.4127,   0.4401,  39.7046,   0.3150,  2.69e-07,  1.71e-07,  1.46e-07,  nan ],
	[  2600,   47.9533,  0.2820,   80.4664,  0.1681,  29.2718,   0.4621,  37.2725,   0.3629,  2.11e-07,  1.88e-07,  1.88e-07,  nan ],
	[  2700,   49.4548,  0.2949,   83.9171,  0.1738,  30.3903,   0.4799,  38.7924,   0.3760,  2.26e-07,  1.81e-07,  1.58e-07,  nan ],
	[  2800,   51.7625,  0.3030,   86.2257,  0.1819,  31.5540,   0.4971,  35.0881,   0.4470,  2.62e-07,  1.74e-07,  1.74e-07,  nan ],
	[  2900,   53.1020,  0.3169,   90.9440,  0.1850,  32.7483,   0.5138,  37.6588,   0.4468,  2.53e-07,  2.10e-07,  1.68e-07,  nan ],
	[  3000,   54.5684,  0.3300,   93.3531,  0.1929,  34.0345,   0.5291,  35.7927,   0.5031,  3.26e-07,  2.44e-07,  2.03e-07,  nan ],
	[  3100,   55.9227,  0.3438,   98.7032,  0.1948,  34.5800,   0.5560,  33.7974,   0.5689,  2.36e-07,  2.36e-07,  1.97e-07,  nan ],
	[  3200,   58.3738,  0.3510,  103.4010,  0.1981,  35.6985,   0.5739,  31.1892,   0.6568,  2.67e-07,  1.91e-07,  1.91e-07,  nan ],
	[  3300,   60.0392,  0.3629,  102.6737,  0.2122,  36.8021,   0.5920,  35.0920,   0.6208,  2.96e-07,  2.22e-07,  1.85e-07,  nan ],
	[  3400,   63.0285,  0.3669,  108.0187,  0.2141,  38.0395,   0.6080,  30.8821,   0.7489,  2.87e-07,  2.15e-07,  1.80e-07,  nan ],
	[  3500,   63.1387,  0.3881,  109.3509,  0.2241,  39.0836,   0.6270,  35.7779,   0.6850,  3.14e-07,  2.09e-07,  1.74e-07,  nan ],
	[  3600,   65.9870,  0.3929,  112.8076,  0.2298,  39.9363,   0.6492,  29.5266,   0.8781,  2.71e-07,  2.37e-07,  1.70e-07,  nan ],
	[  3700,   67.8106,  0.4039,  113.1735,  0.2420,  41.0694,   0.6669,  28.7393,   0.9530,  2.64e-07,  2.31e-07,  1.98e-07,  nan ],
	[  3800,   69.0783,  0.4182,  115.5037,  0.2501,  42.0414,   0.6871,   4.5443,   6.3570,  2.89e-07,  2.89e-07,  1.93e-07,  nan ],
	[  3900,   69.6635,  0.4368,  111.8523,  0.2720,  43.2769,   0.7031,  31.9298,   0.9530,  2.50e-07,  2.19e-07,  1.88e-07,  nan ],
	[  4000,   71.7538,  0.4461,  113.9654,  0.2809,  44.2198,   0.7238,  30.4287,   1.0519,  3.05e-07,  2.14e-07,  1.83e-07,  nan ],
	[  4100,   70.6294,  0.4761,  110.6250,  0.3040,  31.9617,   1.0521,  26.1926,   1.2839,  3.28e-07,  2.08e-07,  2.08e-07,  nan ],
	[  4200,   73.3450,  0.4811,  114.6478,  0.3078,  32.8255,   1.0750,  31.9953,   1.1029,  2.91e-07,  2.33e-07,  2.03e-07,  nan ],
	[  4300,   75.9752,  0.4869,  114.8345,  0.3221,  34.0596,   1.0860,   6.0695,   6.0942,  3.41e-07,  2.55e-07,  1.99e-07,  nan ],
	[  4400,   77.3157,  0.5009,  113.5153,  0.3412,  34.6133,   1.1189,  12.3887,   3.1261,  2.77e-07,  2.77e-07,  2.22e-07,  nan ],
	[  4500,   78.3343,  0.5171,  114.4926,  0.3538,  35.5603,   1.1392,  32.9597,   1.2290,  2.71e-07,  2.44e-07,  2.17e-07,  nan ],
	[  4600,   80.6274,  0.5250,  116.0402,  0.3648,  36.1813,   1.1699,  31.1476,   1.3590,  3.18e-07,  2.39e-07,  2.12e-07,  nan ],
	[  4700,   81.6852,  0.5410,  116.2759,  0.3800,  36.8257,   1.2000,  31.8624,   1.3869,  3.12e-07,  2.60e-07,  2.34e-07,  nan ],
	[  4800,   82.5774,  0.5581,  118.1625,  0.3901,  37.1044,   1.2422,  31.1194,   1.4811,  3.05e-07,  2.29e-07,  1.78e-07,  nan ],
	[  4900,   81.1323,  0.5920,  115.7768,  0.4148,  38.5185,   1.2469,  32.7191,   1.4679,  3.99e-07,  2.24e-07,  2.49e-07,  nan ],
	[  5000,   81.3012,  0.6151,  119.3158,  0.4191,  39.3467,   1.2710,  30.6438,   1.6320,  3.17e-07,  2.44e-07,  2.20e-07,  nan ],
	[  5100,   80.9160,  0.6430,  117.9624,  0.4411,  39.8667,   1.3051,  34.2968,   1.5171,  3.35e-07,  2.15e-07,  2.15e-07,  nan ],
	[  5200,   82.5889,  0.6549,  118.9054,  0.4549,  40.3686,   1.3399,  28.9229,   1.8702,  3.29e-07,  2.58e-07,  2.82e-07,  nan ],
	[  5300,   83.1031,  0.6762,  118.5515,  0.4740,  41.4638,   1.3552,   8.7089,   6.4521,  3.92e-07,  2.53e-07,  2.53e-07,  nan ],
	[  5400,   82.8504,  0.7041,  121.0575,  0.4818,  41.9940,   1.3890,  35.0160,   1.6658,  3.84e-07,  2.49e-07,  2.26e-07,  nan ],
	[  5500,   83.1046,  0.7281,  120.2851,  0.5031,  42.7924,   1.4141,   9.3008,   6.5060,  3.11e-07,  2.66e-07,  2.22e-07,  nan ],
	[  5600,   84.5481,  0.7420,  122.2647,  0.5131,  43.0840,   1.4560,  37.8091,   1.6592,  4.36e-07,  3.05e-07,  2.18e-07,  nan ],
	[  5700,   84.9731,  0.7648,  122.6242,  0.5300,  43.9455,   1.4789,  10.6370,   6.1100,  3.43e-07,  2.57e-07,  2.14e-07,  nan ],
	[  5800,   84.1005,  0.8001,  124.8304,  0.5391,  44.2107,   1.5221,  34.6862,   1.9400,  3.79e-07,  2.53e-07,  2.53e-07,  nan ],
	[  5900,   84.6051,  0.8230,  122.6100,  0.5679,  45.3364,   1.5359,  33.9167,   2.0530,  3.72e-07,  3.31e-07,  2.48e-07,  nan ],
	[  6000,   84.4159,  0.8531,  125.4320,  0.5741,  45.3718,   1.5872,  25.5641,   2.8169,  4.07e-07,  2.85e-07,  2.44e-07,  nan ],
	[  6100,   86.0505,  0.8650,  125.3277,  0.5939,  46.3192,   1.6069,  35.1923,   2.1150,  4.00e-07,  2.80e-07,  2.40e-07,  nan ],
	[  6200,   86.6031,  0.8879,  124.8587,  0.6158,  35.9663,   2.1379,  36.2860,   2.1191,  3.94e-07,  2.76e-07,  2.36e-07,  nan ],
	[  6300,   87.6307,  0.9060,  124.8582,  0.6359,  37.7333,   2.1040,  38.6531,   2.0540,  3.49e-07,  2.71e-07,  2.33e-07,  nan ],
	[  6400,   88.4786,  0.9260,  127.4198,  0.6430,  38.5389,   2.1260,  40.4819,   2.0239,  3.43e-07,  2.67e-07,  2.29e-07,  nan ],
	[  6500,   88.4856,  0.9551,  125.0346,  0.6759,  38.6937,   2.1842,  12.4525,   6.7868,  3.76e-07,  3.00e-07,  3.00e-07,  nan ],
	[  6600,   89.6402,  0.9720,  127.2061,  0.6850,  39.7675,   2.1911,  39.0369,   2.2321,  3.70e-07,  2.96e-07,  3.33e-07,  nan ],
	[  6700,   88.2843,  1.0171,  128.6713,  0.6979,  40.0490,   2.2421,  38.3407,   2.3420,  3.64e-07,  2.55e-07,  2.55e-07,  nan ],
	[  6800,   89.1011,  1.0381,  128.8430,  0.7179,  40.6567,   2.2750,  36.7896,   2.5141,  3.59e-07,  3.95e-07,  2.87e-07,  nan ],
	[  6900,   90.1873,  1.0560,  130.4505,  0.7300,  40.5234,   2.3501,  39.8284,   2.3911,  3.54e-07,  3.18e-07,  2.83e-07,  nan ],
	[  7000,   89.8384,  1.0910,  131.2163,  0.7470,  41.9747,   2.3351,  29.3015,   3.3450,  4.53e-07,  3.14e-07,  2.79e-07,  nan ],
	[  7100,   91.6622,  1.1001,  132.0004,  0.7639,  42.4585,   2.3749,  38.4726,   2.6209,  4.47e-07,  3.09e-07,  3.09e-07,  nan ],
	[  7200,   92.0868,  1.1261,  132.9642,  0.7799,  41.9327,   2.4729,  31.0373,   3.3410,  3.73e-07,  2.71e-07,  3.05e-07,  nan ],
	[  7300,   91.8804,  1.1601,  131.5745,  0.8101,  43.3143,   2.4610,  39.3947,   2.7058,  4.68e-07,  3.01e-07,  2.68e-07,  nan ],
	[  7400,   92.1240,  1.1890,  131.9800,  0.8299,  43.7962,   2.5010,  37.3453,   2.9330,  3.96e-07,  2.97e-07,  2.97e-07,  nan ],
	[  7500,   93.2100,  1.2071,  133.8027,  0.8409,  44.4037,   2.5339,  33.7569,   3.3331,  3.91e-07,  2.93e-07,  2.60e-07,  nan ],
	[  7600,   94.7760,  1.2190,  133.0925,  0.8681,  44.7286,   2.5830,  17.0259,   6.7859,  4.50e-07,  3.21e-07,  2.89e-07,  nan ],
	[  7700,   93.8361,  1.2639,  132.3643,  0.8960,  43.6147,   2.7192,  38.9862,   3.0420,  4.12e-07,  3.17e-07,  3.17e-07,  nan ],
	[  7800,   95.5143,  1.2741,  133.5850,  0.9110,  45.9060,   2.6510,  39.5620,   3.0761,  4.38e-07,  3.13e-07,  3.13e-07,  nan ],
	[  7900,   94.8549,  1.3161,  134.4976,  0.9282,  46.4926,   2.6851,  38.8773,   3.2110,  4.02e-07,  3.09e-07,  2.78e-07,  nan ],
	[  8000,   95.8989,  1.3349,  133.8998,  0.9561,  46.9433,   2.7270,  39.6469,   3.2289,  3.97e-07,  3.36e-07,  2.75e-07,  nan ],
	[  8100,   96.5523,  1.3592,  135.4440,  0.9689,  46.8065,   2.8038,  32.2274,   4.0722,  4.22e-07,  3.92e-07,  3.32e-07,  nan ],
	[  8200,   97.3962,  1.3809,  135.1506,  0.9952,  38.3519,   3.5069,  30.8700,   4.3569,  3.87e-07,  2.98e-07,  2.68e-07,  nan ],
	[  8300,   98.2091,  1.4031,  132.7730,  1.0378,  39.9172,   3.4521,  35.0981,   3.9260,  4.12e-07,  3.53e-07,  2.94e-07,  nan ],
	[  8400,   98.2850,  1.4360,  134.9375,  1.0459,  40.6155,   3.4750,  40.7553,   3.4630,  4.36e-07,  3.78e-07,  2.62e-07,  nan ],
	[  8500,  100.2229,  1.4420,  133.3073,  1.0841,  40.3561,   3.5810,  20.5893,   7.0190,  5.17e-07,  3.45e-07,  2.87e-07,  nan ],
	[  8600,   99.8863,  1.4811,  134.4806,  1.1001,  39.9494,   3.7031,  20.3068,   7.2851,  4.26e-07,  3.12e-07,  2.55e-07,  nan ],
	[  8700,   99.5464,  1.5209,  134.4783,  1.1258,  40.2974,   3.7570,  36.7183,   4.1232,  4.21e-07,  3.37e-07,  2.81e-07,  nan ],
	[  8800,   99.1738,  1.5619,  136.0033,  1.1389,  41.3051,   3.7501,  40.6436,   3.8111,  3.88e-07,  3.05e-07,  2.77e-07,  nan ],
	[  8900,   99.4517,  1.5931,  134.7397,  1.1759,  42.1928,   3.7551,  41.1733,   3.8481,  4.11e-07,  3.29e-07,  2.74e-07,  nan ],
	[  9000,  100.3919,  1.6139,  134.1399,  1.2078,  43.0451,   3.7639,  38.5125,   4.2069,  4.88e-07,  3.80e-07,  3.26e-07,  nan ],
	[ 10000,  103.5862,  1.9310,  135.3355,  1.4780,  47.3418,   4.2250,  39.8057,   5.0249,  4.88e-07,  3.91e-07,  3.66e-07,  nan ],
	[ 12000,  104.7754,  2.7490,  139.4828,  2.0649,  46.2026,   6.2339,  42.5748,   6.7651,  5.70e-07,  4.48e-07,  3.26e-07,  nan ],
	[ 14000,  112.3913,  3.4881,  141.1767,  2.7769,  45.6796,   8.5821,  46.2996,   8.4672,  5.58e-07,  4.19e-07,  3.84e-07,  nan ],
	[ 16000,  113.0087,  4.5309,  140.9753,  3.6321,  46.0132,  11.1279,  40.1972,  12.7380,  5.49e-07,  4.27e-07,  3.97e-07,  nan ],
	[ 18000,  114.0078,  5.6841,  142.1134,  4.5600,  44.7388,  14.4849,  46.4276,  13.9580,  6.51e-07,  5.70e-07,  4.61e-07,  nan ],
	[ 20000,  117.9311,  6.7840,  143.8633,  5.5611,  46.3258,  17.2698,  44.7851,  17.8640,  7.08e-07,  5.13e-07,  4.39e-07,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/zgeev.txt
# numactl --interleave=all ./testing_zgeev -RN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgeev_RN = array([
	[    10,  nan,    0.0004 ],
	[    20,  nan,    0.0007 ],
	[    30,  nan,    0.0011 ],
	[    40,  nan,    0.0036 ],
	[    50,  nan,    0.0042 ],
	[    60,  nan,    0.0049 ],
	[    70,  nan,    0.0078 ],
	[    80,  nan,    0.0113 ],
	[    90,  nan,    0.0139 ],
	[   100,  nan,    0.0173 ],
	[   200,  nan,    0.0863 ],
	[   300,  nan,    0.1768 ],
	[   400,  nan,    0.2995 ],
	[   500,  nan,    0.4464 ],
	[   600,  nan,    0.8873 ],
	[   700,  nan,    1.0439 ],
	[   800,  nan,    1.3072 ],
	[   900,  nan,    1.5468 ],
	[  1000,  nan,    1.8525 ],
	[  2000,  nan,    6.1634 ],
	[  3000,  nan,   17.1323 ],
	[  4000,  nan,   28.0308 ],
	[  5000,  nan,   42.2181 ],
	[  6000,  nan,   78.2429 ],
	[  7000,  nan,  103.6778 ],
	[  8000,  nan,  134.1766 ],
	[  9000,  nan,  166.0422 ],
	[ 10000,  nan,  209.0759 ],
	[ 12000,  nan,  296.2539 ],
	[ 14000,  nan,  415.0786 ],
	[ 16000,  nan,  570.6335 ],
	[ 18000,  nan,  742.0050 ],
	[ 20000,  nan,  968.3600 ],
])

# numactl --interleave=all ./testing_zgeev -RV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgeev_RV = array([
	[    10,  nan,     0.0012 ],
	[    20,  nan,     0.0017 ],
	[    30,  nan,     0.0029 ],
	[    40,  nan,     0.0054 ],
	[    50,  nan,     0.0070 ],
	[    60,  nan,     0.0086 ],
	[    70,  nan,     0.0128 ],
	[    80,  nan,     0.0195 ],
	[    90,  nan,     0.0223 ],
	[   100,  nan,     0.0276 ],
	[   200,  nan,     0.1212 ],
	[   300,  nan,     0.2399 ],
	[   400,  nan,     0.3777 ],
	[   500,  nan,     0.5809 ],
	[   600,  nan,     1.0214 ],
	[   700,  nan,     1.2524 ],
	[   800,  nan,     1.5988 ],
	[   900,  nan,     1.9696 ],
	[  1000,  nan,     2.3669 ],
	[  2000,  nan,     8.3965 ],
	[  3000,  nan,    22.3824 ],
	[  4000,  nan,    41.8941 ],
	[  5000,  nan,    66.8335 ],
	[  6000,  nan,   117.4800 ],
	[  7000,  nan,   152.1168 ],
	[  8000,  nan,   201.9008 ],
	[  9000,  nan,   263.8754 ],
	[ 10000,  nan,   320.2209 ],
	[ 12000,  nan,   488.7023 ],
	[ 14000,  nan,   803.7817 ],
	[ 16000,  nan,  1006.3492 ],
	[ 18000,  nan,  1357.5812 ],
	[ 20000,  nan,  1780.3335 ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/zgeqrf.txt
# numactl --interleave=all ./testing_zgeqrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgeqrf = array([
	[    10,     10,  nan,  nan,     0.13,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.76,   0.00,  nan ],
	[    30,     30,  nan,  nan,     1.85,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.93,   0.00,  nan ],
	[    50,     50,  nan,  nan,     1.60,   0.00,  nan ],
	[    60,     60,  nan,  nan,     2.30,   0.00,  nan ],
	[    70,     70,  nan,  nan,     1.73,   0.00,  nan ],
	[    80,     80,  nan,  nan,     2.62,   0.00,  nan ],
	[    90,     90,  nan,  nan,     3.47,   0.00,  nan ],
	[   100,    100,  nan,  nan,     4.42,   0.00,  nan ],
	[   200,    200,  nan,  nan,    14.01,   0.00,  nan ],
	[   300,    300,  nan,  nan,    29.03,   0.00,  nan ],
	[   400,    400,  nan,  nan,    44.79,   0.01,  nan ],
	[   500,    500,  nan,  nan,    62.82,   0.01,  nan ],
	[   600,    600,  nan,  nan,    77.66,   0.01,  nan ],
	[   700,    700,  nan,  nan,    97.16,   0.02,  nan ],
	[   800,    800,  nan,  nan,   114.19,   0.02,  nan ],
	[   900,    900,  nan,  nan,   132.77,   0.03,  nan ],
	[  1000,   1000,  nan,  nan,   149.44,   0.04,  nan ],
	[  2000,   2000,  nan,  nan,   358.56,   0.12,  nan ],
	[  3000,   3000,  nan,  nan,   579.59,   0.25,  nan ],
	[  4000,   4000,  nan,  nan,   725.78,   0.47,  nan ],
	[  5000,   5000,  nan,  nan,   755.44,   0.88,  nan ],
	[  6000,   6000,  nan,  nan,   859.64,   1.34,  nan ],
	[  7000,   7000,  nan,  nan,   936.70,   1.95,  nan ],
	[  8000,   8000,  nan,  nan,   974.19,   2.80,  nan ],
	[  9000,   9000,  nan,  nan,  1006.34,   3.86,  nan ],
	[ 10000,  10000,  nan,  nan,  1023.16,   5.21,  nan ],
	[ 12000,  12000,  nan,  nan,  1058.95,   8.70,  nan ],
	[ 14000,  14000,  nan,  nan,  1065.63,  13.74,  nan ],
	[ 16000,  16000,  nan,  nan,  1082.08,  20.19,  nan ],
	[ 18000,  18000,  nan,  nan,  1054.27,  29.51,  nan ],
	[ 20000,  20000,  nan,  nan,  1072.48,  39.79,  nan ],
])

# numactl --interleave=all ./testing_zgeqrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgeqrf_gpu = array([
	[    10,     10,  nan,  nan,     0.01,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.05,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.14,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.33,   0.00,  nan ],
	[    50,     50,  nan,  nan,     0.60,   0.00,  nan ],
	[    60,     60,  nan,  nan,     0.97,   0.00,  nan ],
	[    70,     70,  nan,  nan,     2.14,   0.00,  nan ],
	[    80,     80,  nan,  nan,     3.21,   0.00,  nan ],
	[    90,     90,  nan,  nan,     3.56,   0.00,  nan ],
	[   100,    100,  nan,  nan,     2.70,   0.00,  nan ],
	[   200,    200,  nan,  nan,    11.01,   0.00,  nan ],
	[   300,    300,  nan,  nan,    24.71,   0.01,  nan ],
	[   400,    400,  nan,  nan,    40.07,   0.01,  nan ],
	[   500,    500,  nan,  nan,    54.69,   0.01,  nan ],
	[   600,    600,  nan,  nan,    73.37,   0.02,  nan ],
	[   700,    700,  nan,  nan,    87.19,   0.02,  nan ],
	[   800,    800,  nan,  nan,   105.31,   0.03,  nan ],
	[   900,    900,  nan,  nan,   122.82,   0.03,  nan ],
	[  1000,   1000,  nan,  nan,   139.42,   0.04,  nan ],
	[  2000,   2000,  nan,  nan,   349.09,   0.12,  nan ],
	[  3000,   3000,  nan,  nan,   579.17,   0.25,  nan ],
	[  4000,   4000,  nan,  nan,   727.51,   0.47,  nan ],
	[  5000,   5000,  nan,  nan,   755.23,   0.88,  nan ],
	[  6000,   6000,  nan,  nan,   867.98,   1.33,  nan ],
	[  7000,   7000,  nan,  nan,   937.94,   1.95,  nan ],
	[  8000,   8000,  nan,  nan,   975.82,   2.80,  nan ],
	[  9000,   9000,  nan,  nan,   997.39,   3.90,  nan ],
	[ 10000,  10000,  nan,  nan,  1013.86,   5.26,  nan ],
	[ 12000,  12000,  nan,  nan,  1052.61,   8.76,  nan ],
	[ 14000,  14000,  nan,  nan,  1063.15,  13.77,  nan ],
	[ 16000,  16000,  nan,  nan,  1087.37,  20.09,  nan ],
	[ 18000,  18000,  nan,  nan,  1050.26,  29.62,  nan ],
	[ 20000,  20000,  nan,  nan,  1071.03,  39.84,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/zgetrf.txt
# numactl --interleave=all ./testing_zgetrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgetrf = array([
	[    10,     10,  nan,  nan,     0.27,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.81,   0.00,  nan ],
	[    30,     30,  nan,  nan,     1.34,   0.00,  nan ],
	[    40,     40,  nan,  nan,     3.09,   0.00,  nan ],
	[    50,     50,  nan,  nan,     2.01,   0.00,  nan ],
	[    60,     60,  nan,  nan,     4.12,   0.00,  nan ],
	[    70,     70,  nan,  nan,     1.12,   0.00,  nan ],
	[    80,     80,  nan,  nan,     1.63,   0.00,  nan ],
	[    90,     90,  nan,  nan,     2.09,   0.00,  nan ],
	[   100,    100,  nan,  nan,     2.65,   0.00,  nan ],
	[   200,    200,  nan,  nan,    10.58,   0.00,  nan ],
	[   300,    300,  nan,  nan,    22.35,   0.00,  nan ],
	[   400,    400,  nan,  nan,    35.30,   0.00,  nan ],
	[   500,    500,  nan,  nan,    50.70,   0.01,  nan ],
	[   600,    600,  nan,  nan,    66.13,   0.01,  nan ],
	[   700,    700,  nan,  nan,    83.86,   0.01,  nan ],
	[   800,    800,  nan,  nan,   101.99,   0.01,  nan ],
	[   900,    900,  nan,  nan,   118.39,   0.02,  nan ],
	[  1000,   1000,  nan,  nan,   136.90,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   332.12,   0.06,  nan ],
	[  3000,   3000,  nan,  nan,   512.23,   0.14,  nan ],
	[  4000,   4000,  nan,  nan,   624.34,   0.27,  nan ],
	[  5000,   5000,  nan,  nan,   668.85,   0.50,  nan ],
	[  6000,   6000,  nan,  nan,   759.58,   0.76,  nan ],
	[  7000,   7000,  nan,  nan,   820.13,   1.12,  nan ],
	[  8000,   8000,  nan,  nan,   873.60,   1.56,  nan ],
	[  9000,   9000,  nan,  nan,   892.08,   2.18,  nan ],
	[ 10000,  10000,  nan,  nan,   930.85,   2.86,  nan ],
	[ 12000,  12000,  nan,  nan,   985.75,   4.67,  nan ],
	[ 14000,  14000,  nan,  nan,  1023.04,   7.15,  nan ],
	[ 16000,  16000,  nan,  nan,  1050.01,  10.40,  nan ],
	[ 18000,  18000,  nan,  nan,  1058.57,  14.69,  nan ],
	[ 20000,  20000,  nan,  nan,  1066.84,  20.00,  nan ],
])

# numactl --interleave=all ./testing_zgetrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.06,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.29,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.60,   0.00,  nan ],
	[    40,     40,  nan,  nan,     1.29,   0.00,  nan ],
	[    50,     50,  nan,  nan,     1.18,   0.00,  nan ],
	[    60,     60,  nan,  nan,     2.25,   0.00,  nan ],
	[    70,     70,  nan,  nan,     0.54,   0.00,  nan ],
	[    80,     80,  nan,  nan,     0.82,   0.00,  nan ],
	[    90,     90,  nan,  nan,     1.10,   0.00,  nan ],
	[   100,    100,  nan,  nan,     1.45,   0.00,  nan ],
	[   200,    200,  nan,  nan,     6.56,   0.00,  nan ],
	[   300,    300,  nan,  nan,    16.09,   0.00,  nan ],
	[   400,    400,  nan,  nan,    28.03,   0.01,  nan ],
	[   500,    500,  nan,  nan,    43.38,   0.01,  nan ],
	[   600,    600,  nan,  nan,    56.20,   0.01,  nan ],
	[   700,    700,  nan,  nan,    74.53,   0.01,  nan ],
	[   800,    800,  nan,  nan,    92.45,   0.01,  nan ],
	[   900,    900,  nan,  nan,   110.40,   0.02,  nan ],
	[  1000,   1000,  nan,  nan,   132.67,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   417.89,   0.05,  nan ],
	[  3000,   3000,  nan,  nan,   643.55,   0.11,  nan ],
	[  4000,   4000,  nan,  nan,   766.68,   0.22,  nan ],
	[  5000,   5000,  nan,  nan,   807.08,   0.41,  nan ],
	[  6000,   6000,  nan,  nan,   898.85,   0.64,  nan ],
	[  7000,   7000,  nan,  nan,   954.91,   0.96,  nan ],
	[  8000,   8000,  nan,  nan,  1005.00,   1.36,  nan ],
	[  9000,   9000,  nan,  nan,  1015.98,   1.91,  nan ],
	[ 10000,  10000,  nan,  nan,  1048.98,   2.54,  nan ],
	[ 12000,  12000,  nan,  nan,  1090.31,   4.23,  nan ],
	[ 14000,  14000,  nan,  nan,  1115.15,   6.56,  nan ],
	[ 16000,  16000,  nan,  nan,  1131.71,   9.65,  nan ],
	[ 18000,  18000,  nan,  nan,  1135.59,  13.69,  nan ],
	[ 20000,  20000,  nan,  nan,  1127.67,  18.92,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/zheevd.txt
# numactl --interleave=all ./testing_zheevd -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevd_JN = array([
	[    10,  nan,    0.0001 ],
	[    20,  nan,    0.0001 ],
	[    30,  nan,    0.0001 ],
	[    40,  nan,    0.0002 ],
	[    50,  nan,    0.0003 ],
	[    60,  nan,    0.0004 ],
	[    70,  nan,    0.0007 ],
	[    80,  nan,    0.0009 ],
	[    90,  nan,    0.0013 ],
	[   100,  nan,    0.0016 ],
	[   200,  nan,    0.0069 ],
	[   300,  nan,    0.0140 ],
	[   400,  nan,    0.0241 ],
	[   500,  nan,    0.0380 ],
	[   600,  nan,    0.0542 ],
	[   700,  nan,    0.0753 ],
	[   800,  nan,    0.0998 ],
	[   900,  nan,    0.1278 ],
	[  1000,  nan,    0.1603 ],
	[  2000,  nan,    0.8150 ],
	[  3000,  nan,    2.8244 ],
	[  4000,  nan,    5.7916 ],
	[  5000,  nan,   10.4959 ],
	[  6000,  nan,   17.6870 ],
	[  7000,  nan,   26.3405 ],
	[  8000,  nan,   38.2417 ],
	[  9000,  nan,   53.2866 ],
	[ 10000,  nan,   71.6136 ],
	[ 12000,  nan,  122.3322 ],
	[ 14000,  nan,  188.8206 ],
	[ 16000,  nan,  279.5575 ],
	[ 18000,  nan,  395.5457 ],
	[ 20000,  nan,  537.7369 ],
])

# numactl --interleave=all ./testing_zheevd -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevd_JV = array([
	[    10,  nan,    0.0002 ],
	[    20,  nan,    0.0002 ],
	[    30,  nan,    0.0004 ],
	[    40,  nan,    0.0012 ],
	[    50,  nan,    0.0008 ],
	[    60,  nan,    0.0011 ],
	[    70,  nan,    0.0015 ],
	[    80,  nan,    0.0019 ],
	[    90,  nan,    0.0024 ],
	[   100,  nan,    0.0030 ],
	[   200,  nan,    0.0145 ],
	[   300,  nan,    0.0245 ],
	[   400,  nan,    0.0414 ],
	[   500,  nan,    0.0629 ],
	[   600,  nan,    0.0862 ],
	[   700,  nan,    0.1122 ],
	[   800,  nan,    0.1456 ],
	[   900,  nan,    0.1894 ],
	[  1000,  nan,    0.2318 ],
	[  2000,  nan,    0.9682 ],
	[  3000,  nan,    3.1038 ],
	[  4000,  nan,    6.3641 ],
	[  5000,  nan,   11.7205 ],
	[  6000,  nan,   19.3961 ],
	[  7000,  nan,   29.1155 ],
	[  8000,  nan,   42.2231 ],
	[  9000,  nan,   59.2516 ],
	[ 10000,  nan,   80.2949 ],
	[ 12000,  nan,  136.3392 ],
	[ 14000,  nan,  211.1929 ],
	[ 16000,  nan,  312.5293 ],
	[ 18000,  nan,  444.2959 ],
	[ 20000,  nan,  603.9056 ],
])

# numactl --interleave=all ./testing_zheevd_gpu -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevd_gpu_JN = array([
	[    10,  nan,    0.0001 ],
	[    20,  nan,    0.0001 ],
	[    30,  nan,    0.0001 ],
	[    40,  nan,    0.0002 ],
	[    50,  nan,    0.0003 ],
	[    60,  nan,    0.0004 ],
	[    70,  nan,    0.0008 ],
	[    80,  nan,    0.0010 ],
	[    90,  nan,    0.0015 ],
	[   100,  nan,    0.0018 ],
	[   200,  nan,    0.0072 ],
	[   300,  nan,    0.0144 ],
	[   400,  nan,    0.0247 ],
	[   500,  nan,    0.0385 ],
	[   600,  nan,    0.0546 ],
	[   700,  nan,    0.0758 ],
	[   800,  nan,    0.1004 ],
	[   900,  nan,    0.1283 ],
	[  1000,  nan,    0.1620 ],
	[  2000,  nan,    0.8131 ],
	[  3000,  nan,    2.6892 ],
	[  4000,  nan,    5.7411 ],
	[  5000,  nan,   10.4018 ],
	[  6000,  nan,   16.9828 ],
	[  7000,  nan,   26.6123 ],
	[  8000,  nan,   38.1486 ],
	[  9000,  nan,   53.9836 ],
	[ 10000,  nan,   71.8150 ],
	[ 12000,  nan,  122.0239 ],
	[ 14000,  nan,  190.8749 ],
	[ 16000,  nan,  279.0646 ],
	[ 18000,  nan,  394.3002 ],
	[ 20000,  nan,       nan ],  # failed?
])

# numactl --interleave=all ./testing_zheevd_gpu -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevd_gpu_JV = array([
	[    10,  nan,    0.0002 ],
	[    20,  nan,    0.0002 ],
	[    30,  nan,    0.0004 ],
	[    40,  nan,    0.0011 ],
	[    50,  nan,    0.0008 ],
	[    60,  nan,    0.0011 ],
	[    70,  nan,    0.0015 ],
	[    80,  nan,    0.0019 ],
	[    90,  nan,    0.0026 ],
	[   100,  nan,    0.0030 ],
	[   200,  nan,    0.0120 ],
	[   300,  nan,    0.0209 ],
	[   400,  nan,    0.0347 ],
	[   500,  nan,    0.0544 ],
	[   600,  nan,    0.0703 ],
	[   700,  nan,    0.0960 ],
	[   800,  nan,    0.1239 ],
	[   900,  nan,    0.1608 ],
	[  1000,  nan,    0.1991 ],
	[  2000,  nan,    0.9617 ],
	[  3000,  nan,    2.9735 ],
	[  4000,  nan,    6.3155 ],
	[  5000,  nan,   11.4898 ],
	[  6000,  nan,   19.0234 ],
	[  7000,  nan,   29.8118 ],
	[  8000,  nan,   42.3607 ],
	[  9000,  nan,   60.3680 ],
	[ 10000,  nan,   80.3943 ],
	[ 12000,  nan,  135.8985 ],
	[ 14000,  nan,  214.7538 ],
	[ 16000,  nan,  313.2673 ],
	[ 18000,  nan,  444.7189 ],
	[ 20000,  nan,       nan ],  # failed?
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/zheevd_2stage.txt
# numactl --interleave=all ./testing_zheevdx_2stage -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevdx_2stage_JN = array([
	[    10,      0,   0.0061 ],
	[    20,      0,   0.0024 ],
	[    30,      0,   0.0023 ],
	[    40,      0,   0.0024 ],
	[    50,      0,   0.0024 ],
	[    60,      0,   0.0024 ],
	[    70,      0,   0.0025 ],
	[    80,      0,   0.0026 ],
	[    90,      0,   0.0027 ],
	[   100,      0,   0.0028 ],
	[   200,    200,   0.0083 ],
	[   300,    300,   0.0410 ],
	[   400,    400,   0.0786 ],
	[   500,    500,   0.1281 ],
	[   600,    600,   0.1811 ],
	[   700,    700,   0.3994 ],
	[   800,    800,   0.4148 ],
	[   900,    900,   0.3493 ],
	[  1000,   1000,   0.3665 ],
	[  2000,   2000,   0.9242 ],
	[  3000,   3000,   1.7606 ],
	[  4000,   4000,   2.5729 ],
	[  5000,   5000,   3.6990 ],
	[  6000,   6000,   5.0416 ],
	[  7000,   7000,   6.7245 ],
	[  8000,   8000,   8.4638 ],
	[  9000,   9000,  10.6648 ],
	[ 10000,  10000,  13.5386 ],
	[ 12000,  12000,  20.2959 ],
	[ 14000,  14000,  29.6428 ],
	[ 16000,  16000,  41.1193 ],
	[ 18000,  18000,  56.3355 ],
	[ 20000,  20000,  73.3213 ],
])

# numactl --interleave=all ./testing_zheevdx_2stage -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevdx_2stage_JV = array([
	[    10,     10,    0.0002 ],
	[    20,     20,    0.0002 ],
	[    30,     30,    0.0003 ],
	[    40,     40,    0.0010 ],
	[    50,     50,    0.0007 ],
	[    60,     60,    0.0009 ],
	[    70,     70,    0.0013 ],
	[    80,     80,    0.0018 ],
	[    90,     90,    0.0023 ],
	[   100,    100,    0.0028 ],
	[   200,    200,    0.0106 ],
	[   300,    300,    0.0535 ],
	[   400,    400,    0.0946 ],
	[   500,    500,    0.2392 ],
	[   600,    600,    0.1899 ],
	[   700,    700,    0.2386 ],
	[   800,    800,    0.3090 ],
	[   900,    900,    0.3723 ],
	[  1000,   1000,    0.4429 ],
	[  2000,   2000,    1.1564 ],
	[  3000,   3000,    2.2898 ],
	[  4000,   4000,    4.5072 ],
	[  5000,   5000,    6.2553 ],
	[  6000,   6000,   10.6091 ],
	[  7000,   7000,   14.3145 ],
	[  8000,   8000,   20.3137 ],
	[  9000,   9000,   26.0345 ],
	[ 10000,  10000,   33.7556 ],
	[ 12000,  12000,   57.1141 ],
	[ 14000,  14000,   90.0918 ],
	[ 16000,  16000,  125.5741 ],
	[ 18000,  18000,  204.1449 ],
	[ 20000,  20000,       nan ],  # failed? 74.1290 ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/zhemv.txt
# numactl --interleave=all ./testing_zhemv -N 100 -N 1000 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
zhemv_L = array([
	[    10,    0.0270,   0.0341,   0.0327,   0.0281,   0.0382,   0.0241,   0.4823,    0.0019,  1.99e-16,  2.51e-16,  3.20e-16,  nan ],
	[    11,    0.0323,   0.0341,   0.0408,   0.0269,   0.0461,   0.0238,   0.9227,    0.0012,  3.61e-16,  3.33e-16,  2.28e-16,  nan ],
	[    12,    0.0391,   0.0331,   0.0461,   0.0281,   0.0566,   0.0229,   0.6040,    0.0021,  3.70e-16,  3.70e-16,  4.74e-16,  nan ],
	[    13,    0.0442,   0.0341,   0.0555,   0.0272,   0.0652,   0.0231,   0.7906,    0.0019,  1.93e-16,  3.06e-16,  1.93e-16,  nan ],
	[    14,    0.0524,   0.0331,   0.0644,   0.0269,   0.0751,   0.0231,   0.8090,    0.0021,  2.54e-16,  3.92e-16,  2.84e-16,  nan ],
	[    15,    0.0581,   0.0341,   0.0704,   0.0281,   0.0865,   0.0229,   1.0381,    0.0019,  2.65e-16,  2.65e-16,  2.65e-16,  nan ],
	[    16,    0.0701,   0.0319,   0.0831,   0.0269,   0.0979,   0.0229,   1.1744,    0.0019,  3.14e-16,  4.45e-16,  4.74e-16,  nan ],
	[    17,    0.0765,   0.0329,   0.0902,   0.0279,   0.0968,   0.0260,   0.8794,    0.0029,  4.31e-16,  4.21e-16,  4.46e-16,  nan ],
	[    18,    0.0853,   0.0329,   0.1042,   0.0269,   0.1122,   0.0250,   1.3086,    0.0021,  3.21e-16,  4.02e-16,  2.96e-16,  nan ],
	[    19,    0.0914,   0.0341,   0.1117,   0.0279,   0.1199,   0.0260,   1.0053,    0.0031,  4.67e-16,  5.91e-16,  4.41e-16,  nan ],
	[    20,    0.1046,   0.0329,   0.1277,   0.0269,   0.1324,   0.0260,   1.2024,    0.0029,  3.97e-16,  4.87e-16,  3.97e-16,  nan ],
	[    21,    0.1141,   0.0331,   0.1355,   0.0279,   0.1455,   0.0260,   1.2196,    0.0031,  5.08e-16,  3.61e-16,  4.79e-16,  nan ],
	[    22,    0.1213,   0.0341,   0.1483,   0.0279,   0.1592,   0.0260,   1.4456,    0.0029,  3.61e-16,  3.23e-16,  4.04e-16,  nan ],
	[    23,    0.1322,   0.0341,   0.1550,   0.0291,   0.1735,   0.0260,   1.5757,    0.0029,  5.36e-16,  3.45e-16,  4.37e-16,  nan ],
	[    24,    0.1446,   0.0339,   0.1817,   0.0269,   0.1884,   0.0260,   1.7113,    0.0029,  5.92e-16,  5.34e-16,  4.44e-16,  nan ],
	[    25,    0.1555,   0.0341,   0.1822,   0.0291,   0.1967,   0.0269,   1.8525,    0.0029,  3.18e-16,  3.18e-16,  3.18e-16,  nan ],
	[    26,    0.1777,   0.0322,   0.2105,   0.0272,   0.2285,   0.0250,   1.8455,    0.0031,  3.86e-16,  5.63e-16,  3.86e-16,  nan ],
	[    27,    0.1858,   0.0331,   0.2207,   0.0279,   0.2369,   0.0260,   1.9862,    0.0031,  3.72e-16,  4.00e-16,  3.72e-16,  nan ],
	[    28,    0.1994,   0.0331,   0.2453,   0.0269,   0.2543,   0.0260,   1.6304,    0.0041,  3.81e-16,  2.84e-16,  4.26e-16,  nan ],
	[    29,    0.2215,   0.0319,   0.2515,   0.0281,   0.2827,   0.0250,   1.7458,    0.0041,  3.47e-16,  3.73e-16,  3.47e-16,  nan ],
	[    30,    0.2366,   0.0319,   0.2806,   0.0269,   0.2883,   0.0262,   1.8652,    0.0041,  4.27e-16,  2.65e-16,  2.65e-16,  nan ],
	[    31,    0.2450,   0.0329,   0.2865,   0.0281,   0.3101,   0.0260,   1.9886,    0.0041,  4.90e-16,  4.73e-16,  3.05e-16,  nan ],
	[    32,    0.2684,   0.0319,   0.3074,   0.0279,   0.3459,   0.0248,   2.1159,    0.0041,  3.55e-16,  4.58e-16,  5.39e-16,  nan ],
	[    33,    0.2671,   0.0341,   0.2274,   0.0401,   0.3265,   0.0279,   1.8191,    0.0050,  3.05e-16,  3.88e-16,  4.81e-16,  nan ],
	[    34,    0.2852,   0.0339,   0.2531,   0.0381,   0.3584,   0.0269,   2.5313,    0.0038,  3.35e-16,  4.67e-16,  3.77e-16,  nan ],
	[    35,    0.2614,   0.0391,   0.2679,   0.0381,   0.3793,   0.0269,   2.0412,    0.0050,  4.06e-16,  4.19e-16,  4.19e-16,  nan ],
	[    36,    0.3190,   0.0339,   0.2922,   0.0370,   0.3839,   0.0281,   2.1571,    0.0050,  4.93e-16,  4.02e-16,  3.98e-16,  nan ],
	[    37,    0.3252,   0.0350,   0.2987,   0.0381,   0.4085,   0.0279,   2.9874,    0.0038,  4.80e-16,  4.80e-16,  3.84e-16,  nan ],
	[    38,    0.3547,   0.0339,   0.3229,   0.0372,   0.4268,   0.0281,   2.9627,    0.0041,  3.92e-16,  3.74e-16,  4.18e-16,  nan ],
	[    39,    0.3605,   0.0350,   0.3312,   0.0381,   0.4491,   0.0281,   2.5238,    0.0050,  5.15e-16,  6.57e-16,  5.83e-16,  nan ],
	[    40,    0.3789,   0.0350,   0.3594,   0.0370,   0.4720,   0.0281,   2.2280,    0.0060,  3.20e-16,  3.97e-16,  3.55e-16,  nan ],
	[    41,    0.4089,   0.0341,   0.3677,   0.0379,   0.4793,   0.0291,   2.2488,    0.0062,  4.90e-16,  5.48e-16,  5.20e-16,  nan ],
	[    42,    0.4287,   0.0341,   0.3856,   0.0379,   0.5195,   0.0281,   2.9192,    0.0050,  5.42e-16,  4.23e-16,  4.79e-16,  nan ],
	[    43,    0.4522,   0.0339,   0.4013,   0.0381,   0.5441,   0.0281,   2.5683,    0.0060,  6.61e-16,  3.69e-16,  3.41e-16,  nan ],
	[    44,    0.4731,   0.0339,   0.4096,   0.0391,   0.5506,   0.0291,   3.1989,    0.0050,  5.42e-16,  6.51e-16,  5.42e-16,  nan ],
	[    45,    0.4776,   0.0350,   0.4281,   0.0391,   0.6001,   0.0279,   2.7005,    0.0062,  4.80e-16,  4.74e-16,  5.69e-16,  nan ],
	[    46,    0.5163,   0.0339,   0.4471,   0.0391,   0.6213,   0.0281,   2.5282,    0.0069,  5.57e-16,  4.78e-16,  4.52e-16,  nan ],
	[    47,    0.5203,   0.0350,   0.4553,   0.0401,   0.6537,   0.0279,   2.5496,    0.0072,  6.76e-16,  6.76e-16,  4.78e-16,  nan ],
	[    48,    0.5423,   0.0350,   0.4891,   0.0389,   0.6814,   0.0279,   3.1890,    0.0060,  5.34e-16,  4.68e-16,  4.50e-16,  nan ],
	[    49,    0.5806,   0.0341,   0.4942,   0.0401,   0.6806,   0.0291,   3.9538,    0.0050,  5.23e-16,  5.23e-16,  4.86e-16,  nan ],
	[    50,    0.5878,   0.0350,   0.5301,   0.0389,   0.6857,   0.0300,   3.4561,    0.0060,  5.86e-16,  5.86e-16,  6.36e-16,  nan ],
	[    51,    0.6327,   0.0339,   0.5478,   0.0391,   0.7187,   0.0298,   3.0980,    0.0069,  4.67e-16,  3.12e-16,  3.94e-16,  nan ],
	[    52,    0.6350,   0.0350,   0.5727,   0.0389,   0.7409,   0.0300,   3.2189,    0.0069,  5.47e-16,  5.63e-16,  5.63e-16,  nan ],
	[    53,    0.6638,   0.0348,   0.5769,   0.0401,   0.8010,   0.0288,   4.6153,    0.0050,  5.69e-16,  5.40e-16,  4.83e-16,  nan ],
	[    54,    0.6841,   0.0350,   0.6022,   0.0398,   0.8243,   0.0291,   2.9577,    0.0081,  4.74e-16,  4.00e-16,  4.00e-16,  nan ],
	[    55,    0.7292,   0.0341,   0.6244,   0.0398,   0.8275,   0.0300,   2.8181,    0.0088,  4.09e-16,  3.93e-16,  2.89e-16,  nan ],
	[    56,    0.7609,   0.0339,   0.6431,   0.0401,   0.8644,   0.0298,   4.3218,    0.0060,  5.23e-16,  6.34e-16,  4.57e-16,  nan ],
	[    57,    0.7611,   0.0350,   0.6505,   0.0410,   0.8607,   0.0310,   4.4755,    0.0060,  5.57e-16,  5.14e-16,  3.94e-16,  nan ],
	[    58,    0.8155,   0.0339,   0.6893,   0.0401,   0.9492,   0.0291,   3.4058,    0.0081,  5.05e-16,  6.93e-16,  4.78e-16,  nan ],
	[    59,    0.8148,   0.0350,   0.7172,   0.0398,   0.9213,   0.0310,   3.1519,    0.0091,  6.02e-16,  4.97e-16,  4.85e-16,  nan ],
	[    60,    0.8658,   0.0341,   0.7199,   0.0410,   0.9905,   0.0298,   3.2583,    0.0091,  4.74e-16,  4.75e-16,  4.77e-16,  nan ],
	[    61,    0.8702,   0.0350,   0.7438,   0.0410,   1.0153,   0.0300,   3.8766,    0.0079,  5.21e-16,  4.80e-16,  4.80e-16,  nan ],
	[    62,    0.9573,   0.0329,   0.7863,   0.0401,   1.0484,   0.0300,   4.0031,    0.0079,  4.73e-16,  6.88e-16,  5.13e-16,  nan ],
	[    63,    0.9602,   0.0339,   0.8165,   0.0398,   1.1176,   0.0291,   4.0102,    0.0081,  5.64e-16,  4.07e-16,  4.07e-16,  nan ],
	[    64,    1.0193,   0.0329,   0.9075,   0.0370,   1.1625,   0.0288,   3.8016,    0.0088,  5.55e-16,  7.02e-16,  4.00e-16,  nan ],
	[    65,    0.8241,   0.0420,   0.8241,   0.0420,   1.1157,   0.0310,   4.3951,    0.0079,  4.89e-16,  4.89e-16,  4.89e-16,  nan ],
	[    66,    0.8305,   0.0429,   0.8951,   0.0398,   1.1156,   0.0319,   5.1547,    0.0069,  6.55e-16,  4.44e-16,  5.62e-16,  nan ],
	[    67,    0.8508,   0.0432,   0.8953,   0.0410,   1.1846,   0.0310,   4.5294,    0.0081,  4.53e-16,  5.00e-16,  7.65e-16,  nan ],
	[    68,    0.8618,   0.0439,   0.9010,   0.0420,   1.1409,   0.0331,   4.6641,    0.0081,  7.53e-16,  5.22e-16,  5.22e-16,  nan ],
	[    69,    0.9068,   0.0429,   0.9068,   0.0429,   1.2181,   0.0319,   4.8008,    0.0081,  6.26e-16,  6.26e-16,  6.18e-16,  nan ],
	[    70,    0.9078,   0.0441,   0.9542,   0.0420,   1.2170,   0.0329,   3.9986,    0.0100,  6.11e-16,  6.42e-16,  8.18e-16,  nan ],
	[    71,    0.9336,   0.0441,   0.9596,   0.0429,   1.2890,   0.0319,   4.2127,    0.0098,  8.01e-16,  1.00e-15,  8.01e-16,  nan ],
	[    72,    0.9651,   0.0439,   0.9865,   0.0429,   1.2775,   0.0331,   5.2226,    0.0081,  7.12e-16,  4.41e-16,  8.83e-16,  nan ],
	[    73,    0.9864,   0.0441,   1.0369,   0.0420,   1.3224,   0.0329,   4.8023,    0.0091,  6.16e-16,  7.79e-16,  8.03e-16,  nan ],
	[    74,    1.0415,   0.0429,   1.0591,   0.0422,   1.3585,   0.0329,   4.4635,    0.0100,  6.44e-16,  9.06e-16,  6.92e-16,  nan ],
	[    75,    1.0186,   0.0451,   1.0939,   0.0420,   1.4367,   0.0319,   4.5838,    0.0100,  5.36e-16,  6.36e-16,  5.10e-16,  nan ],
	[    76,    1.0741,   0.0439,   1.0919,   0.0432,   1.4749,   0.0319,   5.2009,    0.0091,  6.27e-16,  5.69e-16,  5.63e-16,  nan ],
	[    77,    1.0963,   0.0441,   1.1268,   0.0429,   1.4697,   0.0329,   5.9653,    0.0081,  5.61e-16,  4.61e-16,  4.61e-16,  nan ],
	[    78,    1.1822,   0.0420,   1.1822,   0.0420,   1.6005,   0.0310,   6.1197,    0.0081,  8.59e-16,  7.78e-16,  6.11e-16,  nan ],
	[    79,    1.1789,   0.0432,   1.2124,   0.0420,   1.6415,   0.0310,   5.6155,    0.0091,  7.42e-16,  7.68e-16,  9.17e-16,  nan ],
	[    80,    1.2360,   0.0422,   1.2430,   0.0420,   1.6326,   0.0319,   5.2089,    0.0100,  5.40e-16,  9.06e-16,  9.06e-16,  nan ],
	[    81,    1.2457,   0.0429,   1.2186,   0.0439,   1.6248,   0.0329,   4.8745,    0.0110,  6.85e-16,  5.34e-16,  5.62e-16,  nan ],
	[    82,    1.2693,   0.0432,   1.2486,   0.0439,   1.5629,   0.0350,   6.2094,    0.0088,  7.35e-16,  5.48e-16,  6.25e-16,  nan ],
	[    83,    1.2721,   0.0441,   1.2452,   0.0451,   1.6573,   0.0339,   6.1930,    0.0091,  6.69e-16,  6.17e-16,  7.66e-16,  nan ],
	[    84,    1.3026,   0.0441,   1.3097,   0.0439,   1.6394,   0.0350,   4.8198,    0.0119,  9.11e-16,  6.10e-16,  5.35e-16,  nan ],
	[    85,    1.3123,   0.0448,   1.3336,   0.0441,   1.6783,   0.0350,   4.9342,    0.0119,  8.52e-16,  7.14e-16,  8.52e-16,  nan ],
	[    86,    1.3950,   0.0432,   1.3360,   0.0451,   1.7294,   0.0348,   5.4891,    0.0110,  7.01e-16,  7.39e-16,  6.81e-16,  nan ],
	[    87,    1.3669,   0.0451,   1.3742,   0.0448,   1.7575,   0.0350,   5.6164,    0.0110,  6.93e-16,  5.89e-16,  5.89e-16,  nan ],
	[    88,    1.4682,   0.0429,   1.4057,   0.0448,   1.7978,   0.0350,   5.7451,    0.0110,  5.82e-16,  5.42e-16,  6.51e-16,  nan ],
	[    89,    1.4688,   0.0439,   1.4300,   0.0451,   1.8900,   0.0341,   5.4053,    0.0119,  5.76e-16,  6.77e-16,  6.82e-16,  nan ],
	[    90,    1.4936,   0.0441,   1.4936,   0.0441,   1.8926,   0.0348,   5.0240,    0.0131,  7.93e-16,  9.60e-16,  7.93e-16,  nan ],
	[   100,    1.8410,   0.0441,   1.8020,   0.0451,   2.2555,   0.0360,   6.1923,    0.0131,  7.65e-16,  7.42e-16,  6.07e-16,  nan ],
	[   110,    2.2367,   0.0439,   2.1324,   0.0460,   2.7255,   0.0360,   6.9753,    0.0141,  7.86e-16,  7.31e-16,  6.46e-16,  nan ],
	[   120,    2.6588,   0.0439,   2.4339,   0.0479,   3.1563,   0.0370,   6.8905,    0.0169,  6.70e-16,  8.34e-16,  7.49e-16,  nan ],
	[   130,    2.5381,   0.0539,   2.7315,   0.0501,   3.3350,   0.0410,   7.9668,    0.0172,  7.88e-16,  9.16e-16,  9.28e-16,  nan ],
	[   140,    2.9412,   0.0539,   3.1061,   0.0510,   3.8646,   0.0410,   7.5536,    0.0210,  8.37e-16,  8.67e-16,  7.32e-16,  nan ],
	[   150,    3.3591,   0.0541,   3.4348,   0.0529,   4.2128,   0.0432,   7.9430,    0.0229,  8.47e-16,  7.64e-16,  8.47e-16,  nan ],
	[   160,    3.7534,   0.0551,   4.0516,   0.0510,   4.8986,   0.0422,   8.3370,    0.0248,  7.59e-16,  9.10e-16,  7.19e-16,  nan ],
	[   170,    4.1629,   0.0560,   4.2534,   0.0548,   5.2036,   0.0448,   8.9750,    0.0260,  1.00e-15,  8.52e-16,  8.52e-16,  nan ],
	[   180,    4.7456,   0.0551,   4.6648,   0.0560,   5.1225,   0.0510,   8.4325,    0.0310,  1.11e-15,  8.24e-16,  9.87e-16,  nan ],
	[   190,    5.2852,   0.0551,   5.1952,   0.0560,   6.3258,   0.0460,   9.1110,    0.0319,  8.72e-16,  6.69e-16,  7.48e-16,  nan ],
	[   200,    5.1221,   0.0629,   5.4747,   0.0589,   6.7276,   0.0479,   9.1989,    0.0350,  9.53e-16,  9.10e-16,  8.64e-16,  nan ],
	[   210,    5.6452,   0.0629,   5.9140,   0.0601,   7.0968,   0.0501,   9.3731,    0.0379,  1.03e-15,  1.22e-15,  1.08e-15,  nan ],
	[   220,    6.0114,   0.0648,   6.4122,   0.0608,   7.7862,   0.0501,   9.2904,    0.0420,  9.32e-16,  1.19e-15,  1.04e-15,  nan ],
	[   230,    6.6417,   0.0641,   6.7674,   0.0629,   8.1954,   0.0520,   9.4529,    0.0451,  1.11e-15,  1.04e-15,  9.91e-16,  nan ],
	[   240,    7.2568,   0.0639,   7.4801,   0.0620,   9.3053,   0.0498,   9.4408,    0.0491,  1.12e-15,  1.38e-15,  1.39e-15,  nan ],
	[   250,    7.6164,   0.0660,   7.6164,   0.0660,   9.3351,   0.0539,   9.5033,    0.0529,  1.14e-15,  1.16e-15,  1.02e-15,  nan ],
	[   260,    7.4554,   0.0730,   7.5542,   0.0720,   9.7494,   0.0558,   9.1991,    0.0591,  1.10e-15,  1.03e-15,  1.14e-15,  nan ],
	[   270,    7.9345,   0.0739,   8.6306,   0.0679,  10.1223,   0.0579,   9.7607,    0.0601,  1.13e-15,  1.23e-15,  1.13e-15,  nan ],
	[   280,    8.6149,   0.0732,   9.2799,   0.0679,  11.0659,   0.0570,   9.8318,    0.0641,  1.06e-15,  1.08e-15,  1.02e-15,  nan ],
	[   290,    9.0335,   0.0749,   9.3925,   0.0720,  10.9097,   0.0620,   9.6480,    0.0701,  1.57e-15,  1.39e-15,  1.57e-15,  nan ],
	[   300,    9.5440,   0.0758,   9.7588,   0.0741,  11.4528,   0.0632,   9.7903,    0.0739,  1.33e-15,  1.33e-15,  1.33e-15,  nan ],
	[   310,   10.1573,   0.0761,  10.5888,   0.0730,  12.0902,   0.0639,   9.7891,    0.0789,  1.65e-15,  1.54e-15,  1.51e-15,  nan ],
	[   320,   10.8216,   0.0761,  11.1357,   0.0739,  12.6450,   0.0651,  10.0351,    0.0820,  1.79e-15,  1.97e-15,  1.96e-15,  nan ],
	[   330,   10.3985,   0.0842,  11.3644,   0.0770,  12.8346,   0.0682,  10.0567,    0.0870,  1.22e-15,  1.25e-15,  1.12e-15,  nan ],
	[   340,   11.0368,   0.0842,  12.0994,   0.0768,  13.8648,   0.0670,   9.7890,    0.0949,  1.35e-15,  1.40e-15,  1.24e-15,  nan ],
	[   350,   11.7274,   0.0839,  12.3225,   0.0799,  13.8525,   0.0710,  10.1426,    0.0970,  1.32e-15,  1.32e-15,  1.30e-15,  nan ],
	[   360,   11.9638,   0.0870,  12.8435,   0.0811,  14.6536,   0.0710,  10.2027,    0.1020,  1.59e-15,  1.43e-15,  1.61e-15,  nan ],
	[   370,   12.6709,   0.0868,  13.4076,   0.0820,  15.2723,   0.0720,  10.1815,    0.1080,  1.55e-15,  1.38e-15,  1.24e-15,  nan ],
	[   380,   13.0064,   0.0892,  13.8193,   0.0839,  15.4917,   0.0749,   9.5944,    0.1209,  1.50e-15,  1.50e-15,  1.35e-15,  nan ],
	[   390,   12.8725,   0.0949,  14.3509,   0.0851,  16.2643,   0.0751,  10.1652,    0.1202,  1.46e-15,  1.61e-15,  1.49e-15,  nan ],
	[   400,   13.2730,   0.0968,  14.9690,   0.0858,  17.1619,   0.0749,  10.3632,    0.1240,  1.53e-15,  1.37e-15,  1.48e-15,  nan ],
	[   410,   13.7741,   0.0980,  14.9766,   0.0901,  17.1031,   0.0789,  10.2930,    0.1311,  1.45e-15,  1.37e-15,  1.19e-15,  nan ],
	[   420,   14.0098,   0.1011,  15.2311,   0.0930,  17.7318,   0.0799,  10.4213,    0.1359,  1.64e-15,  1.70e-15,  1.67e-15,  nan ],
	[   430,   14.6836,   0.1011,  15.9637,   0.0930,  18.5846,   0.0799,  10.2399,    0.1450,  1.72e-15,  1.77e-15,  1.80e-15,  nan ],
	[   440,   15.0886,   0.1030,  16.5439,   0.0939,  18.9485,   0.0820,  10.0281,    0.1550,  1.40e-15,  1.51e-15,  1.37e-15,  nan ],
	[   450,   14.9178,   0.1090,  16.5874,   0.0980,  19.5903,   0.0830,  10.3451,    0.1571,  1.58e-15,  1.54e-15,  1.52e-15,  nan ],
	[   460,   14.7480,   0.1152,  17.1645,   0.0989,  19.7869,   0.0858,  10.4754,    0.1621,  1.29e-15,  1.26e-15,  1.36e-15,  nan ],
	[   470,   15.6874,   0.1130,  17.5788,   0.1009,  20.3721,   0.0870,  10.3708,    0.1709,  1.94e-15,  1.85e-15,  1.88e-15,  nan ],
	[   480,   16.1902,   0.1142,  18.2903,   0.1011,  21.2469,   0.0870,  10.2175,    0.1810,  1.59e-15,  1.76e-15,  1.95e-15,  nan ],
	[   490,   16.3254,   0.1180,  18.3244,   0.1051,  20.9354,   0.0920,  10.1905,    0.1891,  2.79e-15,  2.35e-15,  2.81e-15,  nan ],
	[   500,   17.1360,   0.1171,  18.9499,   0.1059,  20.6727,   0.0970,  10.4910,    0.1912,  1.89e-15,  1.82e-15,  1.82e-15,  nan ],
	[   510,   17.8272,   0.1171,  19.4948,   0.1070,  21.7741,   0.0958,  10.3343,    0.2019,  1.79e-15,  2.01e-15,  1.79e-15,  nan ],
	[   520,   17.2009,   0.1261,  19.9109,   0.1090,  22.6351,   0.0958,  10.0434,    0.2160,  1.96e-15,  1.63e-15,  1.63e-15,  nan ],
	[   530,   17.7338,   0.1271,  20.2835,   0.1111,  22.7762,   0.0989,  10.5375,    0.2139,  2.21e-15,  2.03e-15,  2.19e-15,  nan ],
	[   540,   14.6224,   0.1600,  20.6997,   0.1130,  23.4168,   0.0999,  10.5275,    0.2222,  1.99e-15,  1.91e-15,  1.70e-15,  nan ],
	[   550,   18.9533,   0.1280,  21.7013,   0.1118,  24.2909,   0.0999,  10.4603,    0.2320,  1.68e-15,  1.89e-15,  1.67e-15,  nan ],
	[   560,   19.2183,   0.1309,  22.0729,   0.1140,  24.6515,   0.1020,  10.5614,    0.2382,  1.82e-15,  1.69e-15,  1.91e-15,  nan ],
	[   570,   19.5888,   0.1330,  22.3072,   0.1168,  25.0126,   0.1042,  10.5916,    0.2460,  1.88e-15,  2.01e-15,  1.78e-15,  nan ],
	[   580,   19.2464,   0.1402,  22.2774,   0.1211,  25.4885,   0.1059,  10.5765,    0.2551,  2.23e-15,  2.40e-15,  2.02e-15,  nan ],
	[   590,   19.6476,   0.1421,  23.2803,   0.1199,  26.0802,   0.1070,  10.3445,    0.2699,  2.50e-15,  2.51e-15,  2.52e-15,  nan ],
	[   600,   20.1830,   0.1431,  23.8852,   0.1209,  26.4985,   0.1090,  10.6507,    0.2711,  1.84e-15,  1.75e-15,  1.84e-15,  nan ],
	[   610,   20.7224,   0.1440,  23.8406,   0.1252,  27.1503,   0.1099,  10.4739,    0.2849,  2.13e-15,  2.67e-15,  2.71e-15,  nan ],
	[   620,   20.9555,   0.1471,  24.6277,   0.1252,  27.7458,   0.1111,  10.5893,    0.2911,  2.39e-15,  2.20e-15,  2.42e-15,  nan ],
	[   630,   21.7773,   0.1462,  25.2353,   0.1261,  27.4116,   0.1161,  10.5696,    0.3011,  1.95e-15,  2.04e-15,  2.04e-15,  nan ],
	[   640,   22.5100,   0.1459,  25.6538,   0.1280,  29.0635,   0.1130,  10.6626,    0.3080,  2.18e-15,  2.39e-15,  2.22e-15,  nan ],
	[   650,   21.8607,   0.1550,  26.0724,   0.1299,  29.2376,   0.1159,  10.6518,    0.3181,  2.28e-15,  2.31e-15,  2.32e-15,  nan ],
	[   660,   22.5377,   0.1550,  26.4432,   0.1321,  29.8970,   0.1168,  10.6853,    0.3269,  2.10e-15,  2.10e-15,  1.78e-15,  nan ],
	[   670,   22.9427,   0.1569,  27.2497,   0.1321,  30.2531,   0.1190,  10.4908,    0.3431,  2.04e-15,  2.06e-15,  2.10e-15,  nan ],
	[   680,   23.3130,   0.1590,  26.9028,   0.1378,  30.6702,   0.1209,  10.7092,    0.3462,  2.36e-15,  2.34e-15,  2.21e-15,  nan ],
	[   690,   23.8599,   0.1600,  27.6511,   0.1380,  31.0271,   0.1230,  10.6662,    0.3579,  2.49e-15,  2.48e-15,  2.33e-15,  nan ],
	[   700,   24.2307,   0.1621,  28.0697,   0.1400,  32.1815,   0.1221,  10.7341,    0.3660,  2.77e-15,  2.44e-15,  2.28e-15,  nan ],
	[   710,   24.1805,   0.1671,  29.0747,   0.1390,  32.5972,   0.1240,  10.6943,    0.3779,  2.25e-15,  2.40e-15,  2.40e-15,  nan ],
	[   720,   24.5851,   0.1690,  29.6948,   0.1400,  33.2016,   0.1252,  10.6872,    0.3889,  2.08e-15,  1.90e-15,  1.95e-15,  nan ],
	[   730,   25.2721,   0.1690,  30.0636,   0.1421,  32.1109,   0.1330,  10.6023,    0.4029,  1.99e-15,  1.85e-15,  2.03e-15,  nan ],
	[   740,   25.6787,   0.1709,  30.0844,   0.1459,  32.0760,   0.1369,  10.7860,    0.4070,  2.16e-15,  2.16e-15,  2.00e-15,  nan ],
	[   750,   26.1941,   0.1721,  30.8517,   0.1462,  33.8927,   0.1330,  10.6848,    0.4220,  2.04e-15,  2.13e-15,  2.11e-15,  nan ],
	[   760,   26.6018,   0.1740,  31.5248,   0.1469,  34.0689,   0.1359,  10.5943,    0.4370,  2.70e-15,  2.25e-15,  2.29e-15,  nan ],
	[   770,   26.8280,   0.1771,  31.8931,   0.1490,  34.1907,   0.1390,  10.6538,    0.4461,  2.44e-15,  2.38e-15,  2.06e-15,  nan ],
	[   780,   26.9129,   0.1812,  31.8595,   0.1531,  34.7853,   0.1402,  10.7651,    0.4530,  2.60e-15,  2.21e-15,  2.21e-15,  nan ],
	[   790,   27.6431,   0.1810,  33.1455,   0.1509,  35.6821,   0.1402,  10.6665,    0.4690,  2.00e-15,  2.19e-15,  2.25e-15,  nan ],
	[   800,   28.0145,   0.1831,  33.5126,   0.1531,  36.3431,   0.1411,  10.7522,    0.4771,  2.11e-15,  2.15e-15,  2.01e-15,  nan ],
	[   810,   28.5697,   0.1841,  34.1422,   0.1540,  37.0064,   0.1421,  10.6653,    0.4930,  2.16e-15,  1.98e-15,  2.11e-15,  nan ],
	[   820,   29.1279,   0.1850,  34.3515,   0.1569,  36.9335,   0.1459,  10.6922,    0.5040,  2.23e-15,  2.21e-15,  2.10e-15,  nan ],
	[   830,   29.3876,   0.1879,  34.5118,   0.1600,  38.0879,   0.1450,  10.7210,    0.5150,  2.17e-15,  2.30e-15,  2.43e-15,  nan ],
	[   840,   29.3180,   0.1929,  35.1382,   0.1609,  37.7079,   0.1500,  10.7129,    0.5279,  2.00e-15,  2.19e-15,  2.10e-15,  nan ],
	[   850,   30.0196,   0.1929,  35.9791,   0.1609,  37.8284,   0.1531,  10.6284,    0.5448,  2.78e-15,  2.56e-15,  2.56e-15,  nan ],
	[   860,   29.9520,   0.1979,  36.1339,   0.1640,  37.4964,   0.1581,  10.6376,    0.5572,  2.25e-15,  2.66e-15,  2.31e-15,  nan ],
	[   870,   30.6520,   0.1979,  36.2926,   0.1671,  39.3826,   0.1540,  10.6985,    0.5670,  2.03e-15,  2.28e-15,  2.03e-15,  nan ],
	[   880,   31.1723,   0.1991,  37.3978,   0.1659,  40.2923,   0.1540,  10.6284,    0.5839,  2.34e-15,  2.34e-15,  2.33e-15,  nan ],
	[   890,   31.8841,   0.1991,  37.5504,   0.1690,  40.2164,   0.1578,  10.5606,    0.6011,  2.43e-15,  2.33e-15,  2.31e-15,  nan ],
	[   900,   31.3645,   0.2069,  37.7069,   0.1721,  40.8162,   0.1590,  10.6221,    0.6111,  2.84e-15,  2.38e-15,  2.49e-15,  nan ],
	[  1000,   35.2991,   0.2270,  41.7450,   0.1919,  44.2751,   0.1810,  10.4753,    0.7648,  3.31e-15,  2.96e-15,  3.23e-15,  nan ],
	[  1100,   37.2651,   0.2601,  45.7325,   0.2120,  27.4704,   0.3529,  10.1488,    0.9551,  3.19e-15,  3.24e-15,  3.24e-15,  nan ],
	[  1200,   41.4912,   0.2780,  50.1855,   0.2298,  29.3561,   0.3929,   9.1748,    1.2572,  3.04e-15,  3.44e-15,  3.22e-15,  nan ],
	[  1300,   44.5274,   0.3040,  54.7996,   0.2470,  30.9724,   0.4370,   8.1092,    1.6692,  3.33e-15,  3.15e-15,  3.33e-15,  nan ],
	[  1400,   48.4453,   0.3240,  59.4735,   0.2639,  32.9021,   0.4771,   8.0133,    1.9588,  3.45e-15,  4.07e-15,  3.90e-15,  nan ],
	[  1500,   51.9045,   0.3471,  63.8825,   0.2820,  36.7752,   0.4900,   8.0260,    2.2449,  3.54e-15,  2.77e-15,  3.04e-15,  nan ],
	[  1600,   56.0129,   0.3660,  69.4506,   0.2952,  37.5458,   0.5460,   8.3809,    2.4459,  3.14e-15,  3.04e-15,  2.84e-15,  nan ],
	[  1700,   58.7517,   0.3939,  72.5395,   0.3190,  40.1730,   0.5760,   8.1390,    2.8431,  3.76e-15,  3.66e-15,  3.18e-15,  nan ],
	[  1800,   62.9670,   0.4120,  75.1949,   0.3450,  41.9133,   0.6189,   7.5718,    3.4261,  3.33e-15,  3.62e-15,  3.41e-15,  nan ],
	[  1900,   65.5636,   0.4408,  76.2435,   0.3791,  43.5286,   0.6640,   8.0888,    3.5732,  5.07e-15,  5.00e-15,  4.89e-15,  nan ],
	[  2000,   65.1083,   0.4919,  76.7973,   0.4170,  44.1111,   0.7260,   7.9366,    4.0350,  3.93e-15,  4.00e-15,  3.60e-15,  nan ],
	[  2100,   65.1191,   0.5422,  77.4076,   0.4561,  34.9907,   1.0090,   8.1234,    4.3461,  3.76e-15,  3.51e-15,  3.81e-15,  nan ],
	[  2200,   66.7958,   0.5801,  78.5852,   0.4930,  37.1546,   1.0428,   8.1196,    4.7719,  4.15e-15,  4.37e-15,  4.38e-15,  nan ],
	[  2300,   68.3149,   0.6199,  78.4189,   0.5400,  38.1238,   1.1108,   7.4476,    5.6860,  4.35e-15,  4.95e-15,  4.35e-15,  nan ],
	[  2400,   69.6415,   0.6621,  78.8399,   0.5848,  39.6869,   1.1618,   8.2089,    5.6169,  5.39e-15,  5.73e-15,  5.82e-15,  nan ],
	[  2500,   70.7727,   0.7069,  78.4159,   0.6380,  41.2099,   1.2140,   8.1695,    6.1240,  5.28e-15,  5.28e-15,  5.09e-15,  nan ],
	[  2600,   71.5733,   0.7560,  79.3562,   0.6819,  41.1530,   1.3149,   8.2387,    6.5680,  5.84e-15,  4.69e-15,  5.07e-15,  nan ],
	[  2700,   72.6686,   0.8030,  79.3862,   0.7350,  42.1325,   1.3850,   8.4952,    6.8688,  4.90e-15,  4.24e-15,  4.66e-15,  nan ],
	[  2800,   75.1378,   0.8352,  80.3442,   0.7811,  39.5147,   1.5881,   8.1425,    7.7069,  6.08e-15,  5.87e-15,  5.22e-15,  nan ],
	[  2900,   75.3909,   0.8929,  81.2953,   0.8280,  45.7673,   1.4708,   8.1942,    8.2150,  4.26e-15,  4.58e-15,  4.87e-15,  nan ],
	[  3000,   76.3947,   0.9429,  82.8010,   0.8700,  46.6267,   1.5450,   8.2063,    8.7781,  5.07e-15,  4.46e-15,  5.36e-15,  nan ],
	[  3100,   78.1716,   0.9840,  83.4275,   0.9220,  38.1386,   2.0168,   8.0139,    9.5980,  4.85e-15,  5.16e-15,  4.92e-15,  nan ],
	[  3200,   79.7398,   1.0278,  84.3165,   0.9720,  40.1728,   2.0401,   8.9956,    9.1109,  5.78e-15,  5.55e-15,  5.77e-15,  nan ],
	[  3300,   78.8895,   1.1048,  84.8593,   1.0271,  41.2845,   2.1112,   8.2010,   10.6280,  5.83e-15,  6.03e-15,  5.92e-15,  nan ],
	[  3400,   82.1640,   1.1261,  86.3892,   1.0710,  41.9434,   2.2058,   8.2371,   11.2321,  6.40e-15,  5.89e-15,  5.74e-15,  nan ],
	[  3500,   83.3775,   1.1759,  87.3816,   1.1220,  43.9852,   2.2290,   8.1573,   12.0189,  5.33e-15,  4.88e-15,  4.72e-15,  nan ],
	[  3600,   86.3702,   1.2009,  87.4641,   1.1859,  44.8040,   2.3150,   7.9549,   13.0389,  4.98e-15,  5.08e-15,  5.40e-15,  nan ],
	[  3700,   87.6495,   1.2500,  87.4993,   1.2522,  45.2176,   2.4230,   8.1315,   13.4740,  7.14e-15,  6.15e-15,  6.24e-15,  nan ],
	[  3800,   88.4359,   1.3068,  88.5490,   1.3051,  46.0583,   2.5091,   8.1798,   14.1282,  4.79e-15,  5.35e-15,  5.03e-15,  nan ],
	[  3900,   86.8150,   1.4021,  87.9516,   1.3840,  46.3681,   2.6252,   8.1027,   15.0230,  6.18e-15,  6.43e-15,  5.52e-15,  nan ],
	[  4000,   87.4710,   1.4639,  88.7283,   1.4431,  46.6451,   2.7452,   8.1993,   15.6169,  8.13e-15,  7.03e-15,  7.16e-15,  nan ],
	[  4100,   87.1977,   1.5428,  87.0095,   1.5461,  39.2772,   3.4251,   7.6506,   17.5841,  6.49e-15,  6.29e-15,  6.33e-15,  nan ],
	[  4200,   88.1118,   1.6022,  88.8389,   1.5891,  40.9426,   3.4480,   8.0849,   17.4611,  7.64e-15,  7.16e-15,  7.21e-15,  nan ],
	[  4300,   89.1337,   1.6601,  88.2968,   1.6758,  42.5327,   3.4790,   8.1334,   18.1930,  6.87e-15,  7.02e-15,  7.40e-15,  nan ],
	[  4400,   89.6572,   1.7281,  89.7067,   1.7271,  44.2396,   3.5021,   8.1393,   19.0351,  6.15e-15,  6.33e-15,  6.67e-15,  nan ],
	[  4500,   90.6272,   1.7881,  88.5607,   1.8299,  45.0642,   3.5961,   8.1218,   19.9530,  6.38e-15,  6.61e-15,  5.94e-15,  nan ],
	[  4600,   90.1210,   1.8790,  89.7338,   1.8871,  46.8159,   3.6170,   8.0844,   20.9460,  7.94e-15,  7.22e-15,  6.69e-15,  nan ],
	[  4700,   92.0261,   1.9209,  89.6342,   1.9722,  45.9161,   3.8500,   8.2706,   21.3740,  6.17e-15,  6.62e-15,  6.24e-15,  nan ],
	[  4800,   91.6818,   2.0111,  89.5894,   2.0580,  45.5359,   4.0491,   8.2781,   22.2731,  7.29e-15,  6.77e-15,  6.41e-15,  nan ],
	[  4900,   91.3188,   2.1040,  89.8226,   2.1391,  46.5912,   4.1239,   8.2552,   23.2749,  8.60e-15,  7.83e-15,  7.27e-15,  nan ],
	[  5000,   93.0074,   2.1510,  89.7063,   2.2302,  47.1067,   4.2470,   8.3588,   23.9341,  7.46e-15,  6.79e-15,  6.90e-15,  nan ],
	[  5100,   93.2103,   2.2330,  90.4202,   2.3019,  47.7184,   4.3619,   8.1990,   25.3861,  8.21e-15,  7.87e-15,  7.62e-15,  nan ],
	[  5200,   94.5783,   2.2879,  90.9210,   2.3799,  43.5810,   4.9651,   8.2832,   26.1230,  7.62e-15,  8.81e-15,  8.03e-15,  nan ],
	[  5300,   96.3133,   2.3339,  91.0049,   2.4700,  43.2442,   5.1980,   8.2983,   27.0879,  8.09e-15,  7.39e-15,  7.75e-15,  nan ],
	[  5400,   96.2264,   2.4250,  90.9759,   2.5649,  44.0606,   5.2960,   8.2492,   28.2869,  7.52e-15,  7.13e-15,  7.01e-15,  nan ],
	[  5500,   96.8704,   2.4989,  91.5921,   2.6429,  44.3749,   5.4550,   8.2569,   29.3169,  7.80e-15,  7.50e-15,  7.40e-15,  nan ],
	[  5600,   97.9115,   2.5630,  90.6276,   2.7690,  44.9174,   5.5869,   8.2038,   30.5891,  6.73e-15,  6.82e-15,  8.45e-15,  nan ],
	[  5700,   97.9230,   2.6550,  90.9407,   2.8589,  45.8701,   5.6679,   8.2791,   31.4028,  7.51e-15,  7.66e-15,  7.82e-15,  nan ],
	[  5800,   96.8239,   2.7802,  91.0975,   2.9550,  47.6861,   5.6450,   8.1583,   32.9959,  9.77e-15,  9.50e-15,  8.95e-15,  nan ],
	[  5900,   97.3930,   2.8601,  91.8713,   3.0320,  47.2433,   5.8961,   8.2897,   33.6020,  7.59e-15,  6.96e-15,  7.31e-15,  nan ],
	[  6000,   97.8508,   2.9440,  91.5697,   3.1459,  48.4467,   5.9462,   8.3565,   34.4729,  7.65e-15,  8.34e-15,  8.74e-15,  nan ],
	[  6100,   97.7893,   3.0448,  92.2968,   3.2260,  48.1426,   6.1848,   8.4866,   35.0850,  8.56e-15,  8.41e-15,  8.11e-15,  nan ],
	[  6200,   98.8086,   3.1130,  92.6229,   3.3209,  44.1000,   6.9749,   8.3845,   36.6862,  8.77e-15,  7.33e-15,  7.28e-15,  nan ],
	[  6300,   98.3893,   3.2279,  92.6222,   3.4289,  44.7326,   7.0999,   8.2901,   38.3101,  7.80e-15,  7.06e-15,  7.83e-15,  nan ],
	[  6400,   98.9286,   3.3131,  92.1203,   3.5579,  44.9091,   7.2982,   8.6837,   37.7438,  7.25e-15,  7.02e-15,  6.65e-15,  nan ],
	[  6500,  100.7390,   3.3560,  92.5951,   3.6511,  44.7785,   7.5500,   8.2531,   40.9639,  8.65e-15,  8.89e-15,  8.41e-15,  nan ],
	[  6600,   99.4195,   3.5059,  92.7995,   3.7560,  45.8037,   7.6098,   8.4610,   41.1961,  7.22e-15,  7.57e-15,  7.65e-15,  nan ],
	[  6700,   99.3600,   3.6151,  92.3612,   3.8891,  46.3725,   7.7460,   8.3006,   43.2739,  8.01e-15,  9.00e-15,  8.99e-15,  nan ],
	[  6800,  100.1613,   3.6941,  92.3860,   4.0050,  46.6582,   7.9300,   8.2715,   44.7321,  9.13e-15,  8.55e-15,  8.76e-15,  nan ],
	[  6900,  101.6136,   3.7491,  93.0511,   4.0941,  46.9039,   8.1222,   8.2454,   46.2031,  8.09e-15,  8.61e-15,  7.79e-15,  nan ],
	[  7000,  100.4532,   3.9032,  92.6072,   4.2338,  47.7336,   8.2140,   8.2336,   47.6201,  7.82e-15,  7.37e-15,  7.52e-15,  nan ],
	[  7100,  100.0909,   4.0300,  92.7694,   4.3480,  47.5382,   8.4851,   8.2564,   48.8551,  8.14e-15,  8.94e-15,  7.90e-15,  nan ],
	[  7200,  101.8215,   4.0739,  92.4651,   4.4861,  44.7912,   9.2609,   8.1608,   50.8289,  7.41e-15,  8.43e-15,  7.71e-15,  nan ],
	[  7300,  102.3101,   4.1678,  92.5333,   4.6082,  44.9086,   9.4950,   7.8744,   54.1511,  7.77e-15,  7.85e-15,  7.45e-15,  nan ],
	[  7400,  102.8550,   4.2601,  93.6465,   4.6790,  44.7342,   9.7950,   8.1174,   53.9789,  7.64e-15,  7.63e-15,  7.41e-15,  nan ],
	[  7500,  103.1649,   4.3628,  93.1288,   4.8330,  45.4413,   9.9049,   8.1113,   55.4891,  8.62e-15,  8.71e-15,  8.97e-15,  nan ],
	[  7600,  104.0686,   4.4410,  93.4255,   4.9469,  46.0700,  10.0319,   8.0871,   57.1489,  7.76e-15,  8.67e-15,  7.87e-15,  nan ],
	[  7700,  101.9589,   4.6530,  93.6302,   5.0669,  46.6855,  10.1619,   7.9943,   59.3441,  9.77e-15,  1.01e-14,  1.09e-14,  nan ],
	[  7800,  101.7564,   4.7841,  92.9929,   5.2350,  47.2956,  10.2930,   7.5902,   64.1370,  8.48e-15,  8.56e-15,  8.45e-15,  nan ],
	[  7900,  102.3719,   4.8780,  93.2352,   5.3561,  47.6094,  10.4890,   7.6814,   65.0110,  8.30e-15,  9.71e-15,  9.03e-15,  nan ],
	[  8000,  103.0408,   4.9698,  93.2283,   5.4929,  47.8009,  10.7131,   7.6520,   66.9229,  8.46e-15,  9.30e-15,  9.18e-15,  nan ],
	[  8100,  104.4105,   5.0280,  94.2681,   5.5690,  48.5773,  10.8070,   7.5888,   69.1779,  8.61e-15,  8.64e-15,  8.84e-15,  nan ],
	[  8200,  103.0887,   5.2190,  94.0255,   5.7220,  44.7678,  12.0180,   7.4650,   72.0720,  8.71e-15,  8.97e-15,  9.21e-15,  nan ],
	[  8300,  104.5957,   5.2700,  93.5230,   5.8939,  45.3046,  12.1670,   7.3121,   75.3851,  1.17e-14,  9.67e-15,  9.60e-15,  nan ],
	[  8400,  103.5745,   5.4510,  93.1193,   6.0630,  45.8528,  12.3129,   7.5972,   74.3141,  8.88e-15,  9.15e-15,  9.62e-15,  nan ],
	[  8500,  104.9351,   5.5091,  93.8329,   6.1610,  45.0937,  12.8200,   7.6201,   75.8650,  8.81e-15,  8.94e-15,  9.14e-15,  nan ],
	[  8600,  104.7573,   5.6491,  94.1302,   6.2869,  46.4399,  12.7430,   7.6933,   76.9219,  9.75e-15,  8.71e-15,  8.47e-15,  nan ],
	[  8700,  104.0585,   5.8200,  93.8684,   6.4518,  45.7005,  13.2520,   7.5976,   79.7131,  1.13e-14,  1.08e-14,  1.11e-14,  nan ],
	[  8800,  104.7901,   5.9130,  93.0771,   6.6571,  46.8954,  13.2129,   7.9759,   77.6870,  1.13e-14,  1.15e-14,  1.23e-14,  nan ],
	[  8900,  104.7562,   6.0501,  93.8233,   6.7551,  47.6534,  13.2999,   8.1228,   78.0261,  1.01e-14,  1.07e-14,  1.08e-14,  nan ],
	[  9000,  105.7646,   6.1278,  93.8628,   6.9048,  47.5055,  13.6428,   8.1231,   79.7861,  1.03e-14,  1.01e-14,  1.04e-14,  nan ],
	[ 10000,  106.2042,   7.5338,  94.0410,   8.5082,  47.3329,  16.9041,   8.2972,   96.4320,  1.04e-14,  1.00e-14,  9.42e-15,  nan ],
	[ 12000,  109.9582,  10.4780,  94.0438,  12.2511,  47.7000,  24.1539,   8.2870,  139.0300,  1.17e-14,  1.09e-14,  1.11e-14,  nan ],
	[ 14000,  111.2659,  14.0939,  94.4740,  16.5989,  47.9121,  32.7301,   8.4718,  185.1039,  1.12e-14,  1.11e-14,  1.25e-14,  nan ],
	[ 16000,  106.5386,  19.2249,  94.2649,  21.7280,  47.0741,  43.5100,   8.7822,  233.2201,  1.50e-14,  1.39e-14,  1.39e-14,  nan ],
	[ 18000,  110.9398,  23.3660,  95.1936,  27.2310,  46.4988,  55.7480,   8.3911,  308.9230,  1.40e-14,  1.48e-14,  1.46e-14,  nan ],
	[ 20000,  106.5114,  30.0460,  93.8656,  34.0939,  46.5069,  68.8121,   8.3093,  385.1411,  1.77e-14,  1.88e-14,  1.89e-14,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.0/cuda7.0-k40c/zpotrf.txt
# numactl --interleave=all ./testing_zpotrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zpotrf = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.03,  0.00,  nan ],
	[    30,  nan,  nan,     0.10,  0.00,  nan ],
	[    40,  nan,  nan,     1.01,  0.00,  nan ],
	[    50,  nan,  nan,     1.64,  0.00,  nan ],
	[    60,  nan,  nan,     2.20,  0.00,  nan ],
	[    70,  nan,  nan,     0.93,  0.00,  nan ],
	[    80,  nan,  nan,     1.25,  0.00,  nan ],
	[    90,  nan,  nan,     1.60,  0.00,  nan ],
	[   100,  nan,  nan,     1.96,  0.00,  nan ],
	[   200,  nan,  nan,    13.92,  0.00,  nan ],
	[   300,  nan,  nan,    12.62,  0.00,  nan ],
	[   400,  nan,  nan,    26.66,  0.00,  nan ],
	[   500,  nan,  nan,    43.63,  0.00,  nan ],
	[   600,  nan,  nan,    51.53,  0.01,  nan ],
	[   700,  nan,  nan,    72.03,  0.01,  nan ],
	[   800,  nan,  nan,    76.06,  0.01,  nan ],
	[   900,  nan,  nan,   102.69,  0.01,  nan ],
	[  1000,  nan,  nan,   126.40,  0.01,  nan ],
	[  2000,  nan,  nan,   373.05,  0.03,  nan ],
	[  3000,  nan,  nan,   558.56,  0.06,  nan ],
	[  4000,  nan,  nan,   684.43,  0.12,  nan ],
	[  5000,  nan,  nan,   766.19,  0.22,  nan ],
	[  6000,  nan,  nan,   832.29,  0.35,  nan ],
	[  7000,  nan,  nan,   883.34,  0.52,  nan ],
	[  8000,  nan,  nan,   923.73,  0.74,  nan ],
	[  9000,  nan,  nan,   951.37,  1.02,  nan ],
	[ 10000,  nan,  nan,   983.41,  1.36,  nan ],
	[ 12000,  nan,  nan,  1035.82,  2.22,  nan ],
	[ 14000,  nan,  nan,  1063.34,  3.44,  nan ],
	[ 16000,  nan,  nan,  1091.50,  5.00,  nan ],
	[ 18000,  nan,  nan,  1106.31,  7.03,  nan ],
	[ 20000,  nan,  nan,  1114.69,  9.57,  nan ],
])

# numactl --interleave=all ./testing_zpotrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zpotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,  nan,  nan,     0.05,  0.00,  nan ],
	[    40,  nan,  nan,     0.10,  0.00,  nan ],
	[    50,  nan,  nan,     0.20,  0.00,  nan ],
	[    60,  nan,  nan,     0.33,  0.00,  nan ],
	[    70,  nan,  nan,     0.49,  0.00,  nan ],
	[    80,  nan,  nan,     0.70,  0.00,  nan ],
	[    90,  nan,  nan,     0.95,  0.00,  nan ],
	[   100,  nan,  nan,     1.20,  0.00,  nan ],
	[   200,  nan,  nan,     7.51,  0.00,  nan ],
	[   300,  nan,  nan,    11.78,  0.00,  nan ],
	[   400,  nan,  nan,    25.42,  0.00,  nan ],
	[   500,  nan,  nan,    43.64,  0.00,  nan ],
	[   600,  nan,  nan,    55.60,  0.01,  nan ],
	[   700,  nan,  nan,    78.89,  0.01,  nan ],
	[   800,  nan,  nan,    86.34,  0.01,  nan ],
	[   900,  nan,  nan,   115.27,  0.01,  nan ],
	[  1000,  nan,  nan,   146.33,  0.01,  nan ],
	[  2000,  nan,  nan,   450.52,  0.02,  nan ],
	[  3000,  nan,  nan,   647.93,  0.06,  nan ],
	[  4000,  nan,  nan,   789.27,  0.11,  nan ],
	[  5000,  nan,  nan,   866.15,  0.19,  nan ],
	[  6000,  nan,  nan,   926.81,  0.31,  nan ],
	[  7000,  nan,  nan,   975.39,  0.47,  nan ],
	[  8000,  nan,  nan,  1015.29,  0.67,  nan ],
	[  9000,  nan,  nan,  1035.36,  0.94,  nan ],
	[ 10000,  nan,  nan,  1062.24,  1.26,  nan ],
	[ 12000,  nan,  nan,  1102.47,  2.09,  nan ],
	[ 14000,  nan,  nan,  1121.77,  3.26,  nan ],
	[ 16000,  nan,  nan,  1142.91,  4.78,  nan ],
	[ 18000,  nan,  nan,  1153.08,  6.74,  nan ],
	[ 20000,  nan,  nan,  1154.08,  9.24,  nan ],
])

