# Overview

The Ideal Graph Visualizer is a tool developed to help examine the intermediate
representation of C2 which is commonly referred to as the "ideal graph". It was
developed in collaboration with the University of Linz in Austria and has been
included as part of HotSpot since that was the primary target of the tool. The
tool itself is fairly general with only a few modules that contain C2 specific
elements.

The tool is built on top of the NetBeans Platform, and requires a JDK version
between 17 and 21 (the JDKs supported by the current NetBeans Platform).

# Building and Running

The build system used for IGV is Maven. To download all required libraries and
build IGV, issue `mvn install`. To run IGV, use the `igv.sh` command; it will
put all log messages generated by the run to the file `.igv.log`.

To build and run IGV on a different JDK than the system default, set first the
`JAVA_HOME` to the appropriate directory. The same JDK version should be used
for building and running IGV.

# Usage

## Regular JVM Execution

The JVM support is controlled by the flag `-XX:PrintIdealGraphLevel=N`, where
Ideal graphs are dumped at the following points:

* `N=0`: no output (default)
* `N=1`: after parsing, before matching, and final code (also for failed
  compilations, if available)
* `N=2`: additionally, after every major phase
* `N=3`: additionally, after every minor phase
* `N=4`: additionally, after every loop optimization
* `N=5`: additionally, after every effective IGVN and every macro expansion step (slow)
* `N=6`: additionally, after parsing every bytecode (very slow)

By default the JVM expects that it will connect to a visualizer on the local
host on port 4444. This can be configured using the options
`-XX:PrintIdealGraphAddress=` and `-XX:PrintIdealGraphPort=`.
`PrintIdealGraphAddress` can actually be a hostname.

It is advisable to run the JVM with background compilation disabled (-Xbatch).
Compilations going on in the background may be cancelled when the VM terminates,
which can lead to incomplete dumps being sent to IGV.

Alternatively the output can be sent to a file using
`-XX:PrintIdealGraphFile=filename`. Each compiler thread will get it's own file
with unique names being generated by adding a number onto the provided file
name.

## Dumping Graphs From a Debugger

The JVM provides some entry functions to dump graphs from a debugger such as
`gdb` or `rr`, see the different variants of `igv_print` and `igv_append` in
[`compile.cpp`](/src/hotspot/share/opto/compile.cpp). In combination with the
IGV network interface, these functions enable a powerful interactive workflow
where the user can simultaneously step through C2's code and visualize the
evolving Ideal graph. Note that, to produce and print meaningful C2 stack
traces, these functions take the stack pointer, frame pointer, and program
counter registers as arguments. These are usually `$sp`, `$fp`, and `$pc`:

```
(gdb) p igv_print(true, $sp, $fp, $pc)
Method printed over network stream to IGV
```

but might be given different names on different platforms, see the output of
`p help()` for more information. A tip to further simplify the workflow in
`gdb` or `rr` is to create a user-defined command such as e.g.:

```
define igv
  p igv_print(true, $sp, $fp, $pc)
end
```

On `lldb`, it might be necessary to explicitly cast the registers to `void*` to
 ensure their values are correctly passed as arguments:

```
(lldb) p igv_print(true, (void*)$sp, (void*)$fp, (void*)$pc)
```

Another way to dump graphs interactively is through the `Node::dump_bfs`
functionality with the option `!` (run `p find_node(0)->dump_bfs(0,0,"H")` to
see the complete list of options). One of the versions of this function also
takes the three stack management registers to produce a C2 stack trace:

```
(gdb) p find_node(3)->dump_bfs(0, 0, "!", $sp, $fp, $pc)
(...)
Method printed over network stream to IGV
```

Again, user-defined debugger commands can be created for simplicity. For
example, to dump the current graph with a given node highlighted:

```
define igv_node
  p find_node($arg0)->dump_bfs(0, 0, "!", $sp, $fp, $pc)
end
```

## Defining Custom Filters

IGV has a powerful filter mechanism with which nodes and blocks can be colored,
hidden, updated, etc. according to user-defined rules. Filters are programmed in
JavaScript using a set of predefined primitives and auxiliary functions. For
more information, see the documentation in
`Filter/src/main/resources/com/sun/hotspot/igv/filter/helper.js` and the default
filters in
`ServerCompiler/src/main/resources/com/sun/hotspot/igv/servercompiler/filters`.

More information about the tool is available at
https://wiki.openjdk.org/display/HotSpot/IdealGraphVisualizer.
