// Package models contains the types for schema 'public'.
package models

// Code generated by xo. DO NOT EDIT.

import (
	"database/sql"
)

// Table cache hit ratio
type TableCacheHitRatio struct {
	Name  string          // name
	Ratio sql.NullFloat64 // ratio
}

// GetTableCacheHitRatio runs a custom query, returning results as TableCacheHitRatio.
func GetTableCacheHitRatio(db XODB) (*TableCacheHitRatio, error) {
	var err error

	// sql query
	sqlstr := `SELECT 'cache hit rate' AS name, ` +
		`CASE WHEN (sum(heap_blks_read) + sum(idx_blks_hit)) > 0 ` +
		`THEN ` +
		`sum(heap_blks_hit) / (sum(heap_blks_hit) + sum(heap_blks_read)) ` +
		`ELSE 0 ` +
		`END  AS ratio ` +
		`FROM pg_statio_user_tables`

	// run query
	XOLog(sqlstr)
	var tchr TableCacheHitRatio
	err = db.QueryRow(sqlstr).Scan(&tchr.Name, &tchr.Ratio)
	if err != nil {
		return nil, err
	}

	return &tchr, nil
}
