% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace_tests.R
\name{covr.record_tests}
\alias{covr.record_tests}
\title{Record Test Traces During Coverage Execution}
\description{
By setting \code{options(covr.record_tests = TRUE)}, the result of covr coverage
collection functions will include additional data pertaining to the tests
which are executed and an index of which tests, at what stack depth, trigger
the execution of each trace.
}
\details{
This functionality requires that the package code and tests are installed and
sourced with the source. For more details, refer to R options, \code{keep.source},
\code{keep.source.pkgs} and \code{keep.parse.data.pkgs}.
}
\section{Additional fields}{


Within the \code{covr} result, you can explore this information in two places:

\itemize{
\item \code{attr(,"tests")}: A list of call stacks, which results in target code
execution.

\item \verb{$<srcref>$tests}: For each srcref count in the coverage object, a
\verb{$tests} field is now included which contains a matrix with three columns,
"test", "call", "depth" and "i" which specify the test number
(corresponding to the index of the test in \code{attr(,"tests")}, the number
of times the test expression was evaluated to produce the trace hit, the
stack depth into the target code where the trace was executed, and the
order of execution for each test.
}
}

\section{Test traces}{


The content of test traces are dependent on the unit testing framework that
is used by the target package. The behavior is contingent on the available
information in the sources kept for the testing files.

Test traces are extracted by the following criteria:
\enumerate{
\item If any \code{srcref} files are are provided by a file within \link{covr}'s temporary
library, all calls from those files are kept as a test trace. This will
collect traces from tests run with common testing frameworks such as
\code{testthat} and \code{RUnit}.
\item Otherwise, as a conservative fallback in situations where no source
references are found, or when none are from within the temporary
directory, the entire call stack is collected.
}

These calls are subsequently subset for only those up until the call to
\link{covr}'s internal \code{count} function, and will always include the last call in
the call stack prior to a call to \code{count}.
}

\examples{
fcode <- '
f <- function(x) {
  if (x)
    f(!x)
  else
    FALSE
}'

options(covr.record_tests = TRUE)
cov <- code_coverage(fcode, "f(TRUE)")

# extract executed test code for the first test
tail(attr(cov, "tests")[[1L]], 1L)
# [[1]]
# f(TRUE)

# extract test itemization per trace
cov[[3]][c("srcref", "tests")]
# $srcref
# f(!x)
#
# $tests
#      test call depth i
# [1,]    1    1     2 4

# reconstruct the code path of a test by ordering test traces by [,"i"]
lapply(cov, `[[`, "tests")
# $`source.Ref2326138c55:4:6:4:10:6:10:4:4`
#      test call depth i
# [1,]    1    1     1 2
#
# $`source.Ref2326138c55:3:8:3:8:8:8:3:3`
#      test call depth i
# [1,]    1    1     1 1
# [2,]    1    1     2 3
#
# $`source.Ref2326138c55:6:6:6:10:6:10:6:6`
#      test call depth i
# [1,]    1    1     2 4

}
