% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-win.R
\name{check_win}
\alias{check_win}
\alias{check_win_devel}
\alias{check_win_release}
\alias{check_win_oldrelease}
\title{Check a package on Windows}
\usage{
check_win_devel(
  pkg = ".",
  args = NULL,
  manual = TRUE,
  email = NULL,
  quiet = FALSE,
  ...
)

check_win_release(
  pkg = ".",
  args = NULL,
  manual = TRUE,
  email = NULL,
  quiet = FALSE,
  ...
)

check_win_oldrelease(
  pkg = ".",
  args = NULL,
  manual = TRUE,
  email = NULL,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{pkg}{The package to use, can be a file path to the package or a
package object.  See \code{\link[=as.package]{as.package()}} for more information.}

\item{args}{An optional character vector of additional command
line arguments to be passed to \verb{R CMD build} if \code{binary = FALSE},
or \verb{R CMD install} if \code{binary = TRUE}.}

\item{manual}{Should the manual be built?}

\item{email}{An alternative email address to use. If \code{NULL}, the default is
to use the package maintainer's email.}

\item{quiet}{If \code{TRUE}, suppresses output.}

\item{...}{Additional arguments passed to \code{\link[pkgbuild:build]{pkgbuild::build()}}.}
}
\description{
This function first bundles a source package, then uploads it to
\url{https://win-builder.r-project.org/}. Once the service has built and checked
the package, an email is sent to address of the maintainer listed in
\code{DESCRIPTION}. This usually takes around 30 minutes. The email contains a
link to a directory with the package binary and check logs, which will be
deleted after a couple of days.
}
\section{Functions}{
\itemize{
\item \code{check_win_devel()}: Check package on the development version of R.

\item \code{check_win_release()}: Check package on the released version of R.

\item \code{check_win_oldrelease()}: Check package on the previous major release version of R.

}}
\seealso{
Other build functions: 
\code{\link{check_mac_release}()}
}
\concept{build functions}
