% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{ChenThissen1997}
\alias{ChenThissen1997}
\alias{chen.thissen.1997}
\title{Computes local dependence indices for all pairs of items}
\usage{
ChenThissen1997(
  grp,
  ...,
  data = NULL,
  inames = NULL,
  qwidth = 6,
  qpoints = 49,
  method = "pearson",
  .twotier = TRUE,
  .parallel = TRUE
)
}
\arguments{
\item{grp}{a list containing the model and data. See the details section.}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{data}{data \lifecycle{deprecated}}

\item{inames}{a subset of items to examine}

\item{qwidth}{\lifecycle{deprecated}}

\item{qpoints}{\lifecycle{deprecated}}

\item{method}{method to use to calculate P values. The default is the
Pearson X^2 statistic. Use "lr" for the similar likelihood ratio statistic.}

\item{.twotier}{whether to enable the two-tier optimization}

\item{.parallel}{whether to take advantage of multiple CPUs (default TRUE)}
}
\value{
a list with raw, pval and detail. The pval matrix is a
lower triangular matrix of log P values with the sign
determined by relative association between the observed and
expected tables (see \code{\link{ordinal.gamma}})
}
\description{
Item Factor Analysis makes two assumptions: (1) that the latent
distribution is reasonably approximated by the multivariate Normal
and (2) that items are conditionally independent. This test
examines the second assumption. The presence of locally dependent
items can inflate the precision of estimates causing a test to
seem more accurate than it really is.
}
\details{
Statically significant entries suggest that the item pair has
local dependence. Since log(.01)=-4.6, an absolute magitude of 5
is a reasonable cut-off. Positive entries indicate that the two
item residuals are more correlated than expected. These items may share an
unaccounted for latent dimension. Consider a redesign of the items
or the use of testlets for scoring. Negative entries indicate that
the two item residuals are less correlated than expected.
}
\section{Format of a group}{


A model, or group within a model, is represented as a named list.
\describe{
\item{spec}{list of response model objects}
\item{param}{numeric matrix of item parameters}
\item{free}{logical matrix of indicating which parameters are free (TRUE) or fixed (FALSE)}
\item{mean}{numeric vector giving the mean of the latent distribution}
\item{cov}{numeric matrix giving the covariance of the latent distribution}
\item{data}{data.frame containing observed item responses, and optionally,
weights and frequencies}
\item{score}{factors scores with response patterns in rows}
\item{weightColumn}{name of the data column containing the numeric row weights (optional)}
\item{freqColumn}{name of the data column containing the integral row frequencies (optional)}
\item{qwidth}{width of the quadrature expressed in Z units}
\item{qpoints}{number of quadrature points}
\item{minItemsPerScore}{minimum number of non-missing items when estimating factor scores}
}

The \code{param} matrix stores items parameters by column. If a
column has more rows than are required to fully specify a model
then the extra rows are ignored.  The order of the items in
\code{spec} and order of columns in \code{param} are assumed to
match. All items should have the same number of latent dimensions.
Loadings on latent dimensions are given in the first few rows and
can be named by setting rownames. Item names are assigned by
\code{param} colnames.

Currently only a multivariate normal distribution is available,
parameterized by the \code{mean} and \code{cov}. If \code{mean} and
\code{cov} are not specified then a standard normal distribution is
assumed. The quadrature consists of equally spaced points. For
example, \code{qwidth=2} and \code{qpoints=5} would produce points
-2, -1, 0, 1, and 2. The quadrature specification is part of the
group and not passed as extra arguments for the sake of
consistency. As currently implemented, OpenMx uses EAP scores to
estimate latent distribution parameters. By default, the exact same
EAP scores should be produced by \link{EAPscores}.
}

\references{
Chen, W.-H. & Thissen, D. (1997). Local dependence
indexes for item pairs using Item Response Theory. \emph{Journal
of Educational and Behavioral Statistics, 22}(3), 265-289.

Thissen, D., Steinberg, L., & Mooney, J. A. (1989). Trace lines for testlets: A use
of multiple-categorical-response models. \emph{Journal of Educational Measurement,
26} (3), 247--260.

Wainer, H. & Kiely, G. L. (1987). Item clusters and computerized
adaptive testing: A case for testlets.  \emph{Journal of
Educational measurement, 24}(3), 185--201.
}
\seealso{
\href{https://github.com/jpritikin/ifaTools}{ifaTools}

Other diagnostic: 
\code{\link{SitemFit}()},
\code{\link{SitemFit1}()},
\code{\link{multinomialFit}()},
\code{\link{rpf.1dim.fit}()},
\code{\link{sumScoreEAPTest}()}
}
\concept{diagnostic}
