// SPDX-FileCopyrightText: Copyright (c) Kitware Inc.
// SPDX-FileCopyrightText: Copyright (c) Sandia Corporation
// SPDX-License-Identifier: BSD-3-Clause
#include "LogViewerWidget.h"

#include <QApplication>
#include <QFile>
#include <QTest>
#include <pqLogViewerWidget.h>

void LogViewerWidgetTester::basic()
{
  pqLogViewerWidget widget;
  widget.show();
  widget.setLog(
    "arguments: ./bin/paraview -l=/tmp/info.log,9\n"
    "Current dir: /home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5\n"
    "File verbosity level: 9\n"
    "( uptime  ) [ thread name/id ]                   file:line     v| \n"
    "(   0.176s) [main thread     ]             loguru.cpp:751   INFO| Logging to '/tmp/info.log', "
    "mode: 'w', verbosity: 9\n"
    "(   0.177s) [paraview        ] vtkPVPluginTracker.cxx:263      9| Locate and load distributed "
    "plugin list when creating vtkPVPluginTracker.\n"
    "(   0.177s) [paraview        ] vtkPVPluginTracker.cxx:90       9| { looking for plugin "
    "'.plugins'\n"
    "(   0.177s) [paraview        ] vtkPVPluginTracker.cxx:121      9| .   VTK libraries location "
    "is '/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/libvtkCommonCore-pv5.6.so.1'\n"
    "(   0.177s) [paraview        ] vtkPVPluginTracker.cxx:164      9| .   check various prefixes "
    "relative to VTK libraries\n"
    "(   0.177s) [paraview        ]vtkResourceFileLocator.:61       9| .   { looking for "
    "'.plugins'\n"
    "(   0.178s) [paraview        ]vtkResourceFileLocator.:79       9| .   .   trying file "
    "/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/.plugins/.plugins -- "
    "failed!\n"
    "(   0.178s) [paraview        ]vtkResourceFileLocator.:74       9| .   .   trying file "
    "/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins//.plugins -- "
    "success!\n"
    "(   0.178s) [paraview        ]vtkResourceFileLocator.:61       9| .   } 0.001 s: looking for "
    "'.plugins'\n"
    "(   0.178s) [paraview        ] vtkPVPluginTracker.cxx:90       9| } 0.001 s: looking for "
    "plugin '.plugins'\n"
    "(   0.178s) [paraview        ] vtkPVPluginTracker.cxx:309      9| Loading plugin "
    "configuration xml "
    "`/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins//.plugins`.\n"
    "(   0.178s) [paraview        ] vtkPVPluginTracker.cxx:358      9| Trying to locate plugin "
    "with name `AcceleratedAlgorithms`\n"
    "(   0.178s) [paraview        ] vtkPVPluginTracker.cxx:90       9| { looking for plugin "
    "'AcceleratedAlgorithms'\n"
    "(   0.179s) [paraview        ] vtkPVPluginTracker.cxx:121      9| .   VTK libraries location "
    "is '/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/libvtkCommonCore-pv5.6.so.1'\n"
    "(   0.179s) [paraview        ] vtkPVPluginTracker.cxx:164      9| .   check various prefixes "
    "relative to VTK libraries\n"
    "(   0.179s) [paraview        ]vtkResourceFileLocator.:61       9| .   { looking for "
    "'AcceleratedAlgorithms.so'\n"
    "(   0.180s) [paraview        ]vtkResourceFileLocator.:74       9| .   .   trying file "
    "/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/"
    "AcceleratedAlgorithms/AcceleratedAlgorithms.so -- success!\n"
    "(   0.180s) [paraview        ]vtkResourceFileLocator.:61       9| .   } 0.001 s: looking for "
    "'AcceleratedAlgorithms.so'\n"
    "(   0.180s) [paraview        ] vtkPVPluginTracker.cxx:90       9| } 0.001 s: looking for "
    "plugin 'AcceleratedAlgorithms'\n"
    "(   0.180s) [paraview        ] vtkPVPluginTracker.cxx:384      9| found "
    "`/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/"
    "AcceleratedAlgorithms/AcceleratedAlgorithms.so`\n"
    "(   0.180s) [paraview        ] vtkPVPluginTracker.cxx:358      9| Trying to locate plugin "
    "with name `AnalyzeNIfTIReaderWriter`\n"
    "(   0.180s) [paraview        ] vtkPVPluginTracker.cxx:90       9| { looking for plugin "
    "'AnalyzeNIfTIReaderWriter'\n"
    "(   0.180s) [paraview        ] vtkPVPluginTracker.cxx:121      9| .   VTK libraries location "
    "is '/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/libvtkCommonCore-pv5.6.so.1'\n"
    "(   0.180s) [paraview        ] vtkPVPluginTracker.cxx:164      9| .   check various prefixes "
    "relative to VTK libraries\n"
    "(   0.180s) [paraview        ]vtkResourceFileLocator.:61       9| .   { looking for "
    "'AnalyzeNIfTIReaderWriter.so'\n"
    "(   0.181s) [paraview        ]vtkResourceFileLocator.:74       9| .   .   trying file "
    "/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/"
    "AnalyzeNIfTIReaderWriter/AnalyzeNIfTIReaderWriter.so -- success!\n"
    "(   0.181s) [paraview        ]vtkResourceFileLocator.:61       9| .   } 0.001 s: looking for "
    "'AnalyzeNIfTIReaderWriter.so'\n"
    "(   0.181s) [paraview        ] vtkPVPluginTracker.cxx:90       9| } 0.001 s: looking for "
    "plugin 'AnalyzeNIfTIReaderWriter'\n"
    "(   0.181s) [paraview        ] vtkPVPluginTracker.cxx:384      9| found "
    "`/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/"
    "AnalyzeNIfTIReaderWriter/AnalyzeNIfTIReaderWriter.so`\n"
    "(   0.181s) [paraview        ] vtkPVPluginTracker.cxx:358      9| Trying to locate plugin "
    "with name `ArrowGlyph`\n"
    "(   0.181s) [paraview        ] vtkPVPluginTracker.cxx:90       9| { looking for plugin "
    "'ArrowGlyph'\n"
    "(   0.181s) [paraview        ] vtkPVPluginTracker.cxx:121      9| .   VTK libraries location "
    "is '/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/libvtkCommonCore-pv5.6.so.1'\n"
    "(   0.181s) [paraview        ] vtkPVPluginTracker.cxx:164      9| .   check various prefixes "
    "relative to VTK libraries\n"
    "(   0.181s) [paraview        ]vtkResourceFileLocator.:61       9| .   { looking for "
    "'ArrowGlyph.so'\n"
    "(   0.181s) [paraview        ]vtkResourceFileLocator.:74       9| .   .   trying file "
    "/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/ArrowGlyph/"
    "ArrowGlyph.so -- success!\n"
    "(   0.181s) [paraview        ]vtkResourceFileLocator.:61       9| .   } 0.000 s: looking for "
    "'ArrowGlyph.so'\n"
    "(   0.181s) [paraview        ] vtkPVPluginTracker.cxx:90       9| } 0.000 s: looking for "
    "plugin 'ArrowGlyph'\n"
    "(   0.181s) [paraview        ] vtkPVPluginTracker.cxx:384      9| found "
    "`/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/ArrowGlyph/"
    "ArrowGlyph.so`\n"
    "(   0.181s) [paraview        ] vtkPVPluginTracker.cxx:358      9| Trying to locate plugin "
    "with name `BagPlotViewsAndFilters`\n"
    "(   0.181s) [paraview        ] vtkPVPluginTracker.cxx:90       9| { looking for plugin "
    "'BagPlotViewsAndFilters'\n"
    "(   0.181s) [paraview        ] vtkPVPluginTracker.cxx:121      9| .   VTK libraries location "
    "is '/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/libvtkCommonCore-pv5.6.so.1'\n"
    "(   0.181s) [paraview        ] vtkPVPluginTracker.cxx:164      9| .   check various prefixes "
    "relative to VTK libraries\n"
    "(   0.181s) [paraview        ]vtkResourceFileLocator.:61       9| .   { looking for "
    "'BagPlotViewsAndFilters.so'\n"
    "(   0.182s) [paraview        ]vtkResourceFileLocator.:74       9| .   .   trying file "
    "/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/"
    "BagPlotViewsAndFilters/BagPlotViewsAndFilters.so -- success!\n"
    "(   0.182s) [paraview        ]vtkResourceFileLocator.:61       9| .   } 0.001 s: looking for "
    "'BagPlotViewsAndFilters.so'\n"
    "(   0.182s) [paraview        ] vtkPVPluginTracker.cxx:90       9| } 0.001 s: looking for "
    "plugin 'BagPlotViewsAndFilters'\n"
    "(   0.182s) [paraview        ] vtkPVPluginTracker.cxx:384      9| found "
    "`/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/"
    "BagPlotViewsAndFilters/BagPlotViewsAndFilters.so`\n"
    "(   0.182s) [paraview        ] vtkPVPluginTracker.cxx:358      9| Trying to locate plugin "
    "with name `CDIReader`\n"
    "(   0.182s) [paraview        ] vtkPVPluginTracker.cxx:90       9| { looking for plugin "
    "'CDIReader'\n"
    "(   0.182s) [paraview        ] vtkPVPluginTracker.cxx:121      9| .   VTK libraries location "
    "is '/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/libvtkCommonCore-pv5.6.so.1'\n"
    "(   0.182s) [paraview        ] vtkPVPluginTracker.cxx:164      9| .   check various prefixes "
    "relative to VTK libraries\n"
    "(   0.182s) [paraview        ]vtkResourceFileLocator.:61       9| .   { looking for "
    "'CDIReader.so'\n"
    "(   0.183s) [paraview        ]vtkResourceFileLocator.:74       9| .   .   trying file "
    "/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/CDIReader/"
    "CDIReader.so -- success!\n"
    "(   0.183s) [paraview        ]vtkResourceFileLocator.:61       9| .   } 0.000 s: looking for "
    "'CDIReader.so'\n"
    "(   0.183s) [paraview        ] vtkPVPluginTracker.cxx:90       9| } 0.000 s: looking for "
    "plugin 'CDIReader'\n"
    "(   0.183s) [paraview        ] vtkPVPluginTracker.cxx:384      9| found "
    "`/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/CDIReader/"
    "CDIReader.so`\n"
    "(   0.183s) [paraview        ] vtkPVPluginTracker.cxx:358      9| Trying to locate plugin "
    "with name `DigitalRockPhysics`\n"
    "(   0.183s) [paraview        ] vtkPVPluginTracker.cxx:90       9| { looking for plugin "
    "'DigitalRockPhysics'\n"
    "(   0.183s) [paraview        ] vtkPVPluginTracker.cxx:121      9| .   VTK libraries location "
    "is '/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/libvtkCommonCore-pv5.6.so.1'\n"
    "(   0.183s) [paraview        ] vtkPVPluginTracker.cxx:164      9| .   check various prefixes "
    "relative to VTK libraries\n"
    "(   0.183s) [paraview        ]vtkResourceFileLocator.:61       9| .   { looking for "
    "'DigitalRockPhysics.so'\n"
    "(   0.183s) [paraview        ]vtkResourceFileLocator.:74       9| .   .   trying file "
    "/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/DigitalRockPhysics/"
    "DigitalRockPhysics.so -- success!\n"
    "(   0.183s) [paraview        ]vtkResourceFileLocator.:61       9| .   } 0.000 s: looking for "
    "'DigitalRockPhysics.so'\n"
    "(   0.183s) [paraview        ] vtkPVPluginTracker.cxx:90       9| } 0.001 s: looking for "
    "plugin 'DigitalRockPhysics'\n"
    "(   0.183s) [paraview        ] vtkPVPluginTracker.cxx:384      9| found "
    "`/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/DigitalRockPhysics/"
    "DigitalRockPhysics.so`\n"
    "(   0.183s) [paraview        ] vtkPVPluginTracker.cxx:358      9| Trying to locate plugin "
    "with name `EULATestPlugin`\n"
    "(   0.183s) [paraview        ] vtkPVPluginTracker.cxx:90       9| { looking for plugin "
    "'EULATestPlugin'\n"
    "(   0.183s) [paraview        ] vtkPVPluginTracker.cxx:121      9| .   VTK libraries location "
    "is '/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/libvtkCommonCore-pv5.6.so.1'\n"
    "(   0.183s) [paraview        ] vtkPVPluginTracker.cxx:164      9| .   check various prefixes "
    "relative to VTK libraries\n"
    "(   0.183s) [paraview        ]vtkResourceFileLocator.:61       9| .   { looking for "
    "'EULATestPlugin.so'\n"
    "(   0.184s) [paraview        ]vtkResourceFileLocator.:74       9| .   .   trying file "
    "/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/EULATestPlugin/"
    "EULATestPlugin.so -- success!\n"
    "(   0.184s) [paraview        ]vtkResourceFileLocator.:61       9| .   } 0.000 s: looking for "
    "'EULATestPlugin.so'\n"
    "(   0.184s) [paraview        ] vtkPVPluginTracker.cxx:90       9| } 0.000 s: looking for "
    "plugin 'EULATestPlugin'\n"
    "(   0.184s) [paraview        ] vtkPVPluginTracker.cxx:384      9| found "
    "`/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/EULATestPlugin/"
    "EULATestPlugin.so`\n"
    "(   0.184s) [paraview        ] vtkPVPluginTracker.cxx:358      9| Trying to locate plugin "
    "with name `EmbossingRepresentations`\n"
    "(   0.184s) [paraview        ] vtkPVPluginTracker.cxx:90       9| { looking for plugin "
    "'EmbossingRepresentations'\n"
    "(   0.184s) [paraview        ] vtkPVPluginTracker.cxx:121      9| .   VTK libraries location "
    "is '/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/libvtkCommonCore-pv5.6.so.1'\n"
    "(   0.184s) [paraview        ] vtkPVPluginTracker.cxx:164      9| .   check various prefixes "
    "relative to VTK libraries\n"
    "(   0.184s) [paraview        ]vtkResourceFileLocator.:61       9| .   { looking for "
    "'EmbossingRepresentations.so'\n"
    "(   0.184s) [paraview        ]vtkResourceFileLocator.:74       9| .   .   trying file "
    "/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/"
    "EmbossingRepresentations/EmbossingRepresentations.so -- success!\n"
    "(   0.184s) [paraview        ]vtkResourceFileLocator.:61       9| .   } 0.000 s: looking for "
    "'EmbossingRepresentations.so'\n"
    "(   0.184s) [paraview        ] vtkPVPluginTracker.cxx:90       9| } 0.000 s: looking for "
    "plugin 'EmbossingRepresentations'\n"
    "(   0.184s) [paraview        ] vtkPVPluginTracker.cxx:384      9| found "
    "`/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/"
    "EmbossingRepresentations/EmbossingRepresentations.so`\n"
    "(   0.184s) [paraview        ] vtkPVPluginTracker.cxx:358      9| Trying to locate plugin "
    "with name `ExplicitStructuredGrid`\n"
    "(   0.184s) [paraview        ] vtkPVPluginTracker.cxx:90       9| { looking for plugin "
    "'ExplicitStructuredGrid'\n"
    "(   0.184s) [paraview        ] vtkPVPluginTracker.cxx:121      9| .   VTK libraries location "
    "is '/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/libvtkCommonCore-pv5.6.so.1'\n"
    "(   0.184s) [paraview        ] vtkPVPluginTracker.cxx:164      9| .   check various prefixes "
    "relative to VTK libraries\n"
    "(   0.184s) [paraview        ]vtkResourceFileLocator.:61       9| .   { looking for "
    "'ExplicitStructuredGrid.so'\n"
    "(   0.185s) [paraview        ]vtkResourceFileLocator.:74       9| .   .   trying file "
    "/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/"
    "ExplicitStructuredGrid/ExplicitStructuredGrid.so -- success!\n"
    "(   0.185s) [paraview        ]vtkResourceFileLocator.:61       9| .   } 0.001 s: looking for "
    "'ExplicitStructuredGrid.so'\n"
    "(   0.185s) [paraview        ] vtkPVPluginTracker.cxx:90       9| } 0.001 s: looking for "
    "plugin 'ExplicitStructuredGrid'\n"
    "(   0.185s) [paraview        ] vtkPVPluginTracker.cxx:384      9| found "
    "`/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/"
    "ExplicitStructuredGrid/ExplicitStructuredGrid.so`\n"
    "(   0.185s) [paraview        ] vtkPVPluginTracker.cxx:358      9| Trying to locate plugin "
    "with name `EyeDomeLighting`\n"
    "(   0.185s) [paraview        ] vtkPVPluginTracker.cxx:90       9| { looking for plugin "
    "'EyeDomeLighting'\n"
    "(   0.185s) [paraview        ] vtkPVPluginTracker.cxx:121      9| .   VTK libraries location "
    "is '/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/libvtkCommonCore-pv5.6.so.1'\n"
    "(   0.185s) [paraview        ] vtkPVPluginTracker.cxx:164      9| .   check various prefixes "
    "relative to VTK libraries\n"
    "(   0.185s) [paraview        ]vtkResourceFileLocator.:61       9| .   { looking for "
    "'EyeDomeLighting.so'\n"
    "(   0.185s) [paraview        ]vtkResourceFileLocator.:74       9| .   .   trying file "
    "/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/EyeDomeLighting/"
    "EyeDomeLighting.so -- success!\n"
    "(   0.185s) [paraview        ]vtkResourceFileLocator.:61       9| .   } 0.000 s: looking for "
    "'EyeDomeLighting.so'\n"
    "(   0.185s) [paraview        ] vtkPVPluginTracker.cxx:90       9| } 0.000 s: looking for "
    "plugin 'EyeDomeLighting'\n"
    "(   0.185s) [paraview        ] vtkPVPluginTracker.cxx:384      9| found "
    "`/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/EyeDomeLighting/"
    "EyeDomeLighting.so`\n"
    "(   0.185s) [paraview        ] vtkPVPluginTracker.cxx:358      9| Trying to locate plugin "
    "with name `GMVReader`\n"
    "(   0.185s) [paraview        ] vtkPVPluginTracker.cxx:90       9| { looking for plugin "
    "'GMVReader'\n"
    "(   0.185s) [paraview        ] vtkPVPluginTracker.cxx:121      9| .   VTK libraries location "
    "is '/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/libvtkCommonCore-pv5.6.so.1'\n"
    "(   0.185s) [paraview        ] vtkPVPluginTracker.cxx:164      9| .   check various prefixes "
    "relative to VTK libraries\n"
    "(   0.185s) [paraview        ]vtkResourceFileLocator.:61       9| .   { looking for "
    "'GMVReader.so'\n"
    "(   0.186s) [paraview        ]vtkResourceFileLocator.:74       9| .   .   trying file "
    "/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/GMVReader/"
    "GMVReader.so -- success!\n"
    "(   0.186s) [paraview        ]vtkResourceFileLocator.:61       9| .   } 0.001 s: looking for "
    "'GMVReader.so'\n"
    "(   0.186s) [paraview        ] vtkPVPluginTracker.cxx:90       9| } 0.001 s: looking for "
    "plugin 'GMVReader'\n"
    "(   0.186s) [paraview        ] vtkPVPluginTracker.cxx:384      9| found "
    "`/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/GMVReader/"
    "GMVReader.so`\n"
    "(   0.186s) [paraview        ] vtkPVPluginTracker.cxx:358      9| Trying to locate plugin "
    "with name `GeodesicMeasurement`\n"
    "(   0.186s) [paraview        ] vtkPVPluginTracker.cxx:90       9| { looking for plugin "
    "'GeodesicMeasurement'\n"
    "(   0.187s) [paraview        ] vtkPVPluginTracker.cxx:121      9| .   VTK libraries location "
    "is '/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/libvtkCommonCore-pv5.6.so.1'\n"
    "(   0.187s) [paraview        ] vtkPVPluginTracker.cxx:164      9| .   check various prefixes "
    "relative to VTK libraries\n"
    "(   0.187s) [paraview        ]vtkResourceFileLocator.:61       9| .   { looking for "
    "'GeodesicMeasurement.so'\n"
    "(   0.188s) [paraview        ]vtkResourceFileLocator.:74       9| .   .   trying file "
    "/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/GeodesicMeasurement/"
    "GeodesicMeasurement.so -- success!\n"
    "(   0.188s) [paraview        ]vtkResourceFileLocator.:61       9| .   } 0.001 s: looking for "
    "'GeodesicMeasurement.so'\n"
    "(   0.188s) [paraview        ] vtkPVPluginTracker.cxx:90       9| } 0.001 s: looking for "
    "plugin 'GeodesicMeasurement'\n"
    "(   0.188s) [paraview        ] vtkPVPluginTracker.cxx:384      9| found "
    "`/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/GeodesicMeasurement/"
    "GeodesicMeasurement.so`\n"
    "(   0.188s) [paraview        ] vtkPVPluginTracker.cxx:358      9| Trying to locate plugin "
    "with name `LagrangianParticleTracker`\n"
    "(   0.188s) [paraview        ] vtkPVPluginTracker.cxx:90       9| { looking for plugin "
    "'LagrangianParticleTracker'\n"
    "(   0.188s) [paraview        ] vtkPVPluginTracker.cxx:121      9| .   VTK libraries location "
    "is '/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/libvtkCommonCore-pv5.6.so.1'\n"
    "(   0.188s) [paraview        ] vtkPVPluginTracker.cxx:164      9| .   check various prefixes "
    "relative to VTK libraries\n"
    "(   0.188s) [paraview        ]vtkResourceFileLocator.:61       9| .   { looking for "
    "'LagrangianParticleTracker.so'\n"
    "(   0.188s) [paraview        ]vtkResourceFileLocator.:74       9| .   .   trying file "
    "/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/"
    "LagrangianParticleTracker/LagrangianParticleTracker.so -- success!\n"
    "(   0.188s) [paraview        ]vtkResourceFileLocator.:61       9| .   } 0.000 s: looking for "
    "'LagrangianParticleTracker.so'\n"
    "(   0.188s) [paraview        ] vtkPVPluginTracker.cxx:90       9| } 0.000 s: looking for "
    "plugin 'LagrangianParticleTracker'\n"
    "(   0.188s) [paraview        ] vtkPVPluginTracker.cxx:384      9| found "
    "`/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/"
    "LagrangianParticleTracker/LagrangianParticleTracker.so`\n"
    "(   0.188s) [paraview        ] vtkPVPluginTracker.cxx:358      9| Trying to locate plugin "
    "with name `Moments`\n"
    "(   0.188s) [paraview        ] vtkPVPluginTracker.cxx:90       9| { looking for plugin "
    "'Moments'\n"
    "(   0.188s) [paraview        ] vtkPVPluginTracker.cxx:121      9| .   VTK libraries location "
    "is '/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/libvtkCommonCore-pv5.6.so.1'\n"
    "(   0.188s) [paraview        ] vtkPVPluginTracker.cxx:164      9| .   check various prefixes "
    "relative to VTK libraries\n"
    "(   0.188s) [paraview        ]vtkResourceFileLocator.:61       9| .   { looking for "
    "'Moments.so'\n"
    "(   0.188s) [paraview        ]vtkResourceFileLocator.:74       9| .   .   trying file "
    "/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/Moments/Moments.so "
    "-- success!\n"
    "(   0.188s) [paraview        ]vtkResourceFileLocator.:61       9| .   } 0.000 s: looking for "
    "'Moments.so'\n"
    "(   0.188s) [paraview        ] vtkPVPluginTracker.cxx:90       9| } 0.000 s: looking for "
    "plugin 'Moments'\n"
    "(   0.188s) [paraview        ] vtkPVPluginTracker.cxx:384      9| found "
    "`/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/paraview-5.6/plugins/Moments/"
    "Moments.so`\n"
    "(   0.188s) [paraview        ] vtkPVPluginTracker.cxx:358      9| Trying to locate plugin "
    "with name `MooseXfemClip`\n"
    "(   0.188s) [paraview        ] vtkPVPluginTracker.cxx:90       9| { looking for plugin "
    "'MooseXfemClip'\n"
    "(   0.188s) [paraview        ] vtkPVPluginTracker.cxx:121      9| .   VTK libraries location "
    "is '/home/utkarsh/Kitware/ParaView3/ParaViewBin-Qt5/lib/libvtkCommonCore-pv5.6.so.1'\n"
    "(   0.189s) [paraview        ] vtkPVPluginTracker.cxx:164      9| .   check various prefixes "
    "relative to VTK libraries\n");

  QFile f("/tmp/info.log");
  if (f.open(QIODevice::ReadOnly | QIODevice::Text))
  {
    widget.setLog(QString::fromUtf8(f.readAll()));
  }
}

extern int LogViewerWidget(int argc, char* argv[])
{
  QApplication app(argc, argv);
  LogViewerWidgetTester tester;
  return QTest::qExec(&tester, argc, argv);
}
